/****************************************************************************
 * IASPEI91.H                                                               *
 *                                                                          *
 * This is an include file which was created by the program ptable.c.       *
 * Ptable.c utilizes the NEIC Tau/P software to create a P-wave travel time *
 * file.  This file fills a 1-d array with P-wave travel times in seconds.  *
 *                                                                          *  
 * Times listed for distances less than 115.1 degrees are for the first     *
 * arriving P wave (usually P, could be Pn, Pg, Pb, Pdiff).  After 115.1,   *
 * the first branch of the PKP is taken.  This is usually the PKPdf (which  *
 * is the PKIKP through the inner core).                                    *
 *                                                                          *
 * The file is organized by depth, then distance.  That is, the first value *
 * is the P-time for 0km depth, 0 degrees.  Second is 0km depth, 0.5        *
 * degrees. And so on until 0km, 180.0 degrees.  Then the next is for 10km, *
 * 0.0 degrees. The distance increment is 0.5 degrees from 0 to 180 degree  *
 * epicentral distance.  The depth increments are 0-750km in 10km increments*
 * throughout.  This gives 76 "rows" of P-time values.                      *
 *                                                                          *
 * Table created at West Coast/Alaska Tsunami Warning Center in 4/99.       *
 * Converted to earthworm modular form 2/2001 by Whitmore                   *
 *                                                                          *
 ****************************************************************************/
 
#ifndef IASPEI91_H
#define IASPEI91_H

float fPP[27436] = {			/* 0km */
   0.00f,    9.59f,   19.17f,   28.15f,   35.03f,   41.90f,   48.78f,   55.65f, 
  62.53f,   69.40f,   76.27f,   83.14f,   90.01f,   96.88f,  103.75f,  110.61f, 
 117.47f,  124.33f,  131.19f,  138.04f,  144.90f,  151.74f,  158.59f,  165.43f, 
 172.27f,  179.11f,  185.94f,  192.77f,  199.59f,  206.41f,  213.23f,  219.88f, 
 226.38f,  232.80f,  239.13f,  245.38f,  251.58f,  257.66f,  263.16f,  268.64f, 
 274.10f,  279.54f,  284.95f,  290.34f,  295.71f,  301.04f,  306.34f,  311.61f, 
 316.31f,  320.87f,  325.43f,  329.97f,  334.51f,  339.03f,  343.54f,  348.03f, 
 352.50f,  356.96f,  361.41f,  365.85f,  370.27f,  374.69f,  379.10f,  383.50f, 
 387.89f,  392.27f,  396.64f,  400.99f,  405.34f,  409.66f,  413.98f,  418.28f, 
 422.57f,  426.84f,  431.09f,  435.34f,  439.56f,  443.77f,  447.96f,  452.14f, 
 456.30f,  460.45f,  464.57f,  468.68f,  472.78f,  476.85f,  480.91f,  484.95f, 
 488.98f,  492.98f,  496.97f,  500.95f,  504.90f,  508.84f,  512.75f,  516.65f, 
 520.54f,  524.40f,  528.25f,  532.08f,  535.89f,  539.68f,  543.45f,  547.21f, 
 550.95f,  554.67f,  558.37f,  562.05f,  565.72f,  569.37f,  572.99f,  576.61f, 
 580.20f,  583.77f,  587.33f,  590.87f,  594.39f,  597.89f,  601.38f,  604.84f, 
 608.29f,  611.72f,  615.13f,  618.53f,  621.90f,  625.26f,  628.60f,  631.92f, 
 635.22f,  638.51f,  641.77f,  645.02f,  648.25f,  651.46f,  654.66f,  657.83f, 
 660.99f,  664.13f,  667.25f,  670.35f,  673.43f,  676.50f,  679.55f,  682.58f, 
 685.59f,  688.58f,  691.55f,  694.51f,  697.45f,  700.36f,  703.26f,  706.14f, 
 709.01f,  711.85f,  714.68f,  717.48f,  720.27f,  723.04f,  725.79f,  728.52f, 
 731.23f,  733.92f,  736.60f,  739.25f,  741.88f,  744.50f,  747.10f,  749.67f, 
 752.23f,  754.77f,  757.28f,  759.78f,  762.26f,  764.72f,  767.16f,  769.58f, 
 771.96f,  774.32f,  776.67f,  779.01f,  781.35f,  783.68f,  786.00f,  788.31f, 
 790.62f,  792.93f,  795.23f,  797.52f,  799.81f,  802.10f,  804.38f,  806.65f, 
 808.91f,  811.17f,  813.41f,  815.65f,  817.89f,  820.11f,  822.33f,  824.55f, 
 826.77f,  828.99f,  831.20f,  833.42f,  835.64f,  837.86f,  840.08f,  842.30f, 
 844.52f,  846.74f,  848.96f,  851.18f,  853.40f,  855.62f,  857.84f,  860.06f, 
 862.28f,  864.50f,  866.72f,  868.94f,  871.16f,  873.37f,  875.59f,  877.81f, 
 880.03f,  882.25f,  884.47f,  886.69f,  888.91f,  891.13f,  893.35f, 1123.71f, 
1124.67f, 1125.63f, 1126.58f, 1127.54f, 1128.50f, 1129.45f, 1130.41f, 1131.37f, 
1132.32f, 1133.28f, 1134.23f, 1135.19f, 1136.14f, 1137.10f, 1138.05f, 1139.00f, 
1139.96f, 1140.91f, 1141.86f, 1142.81f, 1143.76f, 1144.71f, 1145.66f, 1146.61f, 
1147.55f, 1148.50f, 1149.44f, 1150.39f, 1151.33f, 1152.27f, 1153.21f, 1154.15f, 
1155.09f, 1156.02f, 1156.96f, 1157.89f, 1158.82f, 1159.75f, 1160.68f, 1161.60f, 
1162.52f, 1163.44f, 1164.36f, 1165.27f, 1166.19f, 1167.09f, 1168.00f, 1168.90f, 
1169.80f, 1170.70f, 1171.59f, 1172.48f, 1173.36f, 1174.24f, 1175.12f, 1175.99f, 
1176.85f, 1177.71f, 1177.62f, 1179.23f, 1180.26f, 1181.10f, 1181.93f, 1182.75f, 
1183.57f, 1184.38f, 1185.18f, 1185.98f, 1186.77f, 1187.54f, 1188.31f, 1189.07f, 
1189.83f, 1190.57f, 1191.30f, 1192.03f, 1192.74f, 1193.44f, 1194.13f, 1194.82f, 
1195.49f, 1196.15f, 1196.79f, 1197.43f, 1198.06f, 1198.67f, 1199.27f, 1199.86f, 
1200.43f, 1201.00f, 1201.55f, 1202.09f, 1202.61f, 1203.12f, 1203.62f, 1204.10f, 
1204.58f, 1205.03f, 1205.48f, 1205.91f, 1206.32f, 1206.73f, 1207.11f, 1207.49f, 
1207.85f, 1208.19f, 1208.53f, 1208.84f, 1209.15f, 1209.43f, 1209.71f, 1209.97f, 
1210.21f, 1210.44f, 1210.66f, 1210.86f, 1211.04f, 1211.21f, 1211.37f, 1211.51f, 
1211.64f, 1211.75f, 1211.85f, 1211.93f, 1212.00f, 1212.05f, 1212.09f, 1212.11f, 
1212.12f, 				/* 10km */
   1.72f,    9.74f,   19.24f,   26.95f,   33.83f,   40.70f,   47.58f,   54.45f, 
  61.33f,   68.20f,   75.07f,   81.94f,   88.81f,   95.68f,  102.54f,  109.41f, 
 116.27f,  123.13f,  129.99f,  136.84f,  143.69f,  150.54f,  157.38f,  164.23f, 
 171.06f,  177.90f,  184.73f,  191.56f,  198.38f,  205.20f,  212.02f,  218.62f, 
 225.11f,  231.51f,  237.83f,  244.07f,  250.26f,  256.25f,  261.75f,  267.22f, 
 272.68f,  278.12f,  283.53f,  288.92f,  294.28f,  299.61f,  304.90f,  310.17f, 
 314.79f,  319.36f,  323.91f,  328.45f,  332.99f,  337.51f,  342.02f,  346.50f, 
 350.98f,  355.44f,  359.88f,  364.32f,  368.75f,  373.16f,  377.57f,  381.97f, 
 386.36f,  390.74f,  395.10f,  399.46f,  403.80f,  408.13f,  412.44f,  416.74f, 
 421.02f,  425.29f,  429.55f,  433.79f,  438.01f,  442.22f,  446.41f,  450.59f, 
 454.75f,  458.89f,  463.02f,  467.13f,  471.22f,  475.29f,  479.35f,  483.39f, 
 487.41f,  491.42f,  495.41f,  499.38f,  503.33f,  507.26f,  511.18f,  515.08f, 
 518.96f,  522.82f,  526.67f,  530.50f,  534.30f,  538.09f,  541.87f,  545.62f, 
 549.36f,  553.08f,  556.78f,  560.46f,  564.12f,  567.77f,  571.40f,  575.01f, 
 578.60f,  582.17f,  585.73f,  589.27f,  592.79f,  596.29f,  599.77f,  603.24f, 
 606.68f,  610.11f,  613.52f,  616.91f,  620.29f,  623.64f,  626.98f,  630.30f, 
 633.60f,  636.89f,  640.15f,  643.40f,  646.63f,  649.84f,  653.03f,  656.20f, 
 659.36f,  662.50f,  665.62f,  668.72f,  671.80f,  674.87f,  677.91f,  680.94f, 
 683.95f,  686.94f,  689.91f,  692.87f,  695.80f,  698.72f,  701.62f,  704.50f, 
 707.36f,  710.20f,  713.03f,  715.83f,  718.62f,  721.39f,  724.14f,  726.86f, 
 729.58f,  732.27f,  734.94f,  737.59f,  740.23f,  742.84f,  745.44f,  748.01f, 
 750.57f,  753.10f,  755.62f,  758.11f,  760.59f,  763.05f,  765.49f,  767.91f, 
 770.29f,  772.65f,  775.00f,  777.34f,  779.68f,  782.00f,  784.32f,  786.64f, 
 788.95f,  791.25f,  793.55f,  795.85f,  798.14f,  800.42f,  802.70f,  804.97f, 
 807.24f,  809.49f,  811.74f,  813.98f,  816.21f,  818.43f,  820.65f,  822.87f, 
 825.09f,  827.31f,  829.53f,  831.75f,  833.97f,  836.19f,  838.41f,  840.62f, 
 842.84f,  845.06f,  847.28f,  849.50f,  851.72f,  853.94f,  856.16f,  858.38f, 
 860.60f,  862.82f,  865.04f,  867.26f,  869.48f,  871.70f,  873.92f,  876.14f, 
 878.36f,  880.58f,  882.79f,  885.01f,  887.23f,  889.45f,  891.67f, 1122.00f, 
1122.95f, 1123.91f, 1124.87f, 1125.82f, 1126.78f, 1127.74f, 1128.69f, 1129.65f, 
1130.61f, 1131.56f, 1132.52f, 1133.47f, 1134.43f, 1135.38f, 1136.34f, 1137.29f, 
1138.24f, 1139.19f, 1140.14f, 1141.10f, 1142.05f, 1143.00f, 1143.94f, 1144.89f, 
1145.84f, 1146.78f, 1147.73f, 1148.67f, 1149.61f, 1150.56f, 1151.50f, 1152.43f, 
1153.37f, 1154.31f, 1155.24f, 1156.17f, 1157.10f, 1158.03f, 1158.96f, 1159.88f, 
1160.81f, 1161.73f, 1162.64f, 1163.56f, 1164.47f, 1165.38f, 1166.28f, 1167.19f, 
1168.09f, 1168.98f, 1169.87f, 1170.76f, 1171.65f, 1172.53f, 1173.40f, 1174.27f, 
1175.14f, 1176.00f, 1175.92f, 1177.53f, 1178.54f, 1179.38f, 1180.21f, 1181.04f, 
1181.85f, 1182.66f, 1183.47f, 1184.26f, 1185.05f, 1185.82f, 1186.59f, 1187.36f, 
1188.11f, 1188.85f, 1189.58f, 1190.31f, 1191.02f, 1191.72f, 1192.41f, 1193.10f, 
1193.77f, 1194.43f, 1195.07f, 1195.71f, 1196.34f, 1196.95f, 1197.55f, 1198.14f, 
1198.71f, 1199.28f, 1199.83f, 1200.36f, 1200.89f, 1201.40f, 1201.90f, 1202.38f, 
1202.85f, 1203.31f, 1203.76f, 1204.19f, 1204.60f, 1205.00f, 1205.39f, 1205.77f, 
1206.13f, 1206.47f, 1206.80f, 1207.12f, 1207.42f, 1207.71f, 1207.98f, 1208.24f, 
1208.49f, 1208.72f, 1208.93f, 1209.13f, 1209.32f, 1209.49f, 1209.65f, 1209.79f, 
1209.91f, 1210.03f, 1210.12f, 1210.20f, 1210.27f, 1210.32f, 1210.36f, 1210.38f, 
1210.39f, 				/* 20km */	
   3.45f,   10.09f,   18.62f,   25.75f,   32.63f,   39.50f,   46.38f,   53.26f, 
  60.13f,   67.00f,   73.87f,   80.74f,   87.61f,   94.48f,  101.34f,  108.21f, 
 115.07f,  121.93f,  128.78f,  135.64f,  142.49f,  149.34f,  156.18f,  163.02f, 
 169.86f,  176.69f,  183.52f,  190.35f,  197.17f,  203.99f,  210.81f,  217.36f, 
 223.83f,  230.22f,  236.53f,  242.76f,  248.94f,  254.84f,  260.33f,  265.81f, 
 271.26f,  276.70f,  282.11f,  287.49f,  292.85f,  298.17f,  303.47f,  308.71f, 
 313.28f,  317.84f,  322.39f,  326.94f,  331.47f,  335.99f,  340.49f,  344.98f, 
 349.45f,  353.91f,  358.36f,  362.79f,  367.22f,  371.63f,  376.04f,  380.44f, 
 384.83f,  389.20f,  393.57f,  397.92f,  402.26f,  406.59f,  410.90f,  415.20f, 
 419.48f,  423.75f,  428.00f,  432.24f,  436.47f,  440.67f,  444.86f,  449.04f, 
 453.20f,  457.34f,  461.46f,  465.57f,  469.66f,  473.73f,  477.79f,  481.83f, 
 485.85f,  489.85f,  493.84f,  497.81f,  501.76f,  505.69f,  509.61f,  513.50f, 
 517.38f,  521.24f,  525.09f,  528.91f,  532.72f,  536.51f,  540.28f,  544.04f, 
 547.77f,  551.49f,  555.19f,  558.87f,  562.53f,  566.18f,  569.80f,  573.41f, 
 577.00f,  580.57f,  584.13f,  587.66f,  591.18f,  594.68f,  598.16f,  601.63f, 
 605.07f,  608.50f,  611.91f,  615.30f,  618.67f,  622.03f,  625.37f,  628.68f, 
 631.98f,  635.27f,  638.53f,  641.78f,  645.00f,  648.21f,  651.40f,  654.58f, 
 657.73f,  660.87f,  663.99f,  667.09f,  670.17f,  673.23f,  676.28f,  679.30f, 
 682.31f,  685.30f,  688.27f,  691.23f,  694.16f,  697.08f,  699.98f,  702.86f, 
 705.72f,  708.56f,  711.38f,  714.18f,  716.97f,  719.74f,  722.48f,  725.21f, 
 727.92f,  730.61f,  733.28f,  735.94f,  738.57f,  741.18f,  743.78f,  746.35f, 
 748.91f,  751.44f,  753.95f,  756.45f,  758.93f,  761.39f,  763.83f,  766.24f, 
 768.61f,  770.98f,  773.33f,  775.67f,  778.00f,  780.33f,  782.65f,  784.97f, 
 787.28f,  789.58f,  791.88f,  794.18f,  796.47f,  798.75f,  801.03f,  803.30f, 
 805.56f,  807.82f,  810.06f,  812.30f,  814.53f,  816.75f,  818.97f,  821.19f, 
 823.41f,  825.63f,  827.85f,  830.07f,  832.29f,  834.51f,  836.73f,  838.95f, 
 841.17f,  843.39f,  845.61f,  847.83f,  850.05f,  852.26f,  854.48f,  856.70f, 
 858.92f,  861.14f,  863.36f,  865.58f,  867.80f,  870.02f,  872.24f,  874.46f, 
 876.68f,  878.90f,  881.12f,  883.34f,  885.56f,  887.78f,  890.00f, 1120.28f, 
1121.24f, 1122.19f, 1123.15f, 1124.11f, 1125.07f, 1126.02f, 1126.98f, 1127.94f, 
1128.89f, 1129.85f, 1130.80f, 1131.76f, 1132.71f, 1133.67f, 1134.62f, 1135.57f, 
1136.53f, 1137.48f, 1138.43f, 1139.38f, 1140.33f, 1141.28f, 1142.23f, 1143.18f, 
1144.12f, 1145.07f, 1146.01f, 1146.96f, 1147.90f, 1148.84f, 1149.78f, 1150.72f, 
1151.66f, 1152.59f, 1153.53f, 1154.46f, 1155.39f, 1156.32f, 1157.24f, 1158.17f, 
1159.09f, 1160.01f, 1160.93f, 1161.84f, 1162.75f, 1163.66f, 1164.57f, 1165.47f, 
1166.37f, 1167.27f, 1168.16f, 1169.05f, 1169.93f, 1170.81f, 1171.68f, 1172.55f, 
1173.42f, 1174.28f, 1174.22f, 1175.83f, 1176.83f, 1177.66f, 1178.49f, 1179.32f, 
1180.14f, 1180.95f, 1181.75f, 1182.54f, 1183.33f, 1184.11f, 1184.88f, 1185.64f, 
1186.39f, 1187.13f, 1187.86f, 1188.59f, 1189.30f, 1190.00f, 1190.69f, 1191.38f, 
1192.05f, 1192.71f, 1193.35f, 1193.99f, 1194.61f, 1195.23f, 1195.83f, 1196.42f, 
1196.99f, 1197.55f, 1198.10f, 1198.64f, 1199.17f, 1199.68f, 1200.18f, 1200.66f, 
1201.13f, 1201.59f, 1202.03f, 1202.46f, 1202.88f, 1203.28f, 1203.67f, 1204.04f, 
1204.40f, 1204.75f, 1205.08f, 1205.40f, 1205.70f, 1205.99f, 1206.26f, 1206.52f, 
1206.76f, 1206.99f, 1207.21f, 1207.41f, 1207.60f, 1207.77f, 1207.92f, 1208.06f, 
1208.19f, 1208.30f, 1208.40f, 1208.48f, 1208.55f, 1208.60f, 1208.64f, 1208.66f, 
1208.67f, 				/* 30km */
   4.99f,   10.42f,   17.97f,   24.84f,   31.72f,   38.60f,   45.47f,   52.35f, 
  59.22f,   66.09f,   72.96f,   79.83f,   86.70f,   93.57f,  100.43f,  107.30f, 
 114.16f,  121.01f,  127.87f,  134.72f,  141.57f,  148.42f,  155.26f,  162.10f, 
 168.94f,  175.77f,  182.60f,  189.43f,  196.25f,  203.07f,  209.83f,  216.37f, 
 222.82f,  229.19f,  235.48f,  241.71f,  247.87f,  253.67f,  259.16f,  264.63f, 
 270.08f,  275.51f,  280.92f,  286.30f,  291.65f,  296.97f,  302.26f,  307.41f, 
 311.98f,  316.54f,  321.09f,  325.63f,  330.17f,  334.68f,  339.19f,  343.67f, 
 348.14f,  352.60f,  357.04f,  361.48f,  365.90f,  370.32f,  374.72f,  379.12f, 
 383.51f,  387.88f,  392.25f,  396.60f,  400.94f,  405.26f,  409.57f,  413.87f, 
 418.15f,  422.42f,  426.67f,  430.91f,  435.13f,  439.33f,  443.52f,  447.70f, 
 451.85f,  455.99f,  460.11f,  464.22f,  468.31f,  472.38f,  476.43f,  480.47f, 
 484.49f,  488.49f,  492.48f,  496.44f,  500.39f,  504.33f,  508.24f,  512.13f, 
 516.01f,  519.87f,  523.71f,  527.54f,  531.34f,  535.13f,  538.90f,  542.65f, 
 546.39f,  550.10f,  553.80f,  557.48f,  561.14f,  564.78f,  568.41f,  572.02f, 
 575.61f,  579.18f,  582.73f,  586.26f,  589.78f,  593.28f,  596.76f,  600.22f, 
 603.67f,  607.09f,  610.50f,  613.89f,  617.26f,  620.61f,  623.95f,  627.27f, 
 630.57f,  633.85f,  637.11f,  640.35f,  643.58f,  646.79f,  649.98f,  653.15f, 
 656.30f,  659.44f,  662.55f,  665.65f,  668.73f,  671.80f,  674.84f,  677.87f, 
 680.87f,  683.86f,  686.83f,  689.78f,  692.72f,  695.63f,  698.53f,  701.41f, 
 704.27f,  707.11f,  709.93f,  712.73f,  715.51f,  718.28f,  721.03f,  723.75f, 
 726.46f,  729.15f,  731.82f,  734.47f,  737.10f,  739.72f,  742.31f,  744.88f, 
 747.44f,  749.97f,  752.48f,  754.98f,  757.45f,  759.91f,  762.35f,  764.76f, 
 767.14f,  769.50f,  771.85f,  774.19f,  776.52f,  778.85f,  781.17f,  783.49f, 
 785.79f,  788.10f,  790.40f,  792.69f,  794.98f,  797.27f,  799.55f,  801.82f, 
 804.08f,  806.33f,  808.58f,  810.82f,  813.05f,  815.27f,  817.49f,  819.71f, 
 821.93f,  824.15f,  826.37f,  828.58f,  830.80f,  833.02f,  835.24f,  837.46f, 
 839.68f,  841.90f,  844.12f,  846.34f,  848.56f,  850.78f,  853.00f,  855.22f, 
 857.44f,  859.66f,  861.88f,  864.10f,  866.32f,  868.53f,  870.75f,  872.97f, 
 875.19f,  877.41f,  879.63f,  881.85f,  884.07f,  886.29f,  888.51f, 1118.75f, 
1119.71f, 1120.67f, 1121.62f, 1122.58f, 1123.54f, 1124.49f, 1125.45f, 1126.41f, 
1127.36f, 1128.32f, 1129.27f, 1130.23f, 1131.18f, 1132.14f, 1133.09f, 1134.04f, 
1135.00f, 1135.95f, 1136.90f, 1137.85f, 1138.80f, 1139.75f, 1140.70f, 1141.65f, 
1142.59f, 1143.54f, 1144.48f, 1145.43f, 1146.37f, 1147.31f, 1148.25f, 1149.19f, 
1150.13f, 1151.06f, 1152.00f, 1152.93f, 1153.86f, 1154.79f, 1155.71f, 1156.64f, 
1157.56f, 1158.48f, 1159.40f, 1160.31f, 1161.22f, 1162.13f, 1163.04f, 1163.94f, 
1164.84f, 1165.74f, 1166.63f, 1167.52f, 1168.40f, 1169.28f, 1170.15f, 1171.02f, 
1171.89f, 1172.75f, 1172.71f, 1174.32f, 1175.30f, 1176.13f, 1176.96f, 1177.79f, 
1178.60f, 1179.41f, 1180.22f, 1181.01f, 1181.80f, 1182.57f, 1183.34f, 1184.10f, 
1184.86f, 1185.60f, 1186.33f, 1187.05f, 1187.77f, 1188.47f, 1189.16f, 1189.84f, 
1190.51f, 1191.17f, 1191.82f, 1192.46f, 1193.08f, 1193.69f, 1194.29f, 1194.88f, 
1195.46f, 1196.02f, 1196.57f, 1197.11f, 1197.63f, 1198.14f, 1198.64f, 1199.12f, 
1199.60f, 1200.05f, 1200.50f, 1200.93f, 1201.34f, 1201.74f, 1202.13f, 1202.51f, 
1202.87f, 1203.21f, 1203.54f, 1203.86f, 1204.16f, 1204.45f, 1204.72f, 1204.98f, 
1205.23f, 1205.46f, 1205.67f, 1205.87f, 1206.06f, 1206.23f, 1206.38f, 1206.53f, 
1206.65f, 1206.76f, 1206.86f, 1206.94f, 1207.01f, 1207.06f, 1207.10f, 1207.12f, 
1207.13f, 
   6.38f,   10.73f,   17.53f,   24.39f,   31.27f,   38.14f,   45.01f,   51.88f, 
  58.75f,   65.62f,   72.49f,   79.35f,   86.22f,   93.08f,   99.94f,  106.80f, 
 113.66f,  120.51f,  127.36f,  134.21f,  141.06f,  147.90f,  154.74f,  161.58f, 
 168.41f,  175.24f,  182.07f,  188.89f,  195.71f,  202.53f,  209.15f,  215.66f, 
 222.09f,  228.43f,  234.70f,  240.91f,  247.05f,  252.71f,  258.19f,  263.66f, 
 269.11f,  274.53f,  279.94f,  285.31f,  290.66f,  295.97f,  301.26f,  306.30f, 
 310.87f,  315.43f,  319.98f,  324.52f,  329.05f,  333.56f,  338.06f,  342.55f, 
 347.01f,  351.47f,  355.91f,  360.34f,  364.77f,  369.18f,  373.59f,  377.98f, 
 382.37f,  386.74f,  391.11f,  395.46f,  399.79f,  404.11f,  408.42f,  412.72f, 
 417.00f,  421.26f,  425.51f,  429.75f,  433.97f,  438.17f,  442.36f,  446.53f, 
 450.68f,  454.82f,  458.94f,  463.04f,  467.13f,  471.20f,  475.25f,  479.29f, 
 483.31f,  487.31f,  491.29f,  495.25f,  499.20f,  503.13f,  507.04f,  510.94f, 
 514.81f,  518.67f,  522.51f,  526.33f,  530.14f,  533.92f,  537.69f,  541.44f, 
 545.17f,  548.89f,  552.58f,  556.26f,  559.92f,  563.56f,  567.18f,  570.79f, 
 574.38f,  577.95f,  581.50f,  585.03f,  588.54f,  592.04f,  595.52f,  598.98f, 
 602.42f,  605.85f,  609.25f,  612.64f,  616.01f,  619.36f,  622.70f,  626.01f, 
 629.31f,  632.59f,  635.85f,  639.09f,  642.32f,  645.52f,  648.71f,  651.88f, 
 655.03f,  658.17f,  661.28f,  664.38f,  667.46f,  670.52f,  673.56f,  676.59f, 
 679.59f,  682.58f,  685.55f,  688.50f,  691.43f,  694.35f,  697.24f,  700.12f, 
 702.97f,  705.81f,  708.63f,  711.44f,  714.22f,  716.98f,  719.73f,  722.45f, 
 725.16f,  727.85f,  730.52f,  733.17f,  735.80f,  738.41f,  741.00f,  743.57f, 
 746.12f,  748.66f,  751.17f,  753.66f,  756.14f,  758.60f,  761.03f,  763.44f, 
 765.81f,  768.17f,  770.52f,  772.87f,  775.20f,  777.53f,  779.85f,  782.16f, 
 784.47f,  786.77f,  789.07f,  791.37f,  793.66f,  795.94f,  798.22f,  800.49f, 
 802.75f,  805.00f,  807.25f,  809.49f,  811.72f,  813.94f,  816.16f,  818.38f, 
 820.60f,  822.81f,  825.03f,  827.25f,  829.47f,  831.69f,  833.91f,  836.13f, 
 838.35f,  840.57f,  842.79f,  845.01f,  847.23f,  849.45f,  851.67f,  853.89f, 
 856.11f,  858.33f,  860.55f,  862.76f,  864.98f,  867.20f,  869.42f,  871.64f, 
 873.86f,  876.08f,  878.30f,  880.52f,  882.74f,  884.96f,  887.18f, 1117.37f, 
1118.33f, 1119.29f, 1120.24f, 1121.20f, 1122.16f, 1123.11f, 1124.07f, 1125.03f, 
1125.98f, 1126.94f, 1127.89f, 1128.85f, 1129.80f, 1130.76f, 1131.71f, 1132.66f, 
1133.62f, 1134.57f, 1135.52f, 1136.47f, 1137.42f, 1138.37f, 1139.32f, 1140.27f, 
1141.21f, 1142.16f, 1143.10f, 1144.05f, 1144.99f, 1145.93f, 1146.87f, 1147.81f, 
1148.75f, 1149.68f, 1150.62f, 1151.55f, 1152.48f, 1153.41f, 1154.33f, 1155.26f, 
1156.18f, 1157.10f, 1158.02f, 1158.93f, 1159.84f, 1160.75f, 1161.66f, 1162.56f, 
1163.46f, 1164.35f, 1165.25f, 1166.13f, 1167.02f, 1167.90f, 1168.77f, 1169.64f, 
1170.51f, 1171.37f, 1171.35f, 1172.96f, 1173.91f, 1174.75f, 1175.58f, 1176.40f, 
1177.22f, 1178.03f, 1178.83f, 1179.63f, 1180.41f, 1181.19f, 1181.96f, 1182.72f, 
1183.47f, 1184.21f, 1184.95f, 1185.67f, 1186.38f, 1187.08f, 1187.78f, 1188.46f, 
1189.13f, 1189.79f, 1190.43f, 1191.07f, 1191.69f, 1192.31f, 1192.91f, 1193.49f, 
1194.07f, 1194.63f, 1195.18f, 1195.72f, 1196.24f, 1196.75f, 1197.25f, 1197.74f, 
1198.21f, 1198.66f, 1199.11f, 1199.54f, 1199.95f, 1200.36f, 1200.74f, 1201.12f, 
1201.48f, 1201.82f, 1202.15f, 1202.47f, 1202.77f, 1203.06f, 1203.33f, 1203.59f, 
1203.84f, 1204.07f, 1204.28f, 1204.48f, 1204.67f, 1204.84f, 1204.99f, 1205.13f, 
1205.26f, 1205.37f, 1205.47f, 1205.55f, 1205.62f, 1205.67f, 1205.71f, 1205.73f, 
1205.74f, 
   7.62f,   11.24f,   17.70f,   24.48f,   31.32f,   38.16f,   45.02f,   51.88f, 
  58.74f,   65.60f,   72.45f,   79.31f,   86.17f,   93.03f,   99.88f,  106.73f, 
 113.58f,  120.43f,  127.27f,  134.12f,  140.96f,  147.79f,  154.63f,  161.46f, 
 168.29f,  175.11f,  181.93f,  188.75f,  195.56f,  202.23f,  208.77f,  215.23f, 
 221.62f,  227.93f,  234.18f,  240.36f,  246.46f,  251.96f,  257.44f,  262.91f, 
 268.35f,  273.77f,  279.16f,  284.53f,  289.87f,  295.18f,  300.46f,  305.37f, 
 309.94f,  314.50f,  319.04f,  323.58f,  328.11f,  332.62f,  337.12f,  341.60f, 
 346.07f,  350.52f,  354.96f,  359.39f,  363.82f,  368.23f,  372.63f,  377.03f, 
 381.41f,  385.78f,  390.15f,  394.49f,  398.83f,  403.15f,  407.45f,  411.75f, 
 416.03f,  420.29f,  424.54f,  428.77f,  432.99f,  437.19f,  441.37f,  445.54f, 
 449.69f,  453.83f,  457.95f,  462.05f,  466.13f,  470.20f,  474.25f,  478.28f, 
 482.30f,  486.30f,  490.28f,  494.24f,  498.18f,  502.11f,  506.02f,  509.91f, 
 513.79f,  517.64f,  521.48f,  525.30f,  529.10f,  532.88f,  536.65f,  540.40f, 
 544.13f,  547.84f,  551.53f,  555.21f,  558.87f,  562.51f,  566.13f,  569.73f, 
 573.32f,  576.88f,  580.43f,  583.96f,  587.48f,  590.97f,  594.45f,  597.91f, 
 601.35f,  604.77f,  608.17f,  611.56f,  614.93f,  618.28f,  621.61f,  624.92f, 
 628.22f,  631.50f,  634.75f,  638.00f,  641.22f,  644.42f,  647.61f,  650.78f, 
 653.93f,  657.06f,  660.17f,  663.27f,  666.35f,  669.41f,  672.45f,  675.47f, 
 678.47f,  681.46f,  684.43f,  687.38f,  690.31f,  693.22f,  696.11f,  698.99f, 
 701.84f,  704.68f,  707.50f,  710.30f,  713.08f,  715.84f,  718.59f,  721.31f, 
 724.02f,  726.70f,  729.37f,  732.02f,  734.65f,  737.26f,  739.85f,  742.42f, 
 744.97f,  747.50f,  750.01f,  752.50f,  754.98f,  757.43f,  759.87f,  762.27f, 
 764.65f,  767.01f,  769.36f,  771.70f,  774.03f,  776.35f,  778.67f,  780.99f, 
 783.30f,  785.60f,  787.90f,  790.19f,  792.48f,  794.77f,  797.04f,  799.31f, 
 801.57f,  803.83f,  806.07f,  808.31f,  810.54f,  812.76f,  814.98f,  817.20f, 
 819.42f,  821.64f,  823.86f,  826.08f,  828.30f,  830.52f,  832.74f,  834.95f, 
 837.17f,  839.39f,  841.61f,  843.83f,  846.05f,  848.27f,  850.49f,  852.71f, 
 854.93f,  857.15f,  859.37f,  861.59f,  863.81f,  866.03f,  868.25f,  870.47f, 
 872.69f,  874.90f,  877.12f,  879.34f,  881.56f,  883.78f,  886.00f, 1116.14f, 
1117.10f, 1118.05f, 1119.01f, 1119.97f, 1120.93f, 1121.88f, 1122.84f, 1123.80f, 
1124.75f, 1125.71f, 1126.66f, 1127.62f, 1128.57f, 1129.53f, 1130.48f, 1131.43f, 
1132.39f, 1133.34f, 1134.29f, 1135.24f, 1136.19f, 1137.14f, 1138.09f, 1139.03f, 
1139.98f, 1140.93f, 1141.87f, 1142.82f, 1143.76f, 1144.70f, 1145.64f, 1146.58f, 
1147.51f, 1148.45f, 1149.38f, 1150.32f, 1151.25f, 1152.17f, 1153.10f, 1154.02f, 
1154.95f, 1155.87f, 1156.78f, 1157.70f, 1158.61f, 1159.52f, 1160.42f, 1161.33f, 
1162.23f, 1163.12f, 1164.01f, 1164.90f, 1165.78f, 1166.66f, 1167.54f, 1168.41f, 
1169.27f, 1168.47f, 1170.15f, 1171.75f, 1172.68f, 1173.52f, 1174.35f, 1175.17f, 
1175.99f, 1176.80f, 1177.60f, 1178.39f, 1179.18f, 1179.95f, 1180.72f, 1181.48f, 
1182.24f, 1182.98f, 1183.71f, 1184.43f, 1185.14f, 1185.85f, 1186.54f, 1187.22f, 
1187.89f, 1188.55f, 1189.20f, 1189.83f, 1190.46f, 1191.07f, 1191.67f, 1192.25f, 
1192.83f, 1193.39f, 1193.94f, 1194.48f, 1195.00f, 1195.51f, 1196.01f, 1196.50f, 
1196.97f, 1197.42f, 1197.87f, 1198.30f, 1198.71f, 1199.11f, 1199.50f, 1199.88f, 
1200.23f, 1200.58f, 1200.91f, 1201.23f, 1201.53f, 1201.82f, 1202.09f, 1202.35f, 
1202.59f, 1202.82f, 1203.04f, 1203.24f, 1203.42f, 1203.59f, 1203.75f, 1203.89f, 
1204.02f, 1204.13f, 1204.23f, 1204.31f, 1204.37f, 1204.43f, 1204.46f, 1204.49f, 
1204.49f, 
   8.86f,   11.95f,   18.02f,   24.66f,   31.43f,   38.24f,   45.07f,   51.91f, 
  58.76f,   65.60f,   72.45f,   79.30f,   86.14f,   92.99f,   99.83f,  106.68f, 
 113.52f,  120.36f,  127.20f,  134.03f,  140.87f,  147.70f,  154.52f,  161.35f, 
 168.17f,  174.99f,  181.80f,  188.61f,  195.30f,  201.86f,  208.36f,  214.79f, 
 221.15f,  227.43f,  233.65f,  239.81f,  245.72f,  251.22f,  256.69f,  262.15f, 
 267.59f,  273.00f,  278.39f,  283.76f,  289.09f,  294.39f,  299.66f,  304.44f, 
 309.01f,  313.57f,  318.11f,  322.65f,  327.17f,  331.69f,  336.18f,  340.66f, 
 345.12f,  349.57f,  354.01f,  358.44f,  362.86f,  367.28f,  371.68f,  376.07f, 
 380.46f,  384.83f,  389.18f,  393.53f,  397.86f,  402.18f,  406.49f,  410.78f, 
 415.05f,  419.31f,  423.56f,  427.79f,  432.00f,  436.20f,  440.39f,  444.55f, 
 448.70f,  452.83f,  456.95f,  461.05f,  465.13f,  469.20f,  473.24f,  477.28f, 
 481.29f,  485.28f,  489.26f,  493.22f,  497.17f,  501.09f,  505.00f,  508.89f, 
 512.76f,  516.61f,  520.45f,  524.27f,  528.07f,  531.85f,  535.61f,  539.36f, 
 543.08f,  546.79f,  550.48f,  554.16f,  557.81f,  561.45f,  565.07f,  568.67f, 
 572.25f,  575.82f,  579.37f,  582.90f,  586.41f,  589.90f,  593.37f,  596.83f, 
 600.27f,  603.69f,  607.09f,  610.48f,  613.84f,  617.19f,  620.52f,  623.83f, 
 627.13f,  630.40f,  633.66f,  636.90f,  640.12f,  643.32f,  646.51f,  649.67f, 
 652.82f,  655.95f,  659.07f,  662.16f,  665.24f,  668.29f,  671.33f,  674.35f, 
 677.36f,  680.34f,  683.31f,  686.25f,  689.18f,  692.09f,  694.98f,  697.86f, 
 700.71f,  703.55f,  706.37f,  709.16f,  711.94f,  714.70f,  717.45f,  720.17f, 
 722.87f,  725.56f,  728.22f,  730.87f,  733.50f,  736.11f,  738.70f,  741.27f, 
 743.81f,  746.34f,  748.85f,  751.34f,  753.82f,  756.27f,  758.71f,  761.11f, 
 763.48f,  765.84f,  768.19f,  770.53f,  772.86f,  775.19f,  777.50f,  779.82f, 
 782.13f,  784.43f,  786.73f,  789.02f,  791.31f,  793.59f,  795.87f,  798.14f, 
 800.40f,  802.65f,  804.90f,  807.13f,  809.36f,  811.58f,  813.80f,  816.02f, 
 818.24f,  820.46f,  822.68f,  824.90f,  827.12f,  829.34f,  831.56f,  833.78f, 
 836.00f,  838.22f,  840.44f,  842.66f,  844.88f,  847.09f,  849.31f,  851.53f, 
 853.75f,  855.97f,  858.19f,  860.41f,  862.63f,  864.85f,  867.07f,  869.29f, 
 871.51f,  873.73f,  875.95f,  878.17f,  880.39f,  882.61f,  884.83f, 1114.91f, 
1115.87f, 1116.82f, 1117.78f, 1118.74f, 1119.69f, 1120.65f, 1121.61f, 1122.56f, 
1123.52f, 1124.48f, 1125.43f, 1126.39f, 1127.34f, 1128.29f, 1129.25f, 1130.20f, 
1131.15f, 1132.11f, 1133.06f, 1134.01f, 1134.96f, 1135.91f, 1136.86f, 1137.80f, 
1138.75f, 1139.70f, 1140.64f, 1141.58f, 1142.53f, 1143.47f, 1144.41f, 1145.35f, 
1146.28f, 1147.22f, 1148.15f, 1149.08f, 1150.01f, 1150.94f, 1151.87f, 1152.79f, 
1153.71f, 1154.63f, 1155.55f, 1156.47f, 1157.38f, 1158.29f, 1159.19f, 1160.09f, 
1160.99f, 1161.89f, 1162.78f, 1163.67f, 1164.55f, 1165.43f, 1166.31f, 1167.18f, 
1168.04f, 1167.27f, 1168.94f, 1170.54f, 1171.45f, 1172.28f, 1173.11f, 1173.94f, 
1174.75f, 1175.56f, 1176.36f, 1177.16f, 1177.94f, 1178.72f, 1179.49f, 1180.25f, 
1181.00f, 1181.74f, 1182.47f, 1183.20f, 1183.91f, 1184.61f, 1185.30f, 1185.98f, 
1186.65f, 1187.31f, 1187.96f, 1188.59f, 1189.22f, 1189.83f, 1190.43f, 1191.02f, 
1191.59f, 1192.15f, 1192.70f, 1193.24f, 1193.76f, 1194.27f, 1194.77f, 1195.26f, 
1195.73f, 1196.18f, 1196.63f, 1197.06f, 1197.47f, 1197.87f, 1198.26f, 1198.63f, 
1198.99f, 1199.34f, 1199.67f, 1199.99f, 1200.29f, 1200.57f, 1200.85f, 1201.11f, 
1201.35f, 1201.58f, 1201.79f, 1202.00f, 1202.18f, 1202.35f, 1202.51f, 1202.65f, 
1202.77f, 1202.89f, 1202.98f, 1203.06f, 1203.13f, 1203.18f, 1203.22f, 1203.24f, 
1203.25f, 
  10.11f,   12.80f,   18.47f,   24.93f,   31.62f,   38.38f,   45.17f,   51.98f, 
  58.81f,   65.63f,   72.47f,   79.30f,   86.14f,   92.97f,   99.81f,  106.64f, 
 113.47f,  120.31f,  127.14f,  133.96f,  140.79f,  147.61f,  154.43f,  161.25f, 
 168.06f,  174.87f,  181.67f,  188.37f,  194.95f,  201.48f,  207.95f,  214.34f, 
 220.66f,  226.92f,  233.11f,  239.25f,  244.98f,  250.47f,  255.95f,  261.40f, 
 266.83f,  272.24f,  277.62f,  282.98f,  288.31f,  293.60f,  298.86f,  303.52f, 
 308.08f,  312.64f,  317.18f,  321.72f,  326.24f,  330.75f,  335.24f,  339.72f, 
 344.18f,  348.63f,  353.07f,  357.50f,  361.92f,  366.33f,  370.73f,  375.12f, 
 379.50f,  383.87f,  388.23f,  392.57f,  396.90f,  401.22f,  405.52f,  409.81f, 
 414.08f,  418.34f,  422.58f,  426.81f,  431.02f,  435.22f,  439.40f,  443.56f, 
 447.71f,  451.84f,  455.96f,  460.05f,  464.13f,  468.20f,  472.24f,  476.27f, 
 480.28f,  484.27f,  488.25f,  492.21f,  496.15f,  500.07f,  503.98f,  507.86f, 
 511.73f,  515.58f,  519.42f,  523.23f,  527.03f,  530.81f,  534.57f,  538.31f, 
 542.04f,  545.75f,  549.44f,  553.11f,  556.76f,  560.40f,  564.01f,  567.61f, 
 571.19f,  574.76f,  578.30f,  581.83f,  585.34f,  588.83f,  592.30f,  595.76f, 
 599.19f,  602.61f,  606.01f,  609.39f,  612.76f,  616.11f,  619.43f,  622.74f, 
 626.04f,  629.31f,  632.57f,  635.80f,  639.02f,  642.22f,  645.41f,  648.57f, 
 651.72f,  654.85f,  657.96f,  661.05f,  664.12f,  667.18f,  670.22f,  673.24f, 
 676.24f,  679.22f,  682.18f,  685.13f,  688.06f,  690.97f,  693.86f,  696.73f, 
 699.58f,  702.42f,  705.23f,  708.03f,  710.81f,  713.57f,  716.31f,  719.03f, 
 721.73f,  724.41f,  727.08f,  729.72f,  732.35f,  734.96f,  737.55f,  740.11f, 
 742.66f,  745.19f,  747.70f,  750.19f,  752.66f,  755.11f,  757.54f,  759.94f, 
 762.31f,  764.67f,  767.02f,  769.36f,  771.69f,  774.02f,  776.33f,  778.65f, 
 780.96f,  783.26f,  785.56f,  787.85f,  790.14f,  792.42f,  794.70f,  796.97f, 
 799.23f,  801.48f,  803.72f,  805.96f,  808.19f,  810.41f,  812.63f,  814.85f, 
 817.07f,  819.29f,  821.50f,  823.72f,  825.94f,  828.16f,  830.38f,  832.60f, 
 834.82f,  837.04f,  839.26f,  841.48f,  843.70f,  845.92f,  848.14f,  850.36f, 
 852.58f,  854.80f,  857.02f,  859.24f,  861.46f,  863.67f,  865.89f,  868.11f, 
 870.33f,  872.55f,  874.77f,  876.99f,  879.21f,  881.43f,  883.65f, 1113.68f, 
1114.64f, 1115.59f, 1116.55f, 1117.51f, 1118.46f, 1119.42f, 1120.38f, 1121.33f, 
1122.29f, 1123.24f, 1124.20f, 1125.15f, 1126.11f, 1127.06f, 1128.02f, 1128.97f, 
1129.92f, 1130.87f, 1131.83f, 1132.78f, 1133.73f, 1134.68f, 1135.62f, 1136.57f, 
1137.52f, 1138.46f, 1139.41f, 1140.35f, 1141.29f, 1142.24f, 1143.18f, 1144.11f, 
1145.05f, 1145.99f, 1146.92f, 1147.85f, 1148.78f, 1149.71f, 1150.64f, 1151.56f, 
1152.48f, 1153.40f, 1154.32f, 1155.23f, 1156.15f, 1157.05f, 1157.96f, 1158.86f, 
1159.76f, 1160.66f, 1161.55f, 1162.44f, 1163.32f, 1164.20f, 1165.07f, 1165.94f, 
1166.81f, 1166.07f, 1167.73f, 1169.33f, 1170.21f, 1171.05f, 1171.88f, 1172.70f, 
1173.52f, 1174.33f, 1175.13f, 1175.92f, 1176.71f, 1177.48f, 1178.25f, 1179.01f, 
1179.76f, 1180.51f, 1181.24f, 1181.96f, 1182.67f, 1183.37f, 1184.06f, 1184.74f, 
1185.41f, 1186.07f, 1186.72f, 1187.35f, 1187.98f, 1188.59f, 1189.19f, 1189.78f, 
1190.35f, 1190.91f, 1191.46f, 1192.00f, 1192.52f, 1193.03f, 1193.53f, 1194.01f, 
1194.49f, 1194.94f, 1195.38f, 1195.81f, 1196.23f, 1196.63f, 1197.02f, 1197.39f, 
1197.75f, 1198.10f, 1198.43f, 1198.74f, 1199.05f, 1199.33f, 1199.61f, 1199.86f, 
1200.11f, 1200.34f, 1200.55f, 1200.75f, 1200.94f, 1201.11f, 1201.26f, 1201.41f, 
1201.53f, 1201.64f, 1201.74f, 1201.82f, 1201.89f, 1201.94f, 1201.98f, 1202.00f, 
1202.01f, 
  11.35f,   13.73f,   19.02f,   25.29f,   31.86f,   38.56f,   45.31f,   52.09f, 
  58.89f,   65.69f,   72.51f,   79.33f,   86.15f,   92.97f,   99.80f,  106.62f, 
 113.44f,  120.27f,  127.09f,  133.90f,  140.72f,  147.53f,  154.35f,  161.15f, 
 167.96f,  174.76f,  181.44f,  188.04f,  194.60f,  201.09f,  207.52f,  213.88f, 
 220.17f,  226.40f,  232.58f,  238.70f,  244.24f,  249.73f,  255.20f,  260.65f, 
 266.08f,  271.48f,  276.86f,  282.20f,  287.52f,  292.81f,  298.02f,  302.59f, 
 307.16f,  311.71f,  316.25f,  320.79f,  325.31f,  329.82f,  334.31f,  338.78f, 
 343.24f,  347.68f,  352.12f,  356.55f,  360.97f,  365.38f,  369.78f,  374.17f, 
 378.54f,  382.91f,  387.27f,  391.61f,  395.94f,  400.25f,  404.55f,  408.84f, 
 413.11f,  417.37f,  421.61f,  425.83f,  430.04f,  434.24f,  438.42f,  442.58f, 
 446.72f,  450.85f,  454.96f,  459.06f,  463.13f,  467.19f,  471.24f,  475.26f, 
 479.27f,  483.26f,  487.24f,  491.19f,  495.13f,  499.05f,  502.95f,  506.84f, 
 510.71f,  514.56f,  518.39f,  522.20f,  526.00f,  529.77f,  533.53f,  537.27f, 
 541.00f,  544.70f,  548.39f,  552.06f,  555.71f,  559.34f,  562.96f,  566.56f, 
 570.13f,  573.70f,  577.24f,  580.76f,  584.27f,  587.76f,  591.23f,  594.68f, 
 598.12f,  601.53f,  604.93f,  608.31f,  611.68f,  615.02f,  618.35f,  621.66f, 
 624.95f,  628.22f,  631.47f,  634.71f,  637.93f,  641.12f,  644.31f,  647.47f, 
 650.61f,  653.74f,  656.85f,  659.94f,  663.01f,  666.07f,  669.10f,  672.12f, 
 675.12f,  678.10f,  681.06f,  684.01f,  686.93f,  689.84f,  692.73f,  695.60f, 
 698.45f,  701.28f,  704.10f,  706.89f,  709.67f,  712.43f,  715.17f,  717.89f, 
 720.59f,  723.27f,  725.93f,  728.58f,  731.20f,  733.81f,  736.39f,  738.96f, 
 741.51f,  744.03f,  746.54f,  749.03f,  751.50f,  753.95f,  756.38f,  758.78f, 
 761.15f,  763.50f,  765.85f,  768.19f,  770.52f,  772.85f,  775.17f,  777.48f, 
 779.79f,  782.09f,  784.39f,  786.68f,  788.97f,  791.25f,  793.53f,  795.79f, 
 798.05f,  800.31f,  802.55f,  804.78f,  807.01f,  809.23f,  811.45f,  813.67f, 
 815.89f,  818.11f,  820.33f,  822.55f,  824.77f,  826.99f,  829.21f,  831.43f, 
 833.65f,  835.87f,  838.08f,  840.30f,  842.52f,  844.74f,  846.96f,  849.18f, 
 851.40f,  853.62f,  855.84f,  858.06f,  860.28f,  862.50f,  864.72f,  866.94f, 
 869.16f,  871.38f,  873.60f,  875.82f,  878.04f,  880.25f,  882.47f, 1112.45f, 
1113.40f, 1114.36f, 1115.32f, 1116.28f, 1117.23f, 1118.19f, 1119.15f, 1120.10f, 
1121.06f, 1122.01f, 1122.97f, 1123.92f, 1124.88f, 1125.83f, 1126.79f, 1127.74f, 
1128.69f, 1129.64f, 1130.60f, 1131.55f, 1132.50f, 1133.44f, 1134.39f, 1135.34f, 
1136.29f, 1137.23f, 1138.18f, 1139.12f, 1140.06f, 1141.00f, 1141.94f, 1142.88f, 
1143.82f, 1144.75f, 1145.69f, 1146.62f, 1147.55f, 1148.48f, 1149.41f, 1150.33f, 
1151.25f, 1152.17f, 1153.09f, 1154.00f, 1154.91f, 1155.82f, 1156.73f, 1157.63f, 
1158.53f, 1159.42f, 1160.31f, 1161.20f, 1162.09f, 1162.96f, 1163.84f, 1164.71f, 
1165.57f, 1164.87f, 1166.52f, 1168.12f, 1168.98f, 1169.81f, 1170.64f, 1171.47f, 
1172.28f, 1173.09f, 1173.89f, 1174.69f, 1175.47f, 1176.25f, 1177.02f, 1177.78f, 
1178.53f, 1179.27f, 1180.00f, 1180.72f, 1181.43f, 1182.14f, 1182.83f, 1183.51f, 
1184.18f, 1184.84f, 1185.48f, 1186.12f, 1186.74f, 1187.35f, 1187.95f, 1188.54f, 
1189.11f, 1189.68f, 1190.22f, 1190.76f, 1191.28f, 1191.79f, 1192.29f, 1192.77f, 
1193.25f, 1193.70f, 1194.14f, 1194.57f, 1194.99f, 1195.39f, 1195.78f, 1196.15f, 
1196.51f, 1196.85f, 1197.19f, 1197.50f, 1197.80f, 1198.09f, 1198.36f, 1198.62f, 
1198.87f, 1199.10f, 1199.31f, 1199.51f, 1199.70f, 1199.87f, 1200.02f, 1200.16f, 
1200.29f, 1200.40f, 1200.50f, 1200.58f, 1200.65f, 1200.70f, 1200.73f, 1200.76f, 
1200.76f, 
  12.59f,   14.72f,   19.67f,   25.72f,   32.17f,   38.79f,   45.49f,   52.23f, 
  59.00f,   65.78f,   72.57f,   79.38f,   86.18f,   92.99f,   99.80f,  106.61f, 
 113.43f,  120.24f,  127.05f,  133.86f,  140.66f,  147.47f,  154.27f,  161.07f, 
 167.86f,  174.52f,  181.14f,  187.71f,  194.23f,  200.69f,  207.08f,  213.41f, 
 219.67f,  225.88f,  232.03f,  238.01f,  243.51f,  248.99f,  254.45f,  259.90f, 
 265.32f,  270.72f,  276.09f,  281.43f,  286.74f,  292.02f,  297.10f,  301.67f, 
 306.23f,  310.79f,  315.33f,  319.86f,  324.38f,  328.88f,  333.37f,  337.84f, 
 342.30f,  346.74f,  351.18f,  355.60f,  360.02f,  364.43f,  368.83f,  373.21f, 
 377.59f,  381.96f,  386.31f,  390.65f,  394.97f,  399.29f,  403.59f,  407.87f, 
 412.14f,  416.39f,  420.63f,  424.86f,  429.07f,  433.26f,  437.43f,  441.59f, 
 445.73f,  449.86f,  453.97f,  458.06f,  462.14f,  466.20f,  470.24f,  474.26f, 
 478.27f,  482.25f,  486.23f,  490.18f,  494.12f,  498.03f,  501.93f,  505.82f, 
 509.68f,  513.53f,  517.36f,  521.17f,  524.96f,  528.74f,  532.49f,  536.23f, 
 539.95f,  543.66f,  547.34f,  551.01f,  554.66f,  558.29f,  561.90f,  565.50f, 
 569.08f,  572.63f,  576.18f,  579.70f,  583.20f,  586.69f,  590.16f,  593.61f, 
 597.04f,  600.46f,  603.85f,  607.23f,  610.59f,  613.94f,  617.26f,  620.57f, 
 623.86f,  627.13f,  630.38f,  633.61f,  636.83f,  640.03f,  643.21f,  646.37f, 
 649.51f,  652.64f,  655.74f,  658.83f,  661.90f,  664.96f,  667.99f,  671.01f, 
 674.00f,  676.98f,  679.94f,  682.89f,  685.81f,  688.72f,  691.60f,  694.47f, 
 697.32f,  700.15f,  702.97f,  705.76f,  708.53f,  711.29f,  714.03f,  716.75f, 
 719.45f,  722.13f,  724.79f,  727.43f,  730.05f,  732.66f,  735.24f,  737.81f, 
 740.35f,  742.88f,  745.38f,  747.87f,  750.34f,  752.79f,  755.22f,  757.61f, 
 759.98f,  762.34f,  764.68f,  767.02f,  769.35f,  771.68f,  774.00f,  776.31f, 
 778.62f,  780.92f,  783.22f,  785.51f,  787.80f,  790.08f,  792.35f,  794.62f, 
 796.88f,  799.13f,  801.38f,  803.61f,  805.84f,  808.06f,  810.28f,  812.50f, 
 814.72f,  816.93f,  819.15f,  821.37f,  823.59f,  825.81f,  828.03f,  830.25f, 
 832.47f,  834.69f,  836.91f,  839.13f,  841.35f,  843.57f,  845.79f,  848.01f, 
 850.23f,  852.45f,  854.67f,  856.88f,  859.10f,  861.32f,  863.54f,  865.76f, 
 867.98f,  870.20f,  872.42f,  874.64f,  876.86f,  879.08f,  881.30f, 1111.22f, 
1112.17f, 1113.13f, 1114.09f, 1115.05f, 1116.00f, 1116.96f, 1117.92f, 1118.87f, 
1119.83f, 1120.78f, 1121.74f, 1122.69f, 1123.65f, 1124.60f, 1125.56f, 1126.51f, 
1127.46f, 1128.41f, 1129.36f, 1130.31f, 1131.26f, 1132.21f, 1133.16f, 1134.11f, 
1135.06f, 1136.00f, 1136.95f, 1137.89f, 1138.83f, 1139.77f, 1140.71f, 1141.65f, 
1142.59f, 1143.52f, 1144.46f, 1145.39f, 1146.32f, 1147.25f, 1148.17f, 1149.10f, 
1150.02f, 1150.94f, 1151.86f, 1152.77f, 1153.68f, 1154.59f, 1155.50f, 1156.40f, 
1157.30f, 1158.19f, 1159.08f, 1159.97f, 1160.85f, 1161.73f, 1162.61f, 1163.48f, 
1164.34f, 1163.66f, 1165.32f, 1166.90f, 1167.74f, 1168.58f, 1169.41f, 1170.23f, 
1171.05f, 1171.86f, 1172.66f, 1173.45f, 1174.24f, 1175.01f, 1175.78f, 1176.54f, 
1177.29f, 1178.03f, 1178.77f, 1179.49f, 1180.20f, 1180.90f, 1181.59f, 1182.27f, 
1182.94f, 1183.60f, 1184.24f, 1184.88f, 1185.50f, 1186.11f, 1186.71f, 1187.30f, 
1187.87f, 1188.44f, 1188.99f, 1189.52f, 1190.04f, 1190.55f, 1191.05f, 1191.54f, 
1192.01f, 1192.46f, 1192.90f, 1193.33f, 1193.75f, 1194.15f, 1194.54f, 1194.91f, 
1195.27f, 1195.61f, 1195.94f, 1196.26f, 1196.56f, 1196.85f, 1197.12f, 1197.38f, 
1197.62f, 1197.85f, 1198.07f, 1198.27f, 1198.45f, 1198.62f, 1198.78f, 1198.92f, 
1199.05f, 1199.16f, 1199.25f, 1199.34f, 1199.40f, 1199.45f, 1199.49f, 1199.51f, 
1199.52f, 
  13.84f,   15.76f,   20.39f,   26.22f,   32.54f,   39.07f,   45.71f,   52.40f, 
  59.14f,   65.89f,   72.67f,   79.45f,   86.24f,   93.03f,   99.83f,  106.62f, 
 113.42f,  120.22f,  127.02f,  133.82f,  140.62f,  147.42f,  154.21f,  160.95f, 
 167.61f,  174.23f,  180.82f,  187.36f,  193.84f,  200.27f,  206.63f,  212.93f, 
 219.17f,  225.36f,  231.49f,  237.28f,  242.77f,  248.25f,  253.71f,  259.15f, 
 264.56f,  269.96f,  275.32f,  280.66f,  285.96f,  291.23f,  296.18f,  300.75f, 
 305.31f,  309.86f,  314.40f,  318.93f,  323.45f,  327.95f,  332.43f,  336.90f, 
 341.36f,  345.80f,  350.23f,  354.66f,  359.07f,  363.48f,  367.88f,  372.26f, 
 376.64f,  381.00f,  385.35f,  389.69f,  394.01f,  398.33f,  402.62f,  406.90f, 
 411.17f,  415.42f,  419.66f,  423.88f,  428.09f,  432.28f,  436.45f,  440.61f, 
 444.75f,  448.87f,  452.98f,  457.07f,  461.14f,  465.20f,  469.23f,  473.26f, 
 477.26f,  481.25f,  485.22f,  489.17f,  493.10f,  497.02f,  500.91f,  504.80f, 
 508.66f,  512.50f,  516.33f,  520.14f,  523.93f,  527.70f,  531.46f,  535.19f, 
 538.91f,  542.61f,  546.30f,  549.96f,  553.61f,  557.24f,  560.85f,  564.44f, 
 568.02f,  571.57f,  575.11f,  578.63f,  582.14f,  585.62f,  589.09f,  592.54f, 
 595.97f,  599.38f,  602.78f,  606.15f,  609.51f,  612.85f,  616.18f,  619.48f, 
 622.77f,  626.04f,  629.29f,  632.52f,  635.73f,  638.93f,  642.11f,  645.27f, 
 648.41f,  651.53f,  654.64f,  657.72f,  660.79f,  663.84f,  666.88f,  669.89f, 
 672.89f,  675.86f,  678.82f,  681.76f,  684.69f,  687.59f,  690.48f,  693.34f, 
 696.19f,  699.02f,  701.83f,  704.63f,  707.40f,  710.15f,  712.89f,  715.61f, 
 718.31f,  720.98f,  723.64f,  726.29f,  728.91f,  731.51f,  734.09f,  736.66f, 
 739.20f,  741.72f,  744.23f,  746.71f,  749.18f,  751.63f,  754.06f,  756.45f, 
 758.82f,  761.17f,  763.52f,  765.86f,  768.19f,  770.51f,  772.83f,  775.14f, 
 777.45f,  779.75f,  782.05f,  784.34f,  786.63f,  788.91f,  791.18f,  793.45f, 
 795.71f,  797.96f,  800.20f,  802.44f,  804.66f,  806.88f,  809.10f,  811.32f, 
 813.54f,  815.76f,  817.98f,  820.20f,  822.42f,  824.64f,  826.86f,  829.08f, 
 831.30f,  833.52f,  835.73f,  837.95f,  840.17f,  842.39f,  844.61f,  846.83f, 
 849.05f,  851.27f,  853.49f,  855.71f,  857.93f,  860.15f,  862.37f,  864.59f, 
 866.81f,  869.03f,  871.25f,  873.47f,  875.69f,  877.90f,  880.12f, 1109.99f, 
1110.94f, 1111.90f, 1112.86f, 1113.81f, 1114.77f, 1115.73f, 1116.68f, 1117.64f, 
1118.60f, 1119.55f, 1120.51f, 1121.46f, 1122.42f, 1123.37f, 1124.32f, 1125.28f, 
1126.23f, 1127.18f, 1128.13f, 1129.08f, 1130.03f, 1130.98f, 1131.93f, 1132.88f, 
1133.83f, 1134.77f, 1135.72f, 1136.66f, 1137.60f, 1138.54f, 1139.48f, 1140.42f, 
1141.36f, 1142.29f, 1143.23f, 1144.16f, 1145.09f, 1146.02f, 1146.94f, 1147.87f, 
1148.79f, 1149.71f, 1150.62f, 1151.54f, 1152.45f, 1153.36f, 1154.26f, 1155.17f, 
1156.06f, 1156.96f, 1157.85f, 1158.74f, 1159.62f, 1160.50f, 1161.37f, 1162.24f, 
1163.11f, 1162.46f, 1164.11f, 1165.67f, 1166.51f, 1167.35f, 1168.18f, 1169.00f, 
1169.81f, 1170.62f, 1171.42f, 1172.22f, 1173.00f, 1173.78f, 1174.55f, 1175.31f, 
1176.06f, 1176.80f, 1177.53f, 1178.25f, 1178.96f, 1179.66f, 1180.35f, 1181.03f, 
1181.70f, 1182.36f, 1183.01f, 1183.64f, 1184.27f, 1184.88f, 1185.48f, 1186.06f, 
1186.64f, 1187.20f, 1187.75f, 1188.28f, 1188.81f, 1189.32f, 1189.81f, 1190.30f, 
1190.77f, 1191.22f, 1191.66f, 1192.09f, 1192.51f, 1192.91f, 1193.30f, 1193.67f, 
1194.03f, 1194.37f, 1194.70f, 1195.02f, 1195.32f, 1195.61f, 1195.88f, 1196.14f, 
1196.38f, 1196.61f, 1196.83f, 1197.03f, 1197.21f, 1197.38f, 1197.54f, 1197.68f, 
1197.80f, 1197.91f, 1198.01f, 1198.09f, 1198.16f, 1198.21f, 1198.25f, 1198.27f, 
1198.28f, 
  15.08f,   16.83f,   21.17f,   26.79f,   32.96f,   39.39f,   45.97f,   52.61f, 
  59.31f,   66.03f,   72.78f,   79.54f,   86.31f,   93.08f,   99.87f,  106.65f, 
 113.44f,  120.22f,  127.01f,  133.80f,  140.59f,  147.35f,  154.04f,  160.71f, 
 167.34f,  173.93f,  180.49f,  186.99f,  193.45f,  199.84f,  206.17f,  212.44f, 
 218.66f,  224.83f,  230.94f,  236.55f,  242.04f,  247.51f,  252.97f,  258.40f, 
 263.81f,  269.20f,  274.55f,  279.88f,  285.18f,  290.44f,  295.26f,  299.83f, 
 304.39f,  308.94f,  313.48f,  318.00f,  322.52f,  327.02f,  331.50f,  335.96f, 
 340.42f,  344.86f,  349.29f,  353.71f,  358.13f,  362.53f,  366.93f,  371.31f, 
 375.69f,  380.05f,  384.40f,  388.73f,  393.05f,  397.36f,  401.66f,  405.94f, 
 410.20f,  414.45f,  418.69f,  422.91f,  427.11f,  431.30f,  435.47f,  439.62f, 
 443.76f,  447.88f,  451.99f,  456.07f,  460.14f,  464.20f,  468.23f,  472.25f, 
 476.26f,  480.24f,  484.21f,  488.15f,  492.09f,  496.00f,  499.90f,  503.77f, 
 507.63f,  511.48f,  515.30f,  519.11f,  522.90f,  526.67f,  530.42f,  534.15f, 
 537.87f,  541.57f,  545.25f,  548.91f,  552.56f,  556.19f,  559.80f,  563.39f, 
 566.96f,  570.51f,  574.05f,  577.57f,  581.07f,  584.55f,  588.02f,  591.47f, 
 594.90f,  598.31f,  601.70f,  605.07f,  608.43f,  611.77f,  615.09f,  618.39f, 
 621.68f,  624.95f,  628.19f,  631.42f,  634.64f,  637.83f,  641.01f,  644.16f, 
 647.30f,  650.43f,  653.53f,  656.62f,  659.68f,  662.73f,  665.76f,  668.78f, 
 671.77f,  674.75f,  677.70f,  680.64f,  683.56f,  686.47f,  689.35f,  692.22f, 
 695.06f,  697.89f,  700.70f,  703.49f,  706.26f,  709.02f,  711.75f,  714.47f, 
 717.16f,  719.84f,  722.50f,  725.14f,  727.76f,  730.36f,  732.94f,  735.50f, 
 738.05f,  740.57f,  743.07f,  745.55f,  748.02f,  750.47f,  752.89f,  755.28f, 
 757.65f,  760.01f,  762.35f,  764.69f,  767.02f,  769.34f,  771.66f,  773.97f, 
 776.28f,  778.58f,  780.88f,  783.17f,  785.46f,  787.74f,  790.01f,  792.28f, 
 794.54f,  796.79f,  799.03f,  801.26f,  803.49f,  805.71f,  807.93f,  810.15f, 
 812.37f,  814.59f,  816.80f,  819.02f,  821.24f,  823.46f,  825.68f,  827.90f, 
 830.12f,  832.34f,  834.56f,  836.78f,  839.00f,  841.22f,  843.44f,  845.66f, 
 847.88f,  850.10f,  852.32f,  854.54f,  856.76f,  858.97f,  861.19f,  863.41f, 
 865.63f,  867.85f,  870.07f,  872.29f,  874.51f,  876.73f,  878.95f, 1108.76f, 
1109.71f, 1110.67f, 1111.63f, 1112.58f, 1113.54f, 1114.50f, 1115.45f, 1116.41f, 
1117.37f, 1118.32f, 1119.28f, 1120.23f, 1121.19f, 1122.14f, 1123.09f, 1124.05f, 
1125.00f, 1125.95f, 1126.90f, 1127.85f, 1128.80f, 1129.75f, 1130.70f, 1131.65f, 
1132.60f, 1133.54f, 1134.49f, 1135.43f, 1136.37f, 1137.31f, 1138.25f, 1139.19f, 
1140.13f, 1141.06f, 1142.00f, 1142.93f, 1143.86f, 1144.79f, 1145.71f, 1146.64f, 
1147.56f, 1148.48f, 1149.39f, 1150.31f, 1151.22f, 1152.13f, 1153.03f, 1153.93f, 
1154.83f, 1155.73f, 1156.62f, 1157.51f, 1158.39f, 1159.27f, 1160.14f, 1161.01f, 
1161.88f, 1161.26f, 1162.90f, 1164.44f, 1165.28f, 1166.11f, 1166.94f, 1167.77f, 
1168.58f, 1169.39f, 1170.19f, 1170.98f, 1171.77f, 1172.54f, 1173.31f, 1174.07f, 
1174.82f, 1175.56f, 1176.29f, 1177.02f, 1177.73f, 1178.43f, 1179.12f, 1179.80f, 
1180.47f, 1181.12f, 1181.77f, 1182.41f, 1183.03f, 1183.64f, 1184.24f, 1184.82f, 
1185.40f, 1185.96f, 1186.51f, 1187.04f, 1187.57f, 1188.08f, 1188.57f, 1189.06f, 
1189.53f, 1189.98f, 1190.42f, 1190.85f, 1191.27f, 1191.67f, 1192.06f, 1192.43f, 
1192.79f, 1193.13f, 1193.46f, 1193.78f, 1194.08f, 1194.37f, 1194.64f, 1194.90f, 
1195.14f, 1195.37f, 1195.58f, 1195.78f, 1195.97f, 1196.14f, 1196.29f, 1196.43f, 
1196.56f, 1196.67f, 1196.77f, 1196.85f, 1196.92f, 1196.97f, 1197.01f, 1197.03f, 
1197.04f, 
  16.32f,   17.93f,   22.01f,   27.40f,   33.43f,   39.76f,   46.26f,   52.86f, 
  59.51f,   66.20f,   72.92f,   79.65f,   86.40f,   93.16f,   99.92f,  106.69f, 
 113.46f,  120.24f,  127.01f,  133.75f,  140.46f,  147.15f,  153.81f,  160.45f, 
 167.05f,  173.62f,  180.14f,  186.62f,  193.04f,  199.40f,  205.71f,  211.95f, 
 218.15f,  224.30f,  230.32f,  235.82f,  241.31f,  246.78f,  252.23f,  257.65f, 
 263.06f,  268.44f,  273.79f,  279.11f,  284.40f,  289.66f,  294.34f,  298.91f, 
 303.47f,  308.01f,  312.55f,  317.08f,  321.59f,  326.09f,  330.56f,  335.03f, 
 339.48f,  343.92f,  348.35f,  352.77f,  357.18f,  361.59f,  365.98f,  370.36f, 
 374.74f,  379.10f,  383.44f,  387.78f,  392.10f,  396.40f,  400.69f,  404.97f, 
 409.24f,  413.48f,  417.72f,  421.93f,  426.13f,  430.32f,  434.49f,  438.64f, 
 442.77f,  446.89f,  451.00f,  455.08f,  459.15f,  463.20f,  467.23f,  471.25f, 
 475.25f,  479.23f,  483.20f,  487.14f,  491.07f,  494.98f,  498.88f,  502.75f, 
 506.61f,  510.45f,  514.27f,  518.08f,  521.86f,  525.63f,  529.38f,  533.12f, 
 536.83f,  540.53f,  544.21f,  547.87f,  551.51f,  555.14f,  558.74f,  562.33f, 
 565.90f,  569.46f,  572.99f,  576.51f,  580.01f,  583.49f,  586.95f,  590.40f, 
 593.82f,  597.23f,  600.62f,  604.00f,  607.35f,  610.69f,  614.01f,  617.31f, 
 620.59f,  623.86f,  627.10f,  630.33f,  633.54f,  636.73f,  639.91f,  643.06f, 
 646.20f,  649.32f,  652.42f,  655.51f,  658.57f,  661.62f,  664.65f,  667.66f, 
 670.65f,  673.63f,  676.59f,  679.52f,  682.44f,  685.34f,  688.23f,  691.09f, 
 693.93f,  696.76f,  699.57f,  702.36f,  705.13f,  707.88f,  710.61f,  713.33f, 
 716.02f,  718.70f,  721.36f,  723.99f,  726.61f,  729.21f,  731.79f,  734.35f, 
 736.89f,  739.41f,  741.91f,  744.40f,  746.86f,  749.31f,  751.73f,  754.12f, 
 756.49f,  758.84f,  761.18f,  763.52f,  765.85f,  768.17f,  770.49f,  772.80f, 
 775.11f,  777.41f,  779.71f,  782.00f,  784.29f,  786.57f,  788.84f,  791.11f, 
 793.36f,  795.61f,  797.86f,  800.09f,  802.31f,  804.53f,  806.75f,  808.97f, 
 811.19f,  813.41f,  815.63f,  817.85f,  820.07f,  822.29f,  824.51f,  826.73f, 
 828.95f,  831.17f,  833.39f,  835.61f,  837.83f,  840.04f,  842.26f,  844.48f, 
 846.70f,  848.92f,  851.14f,  853.36f,  855.58f,  857.80f,  860.02f,  862.24f, 
 864.46f,  866.68f,  868.90f,  871.12f,  873.34f,  875.56f,  877.78f, 1107.53f, 
1108.48f, 1109.44f, 1110.40f, 1111.35f, 1112.31f, 1113.27f, 1114.22f, 1115.18f, 
1116.14f, 1117.09f, 1118.05f, 1119.00f, 1119.96f, 1120.91f, 1121.86f, 1122.82f, 
1123.77f, 1124.72f, 1125.67f, 1126.62f, 1127.57f, 1128.52f, 1129.47f, 1130.42f, 
1131.36f, 1132.31f, 1133.25f, 1134.20f, 1135.14f, 1136.08f, 1137.02f, 1137.96f, 
1138.90f, 1139.83f, 1140.76f, 1141.70f, 1142.63f, 1143.55f, 1144.48f, 1145.40f, 
1146.33f, 1147.25f, 1148.16f, 1149.08f, 1149.99f, 1150.90f, 1151.80f, 1152.70f, 
1153.60f, 1154.50f, 1155.39f, 1156.27f, 1157.16f, 1158.04f, 1158.91f, 1159.78f, 
1160.64f, 1160.05f, 1161.70f, 1163.20f, 1164.05f, 1164.88f, 1165.71f, 1166.53f, 
1167.35f, 1168.16f, 1168.96f, 1169.75f, 1170.53f, 1171.31f, 1172.08f, 1172.84f, 
1173.59f, 1174.33f, 1175.06f, 1175.78f, 1176.49f, 1177.19f, 1177.88f, 1178.56f, 
1179.23f, 1179.89f, 1180.53f, 1181.17f, 1181.79f, 1182.40f, 1183.00f, 1183.59f, 
1184.16f, 1184.72f, 1185.27f, 1185.81f, 1186.33f, 1186.84f, 1187.33f, 1187.82f, 
1188.29f, 1188.74f, 1189.18f, 1189.61f, 1190.03f, 1190.43f, 1190.81f, 1191.19f, 
1191.55f, 1191.89f, 1192.22f, 1192.54f, 1192.84f, 1193.12f, 1193.40f, 1193.65f, 
1193.90f, 1194.13f, 1194.34f, 1194.54f, 1194.73f, 1194.90f, 1195.05f, 1195.19f, 
1195.32f, 1195.43f, 1195.53f, 1195.61f, 1195.67f, 1195.73f, 1195.76f, 1195.79f, 
1195.79f, 
  17.56f,   19.04f,   22.88f,   28.07f,   33.94f,   40.17f,   46.59f,   53.12f, 
  59.73f,   66.38f,   73.06f,   79.77f,   86.49f,   93.22f,   99.96f,  106.70f, 
 113.44f,  120.17f,  126.89f,  133.59f,  140.28f,  146.94f,  153.58f,  160.19f, 
 166.76f,  173.30f,  179.80f,  186.24f,  192.63f,  198.96f,  205.24f,  211.46f, 
 217.64f,  223.77f,  229.60f,  235.10f,  240.58f,  246.04f,  251.49f,  256.91f, 
 262.31f,  267.68f,  273.03f,  278.34f,  283.62f,  288.86f,  293.43f,  298.00f, 
 302.55f,  307.10f,  311.63f,  316.15f,  320.66f,  325.16f,  329.63f,  334.10f, 
 338.54f,  342.98f,  347.41f,  351.83f,  356.24f,  360.65f,  365.04f,  369.42f, 
 373.79f,  378.15f,  382.49f,  386.82f,  391.14f,  395.45f,  399.74f,  404.01f, 
 408.27f,  412.52f,  416.75f,  420.96f,  425.16f,  429.34f,  433.51f,  437.66f, 
 441.79f,  445.91f,  450.01f,  454.09f,  458.16f,  462.21f,  466.24f,  470.25f, 
 474.25f,  478.23f,  482.19f,  486.14f,  490.06f,  493.97f,  497.86f,  501.74f, 
 505.59f,  509.43f,  513.25f,  517.05f,  520.84f,  524.60f,  528.35f,  532.08f, 
 535.79f,  539.49f,  543.16f,  546.82f,  550.46f,  554.09f,  557.69f,  561.28f, 
 564.85f,  568.40f,  571.93f,  575.45f,  578.94f,  582.42f,  585.88f,  589.33f, 
 592.75f,  596.16f,  599.55f,  602.92f,  606.27f,  609.61f,  612.93f,  616.22f, 
 619.51f,  622.77f,  626.01f,  629.24f,  632.45f,  635.64f,  638.81f,  641.97f, 
 645.10f,  648.22f,  651.32f,  654.40f,  657.47f,  660.51f,  663.54f,  666.55f, 
 669.54f,  672.51f,  675.47f,  678.41f,  681.32f,  684.22f,  687.10f,  689.97f, 
 692.81f,  695.63f,  698.44f,  701.23f,  704.00f,  706.75f,  709.48f,  712.19f, 
 714.89f,  717.56f,  720.22f,  722.85f,  725.47f,  728.07f,  730.65f,  733.20f, 
 735.74f,  738.26f,  740.76f,  743.24f,  745.71f,  748.15f,  750.57f,  752.96f, 
 755.32f,  757.68f,  760.02f,  762.36f,  764.69f,  767.01f,  769.33f,  771.64f, 
 773.94f,  776.24f,  778.54f,  780.83f,  783.12f,  785.40f,  787.67f,  789.94f, 
 792.19f,  794.44f,  796.69f,  798.92f,  801.14f,  803.36f,  805.58f,  807.80f, 
 810.02f,  812.24f,  814.46f,  816.68f,  818.90f,  821.12f,  823.34f,  825.56f, 
 827.78f,  830.00f,  832.22f,  834.43f,  836.65f,  838.87f,  841.09f,  843.31f, 
 845.53f,  847.75f,  849.97f,  852.19f,  854.41f,  856.63f,  858.85f,  861.07f, 
 863.29f,  865.51f,  867.73f,  869.95f,  872.17f,  874.39f,  876.60f, 1106.30f, 
1107.26f, 1108.21f, 1109.17f, 1110.13f, 1111.08f, 1112.04f, 1113.00f, 1113.95f, 
1114.91f, 1115.86f, 1116.82f, 1117.77f, 1118.73f, 1119.68f, 1120.64f, 1121.59f, 
1122.54f, 1123.49f, 1124.45f, 1125.40f, 1126.35f, 1127.30f, 1128.24f, 1129.19f, 
1130.14f, 1131.08f, 1132.03f, 1132.97f, 1133.91f, 1134.85f, 1135.79f, 1136.73f, 
1137.67f, 1138.60f, 1139.54f, 1140.47f, 1141.40f, 1142.33f, 1143.25f, 1144.18f, 
1145.10f, 1146.02f, 1146.93f, 1147.85f, 1148.76f, 1149.67f, 1150.57f, 1151.47f, 
1152.37f, 1153.27f, 1154.16f, 1155.04f, 1155.93f, 1156.81f, 1157.68f, 1158.55f, 
1159.41f, 1158.85f, 1160.49f, 1161.97f, 1162.81f, 1163.65f, 1164.48f, 1165.30f, 
1166.12f, 1166.92f, 1167.73f, 1168.52f, 1169.30f, 1170.08f, 1170.85f, 1171.61f, 
1172.36f, 1173.10f, 1173.83f, 1174.55f, 1175.26f, 1175.96f, 1176.65f, 1177.33f, 
1178.00f, 1178.65f, 1179.30f, 1179.93f, 1180.56f, 1181.17f, 1181.76f, 1182.35f, 
1182.92f, 1183.49f, 1184.03f, 1184.57f, 1185.09f, 1185.60f, 1186.10f, 1186.58f, 
1187.05f, 1187.50f, 1187.95f, 1188.38f, 1188.79f, 1189.19f, 1189.58f, 1189.95f, 
1190.31f, 1190.65f, 1190.98f, 1191.30f, 1191.60f, 1191.89f, 1192.16f, 1192.42f, 
1192.66f, 1192.89f, 1193.10f, 1193.30f, 1193.49f, 1193.66f, 1193.81f, 1193.95f, 
1194.08f, 1194.19f, 1194.29f, 1194.37f, 1194.43f, 1194.49f, 1194.52f, 1194.55f, 
1194.55f, 
  18.80f,   20.17f,   23.79f,   28.78f,   34.50f,   40.61f,   46.94f,   53.41f, 
  59.96f,   66.56f,   73.21f,   79.88f,   86.57f,   93.27f,   99.98f,  106.68f, 
 113.39f,  120.09f,  126.77f,  133.45f,  140.10f,  146.74f,  153.35f,  159.93f, 
 166.48f,  172.99f,  179.45f,  185.86f,  192.22f,  198.52f,  204.78f,  210.98f, 
 217.14f,  223.24f,  228.89f,  234.38f,  239.86f,  245.32f,  250.76f,  256.18f, 
 261.57f,  266.93f,  272.27f,  277.58f,  282.85f,  287.95f,  292.52f,  297.09f, 
 301.64f,  306.18f,  310.72f,  315.24f,  319.75f,  324.24f,  328.71f,  333.17f, 
 337.62f,  342.05f,  346.48f,  350.90f,  355.31f,  359.71f,  364.10f,  368.48f, 
 372.85f,  377.20f,  381.55f,  385.88f,  390.19f,  394.50f,  398.78f,  403.06f, 
 407.31f,  411.56f,  415.79f,  420.00f,  424.19f,  428.37f,  432.54f,  436.69f, 
 440.82f,  444.93f,  449.03f,  453.11f,  457.17f,  461.22f,  465.25f,  469.26f, 
 473.25f,  477.23f,  481.19f,  485.13f,  489.06f,  492.96f,  496.85f,  500.72f, 
 504.58f,  508.41f,  512.23f,  516.03f,  519.81f,  523.58f,  527.32f,  531.05f, 
 534.76f,  538.45f,  542.13f,  545.79f,  549.42f,  553.05f,  556.65f,  560.23f, 
 563.80f,  567.35f,  570.88f,  574.39f,  577.89f,  581.36f,  584.82f,  588.27f, 
 591.69f,  595.09f,  598.48f,  601.85f,  605.20f,  608.53f,  611.85f,  615.15f, 
 618.43f,  621.69f,  624.93f,  628.16f,  631.36f,  634.55f,  637.72f,  640.87f, 
 644.01f,  647.13f,  650.22f,  653.31f,  656.37f,  659.41f,  662.44f,  665.44f, 
 668.43f,  671.41f,  674.36f,  677.29f,  680.21f,  683.11f,  685.99f,  688.85f, 
 691.69f,  694.51f,  697.32f,  700.10f,  702.87f,  705.62f,  708.35f,  711.06f, 
 713.75f,  716.42f,  719.08f,  721.71f,  724.33f,  726.93f,  729.50f,  732.06f, 
 734.60f,  737.12f,  739.61f,  742.09f,  744.56f,  747.00f,  749.42f,  751.80f, 
 754.17f,  756.52f,  758.86f,  761.20f,  763.53f,  765.85f,  768.17f,  770.48f, 
 772.78f,  775.08f,  777.38f,  779.67f,  781.96f,  784.24f,  786.51f,  788.77f, 
 791.03f,  793.28f,  795.52f,  797.75f,  799.98f,  802.20f,  804.42f,  806.63f, 
 808.85f,  811.07f,  813.29f,  815.51f,  817.73f,  819.95f,  822.17f,  824.39f, 
 826.61f,  828.83f,  831.05f,  833.27f,  835.49f,  837.71f,  839.93f,  842.15f, 
 844.37f,  846.58f,  848.80f,  851.02f,  853.24f,  855.46f,  857.68f,  859.90f, 
 862.12f,  864.34f,  866.56f,  868.78f,  871.00f,  873.22f,  875.44f, 1105.08f, 
1106.03f, 1106.99f, 1107.95f, 1108.90f, 1109.86f, 1110.82f, 1111.77f, 1112.73f, 
1113.69f, 1114.64f, 1115.60f, 1116.55f, 1117.51f, 1118.46f, 1119.41f, 1120.37f, 
1121.32f, 1122.27f, 1123.22f, 1124.17f, 1125.12f, 1126.07f, 1127.02f, 1127.97f, 
1128.91f, 1129.86f, 1130.80f, 1131.75f, 1132.69f, 1133.63f, 1134.57f, 1135.51f, 
1136.44f, 1137.38f, 1138.31f, 1139.24f, 1140.17f, 1141.10f, 1142.03f, 1142.95f, 
1143.87f, 1144.79f, 1145.71f, 1146.62f, 1147.53f, 1148.44f, 1149.35f, 1150.25f, 
1151.15f, 1152.04f, 1152.93f, 1153.82f, 1154.70f, 1155.58f, 1156.45f, 1157.32f, 
1158.19f, 1157.65f, 1159.29f, 1160.75f, 1161.59f, 1162.42f, 1163.25f, 1164.07f, 
1164.89f, 1165.70f, 1166.50f, 1167.29f, 1168.07f, 1168.85f, 1169.62f, 1170.38f, 
1171.13f, 1171.87f, 1172.60f, 1173.32f, 1174.03f, 1174.73f, 1175.42f, 1176.10f, 
1176.77f, 1177.42f, 1178.07f, 1178.70f, 1179.33f, 1179.94f, 1180.53f, 1181.12f, 
1181.69f, 1182.25f, 1182.80f, 1183.34f, 1183.86f, 1184.37f, 1184.86f, 1185.35f, 
1185.82f, 1186.27f, 1186.71f, 1187.14f, 1187.56f, 1187.96f, 1188.34f, 1188.72f, 
1189.07f, 1189.42f, 1189.75f, 1190.06f, 1190.36f, 1190.65f, 1190.92f, 1191.18f, 
1191.42f, 1191.65f, 1191.87f, 1192.07f, 1192.25f, 1192.42f, 1192.58f, 1192.72f, 
1192.84f, 1192.95f, 1193.05f, 1193.13f, 1193.20f, 1193.25f, 1193.29f, 1193.31f, 
1193.32f, 
  20.03f,   21.31f,   24.73f,   29.52f,   35.08f,   41.07f,   47.32f,   53.71f, 
  60.20f,   66.76f,   73.36f,   79.99f,   86.65f,   93.31f,   99.99f,  106.66f, 
 113.33f,  120.00f,  126.66f,  133.30f,  139.93f,  146.54f,  153.12f,  159.67f, 
 166.19f,  172.67f,  179.10f,  185.48f,  191.81f,  198.09f,  204.32f,  210.50f, 
 216.64f,  222.68f,  228.19f,  233.68f,  239.15f,  244.61f,  250.04f,  255.45f, 
 260.83f,  266.19f,  271.52f,  276.82f,  282.09f,  287.05f,  291.62f,  296.19f, 
 300.74f,  305.28f,  309.81f,  314.33f,  318.83f,  323.32f,  327.79f,  332.25f, 
 336.70f,  341.13f,  345.56f,  349.97f,  354.38f,  358.78f,  363.17f,  367.55f, 
 371.92f,  376.27f,  380.61f,  384.94f,  389.25f,  393.55f,  397.84f,  402.11f, 
 406.36f,  410.60f,  414.83f,  419.04f,  423.23f,  427.41f,  431.57f,  435.72f, 
 439.85f,  443.96f,  448.05f,  452.13f,  456.19f,  460.24f,  464.26f,  468.27f, 
 472.26f,  476.24f,  480.20f,  484.14f,  488.06f,  491.96f,  495.85f,  499.72f, 
 503.57f,  507.40f,  511.22f,  515.02f,  518.80f,  522.56f,  526.30f,  530.03f, 
 533.74f,  537.43f,  541.10f,  544.75f,  548.39f,  552.01f,  555.61f,  559.19f, 
 562.76f,  566.30f,  569.83f,  573.34f,  576.84f,  580.31f,  583.77f,  587.21f, 
 590.63f,  594.03f,  597.42f,  600.78f,  604.13f,  607.47f,  610.78f,  614.07f, 
 617.35f,  620.61f,  623.85f,  627.07f,  630.28f,  633.47f,  636.64f,  639.79f, 
 642.92f,  646.04f,  649.13f,  652.21f,  655.27f,  658.31f,  661.34f,  664.34f, 
 667.33f,  670.30f,  673.25f,  676.18f,  679.10f,  682.00f,  684.87f,  687.73f, 
 690.57f,  693.39f,  696.20f,  698.98f,  701.75f,  704.50f,  707.22f,  709.93f, 
 712.62f,  715.29f,  717.95f,  720.58f,  723.20f,  725.79f,  728.37f,  730.92f, 
 733.46f,  735.97f,  738.47f,  740.95f,  743.41f,  745.85f,  748.27f,  750.65f, 
 753.01f,  755.37f,  757.71f,  760.04f,  762.37f,  764.69f,  767.01f,  769.32f, 
 771.63f,  773.93f,  776.22f,  778.51f,  780.80f,  783.08f,  785.35f,  787.61f, 
 789.87f,  792.12f,  794.36f,  796.59f,  798.81f,  801.03f,  803.25f,  805.47f, 
 807.69f,  809.91f,  812.13f,  814.35f,  816.57f,  818.79f,  821.01f,  823.23f, 
 825.45f,  827.67f,  829.89f,  832.11f,  834.33f,  836.55f,  838.76f,  840.98f, 
 843.20f,  845.42f,  847.64f,  849.86f,  852.08f,  854.30f,  856.52f,  858.74f, 
 860.96f,  863.18f,  865.40f,  867.62f,  869.84f,  872.06f,  874.28f, 1103.86f, 
1104.81f, 1105.77f, 1106.73f, 1107.69f, 1108.64f, 1109.60f, 1110.55f, 1111.51f, 
1112.47f, 1113.42f, 1114.38f, 1115.33f, 1116.29f, 1117.24f, 1118.19f, 1119.15f, 
1120.10f, 1121.05f, 1122.00f, 1122.95f, 1123.90f, 1124.85f, 1125.80f, 1126.75f, 
1127.69f, 1128.64f, 1129.58f, 1130.53f, 1131.47f, 1132.41f, 1133.35f, 1134.29f, 
1135.22f, 1136.16f, 1137.09f, 1138.02f, 1138.95f, 1139.88f, 1140.81f, 1141.73f, 
1142.65f, 1143.57f, 1144.49f, 1145.40f, 1146.31f, 1147.22f, 1148.13f, 1149.03f, 
1149.93f, 1150.82f, 1151.71f, 1152.60f, 1153.48f, 1154.36f, 1155.23f, 1156.10f, 
1156.97f, 1156.46f, 1158.10f, 1159.53f, 1160.37f, 1161.20f, 1162.03f, 1162.85f, 
1163.67f, 1164.48f, 1165.28f, 1166.07f, 1166.85f, 1167.63f, 1168.39f, 1169.15f, 
1169.90f, 1170.64f, 1171.37f, 1172.09f, 1172.80f, 1173.50f, 1174.19f, 1174.87f, 
1175.54f, 1176.20f, 1176.84f, 1177.48f, 1178.10f, 1178.71f, 1179.31f, 1179.89f, 
1180.47f, 1181.03f, 1181.57f, 1182.11f, 1182.63f, 1183.14f, 1183.64f, 1184.12f, 
1184.59f, 1185.04f, 1185.48f, 1185.91f, 1186.33f, 1186.73f, 1187.11f, 1187.49f, 
1187.84f, 1188.19f, 1188.52f, 1188.83f, 1189.13f, 1189.42f, 1189.69f, 1189.95f, 
1190.19f, 1190.42f, 1190.64f, 1190.84f, 1191.02f, 1191.19f, 1191.35f, 1191.49f, 
1191.61f, 1191.72f, 1191.82f, 1191.90f, 1191.97f, 1192.02f, 1192.06f, 1192.08f, 
1192.09f, 
  21.26f,   22.45f,   25.69f,   30.30f,   35.70f,   41.57f,   47.72f,   54.04f, 
  60.47f,   66.97f,   73.53f,   80.12f,   86.73f,   93.36f,  100.00f,  106.64f, 
 113.28f,  119.92f,  126.55f,  133.16f,  139.76f,  146.34f,  152.89f,  159.42f, 
 165.91f,  172.36f,  178.76f,  185.11f,  191.41f,  197.67f,  203.87f,  210.03f, 
 216.15f,  221.99f,  227.49f,  232.98f,  238.45f,  243.90f,  249.33f,  254.73f, 
 260.11f,  265.46f,  270.78f,  276.08f,  281.34f,  286.16f,  290.73f,  295.29f, 
 299.84f,  304.38f,  308.91f,  313.43f,  317.93f,  322.41f,  326.88f,  331.34f, 
 335.78f,  340.21f,  344.64f,  349.06f,  353.46f,  357.86f,  362.25f,  366.62f, 
 370.99f,  375.34f,  379.68f,  384.00f,  388.31f,  392.61f,  396.90f,  401.16f, 
 405.42f,  409.66f,  413.88f,  418.09f,  422.28f,  426.45f,  430.61f,  434.76f, 
 438.88f,  442.99f,  447.08f,  451.16f,  455.22f,  459.26f,  463.28f,  467.29f, 
 471.28f,  475.25f,  479.21f,  483.15f,  487.07f,  490.97f,  494.85f,  498.72f, 
 502.57f,  506.40f,  510.21f,  514.01f,  517.78f,  521.54f,  525.29f,  529.01f, 
 532.71f,  536.40f,  540.07f,  543.73f,  547.36f,  550.98f,  554.58f,  558.16f, 
 561.72f,  565.26f,  568.79f,  572.30f,  575.79f,  579.26f,  582.72f,  586.16f, 
 589.57f,  592.98f,  596.36f,  599.72f,  603.07f,  606.40f,  609.71f,  613.01f, 
 616.28f,  619.54f,  622.78f,  626.00f,  629.20f,  632.39f,  635.56f,  638.70f, 
 641.84f,  644.95f,  648.04f,  651.12f,  654.18f,  657.22f,  660.24f,  663.25f, 
 666.23f,  669.20f,  672.15f,  675.08f,  677.99f,  680.89f,  683.76f,  686.62f, 
 689.46f,  692.28f,  695.08f,  697.87f,  700.63f,  703.38f,  706.10f,  708.81f, 
 711.50f,  714.17f,  716.82f,  719.45f,  722.07f,  724.66f,  727.23f,  729.79f, 
 732.32f,  734.84f,  737.33f,  739.81f,  742.27f,  744.71f,  747.12f,  749.50f, 
 751.87f,  754.22f,  756.56f,  758.89f,  761.22f,  763.54f,  765.86f,  768.17f, 
 770.47f,  772.77f,  775.07f,  777.36f,  779.65f,  781.92f,  784.20f,  786.46f, 
 788.72f,  790.96f,  793.20f,  795.43f,  797.66f,  799.88f,  802.10f,  804.32f, 
 806.53f,  808.75f,  810.97f,  813.19f,  815.41f,  817.63f,  819.85f,  822.07f, 
 824.29f,  826.51f,  828.73f,  830.95f,  833.17f,  835.39f,  837.61f,  839.83f, 
 842.05f,  844.27f,  846.49f,  848.70f,  850.92f,  853.14f,  855.36f,  857.58f, 
 859.80f,  862.02f,  864.24f,  866.46f,  868.68f,  870.90f,  873.12f, 1102.64f, 
1103.60f, 1104.56f, 1105.51f, 1106.47f, 1107.43f, 1108.38f, 1109.34f, 1110.30f, 
1111.25f, 1112.21f, 1113.16f, 1114.12f, 1115.07f, 1116.03f, 1116.98f, 1117.93f, 
1118.89f, 1119.84f, 1120.79f, 1121.74f, 1122.69f, 1123.64f, 1124.59f, 1125.53f, 
1126.48f, 1127.42f, 1128.37f, 1129.31f, 1130.25f, 1131.20f, 1132.13f, 1133.07f, 
1134.01f, 1134.94f, 1135.88f, 1136.81f, 1137.74f, 1138.67f, 1139.59f, 1140.52f, 
1141.44f, 1142.36f, 1143.27f, 1144.19f, 1145.10f, 1146.01f, 1146.91f, 1147.81f, 
1148.71f, 1149.60f, 1150.50f, 1151.38f, 1152.27f, 1153.14f, 1154.02f, 1154.89f, 
1155.75f, 1155.27f, 1156.90f, 1158.31f, 1159.15f, 1159.98f, 1160.81f, 1161.63f, 
1162.45f, 1163.26f, 1164.06f, 1164.85f, 1165.63f, 1166.41f, 1167.18f, 1167.93f, 
1168.68f, 1169.42f, 1170.15f, 1170.87f, 1171.58f, 1172.28f, 1172.97f, 1173.65f, 
1174.32f, 1174.98f, 1175.62f, 1176.25f, 1176.88f, 1177.49f, 1178.08f, 1178.67f, 
1179.24f, 1179.80f, 1180.35f, 1180.89f, 1181.41f, 1181.92f, 1182.41f, 1182.89f, 
1183.36f, 1183.82f, 1184.26f, 1184.69f, 1185.10f, 1185.50f, 1185.89f, 1186.26f, 
1186.62f, 1186.96f, 1187.29f, 1187.61f, 1187.91f, 1188.19f, 1188.47f, 1188.72f, 
1188.97f, 1189.20f, 1189.41f, 1189.61f, 1189.79f, 1189.96f, 1190.12f, 1190.26f, 
1190.38f, 1190.50f, 1190.59f, 1190.67f, 1190.74f, 1190.79f, 1190.83f, 1190.85f, 
1190.86f, 
  22.48f,   23.60f,   26.68f,   31.10f,   36.35f,   42.10f,   48.15f,   54.39f, 
  60.75f,   67.20f,   73.71f,   80.26f,   86.83f,   93.42f,  100.03f,  106.63f, 
 113.24f,  119.85f,  126.44f,  133.03f,  139.60f,  146.15f,  152.67f,  159.17f, 
 165.63f,  172.05f,  178.42f,  184.74f,  191.01f,  197.24f,  203.43f,  209.57f, 
 215.66f,  221.31f,  226.81f,  232.29f,  237.76f,  243.20f,  248.62f,  254.02f, 
 259.39f,  264.73f,  270.05f,  275.33f,  280.59f,  285.28f,  289.84f,  294.40f, 
 298.95f,  303.49f,  308.02f,  312.53f,  317.03f,  321.51f,  325.98f,  330.43f, 
 334.87f,  339.31f,  343.73f,  348.14f,  352.55f,  356.94f,  361.33f,  365.70f, 
 370.07f,  374.41f,  378.75f,  383.07f,  387.38f,  391.68f,  395.96f,  400.23f, 
 404.48f,  408.71f,  412.94f,  417.14f,  421.33f,  425.50f,  429.66f,  433.80f, 
 437.92f,  442.03f,  446.12f,  450.19f,  454.25f,  458.29f,  462.31f,  466.32f, 
 470.30f,  474.27f,  478.23f,  482.16f,  486.08f,  489.98f,  493.86f,  497.72f, 
 501.57f,  505.40f,  509.21f,  513.00f,  516.78f,  520.54f,  524.27f,  528.00f, 
 531.70f,  535.39f,  539.05f,  542.70f,  546.34f,  549.95f,  553.55f,  557.13f, 
 560.69f,  564.23f,  567.75f,  571.26f,  574.75f,  578.22f,  581.67f,  585.11f, 
 588.53f,  591.93f,  595.31f,  598.67f,  602.02f,  605.34f,  608.65f,  611.94f, 
 615.22f,  618.47f,  621.71f,  624.93f,  628.13f,  631.31f,  634.48f,  637.63f, 
 640.76f,  643.87f,  646.96f,  650.04f,  653.09f,  656.13f,  659.15f,  662.16f, 
 665.14f,  668.11f,  671.05f,  673.98f,  676.90f,  679.79f,  682.66f,  685.52f, 
 688.35f,  691.17f,  693.97f,  696.76f,  699.52f,  702.26f,  704.99f,  707.69f, 
 710.38f,  713.05f,  715.70f,  718.33f,  720.94f,  723.53f,  726.11f,  728.66f, 
 731.19f,  733.70f,  736.20f,  738.67f,  741.13f,  743.57f,  745.98f,  748.36f, 
 750.72f,  753.07f,  755.42f,  757.75f,  760.08f,  762.40f,  764.71f,  767.02f, 
 769.33f,  771.63f,  773.92f,  776.21f,  778.50f,  780.78f,  783.05f,  785.31f, 
 787.56f,  789.81f,  792.05f,  794.28f,  796.50f,  798.72f,  800.94f,  803.16f, 
 805.38f,  807.60f,  809.82f,  812.04f,  814.26f,  816.48f,  818.70f,  820.92f, 
 823.14f,  825.36f,  827.58f,  829.80f,  832.02f,  834.24f,  836.45f,  838.67f, 
 840.89f,  843.11f,  845.33f,  847.55f,  849.77f,  851.99f,  854.21f,  856.43f, 
 858.65f,  860.87f,  863.09f,  865.31f,  867.53f,  869.75f,  871.97f, 1101.43f, 
1102.39f, 1103.35f, 1104.30f, 1105.26f, 1106.22f, 1107.17f, 1108.13f, 1109.09f, 
1110.04f, 1111.00f, 1111.95f, 1112.91f, 1113.86f, 1114.82f, 1115.77f, 1116.72f, 
1117.67f, 1118.63f, 1119.58f, 1120.53f, 1121.48f, 1122.43f, 1123.38f, 1124.32f, 
1125.27f, 1126.21f, 1127.16f, 1128.10f, 1129.04f, 1129.98f, 1130.92f, 1131.86f, 
1132.80f, 1133.73f, 1134.67f, 1135.60f, 1136.53f, 1137.46f, 1138.38f, 1139.31f, 
1140.23f, 1141.15f, 1142.06f, 1142.98f, 1143.89f, 1144.79f, 1145.70f, 1146.60f, 
1147.50f, 1148.39f, 1149.28f, 1150.17f, 1151.05f, 1151.93f, 1152.80f, 1153.67f, 
1154.54f, 1154.09f, 1155.72f, 1157.09f, 1157.94f, 1158.77f, 1159.60f, 1160.42f, 
1161.24f, 1162.04f, 1162.84f, 1163.63f, 1164.42f, 1165.19f, 1165.96f, 1166.72f, 
1167.47f, 1168.21f, 1168.94f, 1169.66f, 1170.37f, 1171.07f, 1171.76f, 1172.43f, 
1173.10f, 1173.76f, 1174.40f, 1175.04f, 1175.66f, 1176.27f, 1176.87f, 1177.45f, 
1178.02f, 1178.58f, 1179.13f, 1179.67f, 1180.19f, 1180.70f, 1181.19f, 1181.67f, 
1182.14f, 1182.60f, 1183.04f, 1183.47f, 1183.88f, 1184.28f, 1184.67f, 1185.04f, 
1185.40f, 1185.74f, 1186.07f, 1186.38f, 1186.69f, 1186.97f, 1187.24f, 1187.50f, 
1187.74f, 1187.97f, 1188.19f, 1188.39f, 1188.57f, 1188.74f, 1188.90f, 1189.04f, 
1189.16f, 1189.27f, 1189.37f, 1189.45f, 1189.52f, 1189.57f, 1189.61f, 1189.63f, 
1189.64f, 
  23.70f,   24.76f,   27.68f,   31.93f,   37.03f,   42.65f,   48.60f,   54.76f, 
  61.06f,   67.45f,   73.91f,   80.41f,   86.94f,   93.50f,  100.06f,  106.64f, 
 113.21f,  119.78f,  126.35f,  132.90f,  139.44f,  145.96f,  152.46f,  158.93f, 
 165.35f,  171.74f,  178.08f,  184.37f,  190.62f,  196.83f,  202.99f,  209.11f, 
 215.14f,  220.64f,  226.14f,  231.61f,  237.07f,  242.51f,  247.92f,  253.31f, 
 258.68f,  264.02f,  269.32f,  274.60f,  279.82f,  284.40f,  288.96f,  293.52f, 
 298.07f,  302.60f,  307.13f,  311.64f,  316.14f,  320.62f,  325.08f,  329.53f, 
 333.97f,  338.40f,  342.82f,  347.24f,  351.64f,  356.03f,  360.42f,  364.79f, 
 369.15f,  373.50f,  377.83f,  382.15f,  386.46f,  390.75f,  395.03f,  399.30f, 
 403.55f,  407.78f,  412.00f,  416.20f,  420.39f,  424.56f,  428.71f,  432.85f, 
 436.97f,  441.07f,  445.16f,  449.23f,  453.29f,  457.32f,  461.34f,  465.35f, 
 469.33f,  473.30f,  477.25f,  481.18f,  485.10f,  488.99f,  492.87f,  496.73f, 
 500.58f,  504.41f,  508.21f,  512.00f,  515.78f,  519.53f,  523.27f,  526.99f, 
 530.69f,  534.37f,  538.04f,  541.69f,  545.32f,  548.93f,  552.52f,  556.10f, 
 559.66f,  563.20f,  566.72f,  570.23f,  573.71f,  577.18f,  580.63f,  584.07f, 
 587.48f,  590.88f,  594.26f,  597.62f,  600.96f,  604.29f,  607.60f,  610.89f, 
 614.16f,  617.41f,  620.65f,  623.87f,  627.06f,  630.25f,  633.41f,  636.56f, 
 639.68f,  642.79f,  645.88f,  648.96f,  652.01f,  655.05f,  658.07f,  661.07f, 
 664.05f,  667.02f,  669.96f,  672.89f,  675.80f,  678.69f,  681.56f,  684.42f, 
 687.25f,  690.07f,  692.87f,  695.65f,  698.41f,  701.15f,  703.88f,  706.58f, 
 709.27f,  711.93f,  714.58f,  717.21f,  719.82f,  722.41f,  724.98f,  727.53f, 
 730.06f,  732.58f,  735.07f,  737.54f,  740.00f,  742.44f,  744.85f,  747.22f, 
 749.58f,  751.93f,  754.28f,  756.61f,  758.94f,  761.26f,  763.57f,  765.88f, 
 768.18f,  770.48f,  772.78f,  775.07f,  777.35f,  779.63f,  781.90f,  784.16f, 
 786.42f,  788.67f,  790.90f,  793.13f,  795.36f,  797.58f,  799.80f,  802.01f, 
 804.23f,  806.45f,  808.67f,  810.89f,  813.11f,  815.33f,  817.55f,  819.77f, 
 821.99f,  824.21f,  826.43f,  828.65f,  830.87f,  833.09f,  835.31f,  837.53f, 
 839.75f,  841.97f,  844.18f,  846.40f,  848.62f,  850.84f,  853.06f,  855.28f, 
 857.50f,  859.72f,  861.94f,  864.16f,  866.38f,  868.60f,  870.82f, 1100.22f, 
1101.18f, 1102.14f, 1103.10f, 1104.05f, 1105.01f, 1105.97f, 1106.92f, 1107.88f, 
1108.84f, 1109.79f, 1110.75f, 1111.70f, 1112.66f, 1113.61f, 1114.56f, 1115.52f, 
1116.47f, 1117.42f, 1118.37f, 1119.32f, 1120.27f, 1121.22f, 1122.17f, 1123.12f, 
1124.06f, 1125.01f, 1125.95f, 1126.90f, 1127.84f, 1128.78f, 1129.72f, 1130.66f, 
1131.59f, 1132.53f, 1133.46f, 1134.39f, 1135.32f, 1136.25f, 1137.17f, 1138.10f, 
1139.02f, 1139.94f, 1140.85f, 1141.77f, 1142.68f, 1143.59f, 1144.49f, 1145.39f, 
1146.29f, 1147.18f, 1148.08f, 1148.96f, 1149.84f, 1150.72f, 1151.60f, 1152.46f, 
1153.33f, 1152.91f, 1154.53f, 1155.89f, 1156.73f, 1157.56f, 1158.39f, 1159.21f, 
1160.03f, 1160.83f, 1161.63f, 1162.42f, 1163.21f, 1163.98f, 1164.75f, 1165.51f, 
1166.26f, 1167.00f, 1167.73f, 1168.45f, 1169.16f, 1169.85f, 1170.54f, 1171.22f, 
1171.89f, 1172.55f, 1173.19f, 1173.82f, 1174.44f, 1175.05f, 1175.65f, 1176.24f, 
1176.81f, 1177.37f, 1177.92f, 1178.45f, 1178.97f, 1179.48f, 1179.98f, 1180.46f, 
1180.93f, 1181.38f, 1181.82f, 1182.25f, 1182.66f, 1183.06f, 1183.45f, 1183.82f, 
1184.18f, 1184.52f, 1184.85f, 1185.17f, 1185.47f, 1185.75f, 1186.03f, 1186.28f, 
1186.53f, 1186.75f, 1186.97f, 1187.17f, 1187.35f, 1187.52f, 1187.68f, 1187.82f, 
1187.94f, 1188.05f, 1188.15f, 1188.23f, 1188.30f, 1188.35f, 1188.39f, 1188.41f, 
1188.42f, 
  24.91f,   25.91f,   28.69f,   32.78f,   37.74f,   43.24f,   49.09f,   55.16f, 
  61.39f,   67.72f,   74.12f,   80.58f,   87.07f,   93.58f,  100.11f,  106.65f, 
 113.19f,  119.73f,  126.27f,  132.79f,  139.30f,  145.79f,  152.25f,  158.69f, 
 165.08f,  171.43f,  177.74f,  184.01f,  190.23f,  196.42f,  202.56f,  208.66f, 
 214.48f,  219.98f,  225.47f,  230.94f,  236.39f,  241.82f,  247.23f,  252.62f, 
 257.98f,  263.31f,  268.61f,  273.87f,  278.95f,  283.53f,  288.09f,  292.64f, 
 297.19f,  301.72f,  306.25f,  310.76f,  315.25f,  319.73f,  324.19f,  328.64f, 
 333.08f,  337.50f,  341.93f,  346.34f,  350.74f,  355.13f,  359.51f,  363.88f, 
 368.24f,  372.59f,  376.92f,  381.24f,  385.54f,  389.83f,  394.11f,  398.37f, 
 402.62f,  406.85f,  411.07f,  415.27f,  419.45f,  423.62f,  427.77f,  431.91f, 
 436.02f,  440.13f,  444.21f,  448.28f,  452.33f,  456.37f,  460.38f,  464.38f, 
 468.36f,  472.33f,  476.28f,  480.21f,  484.12f,  488.01f,  491.89f,  495.75f, 
 499.59f,  503.42f,  507.22f,  511.01f,  514.78f,  518.53f,  522.27f,  525.99f, 
 529.69f,  533.37f,  537.03f,  540.68f,  544.30f,  547.91f,  551.51f,  555.08f, 
 558.64f,  562.18f,  565.70f,  569.20f,  572.68f,  576.15f,  579.60f,  583.03f, 
 586.44f,  589.84f,  593.22f,  596.58f,  599.92f,  603.24f,  606.55f,  609.83f, 
 613.10f,  616.36f,  619.59f,  622.81f,  626.00f,  629.18f,  632.34f,  635.49f, 
 638.61f,  641.72f,  644.81f,  647.88f,  650.94f,  653.97f,  656.99f,  659.99f, 
 662.97f,  665.93f,  668.88f,  671.80f,  674.71f,  677.60f,  680.47f,  683.32f, 
 686.16f,  688.97f,  691.77f,  694.55f,  697.31f,  700.05f,  702.77f,  705.47f, 
 708.16f,  710.82f,  713.47f,  716.10f,  718.71f,  721.29f,  723.86f,  726.41f, 
 728.94f,  731.45f,  733.94f,  736.42f,  738.87f,  741.31f,  743.72f,  746.09f, 
 748.45f,  750.80f,  753.14f,  755.47f,  757.80f,  760.12f,  762.43f,  764.74f, 
 767.05f,  769.35f,  771.64f,  773.93f,  776.21f,  778.49f,  780.76f,  783.02f, 
 785.28f,  787.52f,  789.76f,  791.99f,  794.21f,  796.43f,  798.65f,  800.87f, 
 803.09f,  805.31f,  807.53f,  809.75f,  811.97f,  814.19f,  816.41f,  818.63f, 
 820.85f,  823.07f,  825.29f,  827.51f,  829.72f,  831.94f,  834.16f,  836.38f, 
 838.60f,  840.82f,  843.04f,  845.26f,  847.48f,  849.70f,  851.92f,  854.14f, 
 856.36f,  858.58f,  860.80f,  863.02f,  865.24f,  867.46f,  869.67f, 1099.02f, 
1099.98f, 1100.94f, 1101.89f, 1102.85f, 1103.81f, 1104.77f, 1105.72f, 1106.68f, 
1107.63f, 1108.59f, 1109.54f, 1110.50f, 1111.45f, 1112.41f, 1113.36f, 1114.31f, 
1115.27f, 1116.22f, 1117.17f, 1118.12f, 1119.07f, 1120.02f, 1120.97f, 1121.91f, 
1122.86f, 1123.81f, 1124.75f, 1125.69f, 1126.63f, 1127.58f, 1128.51f, 1129.45f, 
1130.39f, 1131.32f, 1132.26f, 1133.19f, 1134.12f, 1135.05f, 1135.97f, 1136.90f, 
1137.82f, 1138.73f, 1139.65f, 1140.56f, 1141.48f, 1142.38f, 1143.29f, 1144.19f, 
1145.09f, 1145.98f, 1146.87f, 1147.76f, 1148.64f, 1149.52f, 1150.39f, 1151.26f, 
1152.12f, 1151.73f, 1153.35f, 1154.68f, 1155.52f, 1156.36f, 1157.18f, 1158.01f, 
1158.82f, 1159.63f, 1160.43f, 1161.22f, 1162.00f, 1162.78f, 1163.54f, 1164.30f, 
1165.05f, 1165.79f, 1166.52f, 1167.24f, 1167.95f, 1168.65f, 1169.34f, 1170.01f, 
1170.68f, 1171.34f, 1171.98f, 1172.61f, 1173.24f, 1173.84f, 1174.44f, 1175.03f, 
1175.60f, 1176.16f, 1176.71f, 1177.24f, 1177.76f, 1178.27f, 1178.76f, 1179.25f, 
1179.71f, 1180.17f, 1180.61f, 1181.04f, 1181.45f, 1181.85f, 1182.24f, 1182.61f, 
1182.97f, 1183.31f, 1183.64f, 1183.95f, 1184.25f, 1184.54f, 1184.81f, 1185.07f, 
1185.31f, 1185.54f, 1185.75f, 1185.95f, 1186.14f, 1186.31f, 1186.46f, 1186.60f, 
1186.73f, 1186.84f, 1186.93f, 1187.02f, 1187.08f, 1187.13f, 1187.17f, 1187.19f, 
1187.20f, 
  26.12f,   27.07f,   29.72f,   33.66f,   38.47f,   43.85f,   49.59f,   55.58f, 
  61.73f,   68.00f,   74.35f,   80.76f,   87.20f,   93.68f,  100.17f,  106.68f, 
 113.19f,  119.70f,  126.20f,  132.69f,  139.17f,  145.62f,  152.05f,  158.45f, 
 164.80f,  171.13f,  177.41f,  183.65f,  189.85f,  196.01f,  202.13f,  208.21f, 
 213.83f,  219.33f,  224.81f,  230.28f,  235.72f,  241.15f,  246.55f,  251.93f, 
 257.28f,  262.60f,  267.89f,  273.15f,  278.09f,  282.66f,  287.22f,  291.78f, 
 296.32f,  300.85f,  305.37f,  309.88f,  314.37f,  318.84f,  323.30f,  327.75f, 
 332.19f,  336.61f,  341.03f,  345.44f,  349.84f,  354.23f,  358.61f,  362.98f, 
 367.34f,  371.68f,  376.01f,  380.33f,  384.63f,  388.92f,  393.19f,  397.45f, 
 401.70f,  405.93f,  410.14f,  414.34f,  418.52f,  422.69f,  426.83f,  430.97f, 
 435.08f,  439.18f,  443.27f,  447.33f,  451.38f,  455.41f,  459.43f,  463.42f, 
 467.40f,  471.37f,  475.31f,  479.24f,  483.15f,  487.04f,  490.92f,  494.77f, 
 498.61f,  502.43f,  506.24f,  510.02f,  513.79f,  517.54f,  521.28f,  524.99f, 
 528.69f,  532.37f,  536.03f,  539.67f,  543.30f,  546.90f,  550.49f,  554.07f, 
 557.62f,  561.16f,  564.68f,  568.18f,  571.66f,  575.12f,  578.57f,  582.00f, 
 585.41f,  588.80f,  592.18f,  595.54f,  598.88f,  602.20f,  605.50f,  608.79f, 
 612.05f,  615.30f,  618.54f,  621.75f,  624.95f,  628.12f,  631.28f,  634.43f, 
 637.55f,  640.66f,  643.74f,  646.81f,  649.87f,  652.90f,  655.91f,  658.91f, 
 661.89f,  664.85f,  667.80f,  670.72f,  673.63f,  676.51f,  679.38f,  682.23f, 
 685.07f,  687.88f,  690.67f,  693.45f,  696.21f,  698.95f,  701.67f,  704.37f, 
 707.05f,  709.72f,  712.36f,  714.99f,  717.59f,  720.18f,  722.75f,  725.30f, 
 727.83f,  730.33f,  732.82f,  735.30f,  737.75f,  740.19f,  742.59f,  744.96f, 
 747.32f,  749.67f,  752.01f,  754.34f,  756.67f,  758.99f,  761.30f,  763.61f, 
 765.91f,  768.21f,  770.51f,  772.80f,  775.08f,  777.36f,  779.63f,  781.89f, 
 784.14f,  786.39f,  788.62f,  790.85f,  793.07f,  795.29f,  797.51f,  799.73f, 
 801.95f,  804.17f,  806.39f,  808.61f,  810.83f,  813.05f,  815.27f,  817.49f, 
 819.71f,  821.93f,  824.15f,  826.37f,  828.59f,  830.81f,  833.02f,  835.24f, 
 837.46f,  839.68f,  841.90f,  844.12f,  846.34f,  848.56f,  850.78f,  853.00f, 
 855.22f,  857.44f,  859.66f,  861.88f,  864.10f,  866.32f,  868.54f, 1097.82f, 
1098.78f, 1099.74f, 1100.70f, 1101.65f, 1102.61f, 1103.57f, 1104.52f, 1105.48f, 
1106.44f, 1107.39f, 1108.35f, 1109.30f, 1110.26f, 1111.21f, 1112.16f, 1113.12f, 
1114.07f, 1115.02f, 1115.97f, 1116.92f, 1117.87f, 1118.82f, 1119.77f, 1120.72f, 
1121.66f, 1122.61f, 1123.55f, 1124.49f, 1125.44f, 1126.38f, 1127.32f, 1128.25f, 
1129.19f, 1130.13f, 1131.06f, 1131.99f, 1132.92f, 1133.85f, 1134.77f, 1135.70f, 
1136.62f, 1137.54f, 1138.45f, 1139.37f, 1140.28f, 1141.18f, 1142.09f, 1142.99f, 
1143.89f, 1144.78f, 1145.67f, 1146.56f, 1147.44f, 1148.32f, 1149.19f, 1150.06f, 
1150.92f, 1150.56f, 1152.18f, 1153.48f, 1154.32f, 1155.15f, 1155.98f, 1156.80f, 
1157.62f, 1158.42f, 1159.22f, 1160.02f, 1160.80f, 1161.57f, 1162.34f, 1163.10f, 
1163.85f, 1164.58f, 1165.31f, 1166.03f, 1166.74f, 1167.44f, 1168.13f, 1168.81f, 
1169.48f, 1170.13f, 1170.78f, 1171.41f, 1172.03f, 1172.64f, 1173.24f, 1173.82f, 
1174.39f, 1174.95f, 1175.50f, 1176.03f, 1176.55f, 1177.06f, 1177.56f, 1178.04f, 
1178.51f, 1178.96f, 1179.40f, 1179.83f, 1180.24f, 1180.64f, 1181.03f, 1181.40f, 
1181.76f, 1182.10f, 1182.43f, 1182.74f, 1183.04f, 1183.33f, 1183.60f, 1183.86f, 
1184.10f, 1184.33f, 1184.54f, 1184.74f, 1184.93f, 1185.10f, 1185.25f, 1185.39f, 
1185.52f, 1185.63f, 1185.72f, 1185.81f, 1185.87f, 1185.92f, 1185.96f, 1185.98f, 
1185.99f, 
  27.33f,   28.23f,   30.76f,   34.55f,   39.22f,   44.48f,   50.12f,   56.02f, 
  62.10f,   68.31f,   74.60f,   80.96f,   87.36f,   93.79f,  100.25f,  106.72f, 
 113.19f,  119.67f,  126.14f,  132.60f,  139.04f,  145.45f,  151.84f,  158.20f, 
 164.53f,  170.82f,  177.08f,  183.30f,  189.47f,  195.61f,  201.71f,  207.68f, 
 213.19f,  218.68f,  224.16f,  229.62f,  235.06f,  240.48f,  245.88f,  251.25f, 
 256.59f,  261.90f,  267.19f,  272.44f,  277.23f,  281.80f,  286.36f,  290.91f, 
 295.46f,  299.99f,  304.50f,  309.01f,  313.50f,  317.97f,  322.42f,  326.87f, 
 331.30f,  335.73f,  340.15f,  344.56f,  348.95f,  353.34f,  357.72f,  362.09f, 
 366.44f,  370.78f,  375.11f,  379.42f,  383.73f,  388.01f,  392.28f,  396.54f, 
 400.78f,  405.01f,  409.22f,  413.42f,  417.60f,  421.76f,  425.90f,  430.03f, 
 434.15f,  438.24f,  442.32f,  446.39f,  450.43f,  454.46f,  458.48f,  462.47f, 
 466.45f,  470.41f,  474.35f,  478.28f,  482.18f,  486.07f,  489.95f,  493.80f, 
 497.64f,  501.46f,  505.26f,  509.04f,  512.81f,  516.56f,  520.29f,  524.00f, 
 527.69f,  531.37f,  535.03f,  538.67f,  542.29f,  545.90f,  549.49f,  553.06f, 
 556.61f,  560.14f,  563.66f,  567.16f,  570.64f,  574.10f,  577.55f,  580.97f, 
 584.38f,  587.77f,  591.15f,  594.50f,  597.84f,  601.16f,  604.46f,  607.74f, 
 611.01f,  614.26f,  617.49f,  620.70f,  623.89f,  627.07f,  630.23f,  633.37f, 
 636.49f,  639.59f,  642.68f,  645.75f,  648.80f,  651.83f,  654.84f,  657.84f, 
 660.82f,  663.78f,  666.72f,  669.64f,  672.54f,  675.43f,  678.30f,  681.15f, 
 683.98f,  686.79f,  689.58f,  692.36f,  695.11f,  697.85f,  700.57f,  703.27f, 
 705.95f,  708.61f,  711.26f,  713.88f,  716.49f,  719.07f,  721.64f,  724.19f, 
 726.71f,  729.22f,  731.71f,  734.18f,  736.63f,  739.07f,  741.46f,  743.84f, 
 746.20f,  748.54f,  750.88f,  753.22f,  755.54f,  757.86f,  760.17f,  762.48f, 
 764.78f,  767.08f,  769.38f,  771.67f,  773.95f,  776.23f,  778.49f,  780.76f, 
 783.01f,  785.25f,  787.49f,  789.72f,  791.94f,  794.16f,  796.38f,  798.60f, 
 800.82f,  803.04f,  805.26f,  807.48f,  809.70f,  811.91f,  814.13f,  816.35f, 
 818.57f,  820.79f,  823.01f,  825.23f,  827.45f,  829.67f,  831.89f,  834.11f, 
 836.33f,  838.55f,  840.77f,  842.99f,  845.21f,  847.43f,  849.65f,  851.87f, 
 854.08f,  856.30f,  858.52f,  860.74f,  862.96f,  865.18f,  867.40f, 1096.63f, 
1097.59f, 1098.55f, 1099.50f, 1100.46f, 1101.42f, 1102.37f, 1103.33f, 1104.29f, 
1105.24f, 1106.20f, 1107.15f, 1108.11f, 1109.06f, 1110.02f, 1110.97f, 1111.92f, 
1112.87f, 1113.83f, 1114.78f, 1115.73f, 1116.68f, 1117.63f, 1118.57f, 1119.52f, 
1120.47f, 1121.41f, 1122.36f, 1123.30f, 1124.24f, 1125.18f, 1126.12f, 1127.06f, 
1128.00f, 1128.93f, 1129.86f, 1130.80f, 1131.72f, 1132.65f, 1133.58f, 1134.50f, 
1135.42f, 1136.34f, 1137.26f, 1138.17f, 1139.08f, 1139.99f, 1140.89f, 1141.79f, 
1142.69f, 1143.59f, 1144.48f, 1145.36f, 1146.24f, 1147.12f, 1147.99f, 1148.86f, 
1149.73f, 1149.39f, 1151.01f, 1152.28f, 1153.12f, 1153.96f, 1154.79f, 1155.61f, 
1156.42f, 1157.23f, 1158.03f, 1158.82f, 1159.60f, 1160.37f, 1161.14f, 1161.90f, 
1162.65f, 1163.39f, 1164.11f, 1164.83f, 1165.54f, 1166.24f, 1166.93f, 1167.61f, 
1168.27f, 1168.93f, 1169.57f, 1170.21f, 1170.83f, 1171.44f, 1172.03f, 1172.62f, 
1173.19f, 1173.75f, 1174.30f, 1174.83f, 1175.35f, 1175.86f, 1176.35f, 1176.83f, 
1177.30f, 1177.76f, 1178.20f, 1178.62f, 1179.04f, 1179.44f, 1179.82f, 1180.19f, 
1180.55f, 1180.89f, 1181.22f, 1181.54f, 1181.84f, 1182.12f, 1182.40f, 1182.65f, 
1182.89f, 1183.12f, 1183.34f, 1183.54f, 1183.72f, 1183.89f, 1184.04f, 1184.18f, 
1184.31f, 1184.42f, 1184.52f, 1184.60f, 1184.66f, 1184.72f, 1184.75f, 1184.78f, 
1184.78f, 
  28.53f,   29.39f,   31.81f,   35.46f,   40.00f,   45.13f,   50.67f,   56.49f, 
  62.49f,   68.63f,   74.86f,   81.17f,   87.52f,   93.91f,  100.33f,  106.76f, 
 113.20f,  119.63f,  126.07f,  132.49f,  138.89f,  145.27f,  151.63f,  157.96f, 
 164.26f,  170.53f,  176.76f,  182.95f,  189.11f,  195.22f,  201.30f,  207.05f, 
 212.56f,  218.05f,  223.52f,  228.98f,  234.41f,  239.82f,  245.21f,  250.58f, 
 255.91f,  261.22f,  266.49f,  271.74f,  276.38f,  280.95f,  285.51f,  290.06f, 
 294.60f,  299.13f,  303.64f,  308.15f,  312.63f,  317.10f,  321.55f,  326.00f, 
 330.43f,  334.85f,  339.27f,  343.68f,  348.07f,  352.46f,  356.84f,  361.20f, 
 365.55f,  369.89f,  374.22f,  378.53f,  382.83f,  387.11f,  391.38f,  395.64f, 
 399.87f,  404.10f,  408.31f,  412.50f,  416.68f,  420.84f,  424.98f,  429.11f, 
 433.22f,  437.31f,  441.39f,  445.45f,  449.50f,  453.52f,  457.53f,  461.53f, 
 465.50f,  469.46f,  473.40f,  477.32f,  481.23f,  485.11f,  488.98f,  492.84f, 
 496.67f,  500.49f,  504.29f,  508.07f,  511.83f,  515.58f,  519.30f,  523.01f, 
 526.71f,  530.38f,  534.04f,  537.68f,  541.30f,  544.90f,  548.49f,  552.05f, 
 555.60f,  559.14f,  562.65f,  566.15f,  569.62f,  573.09f,  576.53f,  579.95f, 
 583.36f,  586.75f,  590.12f,  593.47f,  596.81f,  600.13f,  603.43f,  606.71f, 
 609.97f,  613.22f,  616.45f,  619.66f,  622.85f,  626.02f,  629.18f,  632.32f, 
 635.44f,  638.54f,  641.62f,  644.69f,  647.74f,  650.77f,  653.78f,  656.77f, 
 659.75f,  662.71f,  665.65f,  668.57f,  671.47f,  674.35f,  677.22f,  680.07f, 
 682.90f,  685.71f,  688.50f,  691.27f,  694.03f,  696.76f,  699.48f,  702.18f, 
 704.86f,  707.52f,  710.16f,  712.78f,  715.39f,  717.97f,  720.54f,  723.08f, 
 725.61f,  728.11f,  730.60f,  733.07f,  735.52f,  737.95f,  740.35f,  742.72f, 
 745.08f,  747.42f,  749.76f,  752.09f,  754.42f,  756.74f,  759.05f,  761.36f, 
 763.66f,  765.96f,  768.25f,  770.54f,  772.83f,  775.10f,  777.37f,  779.63f, 
 781.88f,  784.13f,  786.36f,  788.59f,  790.81f,  793.03f,  795.25f,  797.47f, 
 799.69f,  801.91f,  804.13f,  806.35f,  808.57f,  810.79f,  813.01f,  815.23f, 
 817.44f,  819.66f,  821.88f,  824.10f,  826.32f,  828.54f,  830.76f,  832.98f, 
 835.20f,  837.42f,  839.64f,  841.86f,  844.08f,  846.30f,  848.52f,  850.74f, 
 852.96f,  855.18f,  857.40f,  859.61f,  861.83f,  864.05f,  866.27f, 1095.44f, 
1096.40f, 1097.36f, 1098.31f, 1099.27f, 1100.23f, 1101.18f, 1102.14f, 1103.10f, 
1104.05f, 1105.01f, 1105.96f, 1106.92f, 1107.87f, 1108.83f, 1109.78f, 1110.73f, 
1111.69f, 1112.64f, 1113.59f, 1114.54f, 1115.49f, 1116.44f, 1117.39f, 1118.33f, 
1119.28f, 1120.22f, 1121.17f, 1122.11f, 1123.05f, 1123.99f, 1124.93f, 1125.87f, 
1126.81f, 1127.74f, 1128.67f, 1129.61f, 1130.54f, 1131.46f, 1132.39f, 1133.31f, 
1134.23f, 1135.15f, 1136.07f, 1136.98f, 1137.89f, 1138.80f, 1139.70f, 1140.60f, 
1141.50f, 1142.40f, 1143.29f, 1144.17f, 1145.05f, 1145.93f, 1146.80f, 1147.67f, 
1148.54f, 1148.23f, 1149.84f, 1151.09f, 1151.93f, 1152.77f, 1153.59f, 1154.41f, 
1155.23f, 1156.03f, 1156.83f, 1157.62f, 1158.41f, 1159.18f, 1159.95f, 1160.70f, 
1161.45f, 1162.19f, 1162.92f, 1163.64f, 1164.35f, 1165.05f, 1165.74f, 1166.41f, 
1167.08f, 1167.73f, 1168.38f, 1169.01f, 1169.63f, 1170.24f, 1170.84f, 1171.42f, 
1171.99f, 1172.55f, 1173.10f, 1173.63f, 1174.15f, 1174.66f, 1175.15f, 1175.64f, 
1176.10f, 1176.56f, 1177.00f, 1177.43f, 1177.84f, 1178.24f, 1178.62f, 1178.99f, 
1179.35f, 1179.69f, 1180.02f, 1180.34f, 1180.64f, 1180.92f, 1181.19f, 1181.45f, 
1181.69f, 1181.92f, 1182.14f, 1182.33f, 1182.52f, 1182.69f, 1182.84f, 1182.98f, 
1183.11f, 1183.22f, 1183.32f, 1183.40f, 1183.46f, 1183.51f, 1183.55f, 1183.57f, 
1183.58f, 
  29.73f,   30.55f,   32.86f,   36.39f,   40.79f,   45.81f,   51.24f,   56.97f, 
  62.89f,   68.97f,   75.14f,   81.39f,   87.70f,   94.04f,  100.42f,  106.80f, 
 113.20f,  119.60f,  126.00f,  132.38f,  138.75f,  145.10f,  151.43f,  157.73f, 
 164.00f,  170.24f,  176.45f,  182.62f,  188.75f,  194.84f,  200.90f,  206.44f, 
 211.94f,  217.42f,  222.89f,  228.34f,  233.77f,  239.18f,  244.56f,  249.91f, 
 255.24f,  260.54f,  265.81f,  270.97f,  275.54f,  280.11f,  284.67f,  289.22f, 
 293.75f,  298.28f,  302.79f,  307.29f,  311.77f,  316.24f,  320.69f,  325.13f, 
 329.56f,  333.99f,  338.40f,  342.80f,  347.20f,  351.59f,  355.96f,  360.32f, 
 364.67f,  369.01f,  373.33f,  377.64f,  381.94f,  386.22f,  390.49f,  394.74f, 
 398.97f,  403.20f,  407.40f,  411.59f,  415.77f,  419.92f,  424.07f,  428.19f, 
 432.30f,  436.39f,  440.47f,  444.52f,  448.57f,  452.59f,  456.60f,  460.59f, 
 464.56f,  468.51f,  472.45f,  476.37f,  480.27f,  484.16f,  488.03f,  491.88f, 
 495.71f,  499.52f,  503.32f,  507.10f,  510.86f,  514.60f,  518.33f,  522.04f, 
 525.73f,  529.40f,  533.05f,  536.69f,  540.31f,  543.91f,  547.49f,  551.06f, 
 554.61f,  558.14f,  561.65f,  565.14f,  568.62f,  572.08f,  575.52f,  578.94f, 
 582.34f,  585.73f,  589.10f,  592.45f,  595.79f,  599.10f,  602.40f,  605.68f, 
 608.94f,  612.18f,  615.41f,  618.62f,  621.81f,  624.98f,  628.14f,  631.27f, 
 634.39f,  637.49f,  640.57f,  643.64f,  646.68f,  649.71f,  652.72f,  655.71f, 
 658.69f,  661.64f,  664.58f,  667.50f,  670.40f,  673.28f,  676.15f,  678.99f, 
 681.82f,  684.63f,  687.42f,  690.19f,  692.95f,  695.68f,  698.40f,  701.09f, 
 703.77f,  706.43f,  709.07f,  711.69f,  714.29f,  716.88f,  719.44f,  721.98f, 
 724.50f,  727.01f,  729.49f,  731.96f,  734.41f,  736.84f,  739.24f,  741.61f, 
 743.96f,  746.31f,  748.65f,  750.98f,  753.30f,  755.62f,  757.93f,  760.24f, 
 762.54f,  764.84f,  767.14f,  769.42f,  771.71f,  773.98f,  776.25f,  778.51f, 
 780.76f,  783.00f,  785.24f,  787.47f,  789.69f,  791.91f,  794.13f,  796.35f, 
 798.57f,  800.79f,  803.00f,  805.22f,  807.44f,  809.66f,  811.88f,  814.10f, 
 816.32f,  818.54f,  820.76f,  822.98f,  825.20f,  827.42f,  829.64f,  831.86f, 
 834.08f,  836.30f,  838.52f,  840.74f,  842.96f,  845.17f,  847.39f,  849.61f, 
 851.83f,  854.05f,  856.27f,  858.49f,  860.71f,  862.93f,  865.15f, 1094.26f, 
1095.22f, 1096.17f, 1097.13f, 1098.09f, 1099.04f, 1100.00f, 1100.96f, 1101.91f, 
1102.87f, 1103.82f, 1104.78f, 1105.73f, 1106.69f, 1107.64f, 1108.60f, 1109.55f, 
1110.50f, 1111.45f, 1112.40f, 1113.35f, 1114.30f, 1115.25f, 1116.20f, 1117.15f, 
1118.09f, 1119.04f, 1119.98f, 1120.93f, 1121.87f, 1122.81f, 1123.75f, 1124.69f, 
1125.62f, 1126.56f, 1127.49f, 1128.42f, 1129.35f, 1130.28f, 1131.20f, 1132.13f, 
1133.05f, 1133.97f, 1134.88f, 1135.80f, 1136.71f, 1137.61f, 1138.52f, 1139.42f, 
1140.32f, 1141.21f, 1142.10f, 1142.99f, 1143.87f, 1144.75f, 1145.62f, 1146.49f, 
1147.35f, 1147.08f, 1148.68f, 1149.90f, 1150.74f, 1151.58f, 1152.41f, 1153.23f, 
1154.04f, 1154.85f, 1155.65f, 1156.44f, 1157.22f, 1157.99f, 1158.76f, 1159.52f, 
1160.26f, 1161.00f, 1161.73f, 1162.45f, 1163.16f, 1163.86f, 1164.55f, 1165.22f, 
1165.89f, 1166.54f, 1167.19f, 1167.82f, 1168.44f, 1169.05f, 1169.64f, 1170.23f, 
1170.80f, 1171.36f, 1171.91f, 1172.44f, 1172.96f, 1173.47f, 1173.96f, 1174.44f, 
1174.91f, 1175.36f, 1175.80f, 1176.23f, 1176.64f, 1177.04f, 1177.43f, 1177.80f, 
1178.16f, 1178.50f, 1178.83f, 1179.14f, 1179.44f, 1179.73f, 1180.00f, 1180.26f, 
1180.50f, 1180.73f, 1180.94f, 1181.14f, 1181.32f, 1181.49f, 1181.65f, 1181.79f, 
1181.91f, 1182.02f, 1182.12f, 1182.20f, 1182.27f, 1182.32f, 1182.35f, 1182.38f, 
1182.38f, 
  30.92f,   31.70f,   33.92f,   37.32f,   41.60f,   46.50f,   51.83f,   57.46f, 
  63.31f,   69.32f,   75.43f,   81.63f,   87.88f,   94.18f,  100.51f,  106.86f, 
 113.22f,  119.58f,  125.94f,  132.29f,  138.62f,  144.94f,  151.24f,  157.51f, 
 163.75f,  169.97f,  176.15f,  182.29f,  188.40f,  194.47f,  200.33f,  205.83f, 
 211.33f,  216.81f,  222.27f,  227.72f,  233.14f,  238.54f,  243.91f,  249.26f, 
 254.58f,  259.87f,  265.13f,  270.14f,  274.71f,  279.28f,  283.83f,  288.38f, 
 292.91f,  297.44f,  301.95f,  306.44f,  310.92f,  315.38f,  319.83f,  324.27f, 
 328.70f,  333.13f,  337.54f,  341.94f,  346.34f,  350.72f,  355.09f,  359.45f, 
 363.80f,  368.13f,  372.45f,  376.76f,  381.05f,  385.33f,  389.60f,  393.85f, 
 398.08f,  402.30f,  406.50f,  410.69f,  414.86f,  419.02f,  423.16f,  427.28f, 
 431.39f,  435.47f,  439.55f,  443.60f,  447.64f,  451.66f,  455.67f,  459.65f, 
 463.62f,  467.58f,  471.51f,  475.43f,  479.33f,  483.21f,  487.08f,  490.92f, 
 494.75f,  498.57f,  502.36f,  506.14f,  509.89f,  513.64f,  517.36f,  521.06f, 
 524.75f,  528.42f,  532.07f,  535.71f,  539.33f,  542.92f,  546.50f,  550.07f, 
 553.61f,  557.14f,  560.65f,  564.14f,  567.62f,  571.07f,  574.51f,  577.93f, 
 581.34f,  584.72f,  588.09f,  591.44f,  594.77f,  598.08f,  601.38f,  604.66f, 
 607.92f,  611.16f,  614.38f,  617.59f,  620.78f,  623.95f,  627.10f,  630.23f, 
 633.35f,  636.45f,  639.53f,  642.59f,  645.64f,  648.66f,  651.67f,  654.66f, 
 657.63f,  660.59f,  663.52f,  666.44f,  669.34f,  672.22f,  675.08f,  677.93f, 
 680.75f,  683.56f,  686.35f,  689.12f,  691.87f,  694.60f,  697.32f,  700.01f, 
 702.69f,  705.34f,  707.98f,  710.60f,  713.20f,  715.78f,  718.35f,  720.89f, 
 723.41f,  725.91f,  728.40f,  730.86f,  733.31f,  735.74f,  738.13f,  740.50f, 
 742.85f,  745.20f,  747.54f,  749.87f,  752.19f,  754.51f,  756.82f,  759.13f, 
 761.43f,  763.73f,  766.02f,  768.31f,  770.59f,  772.87f,  775.13f,  777.39f, 
 779.65f,  781.89f,  784.12f,  786.35f,  788.57f,  790.79f,  793.01f,  795.23f, 
 797.45f,  799.67f,  801.89f,  804.11f,  806.33f,  808.55f,  810.77f,  812.98f, 
 815.20f,  817.42f,  819.64f,  821.86f,  824.08f,  826.30f,  828.52f,  830.74f, 
 832.96f,  835.18f,  837.40f,  839.62f,  841.84f,  844.06f,  846.28f,  848.50f, 
 850.72f,  852.94f,  855.15f,  857.37f,  859.59f,  861.81f,  864.03f, 1093.08f, 
1094.04f, 1095.00f, 1095.95f, 1096.91f, 1097.87f, 1098.82f, 1099.78f, 1100.74f, 
1101.69f, 1102.65f, 1103.60f, 1104.56f, 1105.51f, 1106.46f, 1107.42f, 1108.37f, 
1109.32f, 1110.27f, 1111.23f, 1112.18f, 1113.13f, 1114.07f, 1115.02f, 1115.97f, 
1116.92f, 1117.86f, 1118.81f, 1119.75f, 1120.69f, 1121.63f, 1122.57f, 1123.51f, 
1124.44f, 1125.38f, 1126.31f, 1127.24f, 1128.17f, 1129.10f, 1130.02f, 1130.95f, 
1131.87f, 1132.79f, 1133.70f, 1134.62f, 1135.53f, 1136.43f, 1137.34f, 1138.24f, 
1139.14f, 1140.03f, 1140.92f, 1141.81f, 1142.69f, 1143.56f, 1144.44f, 1145.31f, 
1146.17f, 1145.92f, 1147.53f, 1148.72f, 1149.56f, 1150.40f, 1151.22f, 1152.04f, 
1152.86f, 1153.66f, 1154.46f, 1155.25f, 1156.04f, 1156.81f, 1157.58f, 1158.33f, 
1159.08f, 1159.82f, 1160.55f, 1161.27f, 1161.97f, 1162.67f, 1163.36f, 1164.04f, 
1164.70f, 1165.36f, 1166.00f, 1166.63f, 1167.25f, 1167.86f, 1168.46f, 1169.04f, 
1169.61f, 1170.17f, 1170.72f, 1171.25f, 1171.77f, 1172.28f, 1172.77f, 1173.25f, 
1173.72f, 1174.17f, 1174.61f, 1175.04f, 1175.45f, 1175.85f, 1176.24f, 1176.61f, 
1176.97f, 1177.31f, 1177.64f, 1177.95f, 1178.25f, 1178.54f, 1178.81f, 1179.06f, 
1179.31f, 1179.53f, 1179.75f, 1179.95f, 1180.13f, 1180.30f, 1180.45f, 1180.59f, 
1180.72f, 1180.83f, 1180.93f, 1181.01f, 1181.07f, 1181.13f, 1181.16f, 1181.19f, 
1181.19f, 
  32.11f,   32.86f,   34.99f,   38.27f,   42.42f,   47.21f,   52.44f,   57.98f, 
  63.75f,   69.68f,   75.74f,   81.88f,   88.08f,   94.33f,  100.62f,  106.92f, 
 113.24f,  119.57f,  125.89f,  132.20f,  138.51f,  144.79f,  151.06f,  157.30f, 
 163.52f,  169.70f,  175.85f,  181.98f,  188.06f,  194.11f,  199.74f,  205.24f, 
 210.73f,  216.21f,  221.67f,  227.10f,  232.52f,  237.91f,  243.28f,  248.62f, 
 253.93f,  259.21f,  264.46f,  269.32f,  273.89f,  278.45f,  283.01f,  287.55f, 
 292.08f,  296.60f,  301.11f,  305.60f,  310.08f,  314.54f,  318.99f,  323.43f, 
 327.85f,  332.27f,  336.68f,  341.09f,  345.48f,  349.86f,  354.23f,  358.59f, 
 362.93f,  367.26f,  371.58f,  375.89f,  380.18f,  384.46f,  388.72f,  392.97f, 
 397.20f,  401.41f,  405.61f,  409.80f,  413.97f,  418.12f,  422.26f,  426.38f, 
 430.48f,  434.57f,  438.64f,  442.69f,  446.73f,  450.74f,  454.75f,  458.73f, 
 462.70f,  466.65f,  470.58f,  474.49f,  478.39f,  482.27f,  486.13f,  489.98f, 
 493.81f,  497.62f,  501.41f,  505.18f,  508.94f,  512.68f,  516.40f,  520.10f, 
 523.78f,  527.45f,  531.10f,  534.73f,  538.35f,  541.95f,  545.52f,  549.09f, 
 552.63f,  556.15f,  559.66f,  563.15f,  566.62f,  570.08f,  573.51f,  576.93f, 
 580.33f,  583.72f,  587.08f,  590.43f,  593.76f,  597.07f,  600.36f,  603.64f, 
 606.90f,  610.14f,  613.36f,  616.56f,  619.75f,  622.92f,  626.07f,  629.20f, 
 632.32f,  635.41f,  638.49f,  641.55f,  644.59f,  647.62f,  650.63f,  653.61f, 
 656.58f,  659.54f,  662.47f,  665.39f,  668.28f,  671.16f,  674.02f,  676.86f, 
 679.69f,  682.49f,  685.28f,  688.05f,  690.80f,  693.53f,  696.24f,  698.94f, 
 701.61f,  704.27f,  706.90f,  709.52f,  712.12f,  714.70f,  717.26f,  719.80f, 
 722.32f,  724.82f,  727.30f,  729.77f,  732.22f,  734.64f,  737.03f,  739.40f, 
 741.75f,  744.10f,  746.44f,  748.77f,  751.09f,  753.41f,  755.72f,  758.03f, 
 760.33f,  762.62f,  764.92f,  767.20f,  769.49f,  771.76f,  774.03f,  776.28f, 
 778.54f,  780.78f,  783.01f,  785.24f,  787.46f,  789.68f,  791.90f,  794.12f, 
 796.34f,  798.56f,  800.78f,  803.00f,  805.21f,  807.43f,  809.65f,  811.87f, 
 814.09f,  816.31f,  818.53f,  820.75f,  822.97f,  825.19f,  827.41f,  829.63f, 
 831.85f,  834.07f,  836.29f,  838.51f,  840.73f,  842.95f,  845.17f,  847.38f, 
 849.60f,  851.82f,  854.04f,  856.26f,  858.48f,  860.70f,  862.92f, 1091.91f, 
1092.86f, 1093.82f, 1094.78f, 1095.74f, 1096.69f, 1097.65f, 1098.61f, 1099.56f, 
1100.52f, 1101.47f, 1102.43f, 1103.38f, 1104.34f, 1105.29f, 1106.24f, 1107.20f, 
1108.15f, 1109.10f, 1110.05f, 1111.00f, 1111.95f, 1112.90f, 1113.85f, 1114.80f, 
1115.74f, 1116.69f, 1117.63f, 1118.57f, 1119.52f, 1120.46f, 1121.40f, 1122.33f, 
1123.27f, 1124.20f, 1125.14f, 1126.07f, 1127.00f, 1127.93f, 1128.85f, 1129.77f, 
1130.69f, 1131.61f, 1132.53f, 1133.44f, 1134.35f, 1135.26f, 1136.16f, 1137.06f, 
1137.96f, 1138.86f, 1139.75f, 1140.63f, 1141.51f, 1142.39f, 1143.26f, 1144.13f, 
1143.10f, 1144.78f, 1146.38f, 1147.55f, 1148.39f, 1149.22f, 1150.05f, 1150.87f, 
1151.68f, 1152.49f, 1153.29f, 1154.08f, 1154.86f, 1155.63f, 1156.40f, 1157.15f, 
1157.90f, 1158.64f, 1159.37f, 1160.09f, 1160.80f, 1161.49f, 1162.18f, 1162.86f, 
1163.52f, 1164.18f, 1164.82f, 1165.45f, 1166.07f, 1166.68f, 1167.28f, 1167.86f, 
1168.43f, 1168.99f, 1169.54f, 1170.07f, 1170.59f, 1171.10f, 1171.59f, 1172.07f, 
1172.54f, 1172.99f, 1173.43f, 1173.86f, 1174.27f, 1174.67f, 1175.05f, 1175.42f, 
1175.78f, 1176.12f, 1176.45f, 1176.77f, 1177.07f, 1177.35f, 1177.62f, 1177.88f, 
1178.12f, 1178.35f, 1178.56f, 1178.76f, 1178.94f, 1179.11f, 1179.27f, 1179.41f, 
1179.53f, 1179.64f, 1179.74f, 1179.82f, 1179.89f, 1179.94f, 1179.98f, 1180.00f, 
1180.01f, 
  33.29f,   34.01f,   36.06f,   39.23f,   43.26f,   47.93f,   53.06f,   58.51f, 
  64.20f,   70.07f,   76.06f,   82.14f,   88.29f,   94.49f,  100.73f,  107.00f, 
 113.28f,  119.56f,  125.85f,  132.13f,  138.40f,  144.65f,  150.89f,  157.10f, 
 163.29f,  169.45f,  175.57f,  181.67f,  187.73f,  193.65f,  199.16f,  204.66f, 
 210.15f,  215.62f,  221.07f,  226.50f,  231.91f,  237.29f,  242.65f,  247.98f, 
 253.28f,  258.56f,  263.80f,  268.50f,  273.07f,  277.64f,  282.19f,  286.73f, 
 291.26f,  295.78f,  300.28f,  304.77f,  309.24f,  313.70f,  318.15f,  322.59f, 
 327.01f,  331.43f,  335.84f,  340.24f,  344.63f,  349.01f,  353.38f,  357.73f, 
 362.08f,  366.40f,  370.72f,  375.02f,  379.31f,  383.59f,  387.85f,  392.09f, 
 396.32f,  400.53f,  404.73f,  408.91f,  413.08f,  417.23f,  421.36f,  425.48f, 
 429.58f,  433.66f,  437.73f,  441.78f,  445.82f,  449.83f,  453.83f,  457.81f, 
 461.78f,  465.72f,  469.65f,  473.57f,  477.46f,  481.34f,  485.20f,  489.04f, 
 492.87f,  496.67f,  500.46f,  504.23f,  507.99f,  511.72f,  515.44f,  519.14f, 
 522.82f,  526.49f,  530.14f,  533.77f,  537.38f,  540.97f,  544.55f,  548.11f, 
 551.65f,  555.17f,  558.68f,  562.17f,  565.64f,  569.09f,  572.52f,  575.94f, 
 579.34f,  582.72f,  586.08f,  589.43f,  592.75f,  596.06f,  599.35f,  602.63f, 
 605.88f,  609.12f,  612.34f,  615.54f,  618.73f,  621.89f,  625.04f,  628.17f, 
 631.29f,  634.38f,  637.46f,  640.52f,  643.56f,  646.58f,  649.59f,  652.57f, 
 655.54f,  658.49f,  661.42f,  664.34f,  667.23f,  670.11f,  672.97f,  675.81f, 
 678.63f,  681.44f,  684.22f,  686.99f,  689.73f,  692.46f,  695.17f,  697.87f, 
 700.54f,  703.19f,  705.83f,  708.45f,  711.04f,  713.62f,  716.18f,  718.72f, 
 721.24f,  723.74f,  726.22f,  728.68f,  731.13f,  733.55f,  735.94f,  738.30f, 
 740.66f,  743.00f,  745.34f,  747.67f,  749.99f,  752.31f,  754.62f,  756.93f, 
 759.23f,  761.52f,  763.82f,  766.10f,  768.38f,  770.66f,  772.92f,  775.18f, 
 777.43f,  779.67f,  781.91f,  784.13f,  786.35f,  788.57f,  790.79f,  793.01f, 
 795.23f,  797.45f,  799.67f,  801.89f,  804.11f,  806.33f,  808.55f,  810.77f, 
 812.99f,  815.21f,  817.43f,  819.65f,  821.86f,  824.08f,  826.30f,  828.52f, 
 830.74f,  832.96f,  835.18f,  837.40f,  839.62f,  841.84f,  844.06f,  846.28f, 
 848.50f,  850.72f,  852.94f,  855.16f,  857.38f,  859.60f,  861.81f, 1090.74f, 
1091.70f, 1092.65f, 1093.61f, 1094.57f, 1095.53f, 1096.48f, 1097.44f, 1098.39f, 
1099.35f, 1100.31f, 1101.26f, 1102.22f, 1103.17f, 1104.12f, 1105.08f, 1106.03f, 
1106.98f, 1107.93f, 1108.88f, 1109.83f, 1110.78f, 1111.73f, 1112.68f, 1113.63f, 
1114.57f, 1115.52f, 1116.46f, 1117.41f, 1118.35f, 1119.29f, 1120.23f, 1121.17f, 
1122.10f, 1123.04f, 1123.97f, 1124.90f, 1125.83f, 1126.76f, 1127.68f, 1128.61f, 
1129.53f, 1130.44f, 1131.36f, 1132.27f, 1133.18f, 1134.09f, 1134.99f, 1135.89f, 
1136.79f, 1137.69f, 1138.58f, 1139.46f, 1140.34f, 1141.22f, 1142.09f, 1142.96f, 
1141.97f, 1143.64f, 1145.24f, 1146.38f, 1147.22f, 1148.05f, 1148.88f, 1149.70f, 
1150.51f, 1151.32f, 1152.11f, 1152.90f, 1153.69f, 1154.46f, 1155.22f, 1155.98f, 
1156.73f, 1157.47f, 1158.19f, 1158.91f, 1159.62f, 1160.32f, 1161.01f, 1161.68f, 
1162.35f, 1163.00f, 1163.65f, 1164.28f, 1164.90f, 1165.50f, 1166.10f, 1166.68f, 
1167.25f, 1167.81f, 1168.36f, 1168.89f, 1169.41f, 1169.92f, 1170.41f, 1170.89f, 
1171.36f, 1171.81f, 1172.25f, 1172.68f, 1173.09f, 1173.49f, 1173.87f, 1174.24f, 
1174.60f, 1174.94f, 1175.27f, 1175.59f, 1175.89f, 1176.17f, 1176.44f, 1176.70f, 
1176.94f, 1177.17f, 1177.38f, 1177.58f, 1177.76f, 1177.93f, 1178.09f, 1178.23f, 
1178.35f, 1178.46f, 1178.56f, 1178.64f, 1178.71f, 1178.76f, 1178.79f, 1178.82f, 
1178.82f, 
  34.47f,   35.15f,   37.13f,   40.19f,   44.11f,   48.67f,   53.70f,   59.06f, 
  64.67f,   70.46f,   76.39f,   82.42f,   88.51f,   94.67f,  100.86f,  107.08f, 
 113.32f,  119.57f,  125.82f,  132.06f,  138.30f,  144.52f,  150.73f,  156.91f, 
 163.07f,  169.20f,  175.30f,  181.37f,  187.41f,  193.09f,  198.60f,  204.10f, 
 209.58f,  215.04f,  220.48f,  225.91f,  231.31f,  236.68f,  242.03f,  247.36f, 
 252.65f,  257.91f,  263.12f,  267.70f,  272.27f,  276.83f,  281.38f,  285.92f, 
 290.45f,  294.96f,  299.46f,  303.95f,  308.42f,  312.87f,  317.32f,  321.75f, 
 326.18f,  330.59f,  335.00f,  339.40f,  343.79f,  348.17f,  352.53f,  356.89f, 
 361.23f,  365.55f,  369.87f,  374.17f,  378.45f,  382.72f,  386.98f,  391.22f, 
 395.45f,  399.66f,  403.86f,  408.04f,  412.20f,  416.35f,  420.48f,  424.59f, 
 428.69f,  432.77f,  436.84f,  440.88f,  444.91f,  448.93f,  452.92f,  456.90f, 
 460.86f,  464.81f,  468.74f,  472.65f,  476.54f,  480.41f,  484.27f,  488.11f, 
 491.93f,  495.74f,  499.52f,  503.29f,  507.04f,  510.78f,  514.49f,  518.19f, 
 521.87f,  525.53f,  529.18f,  532.81f,  536.42f,  540.01f,  543.58f,  547.14f, 
 550.68f,  554.20f,  557.70f,  561.19f,  564.65f,  568.10f,  571.54f,  574.95f, 
 578.35f,  581.73f,  585.09f,  588.43f,  591.75f,  595.06f,  598.35f,  601.62f, 
 604.88f,  608.11f,  611.33f,  614.53f,  617.71f,  620.88f,  624.03f,  627.15f, 
 630.26f,  633.36f,  636.43f,  639.49f,  642.53f,  645.55f,  648.55f,  651.54f, 
 654.50f,  657.45f,  660.38f,  663.29f,  666.19f,  669.06f,  671.92f,  674.76f, 
 677.58f,  680.38f,  683.17f,  685.93f,  688.68f,  691.40f,  694.11f,  696.80f, 
 699.47f,  702.13f,  704.76f,  707.38f,  709.97f,  712.55f,  715.10f,  717.64f, 
 720.16f,  722.66f,  725.14f,  727.60f,  730.04f,  732.46f,  734.85f,  737.21f, 
 739.57f,  741.91f,  744.25f,  746.57f,  748.90f,  751.21f,  753.53f,  755.83f, 
 758.13f,  760.43f,  762.72f,  765.01f,  767.29f,  769.56f,  771.83f,  774.08f, 
 776.33f,  778.58f,  780.81f,  783.03f,  785.25f,  787.47f,  789.69f,  791.91f, 
 794.13f,  796.35f,  798.57f,  800.79f,  803.01f,  805.23f,  807.45f,  809.67f, 
 811.89f,  814.11f,  816.33f,  818.54f,  820.76f,  822.98f,  825.20f,  827.42f, 
 829.64f,  831.86f,  834.08f,  836.30f,  838.52f,  840.74f,  842.96f,  845.18f, 
 847.40f,  849.62f,  851.84f,  854.06f,  856.28f,  858.50f,  860.71f, 1089.58f, 
1090.53f, 1091.49f, 1092.45f, 1093.41f, 1094.36f, 1095.32f, 1096.28f, 1097.23f, 
1098.19f, 1099.14f, 1100.10f, 1101.05f, 1102.01f, 1102.96f, 1103.91f, 1104.87f, 
1105.82f, 1106.77f, 1107.72f, 1108.67f, 1109.62f, 1110.57f, 1111.52f, 1112.47f, 
1113.41f, 1114.36f, 1115.30f, 1116.24f, 1117.19f, 1118.13f, 1119.06f, 1120.00f, 
1120.94f, 1121.87f, 1122.81f, 1123.74f, 1124.67f, 1125.59f, 1126.52f, 1127.44f, 
1128.36f, 1129.28f, 1130.20f, 1131.11f, 1132.02f, 1132.93f, 1133.83f, 1134.73f, 
1135.63f, 1136.52f, 1137.41f, 1138.30f, 1139.18f, 1140.05f, 1140.93f, 1141.79f, 
1140.83f, 1142.50f, 1144.10f, 1145.21f, 1146.05f, 1146.88f, 1147.71f, 1148.53f, 
1149.34f, 1150.15f, 1150.95f, 1151.74f, 1152.52f, 1153.29f, 1154.06f, 1154.81f, 
1155.56f, 1156.30f, 1157.03f, 1157.74f, 1158.45f, 1159.15f, 1159.84f, 1160.51f, 
1161.18f, 1161.83f, 1162.48f, 1163.11f, 1163.73f, 1164.33f, 1164.93f, 1165.51f, 
1166.08f, 1166.64f, 1167.19f, 1167.72f, 1168.24f, 1168.75f, 1169.24f, 1169.72f, 
1170.19f, 1170.64f, 1171.08f, 1171.50f, 1171.92f, 1172.32f, 1172.70f, 1173.07f, 
1173.43f, 1173.77f, 1174.10f, 1174.41f, 1174.71f, 1175.00f, 1175.27f, 1175.52f, 
1175.76f, 1175.99f, 1176.21f, 1176.40f, 1176.59f, 1176.76f, 1176.91f, 1177.05f, 
1177.18f, 1177.29f, 1177.38f, 1177.46f, 1177.53f, 1177.58f, 1177.62f, 1177.64f, 
1177.65f, 
  35.64f,   36.30f,   38.20f,   41.16f,   44.98f,   49.43f,   54.35f,   59.63f, 
  65.16f,   70.88f,   76.74f,   82.70f,   88.75f,   94.85f,  101.00f,  107.18f, 
 113.38f,  119.59f,  125.80f,  132.01f,  138.21f,  144.40f,  150.58f,  156.73f, 
 162.86f,  168.96f,  175.04f,  181.09f,  187.03f,  192.55f,  198.05f,  203.54f, 
 209.02f,  214.47f,  219.91f,  225.33f,  230.72f,  236.09f,  241.43f,  246.74f, 
 252.03f,  257.28f,  262.33f,  266.90f,  271.47f,  276.03f,  280.58f,  285.11f, 
 289.64f,  294.15f,  298.65f,  303.13f,  307.60f,  312.05f,  316.50f,  320.93f, 
 325.35f,  329.77f,  334.17f,  338.57f,  342.96f,  347.33f,  351.70f,  356.05f, 
 360.38f,  364.71f,  369.02f,  373.32f,  377.60f,  381.87f,  386.12f,  390.36f, 
 394.59f,  398.80f,  402.99f,  407.17f,  411.33f,  415.47f,  419.60f,  423.71f, 
 427.81f,  431.88f,  435.95f,  439.99f,  444.02f,  448.03f,  452.02f,  456.00f, 
 459.96f,  463.90f,  467.83f,  471.73f,  475.62f,  479.49f,  483.35f,  487.19f, 
 491.01f,  494.81f,  498.59f,  502.36f,  506.11f,  509.84f,  513.55f,  517.25f, 
 520.92f,  524.59f,  528.23f,  531.85f,  535.46f,  539.05f,  542.62f,  546.18f, 
 549.71f,  553.23f,  556.73f,  560.21f,  563.68f,  567.13f,  570.56f,  573.97f, 
 577.36f,  580.74f,  584.10f,  587.44f,  590.76f,  594.07f,  597.36f,  600.63f, 
 603.88f,  607.11f,  610.33f,  613.53f,  616.71f,  619.87f,  623.01f,  626.14f, 
 629.25f,  632.34f,  635.41f,  638.47f,  641.50f,  644.52f,  647.52f,  650.51f, 
 653.47f,  656.42f,  659.35f,  662.26f,  665.15f,  668.02f,  670.88f,  673.72f, 
 676.53f,  679.33f,  682.12f,  684.88f,  687.62f,  690.35f,  693.06f,  695.75f, 
 698.42f,  701.07f,  703.70f,  706.31f,  708.91f,  711.48f,  714.03f,  716.57f, 
 719.08f,  721.58f,  724.06f,  726.52f,  728.97f,  731.38f,  733.76f,  736.13f, 
 738.48f,  740.82f,  743.16f,  745.49f,  747.81f,  750.13f,  752.44f,  754.74f, 
 757.04f,  759.34f,  761.63f,  763.92f,  766.20f,  768.47f,  770.73f,  772.99f, 
 775.24f,  777.48f,  779.71f,  781.94f,  784.16f,  786.38f,  788.60f,  790.82f, 
 793.04f,  795.26f,  797.48f,  799.69f,  801.91f,  804.13f,  806.35f,  808.57f, 
 810.79f,  813.01f,  815.23f,  817.45f,  819.67f,  821.89f,  824.11f,  826.33f, 
 828.55f,  830.77f,  832.99f,  835.21f,  837.43f,  839.64f,  841.86f,  844.08f, 
 846.30f,  848.52f,  850.74f,  852.96f,  855.18f,  857.40f,  859.62f, 1088.42f, 
1089.38f, 1090.33f, 1091.29f, 1092.25f, 1093.21f, 1094.16f, 1095.12f, 1096.07f, 
1097.03f, 1097.99f, 1098.94f, 1099.90f, 1100.85f, 1101.80f, 1102.76f, 1103.71f, 
1104.66f, 1105.61f, 1106.56f, 1107.51f, 1108.46f, 1109.41f, 1110.36f, 1111.31f, 
1112.25f, 1113.20f, 1114.14f, 1115.09f, 1116.03f, 1116.97f, 1117.91f, 1118.84f, 
1119.78f, 1120.71f, 1121.65f, 1122.58f, 1123.51f, 1124.44f, 1125.36f, 1126.28f, 
1127.20f, 1128.12f, 1129.04f, 1129.95f, 1130.86f, 1131.77f, 1132.67f, 1133.57f, 
1134.47f, 1135.36f, 1136.25f, 1137.14f, 1138.02f, 1138.89f, 1139.77f, 1140.63f, 
1139.71f, 1141.37f, 1142.96f, 1144.05f, 1144.89f, 1145.72f, 1146.55f, 1147.37f, 
1148.18f, 1148.99f, 1149.78f, 1150.57f, 1151.36f, 1152.13f, 1152.89f, 1153.65f, 
1154.40f, 1155.13f, 1155.86f, 1156.58f, 1157.29f, 1157.99f, 1158.67f, 1159.35f, 
1160.01f, 1160.67f, 1161.31f, 1161.94f, 1162.56f, 1163.17f, 1163.76f, 1164.35f, 
1164.92f, 1165.47f, 1166.02f, 1166.55f, 1167.07f, 1167.58f, 1168.07f, 1168.55f, 
1169.02f, 1169.47f, 1169.91f, 1170.34f, 1170.75f, 1171.15f, 1171.53f, 1171.90f, 
1172.26f, 1172.60f, 1172.93f, 1173.24f, 1173.54f, 1173.83f, 1174.10f, 1174.35f, 
1174.59f, 1174.82f, 1175.03f, 1175.23f, 1175.42f, 1175.59f, 1175.74f, 1175.88f, 
1176.00f, 1176.12f, 1176.21f, 1176.29f, 1176.36f, 1176.41f, 1176.45f, 1176.47f, 
1176.48f, 
  36.81f,   37.44f,   39.27f,   42.14f,   45.85f,   50.20f,   55.02f,   60.21f, 
  65.66f,   71.31f,   77.10f,   83.01f,   89.00f,   95.05f,  101.15f,  107.29f, 
 113.44f,  119.61f,  125.79f,  131.96f,  138.13f,  144.29f,  150.43f,  156.56f, 
 162.66f,  168.74f,  174.79f,  180.81f,  186.50f,  192.01f,  197.51f,  203.00f, 
 208.47f,  213.92f,  219.35f,  224.75f,  230.14f,  235.50f,  240.83f,  246.14f, 
 251.41f,  256.66f,  261.54f,  266.12f,  270.68f,  275.24f,  279.78f,  284.32f, 
 288.84f,  293.35f,  297.85f,  302.33f,  306.79f,  311.24f,  315.68f,  320.11f, 
 324.54f,  328.95f,  333.35f,  337.75f,  342.13f,  346.50f,  350.87f,  355.21f, 
 359.55f,  363.87f,  368.18f,  372.48f,  376.76f,  381.02f,  385.27f,  389.51f, 
 393.73f,  397.94f,  402.13f,  406.30f,  410.46f,  414.60f,  418.73f,  422.84f, 
 426.93f,  431.00f,  435.06f,  439.11f,  443.13f,  447.14f,  451.13f,  455.10f, 
 459.06f,  463.00f,  466.92f,  470.83f,  474.71f,  478.58f,  482.44f,  486.27f, 
 490.09f,  493.89f,  497.67f,  501.43f,  505.18f,  508.91f,  512.62f,  516.31f, 
 519.99f,  523.64f,  527.28f,  530.91f,  534.51f,  538.10f,  541.67f,  545.22f, 
 548.75f,  552.27f,  555.77f,  559.25f,  562.71f,  566.16f,  569.58f,  572.99f, 
 576.39f,  579.76f,  583.12f,  586.46f,  589.78f,  593.08f,  596.37f,  599.63f, 
 602.88f,  606.12f,  609.33f,  612.53f,  615.70f,  618.86f,  622.01f,  625.13f, 
 628.24f,  631.33f,  634.40f,  637.45f,  640.49f,  643.50f,  646.50f,  649.48f, 
 652.45f,  655.39f,  658.32f,  661.23f,  664.12f,  666.99f,  669.84f,  672.68f, 
 675.49f,  678.29f,  681.07f,  683.83f,  686.58f,  689.30f,  692.01f,  694.69f, 
 697.36f,  700.01f,  702.64f,  705.25f,  707.85f,  710.42f,  712.97f,  715.50f, 
 718.02f,  720.51f,  722.99f,  725.45f,  727.89f,  730.31f,  732.69f,  735.05f, 
 737.40f,  739.74f,  742.08f,  744.41f,  746.73f,  749.04f,  751.35f,  753.66f, 
 755.96f,  758.26f,  760.55f,  762.83f,  765.11f,  767.38f,  769.65f,  771.91f, 
 774.15f,  776.39f,  778.63f,  780.85f,  783.07f,  785.29f,  787.51f,  789.73f, 
 791.95f,  794.17f,  796.39f,  798.61f,  800.83f,  803.04f,  805.26f,  807.48f, 
 809.70f,  811.92f,  814.14f,  816.36f,  818.58f,  820.80f,  823.02f,  825.24f, 
 827.46f,  829.68f,  831.90f,  834.12f,  836.34f,  838.56f,  840.78f,  842.99f, 
 845.21f,  847.43f,  849.65f,  851.87f,  854.09f,  856.31f,  858.53f, 1087.27f, 
1088.22f, 1089.18f, 1090.14f, 1091.10f, 1092.05f, 1093.01f, 1093.97f, 1094.92f, 
1095.88f, 1096.83f, 1097.79f, 1098.74f, 1099.70f, 1100.65f, 1101.60f, 1102.56f, 
1103.51f, 1104.46f, 1105.41f, 1106.36f, 1107.31f, 1108.26f, 1109.21f, 1110.15f, 
1111.10f, 1112.05f, 1112.99f, 1113.93f, 1114.87f, 1115.81f, 1116.75f, 1117.69f, 
1118.63f, 1119.56f, 1120.49f, 1121.43f, 1122.35f, 1123.28f, 1124.21f, 1125.13f, 
1126.05f, 1126.97f, 1127.88f, 1128.80f, 1129.71f, 1130.61f, 1131.52f, 1132.42f, 
1133.31f, 1134.21f, 1135.10f, 1135.98f, 1136.86f, 1137.74f, 1138.61f, 1139.48f, 
1138.59f, 1140.24f, 1141.84f, 1142.89f, 1143.73f, 1144.57f, 1145.39f, 1146.21f, 
1147.03f, 1147.83f, 1148.63f, 1149.42f, 1150.20f, 1150.97f, 1151.74f, 1152.49f, 
1153.24f, 1153.98f, 1154.70f, 1155.42f, 1156.13f, 1156.83f, 1157.51f, 1158.19f, 
1158.85f, 1159.51f, 1160.15f, 1160.78f, 1161.40f, 1162.01f, 1162.60f, 1163.18f, 
1163.75f, 1164.31f, 1164.86f, 1165.39f, 1165.91f, 1166.42f, 1166.91f, 1167.39f, 
1167.85f, 1168.31f, 1168.75f, 1169.17f, 1169.58f, 1169.98f, 1170.37f, 1170.74f, 
1171.09f, 1171.43f, 1171.76f, 1172.08f, 1172.38f, 1172.66f, 1172.93f, 1173.19f, 
1173.43f, 1173.66f, 1173.87f, 1174.07f, 1174.25f, 1174.42f, 1174.57f, 1174.71f, 
1174.84f, 1174.95f, 1175.04f, 1175.13f, 1175.19f, 1175.24f, 1175.28f, 1175.30f, 
1175.31f, 
  37.97f,   38.58f,   40.34f,   43.13f,   46.73f,   50.98f,   55.71f,   60.80f, 
  66.17f,   71.75f,   77.48f,   83.33f,   89.26f,   95.26f,  101.32f,  107.41f, 
 113.52f,  119.65f,  125.79f,  131.93f,  138.07f,  144.19f,  150.30f,  156.40f, 
 162.47f,  168.52f,  174.55f,  180.46f,  185.98f,  191.49f,  196.99f,  202.47f, 
 207.93f,  213.37f,  218.79f,  224.19f,  229.57f,  234.92f,  240.25f,  245.54f, 
 250.81f,  256.04f,  260.76f,  265.34f,  269.90f,  274.45f,  279.00f,  283.53f, 
 288.05f,  292.56f,  297.05f,  301.53f,  305.99f,  310.44f,  314.88f,  319.31f, 
 323.73f,  328.14f,  332.54f,  336.93f,  341.31f,  345.69f,  350.04f,  354.39f, 
 358.72f,  363.04f,  367.35f,  371.64f,  375.92f,  380.18f,  384.43f,  388.67f, 
 392.89f,  397.09f,  401.28f,  405.45f,  409.60f,  413.74f,  417.86f,  421.97f, 
 426.06f,  430.13f,  434.19f,  438.23f,  442.25f,  446.26f,  450.24f,  454.22f, 
 458.17f,  462.11f,  466.02f,  469.93f,  473.81f,  477.68f,  481.53f,  485.36f, 
 489.17f,  492.97f,  496.75f,  500.51f,  504.25f,  507.98f,  511.69f,  515.38f, 
 519.05f,  522.71f,  526.35f,  529.97f,  533.57f,  537.15f,  540.72f,  544.27f, 
 547.80f,  551.31f,  554.81f,  558.29f,  561.75f,  565.19f,  568.62f,  572.03f, 
 575.42f,  578.79f,  582.14f,  585.48f,  588.80f,  592.10f,  595.38f,  598.65f, 
 601.90f,  605.13f,  608.34f,  611.53f,  614.71f,  617.87f,  621.01f,  624.13f, 
 627.23f,  630.32f,  633.39f,  636.44f,  639.48f,  642.49f,  645.49f,  648.47f, 
 651.43f,  654.37f,  657.30f,  660.20f,  663.09f,  665.96f,  668.81f,  671.65f, 
 674.46f,  677.26f,  680.04f,  682.80f,  685.54f,  688.26f,  690.96f,  693.65f, 
 696.31f,  698.96f,  701.59f,  704.20f,  706.79f,  709.36f,  711.91f,  714.44f, 
 716.96f,  719.45f,  721.93f,  724.39f,  726.82f,  729.24f,  731.61f,  733.98f, 
 736.33f,  738.67f,  741.00f,  743.33f,  745.65f,  747.97f,  750.28f,  752.58f, 
 754.88f,  757.18f,  759.47f,  761.75f,  764.03f,  766.30f,  768.57f,  770.82f, 
 773.07f,  775.31f,  777.54f,  779.77f,  781.99f,  784.21f,  786.43f,  788.64f, 
 790.86f,  793.08f,  795.30f,  797.52f,  799.74f,  801.96f,  804.18f,  806.40f, 
 808.62f,  810.84f,  813.06f,  815.28f,  817.50f,  819.72f,  821.94f,  824.16f, 
 826.38f,  828.59f,  830.81f,  833.03f,  835.25f,  837.47f,  839.69f,  841.91f, 
 844.13f,  846.35f,  848.57f,  850.79f,  853.01f,  855.23f,  857.45f, 1086.12f, 
1087.08f, 1088.03f, 1088.99f, 1089.95f, 1090.91f, 1091.86f, 1092.82f, 1093.77f, 
1094.73f, 1095.69f, 1096.64f, 1097.60f, 1098.55f, 1099.50f, 1100.46f, 1101.41f, 
1102.36f, 1103.31f, 1104.26f, 1105.21f, 1106.16f, 1107.11f, 1108.06f, 1109.01f, 
1109.95f, 1110.90f, 1111.84f, 1112.79f, 1113.73f, 1114.67f, 1115.61f, 1116.54f, 
1117.48f, 1118.41f, 1119.35f, 1120.28f, 1121.21f, 1122.13f, 1123.06f, 1123.98f, 
1124.90f, 1125.82f, 1126.74f, 1127.65f, 1128.56f, 1129.46f, 1130.37f, 1131.27f, 
1132.17f, 1133.06f, 1133.95f, 1134.83f, 1135.71f, 1136.59f, 1137.46f, 1138.33f, 
1137.47f, 1139.12f, 1140.71f, 1141.74f, 1142.58f, 1143.42f, 1144.24f, 1145.06f, 
1145.87f, 1146.68f, 1147.48f, 1148.27f, 1149.05f, 1149.82f, 1150.58f, 1151.34f, 
1152.09f, 1152.82f, 1153.55f, 1154.27f, 1154.98f, 1155.67f, 1156.36f, 1157.03f, 
1157.70f, 1158.35f, 1158.99f, 1159.63f, 1160.24f, 1160.85f, 1161.45f, 1162.03f, 
1162.60f, 1163.16f, 1163.70f, 1164.23f, 1164.75f, 1165.26f, 1165.75f, 1166.23f, 
1166.70f, 1167.15f, 1167.59f, 1168.01f, 1168.43f, 1168.82f, 1169.21f, 1169.58f, 
1169.93f, 1170.27f, 1170.60f, 1170.92f, 1171.21f, 1171.50f, 1171.77f, 1172.03f, 
1172.27f, 1172.50f, 1172.71f, 1172.91f, 1173.09f, 1173.26f, 1173.41f, 1173.55f, 
1173.68f, 1173.79f, 1173.88f, 1173.96f, 1174.03f, 1174.08f, 1174.12f, 1174.14f, 
1174.15f, 
  39.12f,   39.71f,   41.42f,   44.11f,   47.62f,   51.77f,   56.40f,   61.41f, 
  66.70f,   72.20f,   77.87f,   83.66f,   89.54f,   95.49f,  101.49f,  107.54f, 
 113.61f,  119.70f,  125.80f,  131.91f,  138.01f,  144.10f,  150.18f,  156.25f, 
 162.29f,  168.32f,  174.31f,  179.96f,  185.48f,  190.98f,  196.47f,  201.95f, 
 207.40f,  212.84f,  218.25f,  223.64f,  229.01f,  234.35f,  239.67f,  244.95f, 
 250.21f,  255.42f,  260.00f,  264.57f,  269.13f,  273.68f,  278.22f,  282.75f, 
 287.27f,  291.78f,  296.27f,  300.74f,  305.20f,  309.64f,  314.08f,  318.51f, 
 322.92f,  327.33f,  331.73f,  336.13f,  340.51f,  344.87f,  349.23f,  353.57f, 
 357.90f,  362.22f,  366.53f,  370.82f,  375.09f,  379.35f,  383.60f,  387.83f, 
 392.05f,  396.25f,  400.43f,  404.60f,  408.75f,  412.89f,  417.01f,  421.11f, 
 425.20f,  429.27f,  433.32f,  437.36f,  441.38f,  445.38f,  449.36f,  453.33f, 
 457.28f,  461.22f,  465.13f,  469.03f,  472.92f,  476.78f,  480.63f,  484.46f, 
 488.27f,  492.06f,  495.84f,  499.60f,  503.34f,  507.06f,  510.77f,  514.45f, 
 518.13f,  521.78f,  525.41f,  529.03f,  532.63f,  536.21f,  539.78f,  543.33f, 
 546.85f,  550.37f,  553.86f,  557.34f,  560.79f,  564.24f,  567.66f,  571.06f, 
 574.45f,  577.82f,  581.17f,  584.51f,  587.83f,  591.12f,  594.41f,  597.67f, 
 600.91f,  604.14f,  607.35f,  610.54f,  613.72f,  616.87f,  620.01f,  623.13f, 
 626.24f,  629.32f,  632.39f,  635.44f,  638.47f,  641.48f,  644.48f,  647.46f, 
 650.41f,  653.36f,  656.28f,  659.18f,  662.07f,  664.94f,  667.79f,  670.62f, 
 673.43f,  676.23f,  679.00f,  681.76f,  684.50f,  687.22f,  689.92f,  692.61f, 
 695.27f,  697.92f,  700.54f,  703.15f,  705.74f,  708.31f,  710.86f,  713.39f, 
 715.90f,  718.39f,  720.87f,  723.33f,  725.76f,  728.17f,  730.55f,  732.91f, 
 735.26f,  737.60f,  739.93f,  742.26f,  744.58f,  746.90f,  749.21f,  751.51f, 
 753.81f,  756.11f,  758.40f,  760.68f,  762.96f,  765.23f,  767.49f,  769.75f, 
 772.00f,  774.24f,  776.47f,  778.69f,  780.91f,  783.13f,  785.35f,  787.57f, 
 789.79f,  792.01f,  794.23f,  796.44f,  798.66f,  800.88f,  803.10f,  805.32f, 
 807.54f,  809.76f,  811.98f,  814.20f,  816.42f,  818.64f,  820.86f,  823.08f, 
 825.30f,  827.52f,  829.74f,  831.96f,  834.18f,  836.39f,  838.61f,  840.83f, 
 843.05f,  845.27f,  847.49f,  849.71f,  851.93f,  854.15f,  856.37f, 1084.98f, 
1085.93f, 1086.89f, 1087.85f, 1088.81f, 1089.76f, 1090.72f, 1091.68f, 1092.63f, 
1093.59f, 1094.54f, 1095.50f, 1096.45f, 1097.41f, 1098.36f, 1099.31f, 1100.27f, 
1101.22f, 1102.17f, 1103.12f, 1104.07f, 1105.02f, 1105.97f, 1106.92f, 1107.86f, 
1108.81f, 1109.76f, 1110.70f, 1111.64f, 1112.58f, 1113.52f, 1114.46f, 1115.40f, 
1116.34f, 1117.27f, 1118.20f, 1119.13f, 1120.06f, 1120.99f, 1121.92f, 1122.84f, 
1123.76f, 1124.68f, 1125.59f, 1126.50f, 1127.41f, 1128.32f, 1129.22f, 1130.12f, 
1131.02f, 1131.91f, 1132.80f, 1133.69f, 1134.57f, 1135.45f, 1136.32f, 1137.18f, 
1136.36f, 1138.01f, 1139.60f, 1140.60f, 1141.44f, 1142.27f, 1143.10f, 1143.92f, 
1144.73f, 1145.53f, 1146.33f, 1147.12f, 1147.90f, 1148.67f, 1149.44f, 1150.19f, 
1150.94f, 1151.68f, 1152.40f, 1153.12f, 1153.83f, 1154.52f, 1155.21f, 1155.88f, 
1156.55f, 1157.20f, 1157.84f, 1158.47f, 1159.09f, 1159.70f, 1160.29f, 1160.88f, 
1161.45f, 1162.00f, 1162.55f, 1163.08f, 1163.60f, 1164.11f, 1164.60f, 1165.08f, 
1165.54f, 1166.00f, 1166.43f, 1166.86f, 1167.27f, 1167.67f, 1168.05f, 1168.42f, 
1168.78f, 1169.12f, 1169.45f, 1169.76f, 1170.06f, 1170.34f, 1170.61f, 1170.87f, 
1171.11f, 1171.34f, 1171.55f, 1171.75f, 1171.93f, 1172.10f, 1172.26f, 1172.40f, 
1172.52f, 1172.63f, 1172.73f, 1172.81f, 1172.87f, 1172.93f, 1172.96f, 1172.98f, 
1172.99f, 
  40.27f,   40.85f,   42.49f,   45.11f,   48.52f,   52.57f,   57.11f,   62.04f, 
  67.25f,   72.68f,   78.27f,   84.00f,   89.82f,   95.73f,  101.68f,  107.68f, 
 113.71f,  119.77f,  125.83f,  131.90f,  137.96f,  144.02f,  150.07f,  156.11f, 
 162.12f,  168.12f,  173.96f,  179.48f,  184.99f,  190.49f,  195.97f,  201.44f, 
 206.88f,  212.31f,  217.72f,  223.10f,  228.46f,  233.80f,  239.10f,  244.38f, 
 249.62f,  254.66f,  259.24f,  263.80f,  268.36f,  272.91f,  277.45f,  281.98f, 
 286.50f,  291.00f,  295.49f,  299.95f,  304.41f,  308.85f,  313.29f,  317.72f, 
 322.13f,  326.54f,  330.94f,  335.33f,  339.70f,  344.07f,  348.42f,  352.77f, 
 357.09f,  361.41f,  365.71f,  370.00f,  374.27f,  378.53f,  382.77f,  387.00f, 
 391.21f,  395.41f,  399.59f,  403.76f,  407.91f,  412.04f,  416.16f,  420.26f, 
 424.34f,  428.41f,  432.46f,  436.49f,  440.51f,  444.51f,  448.49f,  452.46f, 
 456.41f,  460.34f,  464.25f,  468.15f,  472.03f,  475.89f,  479.73f,  483.56f, 
 487.37f,  491.16f,  494.93f,  498.69f,  502.43f,  506.15f,  509.85f,  513.54f, 
 517.20f,  520.86f,  524.49f,  528.10f,  531.70f,  535.28f,  538.84f,  542.39f, 
 545.91f,  549.42f,  552.92f,  556.39f,  559.85f,  563.28f,  566.71f,  570.11f, 
 573.49f,  576.86f,  580.21f,  583.54f,  586.86f,  590.15f,  593.43f,  596.70f, 
 599.94f,  603.16f,  606.37f,  609.56f,  612.73f,  615.89f,  619.03f,  622.14f, 
 625.25f,  628.33f,  631.39f,  634.44f,  637.47f,  640.48f,  643.47f,  646.45f, 
 649.41f,  652.35f,  655.27f,  658.17f,  661.06f,  663.92f,  666.77f,  669.60f, 
 672.41f,  675.20f,  677.98f,  680.73f,  683.47f,  686.19f,  688.89f,  691.57f, 
 694.24f,  696.88f,  699.51f,  702.11f,  704.70f,  707.27f,  709.81f,  712.34f, 
 714.85f,  717.34f,  719.82f,  722.27f,  724.71f,  727.11f,  729.49f,  731.85f, 
 734.20f,  736.54f,  738.87f,  741.20f,  743.52f,  745.83f,  748.14f,  750.45f, 
 752.74f,  755.04f,  757.33f,  759.61f,  761.89f,  764.16f,  766.42f,  768.68f, 
 770.93f,  773.16f,  775.39f,  777.62f,  779.84f,  782.06f,  784.27f,  786.49f, 
 788.71f,  790.93f,  793.15f,  795.37f,  797.59f,  799.81f,  802.03f,  804.25f, 
 806.47f,  808.69f,  810.91f,  813.13f,  815.35f,  817.57f,  819.79f,  822.01f, 
 824.23f,  826.44f,  828.66f,  830.88f,  833.10f,  835.32f,  837.54f,  839.76f, 
 841.98f,  844.20f,  846.42f,  848.64f,  850.86f,  853.08f,  855.30f, 1083.84f, 
1084.80f, 1085.75f, 1086.71f, 1087.67f, 1088.63f, 1089.58f, 1090.54f, 1091.49f, 
1092.45f, 1093.41f, 1094.36f, 1095.32f, 1096.27f, 1097.22f, 1098.18f, 1099.13f, 
1100.08f, 1101.03f, 1101.98f, 1102.93f, 1103.88f, 1104.83f, 1105.78f, 1106.73f, 
1107.67f, 1108.62f, 1109.56f, 1110.50f, 1111.45f, 1112.39f, 1113.33f, 1114.26f, 
1115.20f, 1116.13f, 1117.07f, 1118.00f, 1118.93f, 1119.85f, 1120.78f, 1121.70f, 
1122.62f, 1123.54f, 1124.45f, 1125.37f, 1126.28f, 1127.18f, 1128.09f, 1128.99f, 
1129.88f, 1130.77f, 1131.66f, 1132.55f, 1133.43f, 1134.31f, 1135.18f, 1136.04f, 
1135.25f, 1136.90f, 1138.48f, 1139.46f, 1140.30f, 1141.13f, 1141.95f, 1142.77f, 
1143.59f, 1144.39f, 1145.19f, 1145.98f, 1146.76f, 1147.53f, 1148.29f, 1149.05f, 
1149.80f, 1150.53f, 1151.26f, 1151.98f, 1152.68f, 1153.38f, 1154.06f, 1154.74f, 
1155.40f, 1156.06f, 1156.70f, 1157.33f, 1157.95f, 1158.55f, 1159.15f, 1159.73f, 
1160.30f, 1160.86f, 1161.40f, 1161.93f, 1162.45f, 1162.96f, 1163.45f, 1163.93f, 
1164.39f, 1164.85f, 1165.29f, 1165.71f, 1166.12f, 1166.52f, 1166.90f, 1167.27f, 
1167.63f, 1167.97f, 1168.30f, 1168.61f, 1168.91f, 1169.19f, 1169.46f, 1169.72f, 
1169.96f, 1170.19f, 1170.40f, 1170.60f, 1170.78f, 1170.95f, 1171.11f, 1171.24f, 
1171.37f, 1171.48f, 1171.58f, 1171.66f, 1171.72f, 1171.77f, 1171.81f, 1171.83f, 
1171.84f, 
  41.42f,   41.97f,   43.57f,   46.10f,   49.43f,   53.38f,   57.84f,   62.67f, 
  67.80f,   73.16f,   78.69f,   84.36f,   90.12f,   95.97f,  101.88f,  107.84f, 
 113.83f,  119.84f,  125.86f,  131.89f,  137.93f,  143.96f,  149.97f,  155.98f, 
 161.97f,  167.93f,  173.49f,  179.01f,  184.51f,  190.00f,  195.48f,  200.94f, 
 206.38f,  211.80f,  217.20f,  222.57f,  227.92f,  233.25f,  238.54f,  243.81f, 
 249.05f,  253.91f,  258.49f,  263.05f,  267.61f,  272.16f,  276.69f,  281.22f, 
 285.73f,  290.23f,  294.71f,  299.18f,  303.63f,  308.08f,  312.51f,  316.93f, 
 321.35f,  325.75f,  330.15f,  334.54f,  338.91f,  343.28f,  347.63f,  351.97f, 
 356.29f,  360.60f,  364.90f,  369.19f,  373.46f,  377.71f,  381.95f,  386.18f, 
 390.39f,  394.58f,  398.76f,  402.92f,  407.07f,  411.20f,  415.32f,  419.41f, 
 423.49f,  427.56f,  431.61f,  435.64f,  439.65f,  443.65f,  447.63f,  451.59f, 
 455.54f,  459.46f,  463.38f,  467.27f,  471.14f,  475.00f,  478.85f,  482.67f, 
 486.48f,  490.26f,  494.03f,  497.79f,  501.52f,  505.24f,  508.94f,  512.63f, 
 516.29f,  519.94f,  523.57f,  527.18f,  530.78f,  534.36f,  537.92f,  541.46f, 
 544.98f,  548.49f,  551.98f,  555.45f,  558.90f,  562.34f,  565.76f,  569.16f, 
 572.54f,  575.91f,  579.26f,  582.59f,  585.90f,  589.19f,  592.47f,  595.73f, 
 598.97f,  602.19f,  605.40f,  608.59f,  611.76f,  614.91f,  618.04f,  621.16f, 
 624.26f,  627.34f,  630.40f,  633.45f,  636.48f,  639.49f,  642.48f,  645.45f, 
 648.41f,  651.34f,  654.26f,  657.16f,  660.05f,  662.91f,  665.76f,  668.58f, 
 671.39f,  674.19f,  676.96f,  679.71f,  682.45f,  685.17f,  687.86f,  690.54f, 
 693.21f,  695.85f,  698.47f,  701.08f,  703.66f,  706.23f,  708.77f,  711.30f, 
 713.81f,  716.30f,  718.77f,  721.22f,  723.66f,  726.06f,  728.43f,  730.79f, 
 733.14f,  735.48f,  737.81f,  740.14f,  742.46f,  744.77f,  747.08f,  749.38f, 
 751.68f,  753.98f,  756.27f,  758.55f,  760.83f,  763.10f,  765.36f,  767.61f, 
 769.86f,  772.10f,  774.33f,  776.55f,  778.77f,  780.99f,  783.21f,  785.43f, 
 787.65f,  789.87f,  792.09f,  794.31f,  796.52f,  798.74f,  800.96f,  803.18f, 
 805.40f,  807.62f,  809.84f,  812.06f,  814.28f,  816.50f,  818.72f,  820.94f, 
 823.16f,  825.38f,  827.60f,  829.82f,  832.04f,  834.26f,  836.47f,  838.69f, 
 840.91f,  843.13f,  845.35f,  847.57f,  849.79f,  852.01f,  854.23f, 1082.71f, 
1083.67f, 1084.62f, 1085.58f, 1086.54f, 1087.49f, 1088.45f, 1089.41f, 1090.36f, 
1091.32f, 1092.27f, 1093.23f, 1094.18f, 1095.14f, 1096.09f, 1097.04f, 1098.00f, 
1098.95f, 1099.90f, 1100.85f, 1101.80f, 1102.75f, 1103.70f, 1104.65f, 1105.59f, 
1106.54f, 1107.49f, 1108.43f, 1109.37f, 1110.31f, 1111.25f, 1112.19f, 1113.13f, 
1114.07f, 1115.00f, 1115.93f, 1116.86f, 1117.79f, 1118.72f, 1119.64f, 1120.57f, 
1121.49f, 1122.40f, 1123.32f, 1124.23f, 1125.14f, 1126.05f, 1126.95f, 1127.85f, 
1128.75f, 1129.64f, 1130.53f, 1131.41f, 1132.30f, 1133.17f, 1134.04f, 1134.91f, 
1134.15f, 1135.79f, 1137.37f, 1138.32f, 1139.16f, 1139.99f, 1140.82f, 1141.64f, 
1142.45f, 1143.25f, 1144.05f, 1144.84f, 1145.62f, 1146.39f, 1147.16f, 1147.91f, 
1148.66f, 1149.39f, 1150.12f, 1150.84f, 1151.54f, 1152.24f, 1152.93f, 1153.60f, 
1154.26f, 1154.92f, 1155.56f, 1156.19f, 1156.81f, 1157.41f, 1158.01f, 1158.59f, 
1159.16f, 1159.71f, 1160.26f, 1160.79f, 1161.31f, 1161.81f, 1162.31f, 1162.79f, 
1163.25f, 1163.70f, 1164.14f, 1164.57f, 1164.98f, 1165.38f, 1165.76f, 1166.13f, 
1166.48f, 1166.82f, 1167.15f, 1167.47f, 1167.76f, 1168.05f, 1168.32f, 1168.57f, 
1168.82f, 1169.04f, 1169.25f, 1169.45f, 1169.64f, 1169.80f, 1169.96f, 1170.10f, 
1170.22f, 1170.33f, 1170.43f, 1170.51f, 1170.58f, 1170.63f, 1170.66f, 1170.69f, 
1170.69f, 
  42.56f,   43.10f,   44.64f,   47.10f,   50.34f,   54.20f,   58.57f,   63.32f, 
  68.37f,   73.66f,   79.12f,   84.73f,   90.44f,   96.23f,  102.10f,  108.01f, 
 113.95f,  119.92f,  125.91f,  131.90f,  137.90f,  143.90f,  149.88f,  155.86f, 
 161.82f,  167.51f,  173.04f,  178.55f,  184.05f,  189.53f,  195.00f,  200.45f, 
 205.89f,  211.30f,  216.69f,  222.05f,  227.39f,  232.71f,  237.99f,  243.25f, 
 248.48f,  253.17f,  257.74f,  262.31f,  266.86f,  271.41f,  275.94f,  280.47f, 
 284.98f,  289.47f,  293.95f,  298.41f,  302.86f,  307.30f,  311.73f,  316.16f, 
 320.57f,  324.97f,  329.37f,  333.75f,  338.13f,  342.49f,  346.84f,  351.17f, 
 355.50f,  359.81f,  364.10f,  368.38f,  372.65f,  376.90f,  381.14f,  385.36f, 
 389.57f,  393.76f,  397.94f,  402.10f,  406.24f,  410.37f,  414.48f,  418.57f, 
 422.65f,  426.71f,  430.76f,  434.79f,  438.80f,  442.79f,  446.77f,  450.73f, 
 454.67f,  458.60f,  462.51f,  466.40f,  470.27f,  474.13f,  477.96f,  481.79f, 
 485.59f,  489.37f,  493.14f,  496.89f,  500.63f,  504.34f,  508.04f,  511.72f, 
 515.38f,  519.03f,  522.66f,  526.27f,  529.86f,  533.44f,  536.99f,  540.53f, 
 544.05f,  547.56f,  551.05f,  554.52f,  557.97f,  561.40f,  564.82f,  568.22f, 
 571.60f,  574.96f,  578.30f,  581.63f,  584.94f,  588.24f,  591.51f,  594.77f, 
 598.01f,  601.23f,  604.43f,  607.62f,  610.78f,  613.93f,  617.07f,  620.18f, 
 623.28f,  626.36f,  629.42f,  632.46f,  635.49f,  638.50f,  641.49f,  644.46f, 
 647.41f,  650.35f,  653.26f,  656.16f,  659.04f,  661.91f,  664.75f,  667.58f, 
 670.38f,  673.17f,  675.94f,  678.70f,  681.43f,  684.15f,  686.84f,  689.52f, 
 692.18f,  694.82f,  697.44f,  700.05f,  702.63f,  705.19f,  707.74f,  710.26f, 
 712.77f,  715.26f,  717.73f,  720.18f,  722.61f,  725.01f,  727.38f,  729.74f, 
 732.09f,  734.43f,  736.76f,  739.08f,  741.40f,  743.72f,  746.03f,  748.33f, 
 750.63f,  752.92f,  755.21f,  757.49f,  759.77f,  762.04f,  764.30f,  766.55f, 
 768.80f,  771.04f,  773.27f,  775.49f,  777.71f,  779.93f,  782.15f,  784.37f, 
 786.59f,  788.80f,  791.02f,  793.24f,  795.46f,  797.68f,  799.90f,  802.12f, 
 804.34f,  806.56f,  808.78f,  811.00f,  813.22f,  815.44f,  817.66f,  819.88f, 
 822.10f,  824.32f,  826.54f,  828.76f,  830.97f,  833.19f,  835.41f,  837.63f, 
 839.85f,  842.07f,  844.29f,  846.51f,  848.73f,  850.95f,  853.17f, 1081.58f, 
1082.54f, 1083.49f, 1084.45f, 1085.41f, 1086.37f, 1087.32f, 1088.28f, 1089.23f, 
1090.19f, 1091.15f, 1092.10f, 1093.06f, 1094.01f, 1094.96f, 1095.92f, 1096.87f, 
1097.82f, 1098.77f, 1099.72f, 1100.67f, 1101.62f, 1102.57f, 1103.52f, 1104.47f, 
1105.41f, 1106.36f, 1107.30f, 1108.24f, 1109.19f, 1110.13f, 1111.06f, 1112.00f, 
1112.94f, 1113.87f, 1114.80f, 1115.73f, 1116.66f, 1117.59f, 1118.51f, 1119.44f, 
1120.36f, 1121.28f, 1122.19f, 1123.10f, 1124.01f, 1124.92f, 1125.82f, 1126.72f, 
1127.62f, 1128.51f, 1129.40f, 1130.28f, 1131.17f, 1132.04f, 1132.91f, 1133.78f, 
1133.05f, 1134.69f, 1136.27f, 1137.19f, 1138.03f, 1138.86f, 1139.69f, 1140.51f, 
1141.32f, 1142.12f, 1142.92f, 1143.71f, 1144.49f, 1145.26f, 1146.02f, 1146.78f, 
1147.52f, 1148.26f, 1148.99f, 1149.70f, 1150.41f, 1151.11f, 1151.79f, 1152.47f, 
1153.13f, 1153.78f, 1154.42f, 1155.05f, 1155.67f, 1156.28f, 1156.87f, 1157.45f, 
1158.02f, 1158.58f, 1159.12f, 1159.65f, 1160.17f, 1160.68f, 1161.17f, 1161.65f, 
1162.11f, 1162.56f, 1163.00f, 1163.43f, 1163.84f, 1164.24f, 1164.62f, 1164.99f, 
1165.34f, 1165.68f, 1166.01f, 1166.32f, 1166.62f, 1166.91f, 1167.18f, 1167.43f, 
1167.67f, 1167.90f, 1168.11f, 1168.31f, 1168.49f, 1168.66f, 1168.82f, 1168.96f, 
1169.08f, 1169.19f, 1169.29f, 1169.37f, 1169.43f, 1169.49f, 1169.52f, 1169.54f, 
1169.55f, 
  43.70f,   44.22f,   45.71f,   48.10f,   51.26f,   55.03f,   59.31f,   63.98f, 
  68.95f,   74.16f,   79.56f,   85.11f,   90.76f,   96.51f,  102.32f,  108.18f, 
 114.09f,  120.02f,  125.96f,  131.92f,  137.89f,  143.85f,  149.80f,  155.75f, 
 161.55f,  167.08f,  172.60f,  178.10f,  183.60f,  189.08f,  194.54f,  199.98f, 
 205.41f,  210.81f,  216.19f,  221.55f,  226.88f,  232.18f,  237.46f,  242.70f, 
 247.86f,  252.44f,  257.01f,  261.57f,  266.12f,  270.67f,  275.20f,  279.72f, 
 284.23f,  288.72f,  293.19f,  297.65f,  302.10f,  306.54f,  310.97f,  315.39f, 
 319.80f,  324.20f,  328.60f,  332.98f,  337.35f,  341.71f,  346.05f,  350.39f, 
 354.71f,  359.02f,  363.31f,  367.59f,  371.85f,  376.10f,  380.34f,  384.56f, 
 388.76f,  392.95f,  397.12f,  401.28f,  405.42f,  409.54f,  413.65f,  417.74f, 
 421.82f,  425.88f,  429.92f,  433.95f,  437.95f,  441.94f,  445.92f,  449.88f, 
 453.82f,  457.74f,  461.64f,  465.53f,  469.40f,  473.26f,  477.09f,  480.91f, 
 484.71f,  488.49f,  492.26f,  496.01f,  499.74f,  503.45f,  507.15f,  510.82f, 
 514.48f,  518.13f,  521.75f,  525.36f,  528.95f,  532.52f,  536.08f,  539.61f, 
 543.13f,  546.64f,  550.12f,  553.59f,  557.04f,  560.47f,  563.88f,  567.28f, 
 570.66f,  574.02f,  577.36f,  580.69f,  583.99f,  587.28f,  590.56f,  593.81f, 
 597.05f,  600.27f,  603.47f,  606.65f,  609.82f,  612.97f,  616.10f,  619.21f, 
 622.31f,  625.38f,  628.44f,  631.48f,  634.51f,  637.51f,  640.50f,  643.47f, 
 646.42f,  649.35f,  652.27f,  655.17f,  658.04f,  660.91f,  663.75f,  666.57f, 
 669.38f,  672.17f,  674.93f,  677.69f,  680.42f,  683.13f,  685.83f,  688.50f, 
 691.16f,  693.80f,  696.42f,  699.02f,  701.60f,  704.16f,  706.71f,  709.23f, 
 711.73f,  714.22f,  716.69f,  719.14f,  721.57f,  723.96f,  726.34f,  728.69f, 
 731.04f,  733.38f,  735.71f,  738.04f,  740.36f,  742.67f,  744.98f,  747.28f, 
 749.58f,  751.87f,  754.16f,  756.44f,  758.72f,  760.99f,  763.25f,  765.50f, 
 767.75f,  769.98f,  772.21f,  774.43f,  776.65f,  778.87f,  781.09f,  783.31f, 
 785.53f,  787.75f,  789.97f,  792.19f,  794.41f,  796.63f,  798.85f,  801.07f, 
 803.28f,  805.50f,  807.72f,  809.94f,  812.16f,  814.38f,  816.60f,  818.82f, 
 821.04f,  823.26f,  825.48f,  827.70f,  829.92f,  832.14f,  834.36f,  836.58f, 
 838.80f,  841.02f,  843.24f,  845.45f,  847.67f,  849.89f,  852.11f, 1080.46f, 
1081.41f, 1082.37f, 1083.33f, 1084.29f, 1085.24f, 1086.20f, 1087.16f, 1088.11f, 
1089.07f, 1090.02f, 1090.98f, 1091.93f, 1092.89f, 1093.84f, 1094.79f, 1095.75f, 
1096.70f, 1097.65f, 1098.60f, 1099.55f, 1100.50f, 1101.45f, 1102.40f, 1103.34f, 
1104.29f, 1105.23f, 1106.18f, 1107.12f, 1108.06f, 1109.00f, 1109.94f, 1110.88f, 
1111.81f, 1112.75f, 1113.68f, 1114.61f, 1115.54f, 1116.47f, 1117.39f, 1118.31f, 
1119.23f, 1120.15f, 1121.07f, 1121.98f, 1122.89f, 1123.79f, 1124.70f, 1125.60f, 
1126.49f, 1127.39f, 1128.28f, 1129.16f, 1130.04f, 1130.92f, 1131.79f, 1132.65f, 
1131.96f, 1133.59f, 1135.17f, 1136.07f, 1136.90f, 1137.74f, 1138.56f, 1139.38f, 
1140.19f, 1140.99f, 1141.79f, 1142.58f, 1143.36f, 1144.13f, 1144.90f, 1145.65f, 
1146.40f, 1147.13f, 1147.86f, 1148.57f, 1149.28f, 1149.98f, 1150.66f, 1151.34f, 
1152.00f, 1152.65f, 1153.29f, 1153.92f, 1154.54f, 1155.14f, 1155.74f, 1156.32f, 
1156.89f, 1157.45f, 1157.99f, 1158.52f, 1159.04f, 1159.54f, 1160.03f, 1160.51f, 
1160.98f, 1161.43f, 1161.87f, 1162.29f, 1162.70f, 1163.10f, 1163.48f, 1163.85f, 
1164.21f, 1164.55f, 1164.88f, 1165.19f, 1165.49f, 1165.77f, 1166.04f, 1166.30f, 
1166.54f, 1166.76f, 1166.98f, 1167.17f, 1167.36f, 1167.53f, 1167.68f, 1167.82f, 
1167.94f, 1168.05f, 1168.15f, 1168.23f, 1168.30f, 1168.35f, 1168.38f, 1168.41f, 
1168.41f, 
  44.83f,   45.33f,   46.79f,   49.11f,   52.18f,   55.87f,   60.06f,   64.65f, 
  69.55f,   74.69f,   80.02f,   85.50f,   91.10f,   96.79f,  102.55f,  108.37f, 
 114.23f,  120.12f,  126.03f,  131.95f,  137.88f,  143.81f,  149.73f,  155.60f, 
 161.13f,  166.66f,  172.17f,  177.67f,  183.16f,  188.63f,  194.08f,  199.52f, 
 204.94f,  210.33f,  215.70f,  221.05f,  226.37f,  231.66f,  236.93f,  242.16f, 
 247.14f,  251.71f,  256.28f,  260.84f,  265.39f,  269.93f,  274.46f,  278.98f, 
 283.49f,  287.97f,  292.45f,  296.90f,  301.35f,  305.79f,  310.21f,  314.63f, 
 319.04f,  323.44f,  327.83f,  332.21f,  336.58f,  340.94f,  345.28f,  349.61f, 
 353.93f,  358.23f,  362.52f,  366.80f,  371.06f,  375.31f,  379.54f,  383.76f, 
 387.96f,  392.14f,  396.31f,  400.47f,  404.61f,  408.73f,  412.83f,  416.92f, 
 420.99f,  425.05f,  429.09f,  433.11f,  437.11f,  441.10f,  445.07f,  449.03f, 
 452.97f,  456.88f,  460.79f,  464.67f,  468.54f,  472.39f,  476.22f,  480.04f, 
 483.84f,  487.62f,  491.38f,  495.13f,  498.85f,  502.56f,  506.26f,  509.93f, 
 513.59f,  517.23f,  520.85f,  524.46f,  528.05f,  531.62f,  535.17f,  538.70f, 
 542.22f,  545.72f,  549.20f,  552.67f,  556.11f,  559.54f,  562.95f,  566.35f, 
 569.72f,  573.08f,  576.42f,  579.75f,  583.05f,  586.34f,  589.61f,  592.86f, 
 596.10f,  599.31f,  602.51f,  605.69f,  608.86f,  612.00f,  615.13f,  618.24f, 
 621.34f,  624.41f,  627.47f,  630.51f,  633.53f,  636.53f,  639.52f,  642.49f, 
 645.44f,  648.37f,  651.28f,  654.18f,  657.05f,  659.91f,  662.75f,  665.57f, 
 668.38f,  671.16f,  673.93f,  676.68f,  679.41f,  682.12f,  684.82f,  687.49f, 
 690.15f,  692.78f,  695.40f,  698.00f,  700.58f,  703.14f,  705.68f,  708.20f, 
 710.71f,  713.19f,  715.66f,  718.11f,  720.53f,  722.93f,  725.30f,  727.65f, 
 730.00f,  732.34f,  734.67f,  736.99f,  739.31f,  741.62f,  743.93f,  746.23f, 
 748.53f,  750.83f,  753.11f,  755.40f,  757.67f,  759.94f,  762.20f,  764.45f, 
 766.70f,  768.93f,  771.16f,  773.38f,  775.60f,  777.82f,  780.04f,  782.26f, 
 784.48f,  786.70f,  788.92f,  791.14f,  793.36f,  795.58f,  797.80f,  800.01f, 
 802.23f,  804.45f,  806.67f,  808.89f,  811.11f,  813.33f,  815.55f,  817.77f, 
 819.99f,  822.21f,  824.43f,  826.65f,  828.87f,  831.09f,  833.31f,  835.53f, 
 837.75f,  839.96f,  842.18f,  844.40f,  846.62f,  848.84f,  851.06f, 1079.34f, 
1080.30f, 1081.25f, 1082.21f, 1083.17f, 1084.13f, 1085.08f, 1086.04f, 1086.99f, 
1087.95f, 1088.90f, 1089.86f, 1090.81f, 1091.77f, 1092.72f, 1093.68f, 1094.63f, 
1095.58f, 1096.53f, 1097.48f, 1098.43f, 1099.38f, 1100.33f, 1101.28f, 1102.23f, 
1103.17f, 1104.12f, 1105.06f, 1106.00f, 1106.94f, 1107.88f, 1108.82f, 1109.76f, 
1110.70f, 1111.63f, 1112.56f, 1113.49f, 1114.42f, 1115.35f, 1116.27f, 1117.19f, 
1118.11f, 1119.03f, 1119.95f, 1120.86f, 1121.77f, 1122.68f, 1123.58f, 1124.48f, 
1125.37f, 1126.27f, 1127.16f, 1128.04f, 1128.92f, 1129.80f, 1130.67f, 1131.53f, 
1130.87f, 1132.50f, 1134.08f, 1134.94f, 1135.78f, 1136.61f, 1137.44f, 1138.26f, 
1139.07f, 1139.87f, 1140.67f, 1141.46f, 1142.24f, 1143.01f, 1143.77f, 1144.53f, 
1145.27f, 1146.01f, 1146.73f, 1147.45f, 1148.15f, 1148.85f, 1149.54f, 1150.21f, 
1150.87f, 1151.53f, 1152.17f, 1152.79f, 1153.41f, 1154.02f, 1154.61f, 1155.19f, 
1155.76f, 1156.32f, 1156.86f, 1157.39f, 1157.91f, 1158.41f, 1158.91f, 1159.38f, 
1159.85f, 1160.30f, 1160.74f, 1161.16f, 1161.57f, 1161.97f, 1162.35f, 1162.72f, 
1163.08f, 1163.42f, 1163.74f, 1164.06f, 1164.36f, 1164.64f, 1164.91f, 1165.17f, 
1165.41f, 1165.63f, 1165.84f, 1166.04f, 1166.23f, 1166.39f, 1166.55f, 1166.69f, 
1166.81f, 1166.92f, 1167.02f, 1167.10f, 1167.16f, 1167.22f, 1167.25f, 1167.27f, 
1167.28f, 
  45.96f,   46.45f,   47.86f,   50.11f,   53.11f,   56.72f,   60.82f,   65.33f, 
  70.15f,   75.22f,   80.49f,   85.91f,   91.45f,   97.09f,  102.80f,  108.57f, 
 114.39f,  120.24f,  126.11f,  131.99f,  137.89f,  143.78f,  149.67f,  155.20f, 
 160.73f,  166.25f,  171.76f,  177.25f,  182.73f,  188.20f,  193.64f,  199.07f, 
 204.48f,  209.86f,  215.22f,  220.56f,  225.87f,  231.15f,  236.41f,  241.63f, 
 246.42f,  251.00f,  255.57f,  260.12f,  264.67f,  269.21f,  273.74f,  278.25f, 
 282.75f,  287.24f,  291.71f,  296.16f,  300.60f,  305.04f,  309.46f,  313.88f, 
 318.29f,  322.69f,  327.07f,  331.45f,  335.82f,  340.17f,  344.51f,  348.84f, 
 353.16f,  357.46f,  361.75f,  366.02f,  370.28f,  374.52f,  378.75f,  382.96f, 
 387.16f,  391.35f,  395.51f,  399.66f,  403.80f,  407.92f,  412.02f,  416.10f, 
 420.17f,  424.23f,  428.26f,  432.28f,  436.28f,  440.27f,  444.24f,  448.19f, 
 452.12f,  456.04f,  459.94f,  463.82f,  467.69f,  471.53f,  475.36f,  479.18f, 
 482.97f,  486.75f,  490.51f,  494.25f,  497.98f,  501.68f,  505.37f,  509.05f, 
 512.70f,  516.34f,  519.96f,  523.56f,  527.15f,  530.71f,  534.26f,  537.80f, 
 541.31f,  544.81f,  548.29f,  551.75f,  555.19f,  558.62f,  562.03f,  565.42f, 
 568.80f,  572.15f,  575.49f,  578.81f,  582.12f,  585.40f,  588.67f,  591.92f, 
 595.15f,  598.37f,  601.56f,  604.74f,  607.90f,  611.05f,  614.17f,  617.28f, 
 620.37f,  623.45f,  626.50f,  629.54f,  632.56f,  635.56f,  638.54f,  641.51f, 
 644.46f,  647.39f,  650.30f,  653.19f,  656.07f,  658.92f,  661.76f,  664.58f, 
 667.38f,  670.17f,  672.93f,  675.68f,  678.41f,  681.12f,  683.81f,  686.48f, 
 689.14f,  691.77f,  694.39f,  696.99f,  699.57f,  702.12f,  704.66f,  707.18f, 
 709.68f,  712.17f,  714.63f,  717.08f,  719.50f,  721.89f,  724.26f,  726.62f, 
 728.96f,  731.30f,  733.63f,  735.96f,  738.27f,  740.59f,  742.89f,  745.20f, 
 747.49f,  749.79f,  752.07f,  754.36f,  756.63f,  758.90f,  761.16f,  763.41f, 
 765.65f,  767.89f,  770.12f,  772.34f,  774.56f,  776.77f,  778.99f,  781.21f, 
 783.43f,  785.65f,  787.87f,  790.09f,  792.31f,  794.53f,  796.75f,  798.97f, 
 801.19f,  803.41f,  805.63f,  807.85f,  810.07f,  812.29f,  814.51f,  816.72f, 
 818.94f,  821.16f,  823.38f,  825.60f,  827.82f,  830.04f,  832.26f,  834.48f, 
 836.70f,  838.92f,  841.14f,  843.36f,  845.58f,  847.80f,  850.02f, 1078.23f, 
1079.18f, 1080.14f, 1081.10f, 1082.06f, 1083.01f, 1083.97f, 1084.92f, 1085.88f, 
1086.84f, 1087.79f, 1088.75f, 1089.70f, 1090.66f, 1091.61f, 1092.56f, 1093.52f, 
1094.47f, 1095.42f, 1096.37f, 1097.32f, 1098.27f, 1099.22f, 1100.16f, 1101.11f, 
1102.06f, 1103.00f, 1103.95f, 1104.89f, 1105.83f, 1106.77f, 1107.71f, 1108.65f, 
1109.58f, 1110.52f, 1111.45f, 1112.38f, 1113.31f, 1114.23f, 1115.16f, 1116.08f, 
1117.00f, 1117.92f, 1118.83f, 1119.74f, 1120.65f, 1121.56f, 1122.46f, 1123.36f, 
1124.26f, 1125.15f, 1126.04f, 1126.92f, 1127.80f, 1128.68f, 1129.55f, 1130.42f, 
1129.79f, 1131.42f, 1132.98f, 1133.83f, 1134.67f, 1135.50f, 1136.32f, 1137.14f, 
1137.95f, 1138.75f, 1139.55f, 1140.34f, 1141.12f, 1141.89f, 1142.65f, 1143.41f, 
1144.15f, 1144.89f, 1145.61f, 1146.33f, 1147.03f, 1147.73f, 1148.41f, 1149.09f, 
1149.75f, 1150.40f, 1151.04f, 1151.67f, 1152.29f, 1152.90f, 1153.49f, 1154.07f, 
1154.64f, 1155.19f, 1155.74f, 1156.27f, 1156.79f, 1157.29f, 1157.78f, 1158.26f, 
1158.72f, 1159.18f, 1159.61f, 1160.04f, 1160.45f, 1160.84f, 1161.23f, 1161.60f, 
1161.95f, 1162.29f, 1162.62f, 1162.93f, 1163.23f, 1163.51f, 1163.78f, 1164.04f, 
1164.28f, 1164.51f, 1164.72f, 1164.91f, 1165.10f, 1165.27f, 1165.42f, 1165.56f, 
1165.68f, 1165.79f, 1165.89f, 1165.97f, 1166.04f, 1166.09f, 1166.12f, 1166.15f, 
1166.15f, 
  47.08f,   47.56f,   48.92f,   51.12f,   54.04f,   57.57f,   61.59f,   66.02f, 
  70.76f,   75.76f,   80.96f,   86.32f,   91.81f,   97.40f,  103.06f,  108.78f, 
 114.56f,  120.36f,  126.19f,  132.04f,  137.90f,  143.75f,  149.29f,  154.82f, 
 160.35f,  165.86f,  171.36f,  176.85f,  182.32f,  187.78f,  193.21f,  198.63f, 
 204.03f,  209.40f,  214.75f,  220.08f,  225.38f,  230.65f,  235.89f,  241.11f, 
 245.72f,  250.29f,  254.86f,  259.41f,  263.96f,  268.49f,  273.02f,  277.53f, 
 282.03f,  286.51f,  290.97f,  295.43f,  299.87f,  304.30f,  308.72f,  313.14f, 
 317.54f,  321.94f,  326.33f,  330.70f,  335.06f,  339.42f,  343.75f,  348.08f, 
 352.39f,  356.69f,  360.98f,  365.25f,  369.50f,  373.74f,  377.97f,  382.18f, 
 386.38f,  390.55f,  394.72f,  398.87f,  403.00f,  407.11f,  411.21f,  415.29f, 
 419.36f,  423.41f,  427.44f,  431.46f,  435.46f,  439.44f,  443.41f,  447.35f, 
 451.29f,  455.20f,  459.10f,  462.98f,  466.84f,  470.68f,  474.51f,  478.32f, 
 482.11f,  485.89f,  489.64f,  493.38f,  497.11f,  500.81f,  504.50f,  508.17f, 
 511.82f,  515.46f,  519.07f,  522.67f,  526.26f,  529.82f,  533.37f,  536.90f, 
 540.41f,  543.90f,  547.38f,  550.84f,  554.28f,  557.71f,  561.11f,  564.50f, 
 567.87f,  571.23f,  574.57f,  577.88f,  581.18f,  584.47f,  587.73f,  590.98f, 
 594.21f,  597.42f,  600.62f,  603.80f,  606.96f,  610.10f,  613.22f,  616.33f, 
 619.42f,  622.49f,  625.54f,  628.58f,  631.59f,  634.59f,  637.57f,  640.54f, 
 643.48f,  646.41f,  649.32f,  652.21f,  655.09f,  657.94f,  660.78f,  663.60f, 
 666.40f,  669.18f,  671.94f,  674.69f,  677.41f,  680.12f,  682.81f,  685.48f, 
 688.13f,  690.77f,  693.38f,  695.98f,  698.55f,  701.11f,  703.65f,  706.17f, 
 708.67f,  711.15f,  713.61f,  716.06f,  718.48f,  720.87f,  723.23f,  725.59f, 
 727.93f,  730.27f,  732.60f,  734.92f,  737.24f,  739.55f,  741.86f,  744.16f, 
 746.46f,  748.75f,  751.04f,  753.32f,  755.59f,  757.86f,  760.12f,  762.37f, 
 764.61f,  766.85f,  769.08f,  771.30f,  773.51f,  775.73f,  777.95f,  780.17f, 
 782.39f,  784.61f,  786.83f,  789.05f,  791.27f,  793.49f,  795.71f,  797.93f, 
 800.15f,  802.37f,  804.59f,  806.81f,  809.03f,  811.25f,  813.47f,  815.68f, 
 817.90f,  820.12f,  822.34f,  824.56f,  826.78f,  829.00f,  831.22f,  833.44f, 
 835.66f,  837.88f,  840.10f,  842.32f,  844.54f,  846.76f,  848.98f, 1077.12f, 
1078.08f, 1079.03f, 1079.99f, 1080.95f, 1081.90f, 1082.86f, 1083.82f, 1084.77f, 
1085.73f, 1086.68f, 1087.64f, 1088.59f, 1089.55f, 1090.50f, 1091.45f, 1092.41f, 
1093.36f, 1094.31f, 1095.26f, 1096.21f, 1097.16f, 1098.11f, 1099.06f, 1100.00f, 
1100.95f, 1101.89f, 1102.84f, 1103.78f, 1104.72f, 1105.66f, 1106.60f, 1107.54f, 
1108.47f, 1109.41f, 1110.34f, 1111.27f, 1112.20f, 1113.12f, 1114.05f, 1114.97f, 
1115.89f, 1116.81f, 1117.72f, 1118.64f, 1119.54f, 1120.45f, 1121.35f, 1122.25f, 
1123.15f, 1124.04f, 1124.93f, 1125.81f, 1126.69f, 1127.57f, 1128.44f, 1129.31f, 
1128.71f, 1130.34f, 1131.87f, 1132.72f, 1133.55f, 1134.38f, 1135.21f, 1136.03f, 
1136.84f, 1137.64f, 1138.44f, 1139.23f, 1140.01f, 1140.78f, 1141.54f, 1142.29f, 
1143.04f, 1143.77f, 1144.50f, 1145.21f, 1145.92f, 1146.61f, 1147.30f, 1147.97f, 
1148.64f, 1149.29f, 1149.93f, 1150.56f, 1151.17f, 1151.78f, 1152.37f, 1152.95f, 
1153.52f, 1154.08f, 1154.62f, 1155.15f, 1155.67f, 1156.17f, 1156.66f, 1157.14f, 
1157.60f, 1158.06f, 1158.49f, 1158.92f, 1159.33f, 1159.72f, 1160.11f, 1160.48f, 
1160.83f, 1161.17f, 1161.50f, 1161.81f, 1162.11f, 1162.39f, 1162.66f, 1162.92f, 
1163.16f, 1163.38f, 1163.59f, 1163.79f, 1163.97f, 1164.14f, 1164.30f, 1164.44f, 
1164.56f, 1164.67f, 1164.77f, 1164.85f, 1164.91f, 1164.96f, 1165.00f, 1165.02f, 
1165.03f, 
  48.20f,   48.66f,   49.99f,   52.13f,   54.98f,   58.42f,   62.37f,   66.72f, 
  71.39f,   76.32f,   81.45f,   86.75f,   92.18f,   97.71f,  103.33f,  109.01f, 
 114.73f,  120.50f,  126.29f,  132.10f,  137.85f,  143.40f,  148.93f,  154.46f, 
 159.98f,  165.48f,  170.98f,  176.46f,  181.92f,  187.37f,  192.80f,  198.21f, 
 203.59f,  208.96f,  214.30f,  219.61f,  224.90f,  230.16f,  235.39f,  240.44f, 
 245.02f,  249.59f,  254.16f,  258.71f,  263.25f,  267.79f,  272.31f,  276.82f, 
 281.31f,  285.79f,  290.25f,  294.70f,  299.14f,  303.57f,  307.99f,  312.40f, 
 316.81f,  321.20f,  325.58f,  329.96f,  334.32f,  338.67f,  343.00f,  347.33f, 
 351.64f,  355.93f,  360.21f,  364.48f,  368.73f,  372.97f,  377.19f,  381.40f, 
 385.59f,  389.77f,  393.93f,  398.08f,  402.20f,  406.32f,  410.41f,  414.49f, 
 418.56f,  422.60f,  426.63f,  430.65f,  434.64f,  438.62f,  442.58f,  446.53f, 
 450.46f,  454.37f,  458.26f,  462.14f,  466.00f,  469.84f,  473.66f,  477.47f, 
 481.26f,  485.03f,  488.78f,  492.52f,  496.24f,  499.94f,  503.63f,  507.30f, 
 510.95f,  514.58f,  518.19f,  521.79f,  525.37f,  528.93f,  532.48f,  536.00f, 
 539.51f,  543.01f,  546.48f,  549.94f,  553.38f,  556.80f,  560.20f,  563.59f, 
 566.96f,  570.31f,  573.65f,  576.96f,  580.26f,  583.54f,  586.80f,  590.05f, 
 593.28f,  596.49f,  599.68f,  602.86f,  606.01f,  609.15f,  612.28f,  615.38f, 
 618.47f,  621.54f,  624.59f,  627.62f,  630.63f,  633.63f,  636.61f,  639.57f, 
 642.52f,  645.44f,  648.35f,  651.24f,  654.11f,  656.96f,  659.80f,  662.61f, 
 665.41f,  668.19f,  670.95f,  673.70f,  676.42f,  679.13f,  681.82f,  684.49f, 
 687.14f,  689.77f,  692.38f,  694.97f,  697.55f,  700.10f,  702.64f,  705.16f, 
 707.65f,  710.13f,  712.60f,  715.04f,  717.46f,  719.84f,  722.21f,  724.56f, 
 726.91f,  729.24f,  731.57f,  733.90f,  736.21f,  738.53f,  740.83f,  743.13f, 
 745.43f,  747.72f,  750.01f,  752.29f,  754.56f,  756.83f,  759.09f,  761.34f, 
 763.58f,  765.82f,  768.04f,  770.26f,  772.48f,  774.70f,  776.92f,  779.14f, 
 781.36f,  783.58f,  785.80f,  788.02f,  790.24f,  792.46f,  794.67f,  796.89f, 
 799.11f,  801.33f,  803.55f,  805.77f,  807.99f,  810.21f,  812.43f,  814.65f, 
 816.87f,  819.09f,  821.31f,  823.53f,  825.75f,  827.97f,  830.19f,  832.41f, 
 834.62f,  836.84f,  839.06f,  841.28f,  843.50f,  845.72f,  847.94f, 1076.01f, 
1076.97f, 1077.93f, 1078.89f, 1079.84f, 1080.80f, 1081.76f, 1082.71f, 1083.67f, 
1084.62f, 1085.58f, 1086.53f, 1087.49f, 1088.44f, 1089.40f, 1090.35f, 1091.30f, 
1092.25f, 1093.21f, 1094.16f, 1095.11f, 1096.06f, 1097.00f, 1097.95f, 1098.90f, 
1099.84f, 1100.79f, 1101.73f, 1102.68f, 1103.62f, 1104.56f, 1105.50f, 1106.43f, 
1107.37f, 1108.30f, 1109.23f, 1110.16f, 1111.09f, 1112.02f, 1112.94f, 1113.87f, 
1114.79f, 1115.70f, 1116.62f, 1117.53f, 1118.44f, 1119.35f, 1120.25f, 1121.15f, 
1122.04f, 1122.94f, 1123.82f, 1124.71f, 1125.59f, 1126.46f, 1127.33f, 1128.20f, 
1127.64f, 1129.26f, 1130.76f, 1131.61f, 1132.45f, 1133.28f, 1134.10f, 1134.92f, 
1135.73f, 1136.53f, 1137.33f, 1138.12f, 1138.90f, 1139.67f, 1140.43f, 1141.18f, 
1141.93f, 1142.66f, 1143.39f, 1144.10f, 1144.81f, 1145.50f, 1146.19f, 1146.86f, 
1147.52f, 1148.18f, 1148.82f, 1149.44f, 1150.06f, 1150.67f, 1151.26f, 1151.84f, 
1152.41f, 1152.96f, 1153.50f, 1154.03f, 1154.55f, 1155.06f, 1155.55f, 1156.02f, 
1156.49f, 1156.94f, 1157.38f, 1157.80f, 1158.21f, 1158.61f, 1158.99f, 1159.36f, 
1159.71f, 1160.05f, 1160.38f, 1160.69f, 1160.99f, 1161.27f, 1161.54f, 1161.80f, 
1162.04f, 1162.26f, 1162.48f, 1162.67f, 1162.86f, 1163.02f, 1163.18f, 1163.32f, 
1163.44f, 1163.55f, 1163.65f, 1163.73f, 1163.79f, 1163.85f, 1163.88f, 1163.90f, 
1163.91f, 
  49.32f,   49.76f,   51.05f,   53.13f,   55.91f,   59.29f,   63.16f,   67.43f, 
  72.03f,   76.88f,   81.95f,   87.19f,   92.56f,   98.04f,  103.61f,  109.24f, 
 114.92f,  120.65f,  126.40f,  131.97f,  137.52f,  143.06f,  148.59f,  154.11f, 
 159.62f,  165.12f,  170.61f,  176.08f,  181.54f,  186.97f,  192.39f,  197.79f, 
 203.17f,  208.52f,  213.85f,  219.15f,  224.43f,  229.68f,  234.90f,  239.76f, 
 244.34f,  248.91f,  253.47f,  258.02f,  262.56f,  267.09f,  271.61f,  276.11f, 
 280.60f,  285.08f,  289.53f,  293.98f,  298.42f,  302.85f,  307.27f,  311.68f, 
 316.08f,  320.47f,  324.85f,  329.22f,  333.58f,  337.93f,  342.26f,  346.58f, 
 350.89f,  355.18f,  359.46f,  363.72f,  367.97f,  372.21f,  376.43f,  380.63f, 
 384.82f,  388.99f,  393.15f,  397.29f,  401.42f,  405.53f,  409.62f,  413.70f, 
 417.76f,  421.80f,  425.83f,  429.84f,  433.83f,  437.81f,  441.77f,  445.71f, 
 449.63f,  453.54f,  457.43f,  461.31f,  465.16f,  469.00f,  472.82f,  476.63f, 
 480.41f,  484.18f,  487.93f,  491.67f,  495.38f,  499.08f,  502.77f,  506.43f, 
 510.08f,  513.71f,  517.32f,  520.91f,  524.49f,  528.05f,  531.59f,  535.12f, 
 538.62f,  542.11f,  545.59f,  549.04f,  552.48f,  555.90f,  559.30f,  562.68f, 
 566.05f,  569.40f,  572.73f,  576.05f,  579.34f,  582.62f,  585.88f,  589.13f, 
 592.35f,  595.56f,  598.75f,  601.92f,  605.08f,  608.22f,  611.33f,  614.44f, 
 617.52f,  620.59f,  623.64f,  626.67f,  629.68f,  632.68f,  635.65f,  638.61f, 
 641.55f,  644.48f,  647.38f,  650.27f,  653.14f,  655.99f,  658.82f,  661.64f, 
 664.44f,  667.21f,  669.97f,  672.71f,  675.44f,  678.14f,  680.83f,  683.49f, 
 686.14f,  688.77f,  691.38f,  693.98f,  696.55f,  699.10f,  701.64f,  704.15f, 
 706.65f,  709.13f,  711.59f,  714.03f,  716.44f,  718.83f,  721.19f,  723.54f, 
 725.89f,  728.22f,  730.55f,  732.88f,  735.19f,  737.50f,  739.81f,  742.11f, 
 744.41f,  746.70f,  748.98f,  751.27f,  753.54f,  755.80f,  758.06f,  760.31f, 
 762.55f,  764.79f,  767.01f,  769.23f,  771.45f,  773.67f,  775.89f,  778.11f, 
 780.33f,  782.55f,  784.77f,  786.99f,  789.21f,  791.43f,  793.64f,  795.86f, 
 798.08f,  800.30f,  802.52f,  804.74f,  806.96f,  809.18f,  811.40f,  813.62f, 
 815.84f,  818.06f,  820.28f,  822.50f,  824.72f,  826.94f,  829.16f,  831.38f, 
 833.60f,  835.81f,  838.03f,  840.25f,  842.47f,  844.69f,  846.91f, 1074.92f, 
1075.87f, 1076.83f, 1077.79f, 1078.74f, 1079.70f, 1080.66f, 1081.61f, 1082.57f, 
1083.53f, 1084.48f, 1085.44f, 1086.39f, 1087.34f, 1088.30f, 1089.25f, 1090.20f, 
1091.16f, 1092.11f, 1093.06f, 1094.01f, 1094.96f, 1095.91f, 1096.85f, 1097.80f, 
1098.75f, 1099.69f, 1100.63f, 1101.58f, 1102.52f, 1103.46f, 1104.40f, 1105.33f, 
1106.27f, 1107.20f, 1108.13f, 1109.06f, 1109.99f, 1110.92f, 1111.84f, 1112.77f, 
1113.69f, 1114.60f, 1115.52f, 1116.43f, 1117.34f, 1118.24f, 1119.15f, 1120.05f, 
1120.94f, 1121.83f, 1122.72f, 1123.61f, 1124.49f, 1125.36f, 1126.23f, 1127.10f, 
1126.57f, 1128.19f, 1129.66f, 1130.51f, 1131.34f, 1132.17f, 1133.00f, 1133.82f, 
1134.63f, 1135.43f, 1136.23f, 1137.01f, 1137.79f, 1138.56f, 1139.33f, 1140.08f, 
1140.82f, 1141.56f, 1142.28f, 1143.00f, 1143.70f, 1144.40f, 1145.08f, 1145.75f, 
1146.42f, 1147.07f, 1147.71f, 1148.34f, 1148.95f, 1149.56f, 1150.15f, 1150.73f, 
1151.30f, 1151.85f, 1152.40f, 1152.93f, 1153.44f, 1153.95f, 1154.44f, 1154.91f, 
1155.38f, 1155.83f, 1156.27f, 1156.69f, 1157.10f, 1157.50f, 1157.88f, 1158.25f, 
1158.60f, 1158.94f, 1159.27f, 1159.58f, 1159.88f, 1160.16f, 1160.43f, 1160.68f, 
1160.93f, 1161.15f, 1161.36f, 1161.56f, 1161.74f, 1161.91f, 1162.06f, 1162.20f, 
1162.33f, 1162.44f, 1162.53f, 1162.61f, 1162.68f, 1162.73f, 1162.77f, 1162.79f, 
1162.80f, 
  50.43f,   50.86f,   52.12f,   54.14f,   56.85f,   60.16f,   63.95f,   68.14f, 
  72.67f,   77.46f,   82.47f,   87.64f,   92.96f,   98.38f,  103.90f,  109.46f, 
 115.01f,  120.57f,  126.12f,  131.66f,  137.20f,  142.74f,  148.26f,  153.78f, 
 159.28f,  164.78f,  170.26f,  175.72f,  181.16f,  186.59f,  192.00f,  197.39f, 
 202.75f,  208.09f,  213.41f,  218.70f,  223.97f,  229.21f,  234.42f,  239.08f, 
 243.66f,  248.22f,  252.78f,  257.33f,  261.87f,  266.40f,  270.91f,  275.42f, 
 279.90f,  284.37f,  288.83f,  293.27f,  297.71f,  302.13f,  306.55f,  310.96f, 
 315.36f,  319.75f,  324.13f,  328.50f,  332.85f,  337.19f,  341.52f,  345.84f, 
 350.14f,  354.43f,  358.71f,  362.97f,  367.22f,  371.45f,  375.67f,  379.87f, 
 384.05f,  388.23f,  392.38f,  396.52f,  400.64f,  404.75f,  408.84f,  412.91f, 
 416.97f,  421.01f,  425.03f,  429.04f,  433.03f,  437.00f,  440.96f,  444.90f, 
 448.82f,  452.72f,  456.61f,  460.48f,  464.33f,  468.17f,  471.99f,  475.79f, 
 479.57f,  483.34f,  487.09f,  490.82f,  494.53f,  498.23f,  501.91f,  505.57f, 
 509.22f,  512.84f,  516.45f,  520.04f,  523.62f,  527.18f,  530.71f,  534.24f, 
 537.74f,  541.23f,  544.70f,  548.15f,  551.58f,  555.00f,  558.40f,  561.78f, 
 565.15f,  568.49f,  571.82f,  575.14f,  578.43f,  581.71f,  584.96f,  588.21f, 
 591.43f,  594.63f,  597.82f,  600.99f,  604.15f,  607.28f,  610.40f,  613.50f, 
 616.58f,  619.65f,  622.69f,  625.72f,  628.73f,  631.73f,  634.70f,  637.66f, 
 640.60f,  643.52f,  646.42f,  649.31f,  652.18f,  655.03f,  657.86f,  660.67f, 
 663.46f,  666.24f,  669.00f,  671.74f,  674.46f,  677.16f,  679.84f,  682.51f, 
 685.16f,  687.78f,  690.39f,  692.98f,  695.55f,  698.11f,  700.64f,  703.15f, 
 705.65f,  708.12f,  710.58f,  713.02f,  715.43f,  717.81f,  720.18f,  722.53f, 
 724.87f,  727.21f,  729.54f,  731.86f,  734.18f,  736.49f,  738.79f,  741.09f, 
 743.39f,  745.68f,  747.97f,  750.25f,  752.52f,  754.78f,  757.04f,  759.29f, 
 761.53f,  763.76f,  765.99f,  768.21f,  770.43f,  772.65f,  774.86f,  777.08f, 
 779.30f,  781.52f,  783.74f,  785.96f,  788.18f,  790.40f,  792.62f,  794.84f, 
 797.06f,  799.28f,  801.50f,  803.72f,  805.94f,  808.16f,  810.38f,  812.60f, 
 814.81f,  817.03f,  819.25f,  821.47f,  823.69f,  825.91f,  828.13f,  830.35f, 
 832.57f,  834.79f,  837.01f,  839.23f,  841.45f,  843.67f,  845.89f, 1073.82f, 
1074.78f, 1075.74f, 1076.69f, 1077.65f, 1078.61f, 1079.56f, 1080.52f, 1081.48f, 
1082.43f, 1083.39f, 1084.34f, 1085.30f, 1086.25f, 1087.20f, 1088.16f, 1089.11f, 
1090.06f, 1091.01f, 1091.96f, 1092.91f, 1093.86f, 1094.81f, 1095.76f, 1096.70f, 
1097.65f, 1098.60f, 1099.54f, 1100.48f, 1101.42f, 1102.36f, 1103.30f, 1104.24f, 
1105.17f, 1106.11f, 1107.04f, 1107.97f, 1108.90f, 1109.82f, 1110.75f, 1111.67f, 
1112.59f, 1113.51f, 1114.42f, 1115.33f, 1116.24f, 1117.15f, 1118.05f, 1118.95f, 
1119.85f, 1120.74f, 1121.63f, 1122.51f, 1123.39f, 1124.26f, 1125.13f, 1126.00f, 
1125.51f, 1127.12f, 1128.56f, 1129.41f, 1130.25f, 1131.08f, 1131.90f, 1132.72f, 
1133.53f, 1134.33f, 1135.13f, 1135.91f, 1136.69f, 1137.46f, 1138.23f, 1138.98f, 
1139.72f, 1140.46f, 1141.18f, 1141.90f, 1142.60f, 1143.30f, 1143.98f, 1144.65f, 
1145.31f, 1145.97f, 1146.60f, 1147.23f, 1147.85f, 1148.45f, 1149.05f, 1149.63f, 
1150.19f, 1150.75f, 1151.29f, 1151.82f, 1152.34f, 1152.84f, 1153.33f, 1153.81f, 
1154.27f, 1154.72f, 1155.16f, 1155.58f, 1155.99f, 1156.39f, 1156.77f, 1157.14f, 
1157.49f, 1157.83f, 1158.16f, 1158.47f, 1158.77f, 1159.05f, 1159.32f, 1159.58f, 
1159.82f, 1160.04f, 1160.25f, 1160.45f, 1160.63f, 1160.80f, 1160.96f, 1161.09f, 
1161.22f, 1161.33f, 1161.42f, 1161.50f, 1161.57f, 1161.62f, 1161.66f, 1161.68f, 
1161.69f, 
  51.49f,   51.91f,   53.14f,   55.11f,   57.75f,   60.98f,   64.69f,   68.81f, 
  73.26f,   77.97f,   82.90f,   88.00f,   93.25f,   98.60f,  104.03f,  109.51f, 
 115.03f,  120.55f,  126.08f,  131.61f,  137.13f,  142.64f,  148.15f,  153.65f, 
 159.14f,  164.61f,  170.07f,  175.52f,  180.95f,  186.36f,  191.75f,  197.12f, 
 202.47f,  207.80f,  213.10f,  218.37f,  223.62f,  228.85f,  233.90f,  238.48f, 
 243.05f,  247.62f,  252.17f,  256.72f,  261.26f,  265.78f,  270.29f,  274.79f, 
 279.27f,  283.74f,  288.19f,  292.63f,  297.07f,  301.49f,  305.90f,  310.31f, 
 314.71f,  319.10f,  323.47f,  327.84f,  332.19f,  336.53f,  340.86f,  345.17f, 
 349.47f,  353.76f,  358.03f,  362.29f,  366.53f,  370.76f,  374.97f,  379.17f, 
 383.35f,  387.52f,  391.67f,  395.81f,  399.92f,  404.03f,  408.11f,  412.18f, 
 416.24f,  420.27f,  424.29f,  428.30f,  432.28f,  436.25f,  440.21f,  444.14f, 
 448.06f,  451.96f,  455.85f,  459.71f,  463.56f,  467.40f,  471.21f,  475.01f, 
 478.79f,  482.55f,  486.30f,  490.03f,  493.74f,  497.43f,  501.11f,  504.77f, 
 508.41f,  512.03f,  515.64f,  519.23f,  522.80f,  526.36f,  529.89f,  533.41f, 
 536.91f,  540.40f,  543.86f,  547.31f,  550.75f,  554.16f,  557.56f,  560.94f, 
 564.30f,  567.64f,  570.97f,  574.28f,  577.57f,  580.84f,  584.10f,  587.34f, 
 590.56f,  593.76f,  596.95f,  600.12f,  603.27f,  606.40f,  609.52f,  612.61f, 
 615.69f,  618.76f,  621.80f,  624.83f,  627.84f,  630.83f,  633.80f,  636.76f, 
 639.69f,  642.61f,  645.51f,  648.40f,  651.26f,  654.11f,  656.94f,  659.75f, 
 662.54f,  665.32f,  668.07f,  670.81f,  673.53f,  676.23f,  678.91f,  681.57f, 
 684.22f,  686.84f,  689.45f,  692.04f,  694.61f,  697.16f,  699.69f,  702.20f, 
 704.69f,  707.17f,  709.63f,  712.06f,  714.47f,  716.85f,  719.21f,  721.56f, 
 723.91f,  726.24f,  728.57f,  730.89f,  733.21f,  735.52f,  737.82f,  740.12f, 
 742.42f,  744.71f,  746.99f,  749.27f,  751.54f,  753.81f,  756.06f,  758.31f, 
 760.55f,  762.79f,  765.01f,  767.23f,  769.45f,  771.67f,  773.89f,  776.11f, 
 778.33f,  780.55f,  782.77f,  784.98f,  787.20f,  789.42f,  791.64f,  793.86f, 
 796.08f,  798.30f,  800.52f,  802.74f,  804.96f,  807.18f,  809.40f,  811.62f, 
 813.84f,  816.06f,  818.28f,  820.50f,  822.72f,  824.93f,  827.15f,  829.37f, 
 831.59f,  833.81f,  836.03f,  838.25f,  840.47f,  842.69f,  844.91f, 1072.77f, 
1073.73f, 1074.69f, 1075.64f, 1076.60f, 1077.56f, 1078.51f, 1079.47f, 1080.42f, 
1081.38f, 1082.34f, 1083.29f, 1084.24f, 1085.20f, 1086.15f, 1087.11f, 1088.06f, 
1089.01f, 1089.96f, 1090.91f, 1091.86f, 1092.81f, 1093.76f, 1094.71f, 1095.65f, 
1096.60f, 1097.54f, 1098.49f, 1099.43f, 1100.37f, 1101.31f, 1102.25f, 1103.19f, 
1104.12f, 1105.06f, 1105.99f, 1106.92f, 1107.85f, 1108.77f, 1109.70f, 1110.62f, 
1111.54f, 1112.46f, 1113.37f, 1114.28f, 1115.19f, 1116.10f, 1117.00f, 1117.90f, 
1118.79f, 1119.69f, 1120.57f, 1121.46f, 1122.34f, 1123.21f, 1124.08f, 1122.81f, 
1124.49f, 1126.10f, 1127.51f, 1128.35f, 1129.19f, 1130.02f, 1130.85f, 1131.66f, 
1132.47f, 1133.28f, 1134.07f, 1134.86f, 1135.64f, 1136.41f, 1137.17f, 1137.92f, 
1138.67f, 1139.40f, 1140.12f, 1140.84f, 1141.54f, 1142.24f, 1142.92f, 1143.59f, 
1144.26f, 1144.91f, 1145.55f, 1146.17f, 1146.79f, 1147.39f, 1147.98f, 1148.56f, 
1149.13f, 1149.69f, 1150.23f, 1150.76f, 1151.27f, 1151.78f, 1152.27f, 1152.75f, 
1153.21f, 1153.66f, 1154.10f, 1154.52f, 1154.93f, 1155.32f, 1155.71f, 1156.07f, 
1156.43f, 1156.77f, 1157.09f, 1157.41f, 1157.70f, 1157.99f, 1158.26f, 1158.51f, 
1158.75f, 1158.98f, 1159.19f, 1159.39f, 1159.57f, 1159.74f, 1159.89f, 1160.03f, 
1160.15f, 1160.26f, 1160.36f, 1160.44f, 1160.50f, 1160.56f, 1160.59f, 1160.61f, 
1160.62f, 
  52.56f,   52.96f,   54.15f,   56.07f,   58.65f,   61.81f,   65.45f,   69.49f, 
  73.86f,   78.50f,   83.35f,   88.39f,   93.56f,   98.84f,  104.21f,  109.64f, 
 115.10f,  120.59f,  126.08f,  131.58f,  137.08f,  142.57f,  148.06f,  153.54f, 
 159.01f,  164.46f,  169.91f,  175.33f,  180.74f,  186.14f,  191.51f,  196.87f, 
 202.20f,  207.51f,  212.79f,  218.05f,  223.29f,  228.49f,  233.31f,  237.89f, 
 242.46f,  247.02f,  251.57f,  256.12f,  260.65f,  265.17f,  269.68f,  274.17f, 
 278.65f,  283.11f,  287.56f,  292.00f,  296.43f,  300.85f,  305.27f,  309.67f, 
 314.07f,  318.45f,  322.82f,  327.19f,  331.53f,  335.87f,  340.20f,  344.51f, 
 348.80f,  353.09f,  357.36f,  361.61f,  365.85f,  370.08f,  374.29f,  378.48f, 
 382.66f,  386.82f,  390.97f,  395.10f,  399.22f,  403.31f,  407.40f,  411.46f, 
 415.51f,  419.55f,  423.57f,  427.57f,  431.55f,  435.51f,  439.46f,  443.40f, 
 447.31f,  451.21f,  455.09f,  458.96f,  462.80f,  466.63f,  470.44f,  474.24f, 
 478.02f,  481.78f,  485.52f,  489.24f,  492.95f,  496.64f,  500.32f,  503.97f, 
 507.61f,  511.23f,  514.84f,  518.42f,  521.99f,  525.54f,  529.08f,  532.59f, 
 536.09f,  539.57f,  543.04f,  546.48f,  549.91f,  553.32f,  556.72f,  560.10f, 
 563.45f,  566.80f,  570.12f,  573.43f,  576.72f,  579.99f,  583.24f,  586.48f, 
 589.70f,  592.90f,  596.08f,  599.25f,  602.39f,  605.53f,  608.64f,  611.73f, 
 614.81f,  617.87f,  620.91f,  623.94f,  626.94f,  629.93f,  632.90f,  635.86f, 
 638.79f,  641.71f,  644.61f,  647.49f,  650.35f,  653.20f,  656.02f,  658.83f, 
 661.62f,  664.40f,  667.15f,  669.89f,  672.60f,  675.30f,  677.98f,  680.64f, 
 683.28f,  685.91f,  688.51f,  691.10f,  693.67f,  696.22f,  698.74f,  701.25f, 
 703.74f,  706.22f,  708.67f,  711.11f,  713.52f,  715.89f,  718.25f,  720.60f, 
 722.94f,  725.28f,  727.61f,  729.93f,  732.24f,  734.55f,  736.86f,  739.16f, 
 741.45f,  743.74f,  746.03f,  748.30f,  750.58f,  752.84f,  755.09f,  757.34f, 
 759.58f,  761.81f,  764.04f,  766.26f,  768.48f,  770.70f,  772.91f,  775.13f, 
 777.35f,  779.57f,  781.79f,  784.01f,  786.23f,  788.45f,  790.67f,  792.89f, 
 795.11f,  797.33f,  799.55f,  801.77f,  803.99f,  806.21f,  808.43f,  810.65f, 
 812.86f,  815.08f,  817.30f,  819.52f,  821.74f,  823.96f,  826.18f,  828.40f, 
 830.62f,  832.84f,  835.06f,  837.28f,  839.50f,  841.72f,  843.94f, 1071.72f, 
1072.68f, 1073.64f, 1074.60f, 1075.55f, 1076.51f, 1077.47f, 1078.42f, 1079.38f, 
1080.33f, 1081.29f, 1082.24f, 1083.20f, 1084.15f, 1085.11f, 1086.06f, 1087.01f, 
1087.96f, 1088.92f, 1089.87f, 1090.82f, 1091.76f, 1092.71f, 1093.66f, 1094.61f, 
1095.55f, 1096.50f, 1097.44f, 1098.38f, 1099.32f, 1100.26f, 1101.20f, 1102.14f, 
1103.07f, 1104.01f, 1104.94f, 1105.87f, 1106.80f, 1107.73f, 1108.65f, 1109.57f, 
1110.49f, 1111.41f, 1112.32f, 1113.23f, 1114.14f, 1115.05f, 1115.95f, 1116.85f, 
1117.74f, 1118.64f, 1119.52f, 1120.41f, 1121.29f, 1122.16f, 1123.03f, 1121.80f, 
1123.48f, 1125.08f, 1126.46f, 1127.30f, 1128.14f, 1128.97f, 1129.79f, 1130.61f, 
1131.42f, 1132.22f, 1133.02f, 1133.81f, 1134.58f, 1135.35f, 1136.12f, 1136.87f, 
1137.61f, 1138.35f, 1139.07f, 1139.78f, 1140.49f, 1141.18f, 1141.87f, 1142.54f, 
1143.20f, 1143.85f, 1144.49f, 1145.12f, 1145.73f, 1146.34f, 1146.93f, 1147.51f, 
1148.07f, 1148.63f, 1149.17f, 1149.70f, 1150.22f, 1150.72f, 1151.21f, 1151.69f, 
1152.15f, 1152.60f, 1153.04f, 1153.46f, 1153.87f, 1154.26f, 1154.65f, 1155.01f, 
1155.37f, 1155.71f, 1156.03f, 1156.35f, 1156.64f, 1156.93f, 1157.19f, 1157.45f, 
1157.69f, 1157.91f, 1158.13f, 1158.32f, 1158.51f, 1158.67f, 1158.83f, 1158.97f, 
1159.09f, 1159.20f, 1159.29f, 1159.38f, 1159.44f, 1159.49f, 1159.53f, 1159.55f, 
1159.56f, 
  53.62f,   54.01f,   55.17f,   57.04f,   59.56f,   62.64f,   66.21f,   70.17f, 
  74.47f,   79.04f,   83.82f,   88.79f,   93.90f,   99.12f,  104.42f,  109.80f, 
 115.21f,  120.66f,  126.12f,  131.58f,  137.05f,  142.52f,  147.99f,  153.44f, 
 158.89f,  164.33f,  169.75f,  175.16f,  180.55f,  185.93f,  191.28f,  196.62f, 
 201.93f,  207.23f,  212.50f,  217.74f,  222.96f,  228.14f,  232.73f,  237.30f, 
 241.87f,  246.43f,  250.98f,  255.52f,  260.05f,  264.57f,  269.08f,  273.56f, 
 278.04f,  282.49f,  286.94f,  291.38f,  295.81f,  300.23f,  304.64f,  309.04f, 
 313.43f,  317.81f,  322.18f,  326.54f,  330.89f,  335.22f,  339.54f,  343.85f, 
 348.14f,  352.42f,  356.69f,  360.94f,  365.18f,  369.40f,  373.60f,  377.80f, 
 381.97f,  386.13f,  390.27f,  394.40f,  398.51f,  402.61f,  406.69f,  410.75f, 
 414.80f,  418.83f,  422.84f,  426.84f,  430.82f,  434.78f,  438.73f,  442.66f, 
 446.57f,  450.46f,  454.34f,  458.20f,  462.05f,  465.87f,  469.68f,  473.47f, 
 477.25f,  481.00f,  484.74f,  488.46f,  492.17f,  495.86f,  499.53f,  503.18f, 
 506.82f,  510.43f,  514.04f,  517.62f,  521.18f,  524.73f,  528.26f,  531.78f, 
 535.27f,  538.75f,  542.21f,  545.66f,  549.08f,  552.49f,  555.89f,  559.26f, 
 562.62f,  565.95f,  569.28f,  572.58f,  575.87f,  579.14f,  582.39f,  585.62f, 
 588.84f,  592.04f,  595.22f,  598.38f,  601.53f,  604.65f,  607.77f,  610.86f, 
 613.93f,  616.99f,  620.03f,  623.05f,  626.06f,  629.04f,  632.01f,  634.96f, 
 637.90f,  640.81f,  643.71f,  646.59f,  649.45f,  652.29f,  655.12f,  657.92f, 
 660.71f,  663.48f,  666.23f,  668.97f,  671.68f,  674.38f,  677.06f,  679.71f, 
 682.36f,  684.98f,  687.58f,  690.17f,  692.73f,  695.28f,  697.80f,  700.31f, 
 702.80f,  705.27f,  707.73f,  710.16f,  712.56f,  714.94f,  717.30f,  719.65f, 
 721.99f,  724.32f,  726.65f,  728.97f,  731.28f,  733.59f,  735.89f,  738.19f, 
 740.49f,  742.78f,  745.06f,  747.34f,  749.61f,  751.87f,  754.13f,  756.38f, 
 758.62f,  760.85f,  763.07f,  765.29f,  767.51f,  769.73f,  771.95f,  774.17f, 
 776.39f,  778.60f,  780.82f,  783.04f,  785.26f,  787.48f,  789.70f,  791.92f, 
 794.14f,  796.36f,  798.58f,  800.80f,  803.02f,  805.24f,  807.46f,  809.68f, 
 811.90f,  814.12f,  816.34f,  818.55f,  820.77f,  822.99f,  825.21f,  827.43f, 
 829.65f,  831.87f,  834.09f,  836.31f,  838.53f,  840.75f,  842.97f, 1070.68f, 
1071.64f, 1072.60f, 1073.55f, 1074.51f, 1075.47f, 1076.42f, 1077.38f, 1078.34f, 
1079.29f, 1080.25f, 1081.20f, 1082.16f, 1083.11f, 1084.06f, 1085.02f, 1085.97f, 
1086.92f, 1087.87f, 1088.82f, 1089.77f, 1090.72f, 1091.67f, 1092.62f, 1093.56f, 
1094.51f, 1095.45f, 1096.40f, 1097.34f, 1098.28f, 1099.22f, 1100.16f, 1101.10f, 
1102.03f, 1102.96f, 1103.90f, 1104.83f, 1105.76f, 1106.68f, 1107.61f, 1108.53f, 
1109.45f, 1110.36f, 1111.28f, 1112.19f, 1113.10f, 1114.00f, 1114.91f, 1115.80f, 
1116.70f, 1117.59f, 1118.48f, 1119.36f, 1120.24f, 1121.12f, 1121.99f, 1120.80f, 
1122.46f, 1124.07f, 1125.41f, 1126.26f, 1127.09f, 1127.92f, 1128.75f, 1129.56f, 
1130.37f, 1131.18f, 1131.97f, 1132.76f, 1133.54f, 1134.31f, 1135.07f, 1135.82f, 
1136.56f, 1137.30f, 1138.02f, 1138.73f, 1139.44f, 1140.13f, 1140.82f, 1141.49f, 
1142.15f, 1142.80f, 1143.44f, 1144.06f, 1144.68f, 1145.28f, 1145.88f, 1146.45f, 
1147.02f, 1147.58f, 1148.12f, 1148.65f, 1149.16f, 1149.67f, 1150.16f, 1150.63f, 
1151.10f, 1151.55f, 1151.98f, 1152.40f, 1152.81f, 1153.21f, 1153.59f, 1153.96f, 
1154.31f, 1154.65f, 1154.98f, 1155.29f, 1155.59f, 1155.87f, 1156.14f, 1156.39f, 
1156.63f, 1156.86f, 1157.07f, 1157.27f, 1157.45f, 1157.62f, 1157.77f, 1157.91f, 
1158.03f, 1158.14f, 1158.24f, 1158.32f, 1158.38f, 1158.43f, 1158.47f, 1158.49f, 
1158.50f, 
  54.67f,   55.06f,   56.19f,   58.01f,   60.47f,   63.48f,   66.98f,   70.87f, 
  75.09f,   79.59f,   84.31f,   89.21f,   94.25f,   99.41f,  104.66f,  109.98f, 
 115.35f,  120.75f,  126.17f,  131.61f,  137.05f,  142.49f,  147.93f,  153.36f, 
 158.79f,  164.20f,  169.61f,  175.00f,  180.37f,  185.73f,  191.06f,  196.38f, 
 201.68f,  206.95f,  212.21f,  217.43f,  222.63f,  227.57f,  232.15f,  236.73f, 
 241.29f,  245.85f,  250.40f,  254.94f,  259.46f,  263.98f,  268.48f,  272.96f, 
 277.43f,  281.88f,  286.33f,  290.76f,  295.19f,  299.61f,  304.01f,  308.41f, 
 312.80f,  317.18f,  321.55f,  325.90f,  330.25f,  334.58f,  338.90f,  343.20f, 
 347.49f,  351.77f,  356.03f,  360.28f,  364.51f,  368.73f,  372.93f,  377.12f, 
 381.29f,  385.45f,  389.59f,  393.71f,  397.82f,  401.91f,  405.99f,  410.05f, 
 414.09f,  418.12f,  422.12f,  426.12f,  430.09f,  434.05f,  438.00f,  441.92f, 
 445.83f,  449.72f,  453.60f,  457.45f,  461.29f,  465.12f,  468.92f,  472.71f, 
 476.48f,  480.24f,  483.97f,  487.69f,  491.39f,  495.08f,  498.74f,  502.39f, 
 506.03f,  509.64f,  513.24f,  516.82f,  520.38f,  523.93f,  527.46f,  530.97f, 
 534.46f,  537.94f,  541.40f,  544.84f,  548.26f,  551.67f,  555.06f,  558.43f, 
 561.78f,  565.12f,  568.44f,  571.74f,  575.02f,  578.29f,  581.54f,  584.77f, 
 587.98f,  591.18f,  594.36f,  597.52f,  600.66f,  603.79f,  606.90f,  609.99f, 
 613.06f,  616.12f,  619.15f,  622.17f,  625.18f,  628.16f,  631.13f,  634.08f, 
 637.01f,  639.92f,  642.81f,  645.69f,  648.55f,  651.39f,  654.21f,  657.02f, 
 659.80f,  662.57f,  665.32f,  668.05f,  670.76f,  673.46f,  676.13f,  678.79f, 
 681.43f,  684.05f,  686.65f,  689.24f,  691.80f,  694.34f,  696.87f,  699.37f, 
 701.86f,  704.33f,  706.78f,  709.21f,  711.61f,  713.98f,  716.34f,  718.69f, 
 721.03f,  723.37f,  725.69f,  728.01f,  730.33f,  732.63f,  734.94f,  737.24f, 
 739.53f,  741.82f,  744.10f,  746.38f,  748.65f,  750.91f,  753.17f,  755.41f, 
 757.65f,  759.88f,  762.10f,  764.32f,  766.54f,  768.76f,  770.98f,  773.20f, 
 775.42f,  777.64f,  779.86f,  782.08f,  784.30f,  786.52f,  788.74f,  790.96f, 
 793.18f,  795.40f,  797.62f,  799.84f,  802.05f,  804.27f,  806.49f,  808.71f, 
 810.93f,  813.15f,  815.37f,  817.59f,  819.81f,  822.03f,  824.25f,  826.47f, 
 828.69f,  830.91f,  833.13f,  835.35f,  837.57f,  839.79f,  842.00f, 1069.64f, 
1070.60f, 1071.56f, 1072.51f, 1073.47f, 1074.43f, 1075.38f, 1076.34f, 1077.30f, 
1078.25f, 1079.21f, 1080.16f, 1081.12f, 1082.07f, 1083.02f, 1083.98f, 1084.93f, 
1085.88f, 1086.83f, 1087.78f, 1088.73f, 1089.68f, 1090.63f, 1091.58f, 1092.53f, 
1093.47f, 1094.42f, 1095.36f, 1096.30f, 1097.24f, 1098.18f, 1099.12f, 1100.06f, 
1100.99f, 1101.93f, 1102.86f, 1103.79f, 1104.72f, 1105.64f, 1106.57f, 1107.49f, 
1108.41f, 1109.32f, 1110.24f, 1111.15f, 1112.06f, 1112.96f, 1113.87f, 1114.76f, 
1115.66f, 1116.55f, 1117.44f, 1118.32f, 1119.20f, 1120.08f, 1120.94f, 1119.79f, 
1121.46f, 1123.06f, 1124.37f, 1125.21f, 1126.05f, 1126.88f, 1127.70f, 1128.52f, 
1129.33f, 1130.13f, 1130.93f, 1131.71f, 1132.49f, 1133.26f, 1134.02f, 1134.77f, 
1135.52f, 1136.25f, 1136.97f, 1137.69f, 1138.39f, 1139.09f, 1139.77f, 1140.44f, 
1141.10f, 1141.75f, 1142.39f, 1143.02f, 1143.63f, 1144.24f, 1144.83f, 1145.41f, 
1145.97f, 1146.53f, 1147.07f, 1147.60f, 1148.11f, 1148.61f, 1149.10f, 1149.58f, 
1150.04f, 1150.49f, 1150.93f, 1151.35f, 1151.76f, 1152.16f, 1152.54f, 1152.90f, 
1153.26f, 1153.60f, 1153.92f, 1154.23f, 1154.53f, 1154.81f, 1155.08f, 1155.34f, 
1155.58f, 1155.80f, 1156.01f, 1156.21f, 1156.39f, 1156.56f, 1156.71f, 1156.85f, 
1156.98f, 1157.09f, 1157.18f, 1157.26f, 1157.33f, 1157.38f, 1157.42f, 1157.44f, 
1157.44f, 
  55.72f,   56.10f,   57.20f,   58.97f,   61.38f,   64.33f,   67.75f,   71.57f, 
  75.72f,   80.15f,   84.80f,   89.64f,   94.62f,   99.73f,  104.92f,  110.19f, 
 115.51f,  120.87f,  126.25f,  131.65f,  137.06f,  142.48f,  147.89f,  153.30f, 
 158.70f,  164.09f,  169.48f,  174.84f,  180.20f,  185.53f,  190.85f,  196.15f, 
 201.43f,  206.69f,  211.93f,  217.14f,  222.32f,  227.01f,  231.59f,  236.16f, 
 240.72f,  245.28f,  249.82f,  254.36f,  258.88f,  263.39f,  267.89f,  272.36f, 
 276.83f,  281.28f,  285.72f,  290.16f,  294.58f,  298.99f,  303.40f,  307.80f, 
 312.18f,  316.56f,  320.92f,  325.28f,  329.61f,  333.94f,  338.26f,  342.56f, 
 346.84f,  351.12f,  355.37f,  359.62f,  363.85f,  368.06f,  372.26f,  376.45f, 
 380.61f,  384.77f,  388.90f,  393.02f,  397.13f,  401.22f,  405.29f,  409.35f, 
 413.38f,  417.41f,  421.41f,  425.40f,  429.38f,  433.33f,  437.27f,  441.19f, 
 445.10f,  448.99f,  452.86f,  456.71f,  460.55f,  464.37f,  468.17f,  471.96f, 
 475.72f,  479.47f,  483.21f,  486.92f,  490.62f,  494.30f,  497.97f,  501.61f, 
 505.24f,  508.86f,  512.45f,  516.03f,  519.59f,  523.13f,  526.66f,  530.17f, 
 533.66f,  537.13f,  540.59f,  544.02f,  547.44f,  550.85f,  554.23f,  557.60f, 
 560.95f,  564.29f,  567.60f,  570.90f,  574.18f,  577.45f,  580.69f,  583.92f, 
 587.13f,  590.33f,  593.50f,  596.66f,  599.80f,  602.93f,  606.03f,  609.12f, 
 612.19f,  615.25f,  618.28f,  621.30f,  624.30f,  627.28f,  630.24f,  633.19f, 
 636.12f,  639.03f,  641.92f,  644.80f,  647.65f,  650.49f,  653.31f,  656.11f, 
 658.90f,  661.67f,  664.41f,  667.14f,  669.85f,  672.55f,  675.22f,  677.87f, 
 680.51f,  683.13f,  685.73f,  688.31f,  690.87f,  693.41f,  695.93f,  698.44f, 
 700.92f,  703.39f,  705.84f,  708.27f,  710.67f,  713.04f,  715.40f,  717.74f, 
 720.08f,  722.42f,  724.74f,  727.06f,  729.37f,  731.68f,  733.99f,  736.28f, 
 738.58f,  740.87f,  743.15f,  745.43f,  747.70f,  749.96f,  752.21f,  754.46f, 
 756.69f,  758.92f,  761.14f,  763.36f,  765.58f,  767.80f,  770.02f,  772.24f, 
 774.46f,  776.68f,  778.90f,  781.12f,  783.34f,  785.56f,  787.78f,  790.00f, 
 792.22f,  794.44f,  796.66f,  798.88f,  801.10f,  803.31f,  805.53f,  807.75f, 
 809.97f,  812.19f,  814.41f,  816.63f,  818.85f,  821.07f,  823.29f,  825.51f, 
 827.73f,  829.95f,  832.17f,  834.39f,  836.61f,  838.83f,  841.05f, 1068.61f, 
1069.57f, 1070.52f, 1071.48f, 1072.44f, 1073.39f, 1074.35f, 1075.31f, 1076.26f, 
1077.22f, 1078.17f, 1079.13f, 1080.08f, 1081.04f, 1081.99f, 1082.94f, 1083.89f, 
1084.85f, 1085.80f, 1086.75f, 1087.70f, 1088.65f, 1089.60f, 1090.54f, 1091.49f, 
1092.44f, 1093.38f, 1094.32f, 1095.27f, 1096.21f, 1097.15f, 1098.08f, 1099.02f, 
1099.96f, 1100.89f, 1101.82f, 1102.75f, 1103.68f, 1104.61f, 1105.53f, 1106.45f, 
1107.37f, 1108.29f, 1109.20f, 1110.11f, 1111.02f, 1111.93f, 1112.83f, 1113.73f, 
1114.62f, 1115.51f, 1116.40f, 1117.28f, 1118.16f, 1119.04f, 1119.91f, 1118.80f, 
1120.45f, 1122.05f, 1123.33f, 1124.18f, 1125.01f, 1125.84f, 1126.67f, 1127.48f, 
1128.29f, 1129.09f, 1129.89f, 1130.67f, 1131.45f, 1132.22f, 1132.98f, 1133.73f, 
1134.48f, 1135.21f, 1135.93f, 1136.65f, 1137.35f, 1138.04f, 1138.73f, 1139.40f, 
1140.06f, 1140.71f, 1141.35f, 1141.97f, 1142.59f, 1143.19f, 1143.78f, 1144.36f, 
1144.93f, 1145.48f, 1146.02f, 1146.55f, 1147.07f, 1147.57f, 1148.06f, 1148.53f, 
1149.00f, 1149.45f, 1149.88f, 1150.30f, 1150.71f, 1151.11f, 1151.49f, 1151.86f, 
1152.21f, 1152.55f, 1152.87f, 1153.18f, 1153.48f, 1153.76f, 1154.03f, 1154.29f, 
1154.53f, 1154.75f, 1154.96f, 1155.16f, 1155.34f, 1155.51f, 1155.66f, 1155.80f, 
1155.93f, 1156.03f, 1156.13f, 1156.21f, 1156.28f, 1156.33f, 1156.36f, 1156.39f, 
1156.39f, 
  56.77f,   57.14f,   58.21f,   59.94f,   62.29f,   65.18f,   68.53f,   72.28f, 
  76.37f,   80.73f,   85.31f,   90.09f,   95.01f,  100.06f,  105.20f,  110.42f, 
 115.69f,  121.01f,  126.35f,  131.72f,  137.10f,  142.48f,  147.87f,  153.25f, 
 158.63f,  164.00f,  169.36f,  174.70f,  180.04f,  185.35f,  190.65f,  195.94f, 
 201.20f,  206.44f,  211.65f,  216.85f,  221.87f,  226.45f,  231.03f,  235.60f, 
 240.16f,  244.71f,  249.25f,  253.79f,  258.31f,  262.81f,  267.30f,  271.78f, 
 276.24f,  280.69f,  285.13f,  289.56f,  293.98f,  298.39f,  302.79f,  307.19f, 
 311.57f,  315.94f,  320.30f,  324.65f,  328.99f,  333.31f,  337.62f,  341.92f, 
 346.20f,  350.47f,  354.73f,  358.97f,  363.19f,  367.41f,  371.60f,  375.78f, 
 379.95f,  384.09f,  388.23f,  392.34f,  396.45f,  400.53f,  404.60f,  408.65f, 
 412.69f,  416.71f,  420.71f,  424.70f,  428.66f,  432.62f,  436.55f,  440.47f, 
 444.37f,  448.26f,  452.13f,  455.98f,  459.81f,  463.63f,  467.43f,  471.21f, 
 474.97f,  478.72f,  482.45f,  486.16f,  489.86f,  493.54f,  497.20f,  500.84f, 
 504.47f,  508.08f,  511.67f,  515.24f,  518.80f,  522.34f,  525.86f,  529.37f, 
 532.85f,  536.33f,  539.78f,  543.21f,  546.63f,  550.03f,  553.42f,  556.78f, 
 560.13f,  563.46f,  566.78f,  570.07f,  573.35f,  576.61f,  579.86f,  583.08f, 
 586.29f,  589.48f,  592.66f,  595.81f,  598.95f,  602.07f,  605.18f,  608.26f, 
 611.33f,  614.38f,  617.41f,  620.43f,  623.43f,  626.41f,  629.37f,  632.31f, 
 635.24f,  638.15f,  641.04f,  643.91f,  646.76f,  649.60f,  652.42f,  655.22f, 
 658.00f,  660.76f,  663.51f,  666.24f,  668.95f,  671.64f,  674.31f,  676.96f, 
 679.60f,  682.21f,  684.81f,  687.39f,  689.95f,  692.49f,  695.01f,  697.51f, 
 699.99f,  702.46f,  704.91f,  707.33f,  709.73f,  712.10f,  714.45f,  716.80f, 
 719.14f,  721.47f,  723.80f,  726.11f,  728.43f,  730.73f,  733.04f,  735.34f, 
 737.63f,  739.92f,  742.20f,  744.48f,  746.75f,  749.01f,  751.26f,  753.50f, 
 755.74f,  757.97f,  760.19f,  762.41f,  764.63f,  766.85f,  769.07f,  771.29f, 
 773.51f,  775.73f,  777.95f,  780.16f,  782.38f,  784.60f,  786.82f,  789.04f, 
 791.26f,  793.48f,  795.70f,  797.92f,  800.14f,  802.36f,  804.58f,  806.80f, 
 809.02f,  811.24f,  813.46f,  815.68f,  817.90f,  820.12f,  822.33f,  824.55f, 
 826.77f,  828.99f,  831.21f,  833.43f,  835.65f,  837.87f,  840.09f, 1067.58f, 
1068.53f, 1069.49f, 1070.45f, 1071.41f, 1072.36f, 1073.32f, 1074.27f, 1075.23f, 
1076.19f, 1077.14f, 1078.10f, 1079.05f, 1080.00f, 1080.96f, 1081.91f, 1082.86f, 
1083.82f, 1084.77f, 1085.72f, 1086.67f, 1087.62f, 1088.56f, 1089.51f, 1090.46f, 
1091.40f, 1092.35f, 1093.29f, 1094.23f, 1095.17f, 1096.11f, 1097.05f, 1097.99f, 
1098.92f, 1099.86f, 1100.79f, 1101.72f, 1102.65f, 1103.57f, 1104.50f, 1105.42f, 
1106.34f, 1107.25f, 1108.17f, 1109.08f, 1109.99f, 1110.89f, 1111.80f, 1112.69f, 
1113.59f, 1114.48f, 1115.37f, 1116.25f, 1117.13f, 1118.00f, 1118.87f, 1117.80f, 
1119.45f, 1121.05f, 1122.30f, 1123.14f, 1123.98f, 1124.81f, 1125.63f, 1126.45f, 
1127.25f, 1128.06f, 1128.85f, 1129.64f, 1130.41f, 1131.18f, 1131.94f, 1132.70f, 
1133.44f, 1134.17f, 1134.89f, 1135.61f, 1136.31f, 1137.00f, 1137.69f, 1138.36f, 
1139.02f, 1139.67f, 1140.31f, 1140.93f, 1141.55f, 1142.15f, 1142.74f, 1143.32f, 
1143.88f, 1144.44f, 1144.98f, 1145.51f, 1146.02f, 1146.52f, 1147.01f, 1147.49f, 
1147.95f, 1148.40f, 1148.84f, 1149.26f, 1149.67f, 1150.06f, 1150.44f, 1150.81f, 
1151.16f, 1151.50f, 1151.83f, 1152.14f, 1152.44f, 1152.72f, 1152.99f, 1153.24f, 
1153.48f, 1153.71f, 1153.92f, 1154.11f, 1154.29f, 1154.46f, 1154.62f, 1154.75f, 
1154.88f, 1154.99f, 1155.08f, 1155.16f, 1155.23f, 1155.28f, 1155.32f, 1155.34f, 
1155.35f, 
  57.81f,   58.17f,   59.22f,   60.91f,   63.20f,   66.03f,   69.32f,   73.00f, 
  77.02f,   81.31f,   85.83f,   90.55f,   95.41f,  100.40f,  105.49f,  110.66f, 
 115.89f,  121.16f,  126.47f,  131.80f,  137.14f,  142.50f,  147.86f,  153.21f, 
 158.57f,  163.91f,  169.25f,  174.57f,  179.89f,  185.18f,  190.46f,  195.72f, 
 200.97f,  206.19f,  211.39f,  216.56f,  221.33f,  225.91f,  230.48f,  235.05f, 
 239.61f,  244.16f,  248.69f,  253.22f,  257.74f,  262.24f,  266.73f,  271.20f, 
 275.65f,  280.10f,  284.54f,  288.96f,  293.38f,  297.79f,  302.19f,  306.58f, 
 310.96f,  315.33f,  319.69f,  324.04f,  328.37f,  332.69f,  337.00f,  341.29f, 
 345.57f,  349.84f,  354.09f,  358.33f,  362.55f,  366.76f,  370.95f,  375.12f, 
 379.28f,  383.43f,  387.56f,  391.67f,  395.77f,  399.85f,  403.92f,  407.96f, 
 412.00f,  416.01f,  420.01f,  423.99f,  427.96f,  431.91f,  435.84f,  439.76f, 
 443.65f,  447.53f,  451.40f,  455.25f,  459.08f,  462.89f,  466.69f,  470.46f, 
 474.22f,  477.97f,  481.70f,  485.40f,  489.10f,  492.77f,  496.43f,  500.07f, 
 503.69f,  507.30f,  510.89f,  514.46f,  518.02f,  521.55f,  525.07f,  528.57f, 
 532.06f,  535.53f,  538.98f,  542.41f,  545.83f,  549.22f,  552.60f,  555.97f, 
 559.31f,  562.64f,  565.95f,  569.25f,  572.52f,  575.78f,  579.02f,  582.25f, 
 585.45f,  588.64f,  591.81f,  594.97f,  598.10f,  601.22f,  604.32f,  607.41f, 
 610.47f,  613.52f,  616.55f,  619.56f,  622.56f,  625.54f,  628.50f,  631.44f, 
 634.36f,  637.27f,  640.16f,  643.03f,  645.88f,  648.71f,  651.53f,  654.33f, 
 657.11f,  659.87f,  662.61f,  665.34f,  668.04f,  670.73f,  673.40f,  676.05f, 
 678.68f,  681.30f,  683.89f,  686.47f,  689.03f,  691.57f,  694.08f,  696.58f, 
 699.07f,  701.53f,  703.98f,  706.40f,  708.79f,  711.16f,  713.51f,  715.86f, 
 718.20f,  720.53f,  722.85f,  725.17f,  727.48f,  729.79f,  732.09f,  734.39f, 
 736.69f,  738.97f,  741.26f,  743.53f,  745.80f,  748.06f,  750.31f,  752.55f, 
 754.79f,  757.02f,  759.24f,  761.46f,  763.68f,  765.90f,  768.12f,  770.34f, 
 772.56f,  774.78f,  776.99f,  779.21f,  781.43f,  783.65f,  785.87f,  788.09f, 
 790.31f,  792.53f,  794.75f,  796.97f,  799.19f,  801.41f,  803.63f,  805.85f, 
 808.07f,  810.29f,  812.51f,  814.73f,  816.94f,  819.16f,  821.38f,  823.60f, 
 825.82f,  828.04f,  830.26f,  832.48f,  834.70f,  836.92f,  839.14f, 1066.55f, 
1067.51f, 1068.46f, 1069.42f, 1070.38f, 1071.33f, 1072.29f, 1073.25f, 1074.20f, 
1075.16f, 1076.11f, 1077.07f, 1078.02f, 1078.98f, 1079.93f, 1080.88f, 1081.84f, 
1082.79f, 1083.74f, 1084.69f, 1085.64f, 1086.59f, 1087.54f, 1088.48f, 1089.43f, 
1090.38f, 1091.32f, 1092.26f, 1093.21f, 1094.15f, 1095.09f, 1096.02f, 1096.96f, 
1097.90f, 1098.83f, 1099.76f, 1100.69f, 1101.62f, 1102.54f, 1103.47f, 1104.39f, 
1105.31f, 1106.23f, 1107.14f, 1108.05f, 1108.96f, 1109.86f, 1110.77f, 1111.66f, 
1112.56f, 1113.45f, 1114.34f, 1115.22f, 1116.10f, 1116.97f, 1117.84f, 1116.81f, 
1118.46f, 1120.05f, 1121.27f, 1122.11f, 1122.95f, 1123.78f, 1124.60f, 1125.41f, 
1126.22f, 1127.02f, 1127.82f, 1128.60f, 1129.38f, 1130.15f, 1130.91f, 1131.66f, 
1132.40f, 1133.14f, 1133.86f, 1134.57f, 1135.28f, 1135.97f, 1136.65f, 1137.32f, 
1137.98f, 1138.63f, 1139.27f, 1139.89f, 1140.51f, 1141.11f, 1141.70f, 1142.28f, 
1142.85f, 1143.40f, 1143.94f, 1144.47f, 1144.98f, 1145.48f, 1145.97f, 1146.45f, 
1146.91f, 1147.36f, 1147.80f, 1148.22f, 1148.63f, 1149.02f, 1149.40f, 1149.77f, 
1150.12f, 1150.46f, 1150.79f, 1151.10f, 1151.39f, 1151.68f, 1151.94f, 1152.20f, 
1152.44f, 1152.66f, 1152.87f, 1153.07f, 1153.25f, 1153.42f, 1153.57f, 1153.71f, 
1153.83f, 1153.94f, 1154.04f, 1154.12f, 1154.18f, 1154.24f, 1154.27f, 1154.29f, 
1154.30f, 
  58.85f,   59.20f,   60.22f,   61.88f,   64.12f,   66.89f,   70.11f,   73.73f, 
  77.68f,   81.91f,   86.37f,   91.02f,   95.82f,  100.76f,  105.80f,  110.92f, 
 116.10f,  121.33f,  126.60f,  131.89f,  137.21f,  142.53f,  147.86f,  153.19f, 
 158.51f,  163.84f,  169.15f,  174.45f,  179.74f,  185.02f,  190.28f,  195.52f, 
 200.75f,  205.95f,  211.13f,  216.20f,  220.79f,  225.37f,  229.94f,  234.51f, 
 239.06f,  243.61f,  248.14f,  252.67f,  257.18f,  261.68f,  266.16f,  270.62f, 
 275.08f,  279.52f,  283.95f,  288.38f,  292.79f,  297.20f,  301.60f,  305.99f, 
 310.37f,  314.73f,  319.09f,  323.43f,  327.76f,  332.08f,  336.38f,  340.67f, 
 344.95f,  349.21f,  353.46f,  357.69f,  361.91f,  366.11f,  370.30f,  374.47f, 
 378.63f,  382.77f,  386.90f,  391.00f,  395.10f,  399.18f,  403.24f,  407.28f, 
 411.31f,  415.32f,  419.32f,  423.30f,  427.26f,  431.20f,  435.13f,  439.05f, 
 442.94f,  446.82f,  450.68f,  454.52f,  458.35f,  462.16f,  465.95f,  469.73f, 
 473.48f,  477.22f,  480.95f,  484.65f,  488.34f,  492.02f,  495.67f,  499.31f, 
 502.93f,  506.53f,  510.12f,  513.69f,  517.24f,  520.77f,  524.29f,  527.79f, 
 531.27f,  534.73f,  538.18f,  541.61f,  545.02f,  548.42f,  551.80f,  555.16f, 
 558.50f,  561.83f,  565.13f,  568.43f,  571.70f,  574.96f,  578.19f,  581.41f, 
 584.62f,  587.80f,  590.97f,  594.12f,  597.26f,  600.37f,  603.47f,  606.55f, 
 609.62f,  612.66f,  615.69f,  618.70f,  621.70f,  624.67f,  627.63f,  630.57f, 
 633.49f,  636.39f,  639.28f,  642.15f,  645.00f,  647.83f,  650.64f,  653.44f, 
 656.22f,  658.98f,  661.72f,  664.44f,  667.14f,  669.83f,  672.50f,  675.15f, 
 677.78f,  680.39f,  682.98f,  685.56f,  688.11f,  690.65f,  693.16f,  695.66f, 
 698.14f,  700.61f,  703.05f,  705.47f,  707.86f,  710.23f,  712.58f,  714.93f, 
 717.26f,  719.59f,  721.92f,  724.23f,  726.55f,  728.85f,  731.16f,  733.45f, 
 735.75f,  738.03f,  740.31f,  742.59f,  744.86f,  747.12f,  749.37f,  751.61f, 
 753.85f,  756.07f,  758.29f,  760.51f,  762.73f,  764.95f,  767.17f,  769.39f, 
 771.61f,  773.83f,  776.05f,  778.27f,  780.49f,  782.71f,  784.93f,  787.15f, 
 789.36f,  791.58f,  793.80f,  796.02f,  798.24f,  800.46f,  802.68f,  804.90f, 
 807.12f,  809.34f,  811.56f,  813.78f,  816.00f,  818.22f,  820.44f,  822.66f, 
 824.88f,  827.10f,  829.32f,  831.53f,  833.75f,  835.97f,  838.19f, 1065.53f, 
1066.48f, 1067.44f, 1068.40f, 1069.35f, 1070.31f, 1071.27f, 1072.22f, 1073.18f, 
1074.13f, 1075.09f, 1076.04f, 1077.00f, 1077.95f, 1078.91f, 1079.86f, 1080.81f, 
1081.76f, 1082.72f, 1083.67f, 1084.62f, 1085.56f, 1086.51f, 1087.46f, 1088.41f, 
1089.35f, 1090.30f, 1091.24f, 1092.18f, 1093.12f, 1094.06f, 1095.00f, 1095.94f, 
1096.87f, 1097.80f, 1098.74f, 1099.67f, 1100.59f, 1101.52f, 1102.44f, 1103.37f, 
1104.28f, 1105.20f, 1106.11f, 1107.03f, 1107.93f, 1108.84f, 1109.74f, 1110.64f, 
1111.53f, 1112.42f, 1113.31f, 1114.19f, 1115.07f, 1115.95f, 1116.82f, 1115.82f, 
1117.47f, 1119.06f, 1120.24f, 1121.08f, 1121.92f, 1122.75f, 1123.57f, 1124.39f, 
1125.19f, 1126.00f, 1126.79f, 1127.57f, 1128.35f, 1129.12f, 1129.88f, 1130.63f, 
1131.37f, 1132.11f, 1132.83f, 1133.54f, 1134.24f, 1134.94f, 1135.62f, 1136.29f, 
1136.95f, 1137.60f, 1138.24f, 1138.86f, 1139.48f, 1140.08f, 1140.67f, 1141.25f, 
1141.81f, 1142.36f, 1142.90f, 1143.43f, 1143.95f, 1144.45f, 1144.94f, 1145.41f, 
1145.88f, 1146.32f, 1146.76f, 1147.18f, 1147.59f, 1147.98f, 1148.36f, 1148.73f, 
1149.08f, 1149.42f, 1149.75f, 1150.06f, 1150.35f, 1150.64f, 1150.90f, 1151.16f, 
1151.40f, 1151.62f, 1151.83f, 1152.03f, 1152.21f, 1152.38f, 1152.53f, 1152.67f, 
1152.79f, 1152.90f, 1153.00f, 1153.08f, 1153.14f, 1153.20f, 1153.23f, 1153.25f, 
1153.26f, 
  59.89f,   60.23f,   61.23f,   62.84f,   65.03f,   67.74f,   70.91f,   74.46f, 
  78.35f,   82.51f,   86.91f,   91.50f,   96.25f,  101.13f,  106.12f,  111.19f, 
 116.33f,  121.52f,  126.74f,  132.00f,  137.28f,  142.57f,  147.87f,  153.17f, 
 158.48f,  163.77f,  169.06f,  174.34f,  179.61f,  184.87f,  190.11f,  195.33f, 
 200.53f,  205.72f,  210.88f,  215.68f,  220.27f,  224.84f,  229.41f,  233.97f, 
 238.53f,  243.07f,  247.60f,  252.12f,  256.63f,  261.12f,  265.60f,  270.06f, 
 274.51f,  278.95f,  283.38f,  287.80f,  292.22f,  296.62f,  301.02f,  305.40f, 
 309.78f,  314.14f,  318.49f,  322.83f,  327.16f,  331.47f,  335.77f,  340.06f, 
 344.33f,  348.59f,  352.83f,  357.06f,  361.27f,  365.47f,  369.66f,  373.83f, 
 377.98f,  382.12f,  386.24f,  390.34f,  394.43f,  398.51f,  402.57f,  406.61f, 
 410.63f,  414.64f,  418.63f,  422.61f,  426.57f,  430.51f,  434.43f,  438.34f, 
 442.23f,  446.11f,  449.96f,  453.80f,  457.63f,  461.43f,  465.22f,  468.99f, 
 472.75f,  476.49f,  480.21f,  483.91f,  487.59f,  491.26f,  494.92f,  498.55f, 
 502.17f,  505.77f,  509.35f,  512.92f,  516.46f,  519.99f,  523.51f,  527.00f, 
 530.48f,  533.95f,  537.39f,  540.82f,  544.23f,  547.62f,  550.99f,  554.35f, 
 557.69f,  561.02f,  564.32f,  567.61f,  570.88f,  574.13f,  577.37f,  580.59f, 
 583.79f,  586.97f,  590.14f,  593.29f,  596.42f,  599.53f,  602.63f,  605.71f, 
 608.77f,  611.81f,  614.84f,  617.85f,  620.84f,  623.81f,  626.76f,  629.70f, 
 632.62f,  635.52f,  638.41f,  641.27f,  644.12f,  646.95f,  649.76f,  652.56f, 
 655.33f,  658.09f,  660.83f,  663.55f,  666.25f,  668.93f,  671.60f,  674.25f, 
 676.88f,  679.49f,  682.08f,  684.65f,  687.20f,  689.74f,  692.25f,  694.75f, 
 697.23f,  699.69f,  702.13f,  704.55f,  706.93f,  709.30f,  711.65f,  713.99f, 
 716.33f,  718.66f,  720.98f,  723.30f,  725.61f,  727.92f,  730.22f,  732.52f, 
 734.81f,  737.10f,  739.38f,  741.65f,  743.92f,  746.18f,  748.43f,  750.67f, 
 752.90f,  755.13f,  757.35f,  759.57f,  761.79f,  764.01f,  766.23f,  768.45f, 
 770.67f,  772.89f,  775.11f,  777.33f,  779.55f,  781.76f,  783.98f,  786.20f, 
 788.42f,  790.64f,  792.86f,  795.08f,  797.30f,  799.52f,  801.74f,  803.96f, 
 806.18f,  808.40f,  810.62f,  812.84f,  815.06f,  817.28f,  819.50f,  821.71f, 
 823.93f,  826.15f,  828.37f,  830.59f,  832.81f,  835.03f,  837.25f, 1064.51f, 
1065.46f, 1066.42f, 1067.38f, 1068.33f, 1069.29f, 1070.25f, 1071.20f, 1072.16f, 
1073.11f, 1074.07f, 1075.02f, 1075.98f, 1076.93f, 1077.89f, 1078.84f, 1079.79f, 
1080.74f, 1081.70f, 1082.65f, 1083.60f, 1084.54f, 1085.49f, 1086.44f, 1087.39f, 
1088.33f, 1089.28f, 1090.22f, 1091.16f, 1092.10f, 1093.04f, 1093.98f, 1094.92f, 
1095.85f, 1096.78f, 1097.72f, 1098.65f, 1099.57f, 1100.50f, 1101.42f, 1102.34f, 
1103.26f, 1104.18f, 1105.09f, 1106.00f, 1106.91f, 1107.82f, 1108.72f, 1109.62f, 
1110.51f, 1111.40f, 1112.29f, 1113.17f, 1114.05f, 1114.92f, 1115.79f, 1114.84f, 
1116.48f, 1118.06f, 1119.22f, 1120.06f, 1120.89f, 1121.72f, 1122.55f, 1123.36f, 
1124.17f, 1124.97f, 1125.76f, 1126.55f, 1127.33f, 1128.09f, 1128.85f, 1129.60f, 
1130.35f, 1131.08f, 1131.80f, 1132.51f, 1133.22f, 1133.91f, 1134.59f, 1135.26f, 
1135.92f, 1136.57f, 1137.21f, 1137.83f, 1138.45f, 1139.05f, 1139.64f, 1140.21f, 
1140.78f, 1141.33f, 1141.87f, 1142.40f, 1142.91f, 1143.42f, 1143.90f, 1144.38f, 
1144.84f, 1145.29f, 1145.73f, 1146.15f, 1146.56f, 1146.95f, 1147.33f, 1147.70f, 
1148.05f, 1148.39f, 1148.71f, 1149.02f, 1149.32f, 1149.60f, 1149.87f, 1150.12f, 
1150.36f, 1150.59f, 1150.80f, 1150.99f, 1151.18f, 1151.34f, 1151.50f, 1151.63f, 
1151.76f, 1151.87f, 1151.96f, 1152.04f, 1152.11f, 1152.16f, 1152.19f, 1152.22f, 
1152.22f, 
  60.92f,   61.26f,   62.23f,   63.81f,   65.95f,   68.61f,   71.71f,   75.20f, 
  79.02f,   83.12f,   87.46f,   91.99f,   96.69f,  101.51f,  106.45f,  111.47f, 
 116.57f,  121.71f,  126.90f,  132.12f,  137.37f,  142.63f,  147.90f,  153.17f, 
 158.45f,  163.72f,  168.99f,  174.24f,  179.49f,  184.72f,  189.94f,  195.15f, 
 200.33f,  205.50f,  210.58f,  215.17f,  219.75f,  224.32f,  228.89f,  233.45f, 
 238.00f,  242.54f,  247.06f,  251.58f,  256.08f,  260.57f,  265.04f,  269.50f, 
 273.95f,  278.39f,  282.81f,  287.23f,  291.64f,  296.05f,  300.44f,  304.82f, 
 309.19f,  313.55f,  317.90f,  322.24f,  326.56f,  330.87f,  335.17f,  339.45f, 
 343.72f,  347.97f,  352.21f,  356.44f,  360.65f,  364.84f,  369.02f,  373.19f, 
 377.34f,  381.47f,  385.59f,  389.69f,  393.78f,  397.85f,  401.90f,  405.94f, 
 409.96f,  413.96f,  417.95f,  421.92f,  425.88f,  429.82f,  433.74f,  437.64f, 
 441.53f,  445.40f,  449.25f,  453.09f,  456.91f,  460.71f,  464.50f,  468.27f, 
 472.02f,  475.75f,  479.47f,  483.17f,  486.85f,  490.52f,  494.17f,  497.80f, 
 501.41f,  505.01f,  508.59f,  512.15f,  515.70f,  519.22f,  522.73f,  526.23f, 
 529.70f,  533.16f,  536.60f,  540.03f,  543.44f,  546.83f,  550.20f,  553.55f, 
 556.89f,  560.21f,  563.51f,  566.80f,  570.07f,  573.32f,  576.55f,  579.77f, 
 582.97f,  586.15f,  589.31f,  592.46f,  595.59f,  598.70f,  601.79f,  604.87f, 
 607.92f,  610.97f,  613.99f,  617.00f,  619.98f,  622.95f,  625.91f,  628.84f, 
 631.76f,  634.66f,  637.54f,  640.40f,  643.25f,  646.08f,  648.89f,  651.68f, 
 654.45f,  657.21f,  659.94f,  662.66f,  665.36f,  668.04f,  670.71f,  673.35f, 
 675.98f,  678.59f,  681.18f,  683.75f,  686.30f,  688.83f,  691.34f,  693.83f, 
 696.31f,  698.77f,  701.21f,  703.63f,  706.01f,  708.37f,  710.72f,  713.07f, 
 715.40f,  717.73f,  720.06f,  722.37f,  724.68f,  726.99f,  729.29f,  731.59f, 
 733.88f,  736.16f,  738.45f,  740.72f,  742.98f,  745.24f,  747.49f,  749.73f, 
 751.97f,  754.19f,  756.41f,  758.63f,  760.85f,  763.07f,  765.29f,  767.51f, 
 769.73f,  771.95f,  774.17f,  776.39f,  778.61f,  780.83f,  783.05f,  785.27f, 
 787.49f,  789.70f,  791.92f,  794.14f,  796.36f,  798.58f,  800.80f,  803.02f, 
 805.24f,  807.46f,  809.68f,  811.90f,  814.12f,  816.34f,  818.56f,  820.78f, 
 823.00f,  825.22f,  827.44f,  829.65f,  831.87f,  834.09f,  836.31f, 1063.49f, 
1064.45f, 1065.40f, 1066.36f, 1067.32f, 1068.27f, 1069.23f, 1070.19f, 1071.14f, 
1072.10f, 1073.05f, 1074.01f, 1074.96f, 1075.92f, 1076.87f, 1077.82f, 1078.78f, 
1079.73f, 1080.68f, 1081.63f, 1082.58f, 1083.53f, 1084.48f, 1085.42f, 1086.37f, 
1087.32f, 1088.26f, 1089.20f, 1090.14f, 1091.09f, 1092.02f, 1092.96f, 1093.90f, 
1094.83f, 1095.77f, 1096.70f, 1097.63f, 1098.56f, 1099.48f, 1100.41f, 1101.33f, 
1102.25f, 1103.16f, 1104.08f, 1104.99f, 1105.89f, 1106.80f, 1107.70f, 1108.60f, 
1109.49f, 1110.38f, 1111.27f, 1112.15f, 1113.03f, 1113.90f, 1114.77f, 1113.86f, 
1115.50f, 1117.08f, 1118.20f, 1119.04f, 1119.87f, 1120.70f, 1121.52f, 1122.34f, 
1123.15f, 1123.95f, 1124.74f, 1125.53f, 1126.30f, 1127.07f, 1127.83f, 1128.58f, 
1129.32f, 1130.06f, 1130.78f, 1131.49f, 1132.19f, 1132.88f, 1133.56f, 1134.24f, 
1134.89f, 1135.54f, 1136.18f, 1136.81f, 1137.42f, 1138.02f, 1138.61f, 1139.19f, 
1139.75f, 1140.31f, 1140.84f, 1141.37f, 1141.89f, 1142.39f, 1142.88f, 1143.35f, 
1143.81f, 1144.26f, 1144.70f, 1145.12f, 1145.53f, 1145.92f, 1146.30f, 1146.67f, 
1147.02f, 1147.36f, 1147.68f, 1147.99f, 1148.29f, 1148.57f, 1148.84f, 1149.09f, 
1149.33f, 1149.55f, 1149.76f, 1149.96f, 1150.14f, 1150.31f, 1150.46f, 1150.60f, 
1150.72f, 1150.83f, 1150.93f, 1151.01f, 1151.07f, 1151.13f, 1151.16f, 1151.18f, 
1151.19f, 
  61.95f,   62.28f,   63.23f,   64.77f,   66.87f,   69.47f,   72.52f,   75.94f, 
  79.70f,   83.75f,   88.02f,   92.50f,   97.14f,  101.91f,  106.79f,  111.77f, 
 116.82f,  121.92f,  127.07f,  132.26f,  137.47f,  142.70f,  147.94f,  153.18f, 
 158.43f,  163.68f,  168.92f,  174.15f,  179.38f,  184.59f,  189.79f,  194.97f, 
 200.13f,  205.28f,  210.07f,  214.66f,  219.24f,  223.81f,  228.38f,  232.93f, 
 237.48f,  242.01f,  246.54f,  251.05f,  255.55f,  260.03f,  264.50f,  268.95f, 
 273.40f,  277.83f,  282.26f,  286.67f,  291.08f,  295.48f,  299.87f,  304.25f, 
 308.62f,  312.98f,  317.32f,  321.65f,  325.97f,  330.28f,  334.57f,  338.85f, 
 343.11f,  347.36f,  351.60f,  355.82f,  360.03f,  364.22f,  368.40f,  372.56f, 
 376.70f,  380.83f,  384.95f,  389.04f,  393.13f,  397.19f,  401.24f,  405.28f, 
 409.29f,  413.29f,  417.28f,  421.25f,  425.20f,  429.13f,  433.05f,  436.95f, 
 440.83f,  444.70f,  448.55f,  452.38f,  456.20f,  460.00f,  463.78f,  467.55f, 
 471.29f,  475.02f,  478.74f,  482.44f,  486.11f,  489.78f,  493.42f,  497.05f, 
 500.66f,  504.26f,  507.83f,  511.39f,  514.93f,  518.46f,  521.97f,  525.46f, 
 528.93f,  532.38f,  535.82f,  539.24f,  542.65f,  546.04f,  549.41f,  552.76f, 
 556.09f,  559.41f,  562.71f,  565.99f,  569.26f,  572.51f,  575.74f,  578.95f, 
 582.15f,  585.32f,  588.49f,  591.63f,  594.76f,  597.86f,  600.96f,  604.03f, 
 607.09f,  610.12f,  613.15f,  616.15f,  619.13f,  622.10f,  625.05f,  627.99f, 
 630.90f,  633.80f,  636.68f,  639.54f,  642.38f,  645.21f,  648.01f,  650.80f, 
 653.57f,  656.33f,  659.06f,  661.78f,  664.48f,  667.16f,  669.82f,  672.46f, 
 675.09f,  677.69f,  680.28f,  682.85f,  685.39f,  687.92f,  690.43f,  692.93f, 
 695.40f,  697.86f,  700.30f,  702.71f,  705.09f,  707.45f,  709.80f,  712.15f, 
 714.48f,  716.81f,  719.13f,  721.45f,  723.76f,  726.06f,  728.36f,  730.66f, 
 732.95f,  735.24f,  737.52f,  739.79f,  742.05f,  744.31f,  746.56f,  748.80f, 
 751.04f,  753.26f,  755.48f,  757.70f,  759.92f,  762.14f,  764.36f,  766.58f, 
 768.80f,  771.02f,  773.23f,  775.45f,  777.67f,  779.89f,  782.11f,  784.33f, 
 786.55f,  788.77f,  790.99f,  793.21f,  795.43f,  797.65f,  799.87f,  802.09f, 
 804.31f,  806.53f,  808.75f,  810.97f,  813.19f,  815.40f,  817.62f,  819.84f, 
 822.06f,  824.28f,  826.50f,  828.72f,  830.94f,  833.16f,  835.38f, 1062.48f, 
1063.43f, 1064.39f, 1065.35f, 1066.31f, 1067.26f, 1068.22f, 1069.17f, 1070.13f, 
1071.09f, 1072.04f, 1073.00f, 1073.95f, 1074.90f, 1075.86f, 1076.81f, 1077.76f, 
1078.72f, 1079.67f, 1080.62f, 1081.57f, 1082.52f, 1083.46f, 1084.41f, 1085.36f, 
1086.30f, 1087.25f, 1088.19f, 1089.13f, 1090.07f, 1091.01f, 1091.95f, 1092.89f, 
1093.82f, 1094.75f, 1095.69f, 1096.61f, 1097.54f, 1098.47f, 1099.39f, 1100.31f, 
1101.23f, 1102.15f, 1103.06f, 1103.97f, 1104.88f, 1105.78f, 1106.69f, 1107.58f, 
1108.48f, 1109.37f, 1110.26f, 1111.14f, 1112.02f, 1112.89f, 1113.76f, 1112.88f, 
1114.51f, 1116.09f, 1117.18f, 1118.02f, 1118.86f, 1119.69f, 1120.51f, 1121.32f, 
1122.13f, 1122.93f, 1123.72f, 1124.51f, 1125.29f, 1126.05f, 1126.81f, 1127.56f, 
1128.30f, 1129.04f, 1129.76f, 1130.47f, 1131.17f, 1131.86f, 1132.54f, 1133.21f, 
1133.87f, 1134.52f, 1135.16f, 1135.78f, 1136.40f, 1137.00f, 1137.59f, 1138.16f, 
1138.73f, 1139.28f, 1139.82f, 1140.35f, 1140.86f, 1141.36f, 1141.85f, 1142.33f, 
1142.79f, 1143.24f, 1143.67f, 1144.09f, 1144.50f, 1144.89f, 1145.27f, 1145.64f, 
1145.99f, 1146.33f, 1146.65f, 1146.96f, 1147.26f, 1147.54f, 1147.81f, 1148.06f, 
1148.30f, 1148.53f, 1148.74f, 1148.93f, 1149.11f, 1149.28f, 1149.43f, 1149.57f, 
1149.70f, 1149.80f, 1149.90f, 1149.98f, 1150.04f, 1150.10f, 1150.13f, 1150.15f, 
1150.16f, 
  62.98f,   63.30f,   64.23f,   65.73f,   67.79f,   70.34f,   73.32f,   76.69f, 
  80.39f,   84.37f,   88.59f,   93.01f,   97.59f,  102.32f,  107.15f,  112.08f, 
 117.08f,  122.15f,  127.26f,  132.41f,  137.58f,  142.78f,  147.99f,  153.20f, 
 158.42f,  163.64f,  168.86f,  174.07f,  179.27f,  184.46f,  189.64f,  194.80f, 
 199.94f,  204.99f,  209.58f,  214.16f,  218.74f,  223.31f,  227.87f,  232.42f, 
 236.97f,  241.50f,  246.02f,  250.53f,  255.02f,  259.50f,  263.96f,  268.41f, 
 272.85f,  277.28f,  281.71f,  286.12f,  290.53f,  294.92f,  299.31f,  303.69f, 
 308.05f,  312.40f,  316.74f,  321.07f,  325.39f,  329.69f,  333.98f,  338.25f, 
 342.51f,  346.76f,  350.99f,  355.21f,  359.42f,  363.60f,  367.78f,  371.93f, 
 376.07f,  380.20f,  384.31f,  388.40f,  392.48f,  396.54f,  400.59f,  404.62f, 
 408.63f,  412.63f,  416.61f,  420.57f,  424.52f,  428.45f,  432.37f,  436.26f, 
 440.14f,  444.01f,  447.85f,  451.68f,  455.50f,  459.29f,  463.07f,  466.83f, 
 470.58f,  474.30f,  478.01f,  481.71f,  485.38f,  489.04f,  492.68f,  496.31f, 
 499.92f,  503.51f,  507.08f,  510.64f,  514.18f,  517.70f,  521.20f,  524.69f, 
 528.16f,  531.61f,  535.05f,  538.47f,  541.87f,  545.25f,  548.62f,  551.97f, 
 555.30f,  558.61f,  561.91f,  565.19f,  568.46f,  571.70f,  574.93f,  578.14f, 
 581.33f,  584.51f,  587.67f,  590.81f,  593.93f,  597.04f,  600.13f,  603.20f, 
 606.25f,  609.29f,  612.31f,  615.31f,  618.29f,  621.26f,  624.20f,  627.13f, 
 630.05f,  632.94f,  635.82f,  638.68f,  641.52f,  644.34f,  647.15f,  649.93f, 
 652.70f,  655.45f,  658.19f,  660.90f,  663.60f,  666.27f,  668.93f,  671.57f, 
 674.20f,  676.80f,  679.39f,  681.95f,  684.50f,  687.02f,  689.53f,  692.02f, 
 694.50f,  696.95f,  699.39f,  701.80f,  704.17f,  706.53f,  708.89f,  711.23f, 
 713.56f,  715.89f,  718.21f,  720.53f,  722.84f,  725.14f,  727.44f,  729.74f, 
 732.03f,  734.31f,  736.59f,  738.86f,  741.13f,  743.39f,  745.63f,  747.87f, 
 750.11f,  752.33f,  754.55f,  756.77f,  758.99f,  761.21f,  763.43f,  765.65f, 
 767.87f,  770.09f,  772.31f,  774.52f,  776.74f,  778.96f,  781.18f,  783.40f, 
 785.62f,  787.84f,  790.06f,  792.28f,  794.50f,  796.72f,  798.94f,  801.16f, 
 803.38f,  805.60f,  807.82f,  810.04f,  812.26f,  814.48f,  816.69f,  818.91f, 
 821.13f,  823.35f,  825.57f,  827.79f,  830.01f,  832.23f,  834.45f, 1061.47f, 
1062.43f, 1063.38f, 1064.34f, 1065.30f, 1066.25f, 1067.21f, 1068.17f, 1069.12f, 
1070.08f, 1071.03f, 1071.99f, 1072.94f, 1073.90f, 1074.85f, 1075.80f, 1076.75f, 
1077.71f, 1078.66f, 1079.61f, 1080.56f, 1081.51f, 1082.45f, 1083.40f, 1084.35f, 
1085.29f, 1086.24f, 1087.18f, 1088.12f, 1089.06f, 1090.00f, 1090.94f, 1091.88f, 
1092.81f, 1093.74f, 1094.68f, 1095.61f, 1096.53f, 1097.46f, 1098.38f, 1099.30f, 
1100.22f, 1101.14f, 1102.05f, 1102.96f, 1103.87f, 1104.77f, 1105.68f, 1106.57f, 
1107.47f, 1108.36f, 1109.24f, 1110.13f, 1111.00f, 1111.88f, 1112.75f, 1111.91f, 
1113.54f, 1115.11f, 1116.17f, 1117.01f, 1117.84f, 1118.67f, 1119.49f, 1120.31f, 
1121.12f, 1121.92f, 1122.71f, 1123.49f, 1124.27f, 1125.04f, 1125.80f, 1126.55f, 
1127.29f, 1128.02f, 1128.74f, 1129.45f, 1130.15f, 1130.85f, 1131.53f, 1132.20f, 
1132.86f, 1133.50f, 1134.14f, 1134.76f, 1135.38f, 1135.98f, 1136.57f, 1137.14f, 
1137.71f, 1138.26f, 1138.80f, 1139.33f, 1139.84f, 1140.34f, 1140.83f, 1141.30f, 
1141.76f, 1142.21f, 1142.65f, 1143.07f, 1143.48f, 1143.87f, 1144.25f, 1144.61f, 
1144.97f, 1145.30f, 1145.63f, 1145.94f, 1146.23f, 1146.52f, 1146.78f, 1147.04f, 
1147.28f, 1147.50f, 1147.71f, 1147.91f, 1148.09f, 1148.25f, 1148.41f, 1148.55f, 
1148.67f, 1148.78f, 1148.87f, 1148.95f, 1149.02f, 1149.07f, 1149.11f, 1149.13f, 
1149.14f, 
  64.00f,   64.31f,   65.22f,   66.70f,   68.70f,   71.20f,   74.14f,   77.45f, 
  81.09f,   85.01f,   89.17f,   93.53f,   98.06f,  102.73f,  107.52f,  112.40f, 
 117.36f,  122.38f,  127.45f,  132.56f,  137.71f,  142.87f,  148.05f,  153.23f, 
 158.43f,  163.62f,  168.81f,  174.00f,  179.18f,  184.34f,  189.50f,  194.64f, 
 199.76f,  204.51f,  209.10f,  213.68f,  218.25f,  222.82f,  227.38f,  231.93f, 
 236.46f,  240.99f,  245.51f,  250.01f,  254.50f,  258.97f,  263.43f,  267.88f, 
 272.32f,  276.74f,  281.16f,  285.58f,  289.98f,  294.37f,  298.76f,  303.13f, 
 307.49f,  311.84f,  316.18f,  320.50f,  324.81f,  329.11f,  333.40f,  337.67f, 
 341.92f,  346.17f,  350.40f,  354.61f,  358.81f,  362.99f,  367.16f,  371.31f, 
 375.45f,  379.57f,  383.68f,  387.77f,  391.84f,  395.90f,  399.94f,  403.97f, 
 407.98f,  411.97f,  415.95f,  419.91f,  423.85f,  427.78f,  431.69f,  435.58f, 
 439.46f,  443.32f,  447.16f,  450.99f,  454.80f,  458.59f,  462.36f,  466.12f, 
 469.86f,  473.59f,  477.29f,  480.98f,  484.66f,  488.31f,  491.95f,  495.57f, 
 499.18f,  502.76f,  506.33f,  509.89f,  513.42f,  516.94f,  520.44f,  523.93f, 
 527.40f,  530.85f,  534.28f,  537.69f,  541.09f,  544.47f,  547.84f,  551.18f, 
 554.51f,  557.82f,  561.12f,  564.40f,  567.66f,  570.90f,  574.12f,  577.33f, 
 580.52f,  583.70f,  586.85f,  589.99f,  593.11f,  596.22f,  599.30f,  602.37f, 
 605.42f,  608.46f,  611.47f,  614.47f,  617.45f,  620.41f,  623.36f,  626.29f, 
 629.20f,  632.09f,  634.96f,  637.82f,  640.66f,  643.48f,  646.28f,  649.07f, 
 651.83f,  654.58f,  657.31f,  660.03f,  662.72f,  665.40f,  668.05f,  670.69f, 
 673.31f,  675.91f,  678.50f,  681.06f,  683.60f,  686.13f,  688.64f,  691.12f, 
 693.60f,  696.05f,  698.48f,  700.89f,  703.26f,  705.62f,  707.97f,  710.31f, 
 712.65f,  714.97f,  717.30f,  719.61f,  721.92f,  724.22f,  726.52f,  728.82f, 
 731.11f,  733.39f,  735.67f,  737.94f,  740.21f,  742.46f,  744.71f,  746.95f, 
 749.18f,  751.41f,  753.62f,  755.84f,  758.06f,  760.28f,  762.50f,  764.72f, 
 766.94f,  769.16f,  771.38f,  773.60f,  775.82f,  778.04f,  780.26f,  782.48f, 
 784.70f,  786.92f,  789.14f,  791.36f,  793.57f,  795.79f,  798.01f,  800.23f, 
 802.45f,  804.67f,  806.89f,  809.11f,  811.33f,  813.55f,  815.77f,  817.99f, 
 820.21f,  822.43f,  824.65f,  826.87f,  829.09f,  831.31f,  833.53f, 1060.46f, 
1061.42f, 1062.38f, 1063.33f, 1064.29f, 1065.25f, 1066.20f, 1067.16f, 1068.12f, 
1069.07f, 1070.03f, 1070.98f, 1071.94f, 1072.89f, 1073.84f, 1074.80f, 1075.75f, 
1076.70f, 1077.65f, 1078.60f, 1079.55f, 1080.50f, 1081.45f, 1082.40f, 1083.34f, 
1084.29f, 1085.23f, 1086.17f, 1087.12f, 1088.06f, 1089.00f, 1089.93f, 1090.87f, 
1091.81f, 1092.74f, 1093.67f, 1094.60f, 1095.53f, 1096.45f, 1097.38f, 1098.30f, 
1099.21f, 1100.13f, 1101.04f, 1101.95f, 1102.86f, 1103.77f, 1104.67f, 1105.57f, 
1106.46f, 1107.35f, 1108.24f, 1109.12f, 1110.00f, 1110.87f, 1111.74f, 1110.94f, 
1112.56f, 1114.14f, 1115.16f, 1116.00f, 1116.83f, 1117.66f, 1118.48f, 1119.30f, 
1120.11f, 1120.91f, 1121.70f, 1122.48f, 1123.26f, 1124.03f, 1124.79f, 1125.54f, 
1126.28f, 1127.01f, 1127.73f, 1128.44f, 1129.14f, 1129.83f, 1130.51f, 1131.18f, 
1131.84f, 1132.49f, 1133.12f, 1133.75f, 1134.36f, 1134.96f, 1135.55f, 1136.13f, 
1136.69f, 1137.24f, 1137.78f, 1138.31f, 1138.82f, 1139.32f, 1139.81f, 1140.29f, 
1140.75f, 1141.19f, 1141.63f, 1142.05f, 1142.46f, 1142.85f, 1143.23f, 1143.59f, 
1143.95f, 1144.28f, 1144.61f, 1144.92f, 1145.21f, 1145.49f, 1145.76f, 1146.02f, 
1146.25f, 1146.48f, 1146.69f, 1146.88f, 1147.07f, 1147.23f, 1147.39f, 1147.52f, 
1147.65f, 1147.76f, 1147.85f, 1147.93f, 1148.00f, 1148.05f, 1148.08f, 1148.11f, 
1148.11f, 
  65.02f,   65.32f,   66.21f,   67.66f,   69.62f,   72.07f,   74.95f,   78.21f, 
  81.79f,   85.65f,   89.76f,   94.06f,   98.54f,  103.16f,  107.89f,  112.73f, 
 117.65f,  122.63f,  127.66f,  132.73f,  137.84f,  142.97f,  148.12f,  153.27f, 
 158.44f,  163.61f,  168.77f,  173.93f,  179.09f,  184.23f,  189.37f,  194.49f, 
 199.44f,  204.03f,  208.62f,  213.20f,  217.77f,  222.34f,  226.89f,  231.44f, 
 235.97f,  240.49f,  245.01f,  249.51f,  253.99f,  258.45f,  262.91f,  267.35f, 
 271.79f,  276.21f,  280.63f,  285.04f,  289.44f,  293.83f,  298.21f,  302.58f, 
 306.94f,  311.28f,  315.62f,  319.94f,  324.25f,  328.54f,  332.82f,  337.09f, 
 341.34f,  345.58f,  349.80f,  354.01f,  358.21f,  362.39f,  366.55f,  370.70f, 
 374.83f,  378.95f,  383.05f,  387.14f,  391.21f,  395.27f,  399.30f,  403.33f, 
 407.33f,  411.32f,  415.29f,  419.25f,  423.19f,  427.11f,  431.02f,  434.91f, 
 438.78f,  442.64f,  446.48f,  450.30f,  454.10f,  457.89f,  461.66f,  465.42f, 
 469.16f,  472.88f,  476.58f,  480.27f,  483.94f,  487.59f,  491.22f,  494.84f, 
 498.44f,  502.03f,  505.59f,  509.14f,  512.68f,  516.19f,  519.69f,  523.17f, 
 526.64f,  530.08f,  533.51f,  536.93f,  540.32f,  543.70f,  547.06f,  550.40f, 
 553.73f,  557.04f,  560.33f,  563.61f,  566.86f,  570.10f,  573.33f,  576.53f, 
 579.72f,  582.89f,  586.04f,  589.18f,  592.30f,  595.40f,  598.48f,  601.55f, 
 604.60f,  607.63f,  610.64f,  613.64f,  616.62f,  619.58f,  622.52f,  625.45f, 
 628.35f,  631.24f,  634.12f,  636.97f,  639.81f,  642.62f,  645.43f,  648.21f, 
 650.97f,  653.72f,  656.45f,  659.16f,  661.85f,  664.52f,  667.18f,  669.81f, 
 672.43f,  675.03f,  677.61f,  680.17f,  682.72f,  685.24f,  687.74f,  690.23f, 
 692.70f,  695.15f,  697.58f,  699.98f,  702.36f,  704.71f,  707.06f,  709.40f, 
 711.74f,  714.06f,  716.38f,  718.70f,  721.01f,  723.31f,  725.61f,  727.91f, 
 730.20f,  732.48f,  734.76f,  737.03f,  739.29f,  741.55f,  743.79f,  746.03f, 
 748.26f,  750.48f,  752.70f,  754.92f,  757.14f,  759.36f,  761.58f,  763.80f, 
 766.02f,  768.24f,  770.46f,  772.68f,  774.90f,  777.12f,  779.34f,  781.56f, 
 783.78f,  786.00f,  788.22f,  790.43f,  792.65f,  794.87f,  797.09f,  799.31f, 
 801.53f,  803.75f,  805.97f,  808.19f,  810.41f,  812.63f,  814.85f,  817.07f, 
 819.29f,  821.51f,  823.73f,  825.95f,  828.17f,  830.38f,  832.60f, 1059.46f, 
1060.42f, 1061.38f, 1062.33f, 1063.29f, 1064.25f, 1065.20f, 1066.16f, 1067.12f, 
1068.07f, 1069.03f, 1069.98f, 1070.93f, 1071.89f, 1072.84f, 1073.79f, 1074.75f, 
1075.70f, 1076.65f, 1077.60f, 1078.55f, 1079.50f, 1080.45f, 1081.39f, 1082.34f, 
1083.29f, 1084.23f, 1085.17f, 1086.11f, 1087.05f, 1087.99f, 1088.93f, 1089.87f, 
1090.80f, 1091.74f, 1092.67f, 1093.60f, 1094.52f, 1095.45f, 1096.37f, 1097.29f, 
1098.21f, 1099.13f, 1100.04f, 1100.95f, 1101.86f, 1102.76f, 1103.66f, 1104.56f, 
1105.46f, 1106.35f, 1107.23f, 1108.11f, 1108.99f, 1109.86f, 1110.73f, 1109.97f, 
1111.60f, 1113.17f, 1114.15f, 1114.99f, 1115.83f, 1116.66f, 1117.48f, 1118.29f, 
1119.10f, 1119.90f, 1120.69f, 1121.48f, 1122.25f, 1123.02f, 1123.78f, 1124.53f, 
1125.27f, 1126.00f, 1126.72f, 1127.43f, 1128.13f, 1128.82f, 1129.50f, 1130.17f, 
1130.83f, 1131.48f, 1132.11f, 1132.74f, 1133.35f, 1133.95f, 1134.54f, 1135.11f, 
1135.68f, 1136.23f, 1136.77f, 1137.30f, 1137.81f, 1138.31f, 1138.80f, 1139.27f, 
1139.73f, 1140.18f, 1140.61f, 1141.03f, 1141.44f, 1141.83f, 1142.21f, 1142.58f, 
1142.93f, 1143.27f, 1143.59f, 1143.90f, 1144.20f, 1144.48f, 1144.74f, 1145.00f, 
1145.24f, 1145.46f, 1145.67f, 1145.87f, 1146.05f, 1146.21f, 1146.37f, 1146.50f, 
1146.63f, 1146.74f, 1146.83f, 1146.91f, 1146.98f, 1147.03f, 1147.06f, 1147.09f, 
1147.09f, 
  66.04f,   66.33f,   67.20f,   68.62f,   70.54f,   72.95f,   75.77f,   78.97f, 
  82.50f,   86.30f,   90.35f,   94.60f,   99.02f,  103.59f,  108.28f,  113.07f, 
 117.94f,  122.88f,  127.88f,  132.91f,  137.98f,  143.08f,  148.20f,  153.32f, 
 158.46f,  163.60f,  168.74f,  173.88f,  179.01f,  184.13f,  189.25f,  194.34f, 
 198.98f,  203.57f,  208.16f,  212.73f,  217.30f,  221.86f,  226.41f,  230.95f, 
 235.48f,  240.01f,  244.51f,  249.01f,  253.48f,  257.94f,  262.40f,  266.84f, 
 271.27f,  275.69f,  280.11f,  284.51f,  288.91f,  293.30f,  297.67f,  302.04f, 
 306.39f,  310.74f,  315.06f,  319.38f,  323.69f,  327.98f,  332.25f,  336.52f, 
 340.76f,  345.00f,  349.22f,  353.43f,  357.62f,  361.79f,  365.95f,  370.10f, 
 374.23f,  378.34f,  382.44f,  386.52f,  390.59f,  394.64f,  398.67f,  402.69f, 
 406.69f,  410.67f,  414.64f,  418.60f,  422.53f,  426.45f,  430.35f,  434.24f, 
 438.11f,  441.96f,  445.80f,  449.62f,  453.42f,  457.20f,  460.97f,  464.72f, 
 468.45f,  472.17f,  475.87f,  479.55f,  483.22f,  486.87f,  490.50f,  494.12f, 
 497.71f,  501.30f,  504.86f,  508.41f,  511.94f,  515.45f,  518.94f,  522.42f, 
 525.88f,  529.33f,  532.75f,  536.16f,  539.56f,  542.93f,  546.29f,  549.63f, 
 552.95f,  556.26f,  559.55f,  562.82f,  566.07f,  569.31f,  572.53f,  575.73f, 
 578.92f,  582.09f,  585.24f,  588.37f,  591.49f,  594.59f,  597.67f,  600.73f, 
 603.78f,  606.80f,  609.82f,  612.81f,  615.79f,  618.74f,  621.69f,  624.61f, 
 627.51f,  630.40f,  633.27f,  636.12f,  638.96f,  641.77f,  644.57f,  647.35f, 
 650.11f,  652.86f,  655.58f,  658.29f,  660.98f,  663.65f,  666.30f,  668.94f, 
 671.56f,  674.15f,  676.73f,  679.29f,  681.83f,  684.35f,  686.85f,  689.34f, 
 691.81f,  694.26f,  696.69f,  699.08f,  701.45f,  703.81f,  706.16f,  708.50f, 
 710.83f,  713.16f,  715.48f,  717.79f,  720.10f,  722.40f,  724.70f,  727.00f, 
 729.29f,  731.57f,  733.85f,  736.12f,  738.38f,  740.63f,  742.88f,  745.12f, 
 747.35f,  749.57f,  751.79f,  754.01f,  756.23f,  758.45f,  760.67f,  762.88f, 
 765.10f,  767.32f,  769.54f,  771.76f,  773.98f,  776.20f,  778.42f,  780.64f, 
 782.86f,  785.08f,  787.30f,  789.52f,  791.74f,  793.96f,  796.18f,  798.40f, 
 800.62f,  802.83f,  805.05f,  807.27f,  809.49f,  811.71f,  813.93f,  816.15f, 
 818.37f,  820.59f,  822.81f,  825.03f,  827.25f,  829.47f,  831.69f, 1058.46f, 
1059.42f, 1060.38f, 1061.34f, 1062.29f, 1063.25f, 1064.21f, 1065.16f, 1066.12f, 
1067.07f, 1068.03f, 1068.98f, 1069.94f, 1070.89f, 1071.84f, 1072.80f, 1073.75f, 
1074.70f, 1075.65f, 1076.60f, 1077.55f, 1078.50f, 1079.45f, 1080.40f, 1081.34f, 
1082.29f, 1083.23f, 1084.17f, 1085.12f, 1086.06f, 1087.00f, 1087.93f, 1088.87f, 
1089.80f, 1090.74f, 1091.67f, 1092.60f, 1093.52f, 1094.45f, 1095.37f, 1096.29f, 
1097.21f, 1098.13f, 1099.04f, 1099.95f, 1100.86f, 1101.76f, 1102.66f, 1103.56f, 
1104.46f, 1105.35f, 1106.23f, 1107.11f, 1107.99f, 1108.86f, 1109.73f, 1109.01f, 
1110.63f, 1112.20f, 1113.15f, 1113.99f, 1114.83f, 1115.65f, 1116.48f, 1117.29f, 
1118.10f, 1118.90f, 1119.69f, 1120.47f, 1121.25f, 1122.01f, 1122.77f, 1123.52f, 
1124.26f, 1124.99f, 1125.71f, 1126.42f, 1127.12f, 1127.82f, 1128.50f, 1129.16f, 
1129.82f, 1130.47f, 1131.10f, 1131.73f, 1132.34f, 1132.94f, 1133.53f, 1134.11f, 
1134.67f, 1135.22f, 1135.76f, 1136.28f, 1136.80f, 1137.30f, 1137.79f, 1138.26f, 
1138.72f, 1139.17f, 1139.60f, 1140.02f, 1140.43f, 1140.82f, 1141.20f, 1141.56f, 
1141.92f, 1142.25f, 1142.58f, 1142.89f, 1143.18f, 1143.46f, 1143.73f, 1143.98f, 
1144.22f, 1144.45f, 1144.66f, 1144.85f, 1145.03f, 1145.20f, 1145.35f, 1145.49f, 
1145.61f, 1145.72f, 1145.82f, 1145.90f, 1145.96f, 1146.01f, 1146.05f, 1146.07f, 
1146.08f, 
  67.05f,   67.34f,   68.19f,   69.58f,   71.46f,   73.82f,   76.59f,   79.74f, 
  83.21f,   86.96f,   90.95f,   95.15f,   99.52f,  104.04f,  108.68f,  113.42f, 
 118.25f,  123.15f,  128.10f,  133.10f,  138.14f,  143.20f,  148.29f,  153.39f, 
 158.49f,  163.61f,  168.72f,  173.84f,  178.94f,  184.04f,  189.13f,  193.94f, 
 198.53f,  203.12f,  207.70f,  212.27f,  216.84f,  221.40f,  225.94f,  230.48f, 
 235.01f,  239.52f,  244.03f,  248.51f,  252.98f,  257.44f,  261.89f,  266.33f, 
 270.76f,  275.18f,  279.59f,  283.99f,  288.39f,  292.77f,  297.14f,  301.51f, 
 305.86f,  310.19f,  314.52f,  318.83f,  323.13f,  327.42f,  331.69f,  335.95f, 
 340.20f,  344.43f,  348.64f,  352.84f,  357.03f,  361.20f,  365.36f,  369.50f, 
 373.62f,  377.73f,  381.83f,  385.90f,  389.97f,  394.01f,  398.04f,  402.06f, 
 406.05f,  410.04f,  414.00f,  417.95f,  421.88f,  425.80f,  429.69f,  433.58f, 
 437.44f,  441.29f,  445.12f,  448.94f,  452.74f,  456.52f,  460.28f,  464.03f, 
 467.76f,  471.47f,  475.17f,  478.85f,  482.51f,  486.16f,  489.79f,  493.40f, 
 496.99f,  500.57f,  504.13f,  507.67f,  511.20f,  514.71f,  518.20f,  521.68f, 
 525.13f,  528.57f,  532.00f,  535.40f,  538.79f,  542.17f,  545.52f,  548.86f, 
 552.18f,  555.48f,  558.77f,  562.04f,  565.29f,  568.52f,  571.74f,  574.94f, 
 578.12f,  581.29f,  584.44f,  587.57f,  590.68f,  593.78f,  596.86f,  599.92f, 
 602.96f,  605.99f,  609.00f,  611.99f,  614.96f,  617.92f,  620.85f,  623.78f, 
 626.68f,  629.56f,  632.43f,  635.28f,  638.11f,  640.93f,  643.72f,  646.50f, 
 649.26f,  652.00f,  654.73f,  657.43f,  660.12f,  662.79f,  665.44f,  668.07f, 
 670.68f,  673.28f,  675.86f,  678.41f,  680.95f,  683.47f,  685.97f,  688.45f, 
 690.92f,  693.37f,  695.79f,  698.19f,  700.55f,  702.91f,  705.26f,  707.60f, 
 709.93f,  712.25f,  714.57f,  716.89f,  719.19f,  721.50f,  723.80f,  726.09f, 
 728.38f,  730.66f,  732.94f,  735.21f,  737.47f,  739.72f,  741.97f,  744.21f, 
 746.43f,  748.66f,  750.87f,  753.09f,  755.31f,  757.53f,  759.75f,  761.97f, 
 764.19f,  766.41f,  768.63f,  770.85f,  773.07f,  775.29f,  777.51f,  779.73f, 
 781.95f,  784.17f,  786.39f,  788.61f,  790.83f,  793.04f,  795.26f,  797.48f, 
 799.70f,  801.92f,  804.14f,  806.36f,  808.58f,  810.80f,  813.02f,  815.24f, 
 817.46f,  819.68f,  821.90f,  824.12f,  826.34f,  828.56f,  830.78f, 1057.47f, 
1058.43f, 1059.38f, 1060.34f, 1061.30f, 1062.25f, 1063.21f, 1064.17f, 1065.12f, 
1066.08f, 1067.03f, 1067.99f, 1068.94f, 1069.90f, 1070.85f, 1071.80f, 1072.75f, 
1073.71f, 1074.66f, 1075.61f, 1076.56f, 1077.51f, 1078.45f, 1079.40f, 1080.35f, 
1081.29f, 1082.24f, 1083.18f, 1084.12f, 1085.06f, 1086.00f, 1086.94f, 1087.87f, 
1088.81f, 1089.74f, 1090.67f, 1091.60f, 1092.53f, 1093.45f, 1094.38f, 1095.30f, 
1096.22f, 1097.13f, 1098.05f, 1098.96f, 1099.86f, 1100.77f, 1101.67f, 1102.57f, 
1103.46f, 1104.35f, 1105.23f, 1106.12f, 1106.99f, 1107.87f, 1106.37f, 1108.05f, 
1109.67f, 1111.23f, 1112.15f, 1112.99f, 1113.83f, 1114.66f, 1115.48f, 1116.29f, 
1117.10f, 1117.90f, 1118.69f, 1119.47f, 1120.25f, 1121.01f, 1121.77f, 1122.52f, 
1123.26f, 1123.99f, 1124.71f, 1125.42f, 1126.12f, 1126.81f, 1127.49f, 1128.16f, 
1128.82f, 1129.46f, 1130.10f, 1130.72f, 1131.34f, 1131.94f, 1132.52f, 1133.10f, 
1133.66f, 1134.21f, 1134.75f, 1135.28f, 1135.79f, 1136.29f, 1136.78f, 1137.25f, 
1137.71f, 1138.16f, 1138.59f, 1139.01f, 1139.42f, 1139.81f, 1140.19f, 1140.55f, 
1140.91f, 1141.24f, 1141.57f, 1141.88f, 1142.17f, 1142.45f, 1142.72f, 1142.97f, 
1143.21f, 1143.43f, 1143.64f, 1143.84f, 1144.02f, 1144.19f, 1144.34f, 1144.48f, 
1144.60f, 1144.71f, 1144.80f, 1144.88f, 1144.95f, 1145.00f, 1145.04f, 1145.06f, 
1145.07f, 
  68.06f,   68.34f,   69.18f,   70.53f,   72.38f,   74.69f,   77.42f,   80.51f, 
  83.93f,   87.62f,   91.56f,   95.70f,  100.02f,  104.49f,  109.08f,  113.78f, 
 118.57f,  123.42f,  128.34f,  133.30f,  138.30f,  143.33f,  148.39f,  153.45f, 
 158.53f,  163.62f,  168.71f,  173.80f,  178.88f,  183.96f,  188.90f,  193.50f, 
 198.09f,  202.68f,  207.25f,  211.82f,  216.39f,  220.94f,  225.48f,  230.02f, 
 234.54f,  239.05f,  243.55f,  248.03f,  252.50f,  256.95f,  261.39f,  265.83f, 
 270.25f,  274.67f,  279.08f,  283.48f,  287.87f,  292.25f,  296.62f,  300.98f, 
 305.33f,  309.66f,  313.98f,  318.29f,  322.59f,  326.87f,  331.14f,  335.39f, 
 339.63f,  343.86f,  348.07f,  352.27f,  356.45f,  360.62f,  364.77f,  368.91f, 
 373.03f,  377.13f,  381.22f,  385.30f,  389.35f,  393.40f,  397.42f,  401.43f, 
 405.42f,  409.40f,  413.36f,  417.31f,  421.24f,  425.15f,  429.04f,  432.92f, 
 436.78f,  440.63f,  444.45f,  448.27f,  452.06f,  455.84f,  459.60f,  463.34f, 
 467.07f,  470.78f,  474.47f,  478.15f,  481.81f,  485.45f,  489.07f,  492.68f, 
 496.27f,  499.85f,  503.41f,  506.95f,  510.47f,  513.97f,  517.46f,  520.94f, 
 524.39f,  527.83f,  531.25f,  534.65f,  538.04f,  541.41f,  544.76f,  548.09f, 
 551.41f,  554.71f,  558.00f,  561.26f,  564.51f,  567.74f,  570.96f,  574.15f, 
 577.33f,  580.50f,  583.64f,  586.77f,  589.88f,  592.97f,  596.05f,  599.11f, 
 602.15f,  605.17f,  608.18f,  611.17f,  614.14f,  617.09f,  620.03f,  622.95f, 
 625.85f,  628.73f,  631.59f,  634.44f,  637.27f,  640.08f,  642.88f,  645.65f, 
 648.41f,  651.15f,  653.87f,  656.57f,  659.26f,  661.93f,  664.57f,  667.20f, 
 669.82f,  672.41f,  674.98f,  677.54f,  680.07f,  682.59f,  685.09f,  687.57f, 
 690.03f,  692.48f,  694.90f,  697.29f,  699.66f,  702.02f,  704.36f,  706.70f, 
 709.03f,  711.36f,  713.67f,  715.99f,  718.30f,  720.60f,  722.90f,  725.19f, 
 727.48f,  729.76f,  732.04f,  734.30f,  736.56f,  738.82f,  741.06f,  743.30f, 
 745.53f,  747.75f,  749.97f,  752.19f,  754.41f,  756.62f,  758.84f,  761.06f, 
 763.28f,  765.50f,  767.72f,  769.94f,  772.16f,  774.38f,  776.60f,  778.82f, 
 781.04f,  783.26f,  785.48f,  787.70f,  789.92f,  792.14f,  794.36f,  796.58f, 
 798.79f,  801.01f,  803.23f,  805.45f,  807.67f,  809.89f,  812.11f,  814.33f, 
 816.55f,  818.77f,  820.99f,  823.21f,  825.43f,  827.65f,  829.87f, 1056.48f, 
1057.44f, 1058.39f, 1059.35f, 1060.31f, 1061.26f, 1062.22f, 1063.18f, 1064.13f, 
1065.09f, 1066.04f, 1067.00f, 1067.95f, 1068.91f, 1069.86f, 1070.81f, 1071.76f, 
1072.72f, 1073.67f, 1074.62f, 1075.57f, 1076.51f, 1077.46f, 1078.41f, 1079.36f, 
1080.30f, 1081.24f, 1082.19f, 1083.13f, 1084.07f, 1085.01f, 1085.95f, 1086.88f, 
1087.82f, 1088.75f, 1089.68f, 1090.61f, 1091.54f, 1092.46f, 1093.39f, 1094.31f, 
1095.22f, 1096.14f, 1097.05f, 1097.96f, 1098.87f, 1099.77f, 1100.67f, 1101.57f, 
1102.47f, 1103.36f, 1104.24f, 1105.12f, 1106.00f, 1106.87f, 1105.42f, 1107.10f, 
1108.71f, 1110.27f, 1111.16f, 1112.00f, 1112.83f, 1113.66f, 1114.48f, 1115.29f, 
1116.10f, 1116.90f, 1117.69f, 1118.47f, 1119.25f, 1120.02f, 1120.77f, 1121.52f, 
1122.26f, 1122.99f, 1123.71f, 1124.42f, 1125.12f, 1125.81f, 1126.49f, 1127.16f, 
1127.82f, 1128.46f, 1129.10f, 1129.72f, 1130.33f, 1130.93f, 1131.52f, 1132.10f, 
1132.66f, 1133.21f, 1133.75f, 1134.27f, 1134.79f, 1135.29f, 1135.77f, 1136.25f, 
1136.71f, 1137.15f, 1137.59f, 1138.01f, 1138.41f, 1138.80f, 1139.18f, 1139.55f, 
1139.90f, 1140.24f, 1140.56f, 1140.87f, 1141.16f, 1141.45f, 1141.71f, 1141.96f, 
1142.20f, 1142.43f, 1142.64f, 1142.83f, 1143.01f, 1143.18f, 1143.33f, 1143.47f, 
1143.59f, 1143.70f, 1143.80f, 1143.88f, 1143.94f, 1143.99f, 1144.03f, 1144.05f, 
1144.06f, 
  69.06f,   69.34f,   70.16f,   71.49f,   73.30f,   75.57f,   78.24f,   81.29f, 
  84.65f,   88.29f,   92.17f,   96.26f,  100.53f,  104.95f,  109.50f,  114.15f, 
 118.89f,  123.71f,  128.58f,  133.51f,  138.48f,  143.47f,  148.49f,  153.53f, 
 158.58f,  163.64f,  168.71f,  173.77f,  178.83f,  183.88f,  188.48f,  193.07f, 
 197.66f,  202.24f,  206.82f,  211.38f,  215.94f,  220.49f,  225.03f,  229.56f, 
 234.08f,  238.59f,  243.08f,  247.55f,  252.01f,  256.47f,  260.91f,  265.34f, 
 269.76f,  274.17f,  278.58f,  282.98f,  287.36f,  291.74f,  296.11f,  300.46f, 
 304.80f,  309.13f,  313.45f,  317.76f,  322.05f,  326.33f,  330.59f,  334.84f, 
 339.08f,  343.30f,  347.51f,  351.70f,  355.88f,  360.04f,  364.19f,  368.32f, 
 372.44f,  376.54f,  380.62f,  384.69f,  388.75f,  392.78f,  396.81f,  400.81f, 
 404.80f,  408.77f,  412.73f,  416.67f,  420.60f,  424.50f,  428.39f,  432.27f, 
 436.13f,  439.97f,  443.79f,  447.60f,  451.39f,  455.16f,  458.92f,  462.66f, 
 466.38f,  470.09f,  473.78f,  477.45f,  481.11f,  484.75f,  488.37f,  491.97f, 
 495.56f,  499.13f,  502.69f,  506.22f,  509.74f,  513.25f,  516.73f,  520.20f, 
 523.65f,  527.09f,  530.50f,  533.90f,  537.29f,  540.65f,  544.00f,  547.34f, 
 550.65f,  553.95f,  557.23f,  560.49f,  563.74f,  566.97f,  570.18f,  573.37f, 
 576.55f,  579.71f,  582.85f,  585.98f,  589.08f,  592.18f,  595.25f,  598.30f, 
 601.34f,  604.36f,  607.37f,  610.35f,  613.32f,  616.27f,  619.21f,  622.12f, 
 625.02f,  627.90f,  630.76f,  633.61f,  636.44f,  639.24f,  642.04f,  644.81f, 
 647.56f,  650.30f,  653.02f,  655.72f,  658.40f,  661.07f,  663.72f,  666.34f, 
 668.95f,  671.54f,  674.12f,  676.67f,  679.20f,  681.72f,  684.21f,  686.69f, 
 689.15f,  691.60f,  694.02f,  696.40f,  698.77f,  701.13f,  703.47f,  705.81f, 
 708.14f,  710.46f,  712.78f,  715.09f,  717.40f,  719.70f,  722.00f,  724.29f, 
 726.58f,  728.86f,  731.14f,  733.40f,  735.66f,  737.92f,  740.16f,  742.40f, 
 744.62f,  746.84f,  749.06f,  751.28f,  753.50f,  755.72f,  757.94f,  760.16f, 
 762.38f,  764.60f,  766.82f,  769.04f,  771.26f,  773.48f,  775.70f,  777.92f, 
 780.13f,  782.35f,  784.57f,  786.79f,  789.01f,  791.23f,  793.45f,  795.67f, 
 797.89f,  800.11f,  802.33f,  804.55f,  806.77f,  808.99f,  811.21f,  813.43f, 
 815.65f,  817.87f,  820.09f,  822.30f,  824.52f,  826.74f,  828.96f, 1055.49f, 
1056.45f, 1057.41f, 1058.36f, 1059.32f, 1060.28f, 1061.23f, 1062.19f, 1063.14f, 
1064.10f, 1065.05f, 1066.01f, 1066.96f, 1067.92f, 1068.87f, 1069.82f, 1070.78f, 
1071.73f, 1072.68f, 1073.63f, 1074.58f, 1075.53f, 1076.47f, 1077.42f, 1078.37f, 
1079.31f, 1080.26f, 1081.20f, 1082.14f, 1083.08f, 1084.02f, 1084.96f, 1085.89f, 
1086.83f, 1087.76f, 1088.69f, 1089.62f, 1090.55f, 1091.47f, 1092.40f, 1093.32f, 
1094.24f, 1095.15f, 1096.06f, 1096.97f, 1097.88f, 1098.78f, 1099.69f, 1100.58f, 
1101.48f, 1102.37f, 1103.25f, 1104.13f, 1105.01f, 1105.88f, 1104.48f, 1106.15f, 
1107.75f, 1109.31f, 1110.17f, 1111.01f, 1111.84f, 1112.67f, 1113.49f, 1114.30f, 
1115.11f, 1115.91f, 1116.70f, 1117.48f, 1118.26f, 1119.02f, 1119.78f, 1120.53f, 
1121.27f, 1122.00f, 1122.72f, 1123.43f, 1124.13f, 1124.82f, 1125.50f, 1126.16f, 
1126.82f, 1127.47f, 1128.10f, 1128.72f, 1129.34f, 1129.94f, 1130.52f, 1131.10f, 
1131.66f, 1132.21f, 1132.75f, 1133.27f, 1133.79f, 1134.29f, 1134.77f, 1135.25f, 
1135.71f, 1136.15f, 1136.58f, 1137.00f, 1137.41f, 1137.80f, 1138.18f, 1138.55f, 
1138.90f, 1139.23f, 1139.56f, 1139.87f, 1140.16f, 1140.44f, 1140.71f, 1140.96f, 
1141.20f, 1141.42f, 1141.63f, 1141.83f, 1142.01f, 1142.17f, 1142.33f, 1142.46f, 
1142.59f, 1142.70f, 1142.79f, 1142.87f, 1142.94f, 1142.99f, 1143.02f, 1143.04f, 
1143.05f, 
  70.07f,   70.34f,   71.14f,   72.44f,   74.22f,   76.44f,   79.07f,   82.06f, 
  85.37f,   88.96f,   92.79f,   96.83f,  101.05f,  105.42f,  109.92f,  114.53f, 
 119.23f,  124.00f,  128.84f,  133.73f,  138.66f,  143.62f,  148.61f,  153.62f, 
 158.64f,  163.67f,  168.71f,  173.75f,  178.78f,  183.46f,  188.06f,  192.65f, 
 197.24f,  201.82f,  206.39f,  210.95f,  215.51f,  220.05f,  224.59f,  229.12f, 
 233.63f,  238.13f,  242.62f,  247.08f,  251.54f,  255.99f,  260.43f,  264.85f, 
 269.27f,  273.69f,  278.09f,  282.48f,  286.87f,  291.24f,  295.60f,  299.95f, 
 304.29f,  308.62f,  312.93f,  317.23f,  321.52f,  325.79f,  330.05f,  334.30f, 
 338.53f,  342.75f,  346.95f,  351.14f,  355.31f,  359.47f,  363.61f,  367.74f, 
 371.85f,  375.95f,  380.03f,  384.10f,  388.15f,  392.18f,  396.20f,  400.20f, 
 404.18f,  408.15f,  412.11f,  416.04f,  419.96f,  423.87f,  427.75f,  431.62f, 
 435.48f,  439.31f,  443.14f,  446.94f,  450.73f,  454.50f,  458.25f,  461.98f, 
 465.70f,  469.41f,  473.09f,  476.76f,  480.41f,  484.05f,  487.67f,  491.27f, 
 494.85f,  498.42f,  501.97f,  505.51f,  509.02f,  512.52f,  516.00f,  519.47f, 
 522.92f,  526.35f,  529.76f,  533.16f,  536.54f,  539.91f,  543.25f,  546.58f, 
 549.89f,  553.19f,  556.46f,  559.72f,  562.97f,  566.19f,  569.40f,  572.59f, 
 575.77f,  578.93f,  582.07f,  585.19f,  588.29f,  591.38f,  594.45f,  597.51f, 
 600.54f,  603.56f,  606.56f,  609.54f,  612.51f,  615.46f,  618.39f,  621.30f, 
 624.20f,  627.08f,  629.94f,  632.78f,  635.60f,  638.41f,  641.20f,  643.97f, 
 646.72f,  649.46f,  652.18f,  654.87f,  657.55f,  660.22f,  662.86f,  665.49f, 
 668.09f,  670.68f,  673.25f,  675.80f,  678.33f,  680.85f,  683.34f,  685.82f, 
 688.28f,  690.72f,  693.14f,  695.52f,  697.89f,  700.24f,  702.58f,  704.92f, 
 707.25f,  709.57f,  711.89f,  714.20f,  716.51f,  718.81f,  721.11f,  723.40f, 
 725.69f,  727.97f,  730.24f,  732.51f,  734.77f,  737.02f,  739.26f,  741.50f, 
 743.72f,  745.94f,  748.16f,  750.38f,  752.60f,  754.82f,  757.04f,  759.26f, 
 761.48f,  763.70f,  765.92f,  768.14f,  770.36f,  772.58f,  774.80f,  777.02f, 
 779.23f,  781.45f,  783.67f,  785.89f,  788.11f,  790.33f,  792.55f,  794.77f, 
 796.99f,  799.21f,  801.43f,  803.65f,  805.87f,  808.09f,  810.31f,  812.53f, 
 814.75f,  816.97f,  819.19f,  821.40f,  823.62f,  825.84f,  828.06f, 1054.51f, 
1055.47f, 1056.42f, 1057.38f, 1058.34f, 1059.29f, 1060.25f, 1061.20f, 1062.16f, 
1063.12f, 1064.07f, 1065.03f, 1065.98f, 1066.93f, 1067.89f, 1068.84f, 1069.79f, 
1070.74f, 1071.69f, 1072.64f, 1073.59f, 1074.54f, 1075.49f, 1076.44f, 1077.38f, 
1078.33f, 1079.27f, 1080.22f, 1081.16f, 1082.10f, 1083.04f, 1083.97f, 1084.91f, 
1085.84f, 1086.78f, 1087.71f, 1088.64f, 1089.56f, 1090.49f, 1091.41f, 1092.33f, 
1093.25f, 1094.17f, 1095.08f, 1095.99f, 1096.90f, 1097.80f, 1098.70f, 1099.60f, 
1100.49f, 1101.38f, 1102.26f, 1103.15f, 1104.02f, 1104.90f, 1103.53f, 1105.20f, 
1106.80f, 1108.33f, 1109.18f, 1110.02f, 1110.85f, 1111.68f, 1112.50f, 1113.31f, 
1114.12f, 1114.92f, 1115.71f, 1116.49f, 1117.27f, 1118.03f, 1118.79f, 1119.54f, 
1120.28f, 1121.01f, 1121.73f, 1122.43f, 1123.13f, 1123.82f, 1124.50f, 1125.17f, 
1125.83f, 1126.47f, 1127.11f, 1127.73f, 1128.34f, 1128.94f, 1129.53f, 1130.10f, 
1130.67f, 1131.22f, 1131.75f, 1132.28f, 1132.79f, 1133.29f, 1133.77f, 1134.25f, 
1134.71f, 1135.15f, 1135.59f, 1136.01f, 1136.41f, 1136.80f, 1137.18f, 1137.55f, 
1137.90f, 1138.23f, 1138.56f, 1138.87f, 1139.16f, 1139.44f, 1139.71f, 1139.96f, 
1140.20f, 1140.42f, 1140.63f, 1140.83f, 1141.01f, 1141.17f, 1141.33f, 1141.46f, 
1141.59f, 1141.69f, 1141.79f, 1141.87f, 1141.93f, 1141.98f, 1142.02f, 1142.04f, 
1142.05f, 
  71.06f,   71.33f,   72.12f,   73.39f,   75.13f,   77.32f,   79.90f,   82.85f, 
  86.10f,   89.64f,   93.42f,   97.41f,  101.58f,  105.90f,  110.35f,  114.91f, 
 119.57f,  124.30f,  129.10f,  133.95f,  138.85f,  143.78f,  148.74f,  153.72f, 
 158.71f,  163.71f,  168.72f,  173.73f,  178.46f,  183.06f,  187.66f,  192.25f, 
 196.83f,  201.41f,  205.97f,  210.53f,  215.09f,  219.63f,  224.16f,  228.68f, 
 233.19f,  237.68f,  242.16f,  246.63f,  251.08f,  255.52f,  259.96f,  264.38f, 
 268.80f,  273.21f,  277.61f,  282.00f,  286.38f,  290.75f,  295.10f,  299.45f, 
 303.78f,  308.11f,  312.41f,  316.71f,  320.99f,  325.26f,  329.52f,  333.76f, 
 337.99f,  342.20f,  346.40f,  350.58f,  354.75f,  358.91f,  363.05f,  367.17f, 
 371.28f,  375.37f,  379.45f,  383.51f,  387.55f,  391.58f,  395.60f,  399.59f, 
 403.57f,  407.54f,  411.49f,  415.42f,  419.34f,  423.24f,  427.12f,  430.98f, 
 434.83f,  438.67f,  442.48f,  446.28f,  450.07f,  453.83f,  457.58f,  461.31f, 
 465.03f,  468.73f,  472.41f,  476.08f,  479.73f,  483.36f,  486.97f,  490.57f, 
 494.15f,  497.72f,  501.26f,  504.79f,  508.31f,  511.80f,  515.28f,  518.75f, 
 522.19f,  525.62f,  529.03f,  532.42f,  535.80f,  539.16f,  542.50f,  545.83f, 
 549.14f,  552.43f,  555.71f,  558.96f,  562.20f,  565.43f,  568.63f,  571.82f, 
 574.99f,  578.15f,  581.28f,  584.40f,  587.51f,  590.59f,  593.66f,  596.71f, 
 599.74f,  602.76f,  605.76f,  608.74f,  611.70f,  614.65f,  617.58f,  620.49f, 
 623.38f,  626.26f,  629.11f,  631.95f,  634.78f,  637.58f,  640.37f,  643.14f, 
 645.89f,  648.62f,  651.33f,  654.03f,  656.71f,  659.37f,  662.01f,  664.63f, 
 667.24f,  669.83f,  672.39f,  674.94f,  677.47f,  679.98f,  682.47f,  684.95f, 
 687.41f,  689.85f,  692.26f,  694.64f,  697.00f,  699.36f,  701.70f,  704.04f, 
 706.36f,  708.69f,  711.00f,  713.31f,  715.62f,  717.92f,  720.22f,  722.51f, 
 724.80f,  727.08f,  729.35f,  731.62f,  733.87f,  736.12f,  738.37f,  740.60f, 
 742.83f,  745.05f,  747.27f,  749.49f,  751.71f,  753.92f,  756.14f,  758.36f, 
 760.58f,  762.80f,  765.02f,  767.24f,  769.46f,  771.68f,  773.90f,  776.12f, 
 778.34f,  780.56f,  782.78f,  785.00f,  787.22f,  789.44f,  791.66f,  793.88f, 
 796.09f,  798.31f,  800.53f,  802.75f,  804.97f,  807.19f,  809.41f,  811.63f, 
 813.85f,  816.07f,  818.29f,  820.51f,  822.73f,  824.95f,  827.17f, 1053.53f, 
1054.48f, 1055.44f, 1056.40f, 1057.36f, 1058.31f, 1059.27f, 1060.22f, 1061.18f, 
1062.14f, 1063.09f, 1064.05f, 1065.00f, 1065.95f, 1066.91f, 1067.86f, 1068.81f, 
1069.76f, 1070.71f, 1071.66f, 1072.61f, 1073.56f, 1074.51f, 1075.46f, 1076.40f, 
1077.35f, 1078.29f, 1079.23f, 1080.18f, 1081.12f, 1082.06f, 1082.99f, 1083.93f, 
1084.86f, 1085.80f, 1086.73f, 1087.66f, 1088.58f, 1089.51f, 1090.43f, 1091.35f, 
1092.27f, 1093.18f, 1094.10f, 1095.01f, 1095.91f, 1096.82f, 1097.72f, 1098.61f, 
1099.51f, 1100.40f, 1101.28f, 1102.16f, 1103.04f, 1103.91f, 1102.59f, 1104.25f, 
1105.85f, 1107.35f, 1108.19f, 1109.03f, 1109.87f, 1110.69f, 1111.51f, 1112.33f, 
1113.13f, 1113.93f, 1114.72f, 1115.50f, 1116.28f, 1117.04f, 1117.80f, 1118.55f, 
1119.29f, 1120.02f, 1120.74f, 1121.45f, 1122.15f, 1122.83f, 1123.51f, 1124.18f, 
1124.84f, 1125.48f, 1126.12f, 1126.74f, 1127.35f, 1127.95f, 1128.54f, 1129.11f, 
1129.67f, 1130.22f, 1130.76f, 1131.28f, 1131.80f, 1132.30f, 1132.78f, 1133.25f, 
1133.71f, 1134.16f, 1134.59f, 1135.01f, 1135.42f, 1135.81f, 1136.19f, 1136.55f, 
1136.90f, 1137.24f, 1137.56f, 1137.87f, 1138.16f, 1138.44f, 1138.71f, 1138.96f, 
1139.20f, 1139.42f, 1139.63f, 1139.83f, 1140.01f, 1140.18f, 1140.33f, 1140.46f, 
1140.59f, 1140.70f, 1140.79f, 1140.87f, 1140.94f, 1140.99f, 1141.02f, 1141.04f, 
1141.05f, 
  72.06f,   72.32f,   73.09f,   74.34f,   76.05f,   78.19f,   80.73f,   83.63f, 
  86.84f,   90.32f,   94.05f,   97.99f,  102.11f,  106.38f,  110.79f,  115.31f, 
 119.92f,  124.61f,  129.37f,  134.19f,  139.05f,  143.95f,  148.87f,  153.82f, 
 158.78f,  163.76f,  168.74f,  173.47f,  178.07f,  182.67f,  187.26f,  191.85f, 
 196.43f,  201.00f,  205.57f,  210.12f,  214.67f,  219.21f,  223.73f,  228.25f, 
 232.75f,  237.24f,  241.71f,  246.17f,  250.62f,  255.06f,  259.49f,  263.92f, 
 268.33f,  272.73f,  277.13f,  281.52f,  285.89f,  290.26f,  294.61f,  298.95f, 
 303.28f,  307.60f,  311.91f,  316.20f,  320.48f,  324.74f,  328.99f,  333.23f, 
 337.45f,  341.66f,  345.86f,  350.04f,  354.20f,  358.35f,  362.48f,  366.60f, 
 370.71f,  374.79f,  378.87f,  382.92f,  386.97f,  390.99f,  395.00f,  398.99f, 
 402.97f,  406.93f,  410.87f,  414.80f,  418.71f,  422.61f,  426.49f,  430.35f, 
 434.20f,  438.03f,  441.84f,  445.63f,  449.41f,  453.18f,  456.92f,  460.65f, 
 464.36f,  468.06f,  471.74f,  475.40f,  479.04f,  482.67f,  486.28f,  489.88f, 
 493.46f,  497.02f,  500.56f,  504.09f,  507.60f,  511.09f,  514.57f,  518.03f, 
 521.47f,  524.89f,  528.30f,  531.69f,  535.07f,  538.42f,  541.76f,  545.09f, 
 548.39f,  551.68f,  554.95f,  558.21f,  561.44f,  564.66f,  567.87f,  571.05f, 
 574.22f,  577.37f,  580.51f,  583.63f,  586.72f,  589.81f,  592.87f,  595.92f, 
 598.95f,  601.96f,  604.96f,  607.94f,  610.90f,  613.84f,  616.77f,  619.68f, 
 622.57f,  625.44f,  628.30f,  631.13f,  633.95f,  636.76f,  639.54f,  642.31f, 
 645.05f,  647.78f,  650.50f,  653.19f,  655.87f,  658.52f,  661.16f,  663.79f, 
 666.39f,  668.97f,  671.54f,  674.08f,  676.61f,  679.12f,  681.61f,  684.08f, 
 686.54f,  688.98f,  691.39f,  693.76f,  696.13f,  698.48f,  700.82f,  703.16f, 
 705.48f,  707.81f,  710.12f,  712.43f,  714.74f,  717.04f,  719.33f,  721.63f, 
 723.91f,  726.19f,  728.46f,  730.73f,  732.99f,  735.24f,  737.48f,  739.71f, 
 741.94f,  744.16f,  746.37f,  748.59f,  750.81f,  753.03f,  755.25f,  757.47f, 
 759.69f,  761.91f,  764.13f,  766.35f,  768.57f,  770.79f,  773.01f,  775.23f, 
 777.45f,  779.67f,  781.89f,  784.11f,  786.33f,  788.54f,  790.76f,  792.98f, 
 795.20f,  797.42f,  799.64f,  801.86f,  804.08f,  806.30f,  808.52f,  810.74f, 
 812.96f,  815.18f,  817.40f,  819.62f,  821.84f,  824.06f,  826.28f, 1052.55f, 
1053.51f, 1054.47f, 1055.42f, 1056.38f, 1057.34f, 1058.29f, 1059.25f, 1060.20f, 
1061.16f, 1062.11f, 1063.07f, 1064.02f, 1064.98f, 1065.93f, 1066.88f, 1067.83f, 
1068.79f, 1069.74f, 1070.69f, 1071.64f, 1072.59f, 1073.53f, 1074.48f, 1075.43f, 
1076.37f, 1077.31f, 1078.26f, 1079.20f, 1080.14f, 1081.08f, 1082.02f, 1082.95f, 
1083.89f, 1084.82f, 1085.75f, 1086.68f, 1087.60f, 1088.53f, 1089.45f, 1090.37f, 
1091.29f, 1092.21f, 1093.12f, 1094.03f, 1094.93f, 1095.84f, 1096.74f, 1097.63f, 
1098.53f, 1099.42f, 1100.30f, 1101.18f, 1102.06f, 1102.93f, 1101.66f, 1103.31f, 
1104.91f, 1106.37f, 1107.21f, 1108.05f, 1108.89f, 1109.71f, 1110.53f, 1111.35f, 
1112.15f, 1112.95f, 1113.74f, 1114.52f, 1115.30f, 1116.06f, 1116.82f, 1117.57f, 
1118.30f, 1119.03f, 1119.75f, 1120.46f, 1121.16f, 1121.85f, 1122.53f, 1123.19f, 
1123.85f, 1124.50f, 1125.13f, 1125.75f, 1126.36f, 1126.96f, 1127.55f, 1128.12f, 
1128.68f, 1129.23f, 1129.77f, 1130.29f, 1130.81f, 1131.30f, 1131.79f, 1132.26f, 
1132.72f, 1133.17f, 1133.60f, 1134.02f, 1134.42f, 1134.82f, 1135.19f, 1135.56f, 
1135.91f, 1136.24f, 1136.57f, 1136.88f, 1137.17f, 1137.45f, 1137.72f, 1137.97f, 
1138.21f, 1138.43f, 1138.64f, 1138.83f, 1139.01f, 1139.18f, 1139.33f, 1139.47f, 
1139.59f, 1139.70f, 1139.80f, 1139.87f, 1139.94f, 1139.99f, 1140.03f, 1140.05f, 
1140.06f, 
  73.05f,   73.31f,   74.06f,   75.29f,   76.97f,   79.07f,   81.57f,   84.42f, 
  87.57f,   91.01f,   94.69f,   98.58f,  102.65f,  106.87f,  111.23f,  115.71f, 
 120.28f,  124.93f,  129.66f,  134.43f,  139.26f,  144.12f,  149.02f,  153.93f, 
 158.87f,  163.82f,  168.49f,  173.09f,  177.69f,  182.29f,  186.88f,  191.46f, 
 196.04f,  200.61f,  205.17f,  209.72f,  214.27f,  218.80f,  223.32f,  227.83f, 
 232.33f,  236.81f,  241.28f,  245.73f,  250.18f,  254.61f,  259.04f,  263.46f, 
 267.87f,  272.27f,  276.66f,  281.05f,  285.42f,  289.78f,  294.13f,  298.47f, 
 302.79f,  307.11f,  311.41f,  315.69f,  319.97f,  324.23f,  328.48f,  332.71f, 
 336.93f,  341.13f,  345.32f,  349.50f,  353.66f,  357.80f,  361.93f,  366.04f, 
 370.14f,  374.23f,  378.30f,  382.35f,  386.38f,  390.40f,  394.41f,  398.40f, 
 402.37f,  406.33f,  410.27f,  414.19f,  418.10f,  421.99f,  425.87f,  429.72f, 
 433.57f,  437.39f,  441.20f,  444.99f,  448.77f,  452.52f,  456.27f,  459.99f, 
 463.70f,  467.39f,  471.07f,  474.73f,  478.37f,  481.99f,  485.60f,  489.19f, 
 492.76f,  496.32f,  499.86f,  503.39f,  506.89f,  510.38f,  513.85f,  517.31f, 
 520.75f,  524.17f,  527.58f,  530.96f,  534.34f,  537.69f,  541.03f,  544.35f, 
 547.65f,  550.93f,  554.20f,  557.45f,  560.69f,  563.91f,  567.11f,  570.29f, 
 573.46f,  576.60f,  579.74f,  582.85f,  585.95f,  589.03f,  592.09f,  595.14f, 
 598.16f,  601.17f,  604.17f,  607.14f,  610.10f,  613.04f,  615.97f,  618.87f, 
 621.76f,  624.63f,  627.48f,  630.32f,  633.14f,  635.93f,  638.72f,  641.48f, 
 644.23f,  646.95f,  649.66f,  652.36f,  655.03f,  657.68f,  660.32f,  662.94f, 
 665.54f,  668.12f,  670.69f,  673.23f,  675.75f,  678.26f,  680.75f,  683.22f, 
 685.68f,  688.11f,  690.52f,  692.89f,  695.25f,  697.60f,  699.94f,  702.28f, 
 704.61f,  706.93f,  709.24f,  711.55f,  713.86f,  716.16f,  718.45f,  720.74f, 
 723.03f,  725.31f,  727.58f,  729.85f,  732.10f,  734.35f,  736.59f,  738.82f, 
 741.05f,  743.27f,  745.49f,  747.71f,  749.93f,  752.15f,  754.36f,  756.58f, 
 758.80f,  761.02f,  763.24f,  765.46f,  767.68f,  769.90f,  772.12f,  774.34f, 
 776.56f,  778.78f,  781.00f,  783.22f,  785.44f,  787.66f,  789.88f,  792.10f, 
 794.32f,  796.53f,  798.75f,  800.97f,  803.19f,  805.41f,  807.63f,  809.85f, 
 812.07f,  814.29f,  816.51f,  818.73f,  820.95f,  823.17f,  825.39f, 1051.58f, 
1052.53f, 1053.49f, 1054.45f, 1055.41f, 1056.36f, 1057.32f, 1058.27f, 1059.23f, 
1060.19f, 1061.14f, 1062.09f, 1063.05f, 1064.00f, 1064.96f, 1065.91f, 1066.86f, 
1067.81f, 1068.76f, 1069.71f, 1070.66f, 1071.61f, 1072.56f, 1073.51f, 1074.45f, 
1075.40f, 1076.34f, 1077.28f, 1078.22f, 1079.16f, 1080.10f, 1081.04f, 1081.98f, 
1082.91f, 1083.84f, 1084.77f, 1085.70f, 1086.63f, 1087.55f, 1088.48f, 1089.40f, 
1090.32f, 1091.23f, 1092.14f, 1093.05f, 1093.96f, 1094.86f, 1095.76f, 1096.66f, 
1097.55f, 1098.44f, 1099.33f, 1100.21f, 1101.08f, 1101.95f, 1100.73f, 1102.37f, 
1103.97f, 1105.39f, 1106.24f, 1107.08f, 1107.91f, 1108.73f, 1109.55f, 1110.37f, 
1111.17f, 1111.97f, 1112.76f, 1113.54f, 1114.32f, 1115.08f, 1115.84f, 1116.58f, 
1117.32f, 1118.05f, 1118.77f, 1119.48f, 1120.18f, 1120.87f, 1121.54f, 1122.21f, 
1122.87f, 1123.51f, 1124.15f, 1124.77f, 1125.38f, 1125.98f, 1126.56f, 1127.14f, 
1127.70f, 1128.25f, 1128.78f, 1129.31f, 1129.82f, 1130.32f, 1130.80f, 1131.27f, 
1131.73f, 1132.18f, 1132.61f, 1133.03f, 1133.44f, 1133.83f, 1134.20f, 1134.57f, 
1134.92f, 1135.25f, 1135.58f, 1135.89f, 1136.18f, 1136.46f, 1136.73f, 1136.98f, 
1137.21f, 1137.44f, 1137.65f, 1137.84f, 1138.02f, 1138.19f, 1138.34f, 1138.48f, 
1138.60f, 1138.71f, 1138.80f, 1138.88f, 1138.95f, 1139.00f, 1139.04f, 1139.06f, 
1139.06f, 
  74.04f,   74.29f,   75.03f,   76.24f,   77.88f,   79.95f,   82.40f,   85.20f, 
  88.32f,   91.70f,   95.33f,   99.17f,  103.19f,  107.37f,  111.69f,  116.12f, 
 120.65f,  125.26f,  129.94f,  134.69f,  139.48f,  144.31f,  149.17f,  154.05f, 
 158.91f,  163.52f,  168.13f,  172.73f,  177.33f,  181.92f,  186.51f,  191.09f, 
 195.66f,  200.23f,  204.78f,  209.33f,  213.87f,  218.40f,  222.92f,  227.42f, 
 231.91f,  236.39f,  240.85f,  245.30f,  249.74f,  254.17f,  258.60f,  263.01f, 
 267.42f,  271.82f,  276.21f,  280.59f,  284.95f,  289.31f,  293.66f,  297.99f, 
 302.31f,  306.62f,  310.91f,  315.20f,  319.47f,  323.72f,  327.97f,  332.19f, 
 336.41f,  340.61f,  344.79f,  348.96f,  353.12f,  357.26f,  361.38f,  365.49f, 
 369.59f,  373.67f,  377.73f,  381.78f,  385.81f,  389.83f,  393.83f,  397.81f, 
 401.78f,  405.73f,  409.67f,  413.59f,  417.49f,  421.38f,  425.25f,  429.10f, 
 432.94f,  436.76f,  440.57f,  444.35f,  448.12f,  451.88f,  455.62f,  459.34f, 
 463.04f,  466.73f,  470.40f,  474.06f,  477.70f,  481.32f,  484.92f,  488.51f, 
 492.08f,  495.63f,  499.17f,  502.69f,  506.19f,  509.68f,  513.15f,  516.60f, 
 520.04f,  523.46f,  526.86f,  530.24f,  533.61f,  536.96f,  540.29f,  543.61f, 
 546.91f,  550.19f,  553.46f,  556.71f,  559.94f,  563.15f,  566.35f,  569.53f, 
 572.69f,  575.84f,  578.97f,  582.08f,  585.17f,  588.25f,  591.31f,  594.35f, 
 597.38f,  600.39f,  603.38f,  606.35f,  609.31f,  612.25f,  615.17f,  618.07f, 
 620.96f,  623.82f,  626.67f,  629.51f,  632.32f,  635.12f,  637.90f,  640.66f, 
 643.40f,  646.13f,  648.84f,  651.52f,  654.20f,  656.85f,  659.48f,  662.10f, 
 664.70f,  667.28f,  669.84f,  672.38f,  674.90f,  677.41f,  679.89f,  682.36f, 
 684.82f,  687.25f,  689.65f,  692.02f,  694.38f,  696.73f,  699.07f,  701.41f, 
 703.73f,  706.05f,  708.37f,  710.68f,  712.98f,  715.28f,  717.58f,  719.87f, 
 722.15f,  724.43f,  726.70f,  728.97f,  731.22f,  733.47f,  735.71f,  737.94f, 
 740.16f,  742.38f,  744.60f,  746.82f,  749.04f,  751.26f,  753.48f,  755.70f, 
 757.92f,  760.14f,  762.36f,  764.58f,  766.80f,  769.02f,  771.24f,  773.46f, 
 775.68f,  777.90f,  780.11f,  782.33f,  784.55f,  786.77f,  788.99f,  791.21f, 
 793.43f,  795.65f,  797.87f,  800.09f,  802.31f,  804.53f,  806.75f,  808.97f, 
 811.19f,  813.41f,  815.63f,  817.85f,  820.07f,  822.28f,  824.50f, 1050.61f, 
1051.56f, 1052.52f, 1053.48f, 1054.44f, 1055.39f, 1056.35f, 1057.30f, 1058.26f, 
1059.22f, 1060.17f, 1061.12f, 1062.08f, 1063.03f, 1063.99f, 1064.94f, 1065.89f, 
1066.84f, 1067.79f, 1068.74f, 1069.69f, 1070.64f, 1071.59f, 1072.54f, 1073.48f, 
1074.43f, 1075.37f, 1076.31f, 1077.25f, 1078.19f, 1079.13f, 1080.07f, 1081.01f, 
1081.94f, 1082.87f, 1083.80f, 1084.73f, 1085.66f, 1086.58f, 1087.51f, 1088.43f, 
1089.34f, 1090.26f, 1091.17f, 1092.08f, 1092.99f, 1093.89f, 1094.79f, 1095.69f, 
1096.58f, 1097.47f, 1098.35f, 1099.23f, 1100.11f, 1100.98f, 1099.80f, 1101.44f, 
1103.03f, 1104.42f, 1105.26f, 1106.10f, 1106.93f, 1107.76f, 1108.58f, 1109.39f, 
1110.20f, 1110.99f, 1111.78f, 1112.57f, 1113.34f, 1114.10f, 1114.86f, 1115.61f, 
1116.34f, 1117.07f, 1117.79f, 1118.50f, 1119.20f, 1119.89f, 1120.56f, 1121.23f, 
1121.89f, 1122.53f, 1123.16f, 1123.79f, 1124.40f, 1124.99f, 1125.58f, 1126.15f, 
1126.72f, 1127.26f, 1127.80f, 1128.32f, 1128.84f, 1129.33f, 1129.82f, 1130.29f, 
1130.75f, 1131.19f, 1131.63f, 1132.04f, 1132.45f, 1132.84f, 1133.22f, 1133.58f, 
1133.93f, 1134.27f, 1134.59f, 1134.90f, 1135.19f, 1135.47f, 1135.74f, 1135.99f, 
1136.23f, 1136.45f, 1136.66f, 1136.85f, 1137.03f, 1137.20f, 1137.35f, 1137.49f, 
1137.61f, 1137.72f, 1137.81f, 1137.89f, 1137.96f, 1138.01f, 1138.05f, 1138.07f, 
1138.08f, 
  75.03f,   75.27f,   76.00f,   77.18f,   78.80f,   80.82f,   83.24f,   85.99f, 
  89.06f,   92.40f,   95.98f,   99.77f,  103.74f,  107.88f,  112.15f,  116.53f, 
 121.02f,  125.60f,  130.24f,  134.95f,  139.70f,  144.50f,  149.33f,  153.95f, 
 158.57f,  163.17f,  167.78f,  172.38f,  176.97f,  181.56f,  186.15f,  190.72f, 
 195.29f,  199.85f,  204.41f,  208.95f,  213.48f,  218.01f,  222.52f,  227.02f, 
 231.50f,  235.97f,  240.43f,  244.87f,  249.31f,  253.74f,  258.16f,  262.57f, 
 266.98f,  271.37f,  275.76f,  280.13f,  284.50f,  288.85f,  293.19f,  297.52f, 
 301.83f,  306.14f,  310.43f,  314.71f,  318.97f,  323.22f,  327.46f,  331.69f, 
 335.89f,  340.09f,  344.27f,  348.44f,  352.59f,  356.72f,  360.84f,  364.95f, 
 369.04f,  373.11f,  377.17f,  381.21f,  385.24f,  389.25f,  393.25f,  397.23f, 
 401.19f,  405.14f,  409.07f,  412.99f,  416.89f,  420.77f,  424.64f,  428.49f, 
 432.32f,  436.14f,  439.94f,  443.72f,  447.49f,  451.24f,  454.97f,  458.69f, 
 462.39f,  466.08f,  469.74f,  473.39f,  477.03f,  480.65f,  484.25f,  487.83f, 
 491.40f,  494.95f,  498.48f,  502.00f,  505.50f,  508.98f,  512.45f,  515.90f, 
 519.33f,  522.74f,  526.14f,  529.52f,  532.89f,  536.24f,  539.57f,  542.88f, 
 546.18f,  549.46f,  552.72f,  555.97f,  559.19f,  562.41f,  565.60f,  568.78f, 
 571.94f,  575.08f,  578.21f,  581.32f,  584.41f,  587.48f,  590.54f,  593.58f, 
 596.60f,  599.61f,  602.59f,  605.56f,  608.52f,  611.45f,  614.37f,  617.27f, 
 620.16f,  623.02f,  625.87f,  628.70f,  631.51f,  634.31f,  637.08f,  639.84f, 
 642.58f,  645.31f,  648.01f,  650.70f,  653.37f,  656.02f,  658.65f,  661.26f, 
 663.86f,  666.44f,  669.00f,  671.54f,  674.06f,  676.56f,  679.04f,  681.51f, 
 683.96f,  686.39f,  688.79f,  691.16f,  693.52f,  695.87f,  698.21f,  700.54f, 
 702.86f,  705.18f,  707.50f,  709.81f,  712.11f,  714.41f,  716.71f,  719.00f, 
 721.28f,  723.56f,  725.83f,  728.09f,  730.35f,  732.59f,  734.83f,  737.06f, 
 739.28f,  741.50f,  743.72f,  745.94f,  748.16f,  750.38f,  752.60f,  754.82f, 
 757.04f,  759.26f,  761.48f,  763.70f,  765.92f,  768.14f,  770.36f,  772.58f, 
 774.80f,  777.02f,  779.24f,  781.45f,  783.67f,  785.89f,  788.11f,  790.33f, 
 792.55f,  794.77f,  796.99f,  799.21f,  801.43f,  803.65f,  805.87f,  808.09f, 
 810.31f,  812.53f,  814.75f,  816.97f,  819.19f,  821.40f,  823.62f, 1049.64f, 
1050.60f, 1051.56f, 1052.51f, 1053.47f, 1054.43f, 1055.38f, 1056.34f, 1057.29f, 
1058.25f, 1059.20f, 1060.16f, 1061.11f, 1062.07f, 1063.02f, 1063.97f, 1064.92f, 
1065.88f, 1066.83f, 1067.78f, 1068.73f, 1069.67f, 1070.62f, 1071.57f, 1072.51f, 
1073.46f, 1074.40f, 1075.35f, 1076.29f, 1077.23f, 1078.17f, 1079.10f, 1080.04f, 
1080.97f, 1081.90f, 1082.84f, 1083.76f, 1084.69f, 1085.62f, 1086.54f, 1087.46f, 
1088.38f, 1089.29f, 1090.20f, 1091.11f, 1092.02f, 1092.92f, 1093.82f, 1094.72f, 
1095.61f, 1096.50f, 1097.38f, 1098.26f, 1099.14f, 1100.01f, 1098.87f, 1100.51f, 
1102.10f, 1103.45f, 1104.29f, 1105.13f, 1105.96f, 1106.79f, 1107.61f, 1108.42f, 
1109.22f, 1110.02f, 1110.81f, 1111.59f, 1112.37f, 1113.13f, 1113.89f, 1114.63f, 
1115.37f, 1116.10f, 1116.82f, 1117.53f, 1118.22f, 1118.91f, 1119.59f, 1120.25f, 
1120.91f, 1121.55f, 1122.19f, 1122.81f, 1123.42f, 1124.02f, 1124.60f, 1125.18f, 
1125.74f, 1126.29f, 1126.82f, 1127.34f, 1127.86f, 1128.35f, 1128.84f, 1129.31f, 
1129.77f, 1130.21f, 1130.64f, 1131.06f, 1131.47f, 1131.86f, 1132.24f, 1132.60f, 
1132.95f, 1133.29f, 1133.61f, 1133.91f, 1134.21f, 1134.49f, 1134.75f, 1135.01f, 
1135.24f, 1135.47f, 1135.68f, 1135.87f, 1136.05f, 1136.22f, 1136.37f, 1136.50f, 
1136.63f, 1136.74f, 1136.83f, 1136.91f, 1136.97f, 1137.02f, 1137.06f, 1137.08f, 
1137.09f, 
  76.01f,   76.25f,   76.96f,   78.12f,   79.71f,   81.70f,   84.07f,   86.78f, 
  89.80f,   93.10f,   96.63f,  100.37f,  104.30f,  108.39f,  112.61f,  116.96f, 
 121.41f,  125.94f,  130.54f,  135.16f,  139.78f,  144.40f,  149.01f,  153.62f, 
 158.23f,  162.84f,  167.44f,  172.04f,  176.63f,  181.22f,  185.80f,  190.37f, 
 194.94f,  199.49f,  204.04f,  208.58f,  213.11f,  217.63f,  222.13f,  226.62f, 
 231.10f,  235.56f,  240.02f,  244.46f,  248.89f,  253.32f,  257.74f,  262.14f, 
 266.54f,  270.93f,  275.32f,  279.69f,  284.05f,  288.39f,  292.73f,  297.06f, 
 301.37f,  305.67f,  309.95f,  314.23f,  318.49f,  322.73f,  326.97f,  331.18f, 
 335.39f,  339.58f,  343.75f,  347.92f,  352.06f,  356.19f,  360.31f,  364.41f, 
 368.49f,  372.56f,  376.62f,  380.66f,  384.68f,  388.69f,  392.68f,  396.65f, 
 400.61f,  404.56f,  408.48f,  412.39f,  416.29f,  420.17f,  424.03f,  427.88f, 
 431.71f,  435.52f,  439.32f,  443.10f,  446.86f,  450.61f,  454.34f,  458.05f, 
 461.75f,  465.43f,  469.09f,  472.74f,  476.37f,  479.98f,  483.58f,  487.16f, 
 490.72f,  494.27f,  497.80f,  501.31f,  504.81f,  508.29f,  511.75f,  515.20f, 
 518.63f,  522.04f,  525.43f,  528.81f,  532.17f,  535.52f,  538.85f,  542.16f, 
 545.45f,  548.73f,  551.99f,  555.23f,  558.45f,  561.66f,  564.85f,  568.03f, 
 571.19f,  574.33f,  577.45f,  580.55f,  583.64f,  586.72f,  589.77f,  592.81f, 
 595.83f,  598.83f,  601.81f,  604.78f,  607.73f,  610.67f,  613.58f,  616.48f, 
 619.36f,  622.22f,  625.07f,  627.90f,  630.71f,  633.50f,  636.27f,  639.03f, 
 641.77f,  644.49f,  647.19f,  649.88f,  652.54f,  655.19f,  657.82f,  660.43f, 
 663.03f,  665.60f,  668.16f,  670.69f,  673.21f,  675.71f,  678.19f,  680.66f, 
 683.11f,  685.53f,  687.93f,  690.30f,  692.66f,  695.00f,  697.34f,  699.67f, 
 702.00f,  704.32f,  706.63f,  708.94f,  711.24f,  713.54f,  715.84f,  718.13f, 
 720.41f,  722.69f,  724.96f,  727.22f,  729.47f,  731.72f,  733.96f,  736.19f, 
 738.41f,  740.63f,  742.85f,  745.07f,  747.29f,  749.51f,  751.73f,  753.95f, 
 756.17f,  758.38f,  760.60f,  762.82f,  765.04f,  767.26f,  769.48f,  771.70f, 
 773.92f,  776.14f,  778.36f,  780.58f,  782.80f,  785.02f,  787.24f,  789.46f, 
 791.68f,  793.90f,  796.12f,  798.33f,  800.55f,  802.77f,  804.99f,  807.21f, 
 809.43f,  811.65f,  813.87f,  816.09f,  818.31f,  820.53f,  822.75f, 1048.68f, 
1049.63f, 1050.59f, 1051.55f, 1052.51f, 1053.46f, 1054.42f, 1055.37f, 1056.33f, 
1057.29f, 1058.24f, 1059.19f, 1060.15f, 1061.10f, 1062.06f, 1063.01f, 1063.96f, 
1064.91f, 1065.86f, 1066.81f, 1067.76f, 1068.71f, 1069.66f, 1070.61f, 1071.55f, 
1072.50f, 1073.44f, 1074.38f, 1075.32f, 1076.26f, 1077.20f, 1078.14f, 1079.07f, 
1080.01f, 1080.94f, 1081.87f, 1082.80f, 1083.73f, 1084.65f, 1085.57f, 1086.49f, 
1087.41f, 1088.33f, 1089.24f, 1090.15f, 1091.05f, 1091.96f, 1092.86f, 1093.75f, 
1094.64f, 1095.53f, 1096.42f, 1097.30f, 1098.17f, 1099.05f, 1097.95f, 1099.58f, 
1101.16f, 1102.48f, 1103.32f, 1104.16f, 1104.99f, 1105.82f, 1106.64f, 1107.45f, 
1108.26f, 1109.05f, 1109.84f, 1110.62f, 1111.40f, 1112.16f, 1112.92f, 1113.66f, 
1114.40f, 1115.13f, 1115.85f, 1116.55f, 1117.25f, 1117.94f, 1118.62f, 1119.28f, 
1119.94f, 1120.58f, 1121.21f, 1121.83f, 1122.44f, 1123.04f, 1123.63f, 1124.20f, 
1124.76f, 1125.31f, 1125.85f, 1126.37f, 1126.88f, 1127.38f, 1127.86f, 1128.33f, 
1128.79f, 1129.24f, 1129.67f, 1130.08f, 1130.49f, 1130.88f, 1131.26f, 1131.62f, 
1131.97f, 1132.31f, 1132.63f, 1132.93f, 1133.23f, 1133.51f, 1133.77f, 1134.02f, 
1134.26f, 1134.49f, 1134.69f, 1134.89f, 1135.07f, 1135.23f, 1135.39f, 1135.52f, 
1135.65f, 1135.75f, 1135.85f, 1135.93f, 1135.99f, 1136.04f, 1136.08f, 1136.10f, 
1136.11f, 
  76.93f,   77.17f,   77.87f,   79.01f,   80.56f,   82.52f,   84.84f,   87.51f, 
  90.48f,   93.72f,   97.20f,  100.89f,  104.76f,  108.80f,  112.97f,  117.25f, 
 121.64f,  126.10f,  130.63f,  135.20f,  139.79f,  144.39f,  148.99f,  153.59f, 
 158.18f,  162.78f,  167.37f,  171.95f,  176.54f,  181.11f,  185.68f,  190.24f, 
 194.80f,  199.34f,  203.88f,  208.41f,  212.93f,  217.43f,  221.93f,  226.40f, 
 230.87f,  235.33f,  239.77f,  244.21f,  248.64f,  253.05f,  257.47f,  261.87f, 
 266.26f,  270.65f,  275.02f,  279.39f,  283.74f,  288.08f,  292.41f,  296.73f, 
 301.04f,  305.33f,  309.61f,  313.87f,  318.13f,  322.37f,  326.59f,  330.81f, 
 335.01f,  339.19f,  343.36f,  347.51f,  351.65f,  355.78f,  359.89f,  363.98f, 
 368.06f,  372.12f,  376.17f,  380.21f,  384.22f,  388.23f,  392.21f,  396.18f, 
 400.14f,  404.07f,  408.00f,  411.90f,  415.79f,  419.66f,  423.52f,  427.36f, 
 431.19f,  435.00f,  438.79f,  442.56f,  446.32f,  450.06f,  453.79f,  457.50f, 
 461.19f,  464.87f,  468.53f,  472.17f,  475.80f,  479.40f,  483.00f,  486.57f, 
 490.13f,  493.68f,  497.20f,  500.71f,  504.20f,  507.68f,  511.14f,  514.58f, 
 518.01f,  521.41f,  524.81f,  528.18f,  531.54f,  534.88f,  538.20f,  541.51f, 
 544.80f,  548.07f,  551.33f,  554.57f,  557.79f,  561.00f,  564.18f,  567.35f, 
 570.51f,  573.65f,  576.77f,  579.87f,  582.95f,  586.02f,  589.07f,  592.11f, 
 595.13f,  598.13f,  601.11f,  604.07f,  607.02f,  609.95f,  612.86f,  615.76f, 
 618.64f,  621.50f,  624.34f,  627.16f,  629.97f,  632.76f,  635.53f,  638.29f, 
 641.02f,  643.74f,  646.44f,  649.12f,  651.79f,  654.43f,  657.06f,  659.67f, 
 662.26f,  664.83f,  667.39f,  669.92f,  672.44f,  674.93f,  677.41f,  679.88f, 
 682.32f,  684.75f,  687.13f,  689.50f,  691.86f,  694.21f,  696.54f,  698.88f, 
 701.20f,  703.52f,  705.83f,  708.14f,  710.44f,  712.74f,  715.03f,  717.32f, 
 719.61f,  721.88f,  724.15f,  726.41f,  728.67f,  730.91f,  733.15f,  735.38f, 
 737.60f,  739.82f,  742.04f,  744.26f,  746.48f,  748.70f,  750.91f,  753.13f, 
 755.35f,  757.57f,  759.79f,  762.01f,  764.23f,  766.45f,  768.67f,  770.89f, 
 773.11f,  775.33f,  777.55f,  779.77f,  781.99f,  784.21f,  786.43f,  788.65f, 
 790.87f,  793.08f,  795.30f,  797.52f,  799.74f,  801.96f,  804.18f,  806.40f, 
 808.62f,  810.84f,  813.06f,  815.28f,  817.50f,  819.72f,  821.94f, 1047.77f, 
1048.73f, 1049.69f, 1050.64f, 1051.60f, 1052.56f, 1053.51f, 1054.47f, 1055.42f, 
1056.38f, 1057.33f, 1058.29f, 1059.24f, 1060.20f, 1061.15f, 1062.10f, 1063.05f, 
1064.01f, 1064.96f, 1065.91f, 1066.86f, 1067.80f, 1068.75f, 1069.70f, 1070.64f, 
1071.59f, 1072.53f, 1073.48f, 1074.42f, 1075.36f, 1076.30f, 1077.23f, 1078.17f, 
1079.10f, 1080.03f, 1080.96f, 1081.89f, 1082.82f, 1083.74f, 1084.67f, 1085.59f, 
1086.50f, 1087.42f, 1088.33f, 1089.24f, 1090.15f, 1091.05f, 1091.95f, 1092.84f, 
1093.74f, 1094.62f, 1095.51f, 1096.39f, 1097.27f, 1098.14f, 1097.08f, 1098.71f, 
1100.29f, 1101.57f, 1102.41f, 1103.25f, 1104.08f, 1104.91f, 1105.73f, 1106.54f, 
1107.34f, 1108.14f, 1108.93f, 1109.71f, 1110.48f, 1111.25f, 1112.00f, 1112.75f, 
1113.49f, 1114.21f, 1114.93f, 1115.64f, 1116.34f, 1117.02f, 1117.70f, 1118.37f, 
1119.02f, 1119.66f, 1120.30f, 1120.92f, 1121.53f, 1122.12f, 1122.71f, 1123.28f, 
1123.84f, 1124.39f, 1124.93f, 1125.45f, 1125.96f, 1126.46f, 1126.94f, 1127.41f, 
1127.87f, 1128.31f, 1128.74f, 1129.16f, 1129.57f, 1129.96f, 1130.33f, 1130.70f, 
1131.05f, 1131.38f, 1131.70f, 1132.01f, 1132.30f, 1132.58f, 1132.85f, 1133.10f, 
1133.34f, 1133.56f, 1133.77f, 1133.96f, 1134.14f, 1134.31f, 1134.46f, 1134.60f, 
1134.72f, 1134.83f, 1134.92f, 1135.00f, 1135.07f, 1135.12f, 1135.15f, 1135.18f, 
1135.18f, 
  77.86f,   78.09f,   78.77f,   79.89f,   81.42f,   83.34f,   85.62f,   88.24f, 
  91.17f,   94.36f,   97.78f,  101.42f,  105.24f,  109.22f,  113.34f,  117.57f, 
 121.90f,  126.31f,  130.79f,  135.31f,  139.86f,  144.42f,  149.00f,  153.58f, 
 158.16f,  162.74f,  167.31f,  171.89f,  176.45f,  181.02f,  185.57f,  190.12f, 
 194.67f,  199.20f,  203.73f,  208.24f,  212.75f,  217.24f,  221.72f,  226.19f, 
 230.65f,  235.10f,  239.54f,  243.97f,  248.39f,  252.80f,  257.21f,  261.60f, 
 265.99f,  270.37f,  274.74f,  279.10f,  283.44f,  287.78f,  292.10f,  296.41f, 
 300.71f,  305.00f,  309.27f,  313.53f,  317.78f,  322.01f,  326.23f,  330.44f, 
 334.63f,  338.80f,  342.97f,  347.12f,  351.25f,  355.37f,  359.47f,  363.56f, 
 367.63f,  371.69f,  375.73f,  379.76f,  383.77f,  387.77f,  391.75f,  395.71f, 
 399.66f,  403.60f,  407.51f,  411.41f,  415.30f,  419.17f,  423.02f,  426.85f, 
 430.67f,  434.48f,  438.26f,  442.03f,  445.79f,  449.53f,  453.25f,  456.95f, 
 460.64f,  464.31f,  467.97f,  471.60f,  475.23f,  478.83f,  482.42f,  485.99f, 
 489.55f,  493.09f,  496.61f,  500.11f,  503.60f,  507.07f,  510.53f,  513.97f, 
 517.39f,  520.79f,  524.18f,  527.55f,  530.91f,  534.24f,  537.56f,  540.87f, 
 544.15f,  547.42f,  550.68f,  553.91f,  557.13f,  560.33f,  563.52f,  566.69f, 
 569.84f,  572.97f,  576.09f,  579.19f,  582.27f,  585.33f,  588.38f,  591.41f, 
 594.43f,  597.42f,  600.40f,  603.37f,  606.31f,  609.24f,  612.15f,  615.04f, 
 617.91f,  620.77f,  623.61f,  626.43f,  629.24f,  632.03f,  634.79f,  637.55f, 
 640.28f,  642.99f,  645.69f,  648.37f,  651.03f,  653.68f,  656.30f,  658.91f, 
 661.50f,  664.07f,  666.62f,  669.15f,  671.66f,  674.16f,  676.64f,  679.10f, 
 681.54f,  683.96f,  686.34f,  688.71f,  691.07f,  693.41f,  695.75f,  698.08f, 
 700.40f,  702.72f,  705.03f,  707.34f,  709.64f,  711.94f,  714.23f,  716.52f, 
 718.80f,  721.08f,  723.35f,  725.61f,  727.86f,  730.10f,  732.34f,  734.57f, 
 736.79f,  739.01f,  741.23f,  743.45f,  745.67f,  747.89f,  750.11f,  752.33f, 
 754.55f,  756.77f,  758.98f,  761.20f,  763.42f,  765.64f,  767.86f,  770.08f, 
 772.30f,  774.52f,  776.74f,  778.96f,  781.18f,  783.40f,  785.62f,  787.84f, 
 790.06f,  792.28f,  794.50f,  796.72f,  798.93f,  801.15f,  803.37f,  805.59f, 
 807.81f,  810.03f,  812.25f,  814.47f,  816.69f,  818.91f,  821.13f, 1046.87f, 
1047.83f, 1048.78f, 1049.74f, 1050.70f, 1051.65f, 1052.61f, 1053.57f, 1054.52f, 
1055.48f, 1056.43f, 1057.39f, 1058.34f, 1059.29f, 1060.25f, 1061.20f, 1062.15f, 
1063.10f, 1064.05f, 1065.00f, 1065.95f, 1066.90f, 1067.85f, 1068.80f, 1069.74f, 
1070.69f, 1071.63f, 1072.57f, 1073.51f, 1074.45f, 1075.39f, 1076.33f, 1077.26f, 
1078.20f, 1079.13f, 1080.06f, 1080.99f, 1081.92f, 1082.84f, 1083.76f, 1084.68f, 
1085.60f, 1086.51f, 1087.43f, 1088.33f, 1089.24f, 1090.14f, 1091.04f, 1091.94f, 
1092.83f, 1093.72f, 1094.60f, 1095.48f, 1096.36f, 1097.23f, 1096.22f, 1097.85f, 
1099.42f, 1100.66f, 1101.51f, 1102.34f, 1103.18f, 1104.00f, 1104.82f, 1105.63f, 
1106.43f, 1107.23f, 1108.02f, 1108.80f, 1109.57f, 1110.34f, 1111.09f, 1111.84f, 
1112.57f, 1113.30f, 1114.02f, 1114.73f, 1115.42f, 1116.11f, 1116.79f, 1117.45f, 
1118.11f, 1118.75f, 1119.38f, 1120.00f, 1120.61f, 1121.21f, 1121.79f, 1122.36f, 
1122.93f, 1123.47f, 1124.01f, 1124.53f, 1125.04f, 1125.54f, 1126.02f, 1126.49f, 
1126.95f, 1127.39f, 1127.83f, 1128.24f, 1128.65f, 1129.04f, 1129.41f, 1129.78f, 
1130.13f, 1130.46f, 1130.78f, 1131.09f, 1131.38f, 1131.66f, 1131.93f, 1132.18f, 
1132.42f, 1132.64f, 1132.85f, 1133.04f, 1133.22f, 1133.39f, 1133.54f, 1133.67f, 
1133.80f, 1133.91f, 1134.00f, 1134.08f, 1134.14f, 1134.19f, 1134.23f, 1134.25f, 
1134.26f, 
  78.78f,   79.01f,   79.68f,   80.77f,   82.27f,   84.16f,   86.40f,   88.98f, 
  91.85f,   95.00f,   98.37f,  101.96f,  105.73f,  109.66f,  113.72f,  117.90f, 
 122.18f,  126.55f,  130.97f,  135.45f,  139.96f,  144.49f,  149.04f,  153.60f, 
 158.16f,  162.72f,  167.28f,  171.83f,  176.39f,  180.94f,  185.48f,  190.02f, 
 194.55f,  199.07f,  203.59f,  208.09f,  212.58f,  217.06f,  221.53f,  225.99f, 
 230.44f,  234.88f,  239.31f,  243.73f,  248.15f,  252.56f,  256.96f,  261.35f, 
 265.73f,  270.10f,  274.46f,  278.81f,  283.15f,  287.48f,  291.80f,  296.10f, 
 300.39f,  304.67f,  308.94f,  313.19f,  317.43f,  321.66f,  325.87f,  330.07f, 
 334.26f,  338.43f,  342.58f,  346.72f,  350.85f,  354.96f,  359.06f,  363.14f, 
 367.21f,  371.26f,  375.30f,  379.32f,  383.33f,  387.32f,  391.29f,  395.25f, 
 399.20f,  403.12f,  407.03f,  410.93f,  414.81f,  418.67f,  422.52f,  426.35f, 
 430.16f,  433.96f,  437.75f,  441.51f,  445.26f,  448.99f,  452.71f,  456.41f, 
 460.09f,  463.76f,  467.41f,  471.04f,  474.66f,  478.26f,  481.85f,  485.41f, 
 488.97f,  492.50f,  496.02f,  499.52f,  503.00f,  506.47f,  509.92f,  513.36f, 
 516.78f,  520.18f,  523.56f,  526.93f,  530.28f,  533.61f,  536.93f,  540.23f, 
 543.51f,  546.78f,  550.03f,  553.26f,  556.47f,  559.67f,  562.85f,  566.02f, 
 569.17f,  572.30f,  575.41f,  578.51f,  581.59f,  584.65f,  587.69f,  590.72f, 
 593.73f,  596.73f,  599.70f,  602.66f,  605.60f,  608.53f,  611.44f,  614.33f, 
 617.20f,  620.05f,  622.89f,  625.71f,  628.51f,  631.29f,  634.06f,  636.81f, 
 639.54f,  642.25f,  644.95f,  647.62f,  650.28f,  652.92f,  655.55f,  658.15f, 
 660.74f,  663.30f,  665.85f,  668.38f,  670.89f,  673.38f,  675.86f,  678.32f, 
 680.76f,  683.18f,  685.56f,  687.92f,  690.28f,  692.62f,  694.96f,  697.29f, 
 699.61f,  701.93f,  704.24f,  706.55f,  708.85f,  711.14f,  713.44f,  715.72f, 
 718.01f,  720.28f,  722.55f,  724.81f,  727.06f,  729.30f,  731.54f,  733.76f, 
 735.98f,  738.20f,  740.42f,  742.64f,  744.86f,  747.08f,  749.30f,  751.52f, 
 753.74f,  755.96f,  758.18f,  760.40f,  762.62f,  764.84f,  767.06f,  769.28f, 
 771.50f,  773.72f,  775.94f,  778.15f,  780.37f,  782.59f,  784.81f,  787.03f, 
 789.25f,  791.47f,  793.69f,  795.91f,  798.13f,  800.35f,  802.57f,  804.79f, 
 807.01f,  809.23f,  811.45f,  813.67f,  815.89f,  818.10f,  820.32f, 1045.97f, 
1046.93f, 1047.88f, 1048.84f, 1049.80f, 1050.75f, 1051.71f, 1052.66f, 1053.62f, 
1054.58f, 1055.53f, 1056.49f, 1057.44f, 1058.39f, 1059.35f, 1060.30f, 1061.25f, 
1062.20f, 1063.15f, 1064.10f, 1065.05f, 1066.00f, 1066.95f, 1067.89f, 1068.84f, 
1069.78f, 1070.73f, 1071.67f, 1072.61f, 1073.55f, 1074.49f, 1075.43f, 1076.36f, 
1077.30f, 1078.23f, 1079.16f, 1080.09f, 1081.01f, 1081.94f, 1082.86f, 1083.78f, 
1084.70f, 1085.61f, 1086.52f, 1087.43f, 1088.34f, 1089.24f, 1090.14f, 1091.04f, 
1091.93f, 1092.82f, 1093.70f, 1094.58f, 1095.45f, 1096.33f, 1095.36f, 1096.99f, 
1098.56f, 1099.76f, 1100.60f, 1101.44f, 1102.27f, 1103.09f, 1103.91f, 1104.72f, 
1105.53f, 1106.32f, 1107.11f, 1107.89f, 1108.66f, 1109.43f, 1110.18f, 1110.93f, 
1111.66f, 1112.39f, 1113.11f, 1113.82f, 1114.51f, 1115.20f, 1115.88f, 1116.54f, 
1117.19f, 1117.84f, 1118.47f, 1119.09f, 1119.70f, 1120.29f, 1120.88f, 1121.45f, 
1122.01f, 1122.56f, 1123.09f, 1123.62f, 1124.13f, 1124.62f, 1125.11f, 1125.58f, 
1126.03f, 1126.48f, 1126.91f, 1127.33f, 1127.73f, 1128.12f, 1128.50f, 1128.86f, 
1129.21f, 1129.54f, 1129.86f, 1130.17f, 1130.46f, 1130.74f, 1131.01f, 1131.26f, 
1131.50f, 1131.72f, 1131.93f, 1132.12f, 1132.30f, 1132.47f, 1132.62f, 1132.75f, 
1132.88f, 1132.98f, 1133.08f, 1133.16f, 1133.22f, 1133.27f, 1133.31f, 1133.33f, 
1133.34f, 
  79.70f,   79.92f,   80.58f,   81.65f,   83.13f,   84.98f,   87.18f,   89.72f, 
  92.55f,   95.64f,   98.97f,  102.51f,  106.23f,  110.10f,  114.12f,  118.25f, 
 122.49f,  126.80f,  131.18f,  135.62f,  140.09f,  144.59f,  149.11f,  153.64f, 
 158.18f,  162.72f,  167.26f,  171.80f,  176.34f,  180.87f,  185.40f,  189.92f, 
 194.44f,  198.95f,  203.45f,  207.94f,  212.42f,  216.89f,  221.35f,  225.80f, 
 230.24f,  234.67f,  239.09f,  243.51f,  247.92f,  252.32f,  256.72f,  261.10f, 
 265.48f,  269.84f,  274.19f,  278.54f,  282.87f,  287.19f,  291.50f,  295.80f, 
 300.08f,  304.35f,  308.61f,  312.86f,  317.09f,  321.31f,  325.52f,  329.71f, 
 333.89f,  338.05f,  342.20f,  346.34f,  350.46f,  354.56f,  358.66f,  362.73f, 
 366.79f,  370.84f,  374.87f,  378.89f,  382.89f,  386.87f,  390.84f,  394.79f, 
 398.73f,  402.65f,  406.56f,  410.45f,  414.32f,  418.18f,  422.03f,  425.85f, 
 429.66f,  433.45f,  437.23f,  440.99f,  444.74f,  448.46f,  452.18f,  455.87f, 
 459.55f,  463.21f,  466.86f,  470.49f,  474.10f,  477.70f,  481.28f,  484.84f, 
 488.39f,  491.92f,  495.43f,  498.93f,  502.41f,  505.87f,  509.32f,  512.75f, 
 516.17f,  519.56f,  522.94f,  526.31f,  529.65f,  532.98f,  536.30f,  539.59f, 
 542.87f,  546.14f,  549.38f,  552.61f,  555.82f,  559.02f,  562.20f,  565.36f, 
 568.50f,  571.63f,  574.74f,  577.83f,  580.91f,  583.97f,  587.01f,  590.03f, 
 593.04f,  596.03f,  599.01f,  601.96f,  604.90f,  607.82f,  610.73f,  613.61f, 
 616.48f,  619.33f,  622.17f,  624.98f,  627.78f,  630.56f,  633.33f,  636.07f, 
 638.80f,  641.51f,  644.20f,  646.88f,  649.53f,  652.17f,  654.79f,  657.39f, 
 659.98f,  662.54f,  665.09f,  667.62f,  670.12f,  672.61f,  675.09f,  677.55f, 
 679.98f,  682.39f,  684.77f,  687.14f,  689.49f,  691.83f,  694.17f,  696.50f, 
 698.82f,  701.14f,  703.45f,  705.75f,  708.05f,  710.35f,  712.64f,  714.93f, 
 717.21f,  719.48f,  721.75f,  724.01f,  726.26f,  728.50f,  730.74f,  732.96f, 
 735.18f,  737.40f,  739.62f,  741.84f,  744.06f,  746.28f,  748.50f,  750.72f, 
 752.94f,  755.16f,  757.38f,  759.60f,  761.82f,  764.04f,  766.25f,  768.47f, 
 770.69f,  772.91f,  775.13f,  777.35f,  779.57f,  781.79f,  784.01f,  786.23f, 
 788.45f,  790.67f,  792.89f,  795.11f,  797.33f,  799.55f,  801.77f,  803.99f, 
 806.21f,  808.42f,  810.64f,  812.86f,  815.08f,  817.30f,  819.52f, 1045.07f, 
1046.03f, 1046.98f, 1047.94f, 1048.90f, 1049.85f, 1050.81f, 1051.77f, 1052.72f, 
1053.68f, 1054.63f, 1055.59f, 1056.54f, 1057.49f, 1058.45f, 1059.40f, 1060.35f, 
1061.30f, 1062.25f, 1063.20f, 1064.15f, 1065.10f, 1066.05f, 1067.00f, 1067.94f, 
1068.89f, 1069.83f, 1070.77f, 1071.71f, 1072.65f, 1073.59f, 1074.53f, 1075.46f, 
1076.40f, 1077.33f, 1078.26f, 1079.19f, 1080.11f, 1081.04f, 1081.96f, 1082.88f, 
1083.80f, 1084.71f, 1085.62f, 1086.53f, 1087.44f, 1088.34f, 1089.24f, 1090.13f, 
1091.03f, 1091.91f, 1092.80f, 1093.68f, 1094.55f, 1092.82f, 1094.51f, 1096.12f, 
1097.69f, 1098.85f, 1099.70f, 1100.53f, 1101.37f, 1102.19f, 1103.01f, 1103.82f, 
1104.62f, 1105.42f, 1106.21f, 1106.99f, 1107.76f, 1108.52f, 1109.28f, 1110.02f, 
1110.76f, 1111.48f, 1112.20f, 1112.91f, 1113.60f, 1114.29f, 1114.97f, 1115.63f, 
1116.28f, 1116.93f, 1117.56f, 1118.18f, 1118.79f, 1119.38f, 1119.97f, 1120.54f, 
1121.10f, 1121.65f, 1122.18f, 1122.70f, 1123.21f, 1123.71f, 1124.19f, 1124.66f, 
1125.12f, 1125.56f, 1125.99f, 1126.41f, 1126.81f, 1127.20f, 1127.58f, 1127.94f, 
1128.29f, 1128.63f, 1128.95f, 1129.25f, 1129.55f, 1129.83f, 1130.09f, 1130.34f, 
1130.58f, 1130.80f, 1131.01f, 1131.20f, 1131.38f, 1131.55f, 1131.70f, 1131.84f, 
1131.96f, 1132.07f, 1132.16f, 1132.24f, 1132.30f, 1132.35f, 1132.39f, 1132.41f, 
1132.42f, 
  80.61f,   80.83f,   81.48f,   82.53f,   83.98f,   85.80f,   87.96f,   90.46f, 
  93.24f,   96.29f,   99.57f,  103.06f,  106.73f,  110.56f,  114.53f,  118.62f, 
 122.80f,  127.07f,  131.41f,  135.80f,  140.24f,  144.71f,  149.19f,  153.70f, 
 158.21f,  162.73f,  167.25f,  171.78f,  176.30f,  180.82f,  185.33f,  189.84f, 
 194.34f,  198.84f,  203.32f,  207.80f,  212.26f,  216.72f,  221.17f,  225.61f, 
 230.05f,  234.47f,  238.89f,  243.30f,  247.70f,  252.10f,  256.48f,  260.86f, 
 265.23f,  269.59f,  273.93f,  278.27f,  282.59f,  286.91f,  291.21f,  295.50f, 
 299.78f,  304.04f,  308.29f,  312.53f,  316.76f,  320.97f,  325.17f,  329.36f, 
 333.53f,  337.69f,  341.83f,  345.96f,  350.07f,  354.17f,  358.26f,  362.33f, 
 366.38f,  370.42f,  374.45f,  378.46f,  382.45f,  386.43f,  390.40f,  394.34f, 
 398.28f,  402.19f,  406.09f,  409.98f,  413.85f,  417.70f,  421.54f,  425.36f, 
 429.16f,  432.95f,  436.72f,  440.48f,  444.22f,  447.94f,  451.65f,  455.34f, 
 459.01f,  462.67f,  466.31f,  469.94f,  473.55f,  477.14f,  480.71f,  484.27f, 
 487.82f,  491.34f,  494.85f,  498.34f,  501.82f,  505.28f,  508.72f,  512.15f, 
 515.56f,  518.95f,  522.33f,  525.69f,  529.03f,  532.36f,  535.67f,  538.96f, 
 542.24f,  545.50f,  548.74f,  551.97f,  555.17f,  558.37f,  561.54f,  564.70f, 
 567.84f,  570.96f,  574.07f,  577.16f,  580.23f,  583.29f,  586.33f,  589.35f, 
 592.36f,  595.34f,  598.31f,  601.27f,  604.20f,  607.12f,  610.02f,  612.91f, 
 615.77f,  618.62f,  621.45f,  624.26f,  627.06f,  629.84f,  632.60f,  635.34f, 
 638.07f,  640.78f,  643.47f,  646.14f,  648.79f,  651.43f,  654.04f,  656.64f, 
 659.22f,  661.79f,  664.33f,  666.85f,  669.36f,  671.85f,  674.32f,  676.77f, 
 679.21f,  681.62f,  683.99f,  686.35f,  688.71f,  691.05f,  693.38f,  695.71f, 
 698.03f,  700.35f,  702.66f,  704.96f,  707.26f,  709.56f,  711.85f,  714.14f, 
 716.42f,  718.69f,  720.96f,  723.21f,  725.46f,  727.70f,  729.94f,  732.16f, 
 734.38f,  736.60f,  738.82f,  741.04f,  743.26f,  745.48f,  747.70f,  749.92f, 
 752.14f,  754.36f,  756.58f,  758.80f,  761.02f,  763.24f,  765.46f,  767.68f, 
 769.89f,  772.11f,  774.33f,  776.55f,  778.77f,  780.99f,  783.21f,  785.43f, 
 787.65f,  789.87f,  792.09f,  794.31f,  796.53f,  798.75f,  800.97f,  803.19f, 
 805.41f,  807.63f,  809.84f,  812.06f,  814.28f,  816.50f,  818.72f, 1044.17f, 
1045.13f, 1046.09f, 1047.05f, 1048.00f, 1048.96f, 1049.91f, 1050.87f, 1051.83f, 
1052.78f, 1053.74f, 1054.69f, 1055.64f, 1056.60f, 1057.55f, 1058.50f, 1059.46f, 
1060.41f, 1061.36f, 1062.31f, 1063.26f, 1064.21f, 1065.15f, 1066.10f, 1067.04f, 
1067.99f, 1068.93f, 1069.87f, 1070.82f, 1071.76f, 1072.69f, 1073.63f, 1074.57f, 
1075.50f, 1076.43f, 1077.36f, 1078.29f, 1079.22f, 1080.14f, 1081.06f, 1081.98f, 
1082.90f, 1083.81f, 1084.72f, 1085.63f, 1086.54f, 1087.44f, 1088.34f, 1089.24f, 
1090.13f, 1091.02f, 1091.90f, 1092.78f, 1093.65f, 1091.97f, 1093.65f, 1095.27f, 
1096.83f, 1097.95f, 1098.80f, 1099.63f, 1100.46f, 1101.29f, 1102.11f, 1102.92f, 
1103.72f, 1104.52f, 1105.30f, 1106.08f, 1106.86f, 1107.62f, 1108.37f, 1109.12f, 
1109.85f, 1110.58f, 1111.30f, 1112.00f, 1112.70f, 1113.38f, 1114.06f, 1114.72f, 
1115.38f, 1116.02f, 1116.65f, 1117.27f, 1117.88f, 1118.47f, 1119.06f, 1119.63f, 
1120.19f, 1120.74f, 1121.27f, 1121.79f, 1122.30f, 1122.80f, 1123.28f, 1123.75f, 
1124.21f, 1124.65f, 1125.08f, 1125.50f, 1125.90f, 1126.29f, 1126.67f, 1127.03f, 
1127.38f, 1127.71f, 1128.03f, 1128.34f, 1128.63f, 1128.91f, 1129.18f, 1129.43f, 
1129.66f, 1129.88f, 1130.09f, 1130.29f, 1130.47f, 1130.63f, 1130.78f, 1130.92f, 
1131.04f, 1131.15f, 1131.24f, 1131.32f, 1131.39f, 1131.44f, 1131.47f, 1131.50f, 
1131.50f, 
  81.53f,   81.74f,   82.38f,   83.41f,   84.83f,   86.62f,   88.75f,   91.20f, 
  93.95f,   96.95f,  100.18f,  103.62f,  107.25f,  111.03f,  114.95f,  118.99f, 
 123.13f,  127.36f,  131.66f,  136.01f,  140.41f,  144.84f,  149.30f,  153.78f, 
 158.27f,  162.76f,  167.26f,  171.77f,  176.27f,  180.77f,  185.27f,  189.77f, 
 194.25f,  198.73f,  203.20f,  207.66f,  212.12f,  216.57f,  221.01f,  225.44f, 
 229.87f,  234.28f,  238.70f,  243.10f,  247.49f,  251.88f,  256.26f,  260.63f, 
 264.99f,  269.34f,  273.68f,  278.01f,  282.33f,  286.63f,  290.93f,  295.21f, 
 299.48f,  303.74f,  307.98f,  312.21f,  316.43f,  320.64f,  324.83f,  329.01f, 
 333.18f,  337.33f,  341.46f,  345.58f,  349.69f,  353.79f,  357.86f,  361.93f, 
 365.98f,  370.01f,  374.03f,  378.03f,  382.02f,  386.00f,  389.95f,  393.90f, 
 397.82f,  401.73f,  405.63f,  409.51f,  413.37f,  417.22f,  421.05f,  424.87f, 
 428.67f,  432.45f,  436.22f,  439.97f,  443.70f,  447.42f,  451.12f,  454.81f, 
 458.48f,  462.13f,  465.77f,  469.39f,  472.99f,  476.58f,  480.15f,  483.71f, 
 487.25f,  490.77f,  494.27f,  497.76f,  501.24f,  504.69f,  508.13f,  511.55f, 
 514.96f,  518.35f,  521.72f,  525.08f,  528.42f,  531.74f,  535.05f,  538.33f, 
 541.61f,  544.86f,  548.10f,  551.32f,  554.53f,  557.72f,  560.89f,  564.04f, 
 567.18f,  570.30f,  573.41f,  576.49f,  579.56f,  582.61f,  585.65f,  588.67f, 
 591.67f,  594.66f,  597.62f,  600.57f,  603.51f,  606.42f,  609.32f,  612.20f, 
 615.06f,  617.91f,  620.74f,  623.55f,  626.34f,  629.12f,  631.88f,  634.62f, 
 637.34f,  640.04f,  642.73f,  645.40f,  648.05f,  650.68f,  653.30f,  655.89f, 
 658.47f,  661.03f,  663.57f,  666.09f,  668.60f,  671.08f,  673.55f,  676.01f, 
 678.44f,  680.84f,  683.21f,  685.57f,  687.92f,  690.27f,  692.60f,  694.93f, 
 697.25f,  699.56f,  701.87f,  704.18f,  706.48f,  708.77f,  711.06f,  713.35f, 
 715.63f,  717.90f,  720.16f,  722.42f,  724.67f,  726.91f,  729.14f,  731.37f, 
 733.59f,  735.81f,  738.03f,  740.25f,  742.46f,  744.68f,  746.90f,  749.12f, 
 751.34f,  753.56f,  755.78f,  758.00f,  760.22f,  762.44f,  764.66f,  766.88f, 
 769.10f,  771.32f,  773.54f,  775.76f,  777.98f,  780.20f,  782.42f,  784.63f, 
 786.85f,  789.07f,  791.29f,  793.51f,  795.73f,  797.95f,  800.17f,  802.39f, 
 804.61f,  806.83f,  809.05f,  811.27f,  813.49f,  815.71f,  817.93f, 1043.28f, 
1044.24f, 1045.19f, 1046.15f, 1047.11f, 1048.06f, 1049.02f, 1049.98f, 1050.93f, 
1051.89f, 1052.84f, 1053.80f, 1054.75f, 1055.70f, 1056.66f, 1057.61f, 1058.56f, 
1059.51f, 1060.46f, 1061.41f, 1062.36f, 1063.31f, 1064.26f, 1065.21f, 1066.15f, 
1067.10f, 1068.04f, 1068.98f, 1069.92f, 1070.86f, 1071.80f, 1072.74f, 1073.67f, 
1074.61f, 1075.54f, 1076.47f, 1077.40f, 1078.32f, 1079.25f, 1080.17f, 1081.09f, 
1082.00f, 1082.92f, 1083.83f, 1084.74f, 1085.64f, 1086.55f, 1087.44f, 1088.34f, 
1089.23f, 1090.12f, 1091.00f, 1091.88f, 1092.76f, 1091.13f, 1092.80f, 1094.41f, 
1095.97f, 1097.05f, 1097.90f, 1098.74f, 1099.57f, 1100.39f, 1101.21f, 1102.02f, 
1102.82f, 1103.62f, 1104.40f, 1105.18f, 1105.95f, 1106.72f, 1107.47f, 1108.22f, 
1108.95f, 1109.68f, 1110.39f, 1111.10f, 1111.79f, 1112.48f, 1113.16f, 1113.82f, 
1114.47f, 1115.11f, 1115.75f, 1116.36f, 1116.97f, 1117.57f, 1118.15f, 1118.72f, 
1119.28f, 1119.83f, 1120.36f, 1120.88f, 1121.39f, 1121.89f, 1122.37f, 1122.84f, 
1123.30f, 1123.74f, 1124.17f, 1124.59f, 1124.99f, 1125.38f, 1125.75f, 1126.12f, 
1126.47f, 1126.80f, 1127.12f, 1127.43f, 1127.72f, 1128.00f, 1128.26f, 1128.51f, 
1128.75f, 1128.97f, 1129.18f, 1129.37f, 1129.55f, 1129.72f, 1129.87f, 1130.01f, 
1130.13f, 1130.24f, 1130.33f, 1130.41f, 1130.47f, 1130.52f, 1130.56f, 1130.58f, 
1130.59f, 
  82.44f,   82.65f,   83.27f,   84.29f,   85.69f,   87.44f,   89.54f,   91.95f, 
  94.65f,   97.61f,  100.80f,  104.19f,  107.77f,  111.51f,  115.38f,  119.38f, 
 123.48f,  127.66f,  131.92f,  136.23f,  140.59f,  144.99f,  149.42f,  153.87f, 
 158.33f,  162.81f,  167.29f,  171.77f,  176.26f,  180.74f,  185.22f,  189.70f, 
 194.17f,  198.63f,  203.09f,  207.54f,  211.99f,  216.43f,  220.86f,  225.28f, 
 229.70f,  234.11f,  238.51f,  242.91f,  247.30f,  251.68f,  256.05f,  260.41f, 
 264.76f,  269.10f,  273.44f,  277.76f,  282.07f,  286.36f,  290.65f,  294.93f, 
 299.19f,  303.44f,  307.68f,  311.90f,  316.11f,  320.31f,  324.50f,  328.67f, 
 332.83f,  336.97f,  341.10f,  345.22f,  349.32f,  353.40f,  357.48f,  361.53f, 
 365.58f,  369.61f,  373.62f,  377.62f,  381.60f,  385.57f,  389.52f,  393.45f, 
 397.37f,  401.28f,  405.17f,  409.04f,  412.90f,  416.74f,  420.57f,  424.38f, 
 428.17f,  431.95f,  435.71f,  439.46f,  443.19f,  446.90f,  450.60f,  454.28f, 
 457.95f,  461.60f,  465.23f,  468.85f,  472.45f,  476.03f,  479.60f,  483.15f, 
 486.68f,  490.20f,  493.70f,  497.19f,  500.65f,  504.11f,  507.54f,  510.96f, 
 514.36f,  517.75f,  521.12f,  524.47f,  527.80f,  531.12f,  534.43f,  537.71f, 
 540.98f,  544.23f,  547.47f,  550.69f,  553.89f,  557.07f,  560.24f,  563.39f, 
 566.53f,  569.64f,  572.74f,  575.83f,  578.89f,  581.94f,  584.98f,  587.99f, 
 590.99f,  593.97f,  596.94f,  599.88f,  602.81f,  605.73f,  608.62f,  611.50f, 
 614.36f,  617.20f,  620.03f,  622.83f,  625.63f,  628.40f,  631.15f,  633.89f, 
 636.61f,  639.31f,  642.00f,  644.66f,  647.31f,  649.94f,  652.55f,  655.15f, 
 657.72f,  660.28f,  662.82f,  665.34f,  667.84f,  670.32f,  672.79f,  675.24f, 
 677.67f,  680.07f,  682.44f,  684.80f,  687.15f,  689.49f,  691.82f,  694.15f, 
 696.47f,  698.78f,  701.09f,  703.39f,  705.69f,  707.99f,  710.28f,  712.56f, 
 714.84f,  717.11f,  719.38f,  721.63f,  723.88f,  726.12f,  728.35f,  730.57f, 
 732.79f,  735.01f,  737.23f,  739.45f,  741.67f,  743.89f,  746.11f,  748.33f, 
 750.55f,  752.77f,  754.99f,  757.21f,  759.43f,  761.65f,  763.87f,  766.09f, 
 768.31f,  770.52f,  772.74f,  774.96f,  777.18f,  779.40f,  781.62f,  783.84f, 
 786.06f,  788.28f,  790.50f,  792.72f,  794.94f,  797.16f,  799.38f,  801.60f, 
 803.82f,  806.04f,  808.26f,  810.48f,  812.69f,  814.91f,  817.13f, 1042.39f, 
1043.35f, 1044.30f, 1045.26f, 1046.22f, 1047.17f, 1048.13f, 1049.09f, 1050.04f, 
1051.00f, 1051.95f, 1052.91f, 1053.86f, 1054.81f, 1055.77f, 1056.72f, 1057.67f, 
1058.62f, 1059.57f, 1060.52f, 1061.47f, 1062.42f, 1063.37f, 1064.31f, 1065.26f, 
1066.20f, 1067.15f, 1068.09f, 1069.03f, 1069.97f, 1070.91f, 1071.84f, 1072.78f, 
1073.71f, 1074.64f, 1075.57f, 1076.50f, 1077.43f, 1078.35f, 1079.27f, 1080.19f, 
1081.11f, 1082.02f, 1082.94f, 1083.84f, 1084.75f, 1085.65f, 1086.55f, 1087.45f, 
1088.34f, 1089.22f, 1090.11f, 1090.99f, 1091.86f, 1090.29f, 1091.95f, 1093.56f, 
1095.12f, 1096.16f, 1097.00f, 1097.84f, 1098.67f, 1099.49f, 1100.31f, 1101.12f, 
1101.92f, 1102.72f, 1103.51f, 1104.28f, 1105.06f, 1105.82f, 1106.57f, 1107.32f, 
1108.05f, 1108.78f, 1109.49f, 1110.20f, 1110.89f, 1111.58f, 1112.25f, 1112.92f, 
1113.57f, 1114.21f, 1114.84f, 1115.46f, 1116.07f, 1116.66f, 1117.25f, 1117.82f, 
1118.38f, 1118.92f, 1119.46f, 1119.98f, 1120.49f, 1120.98f, 1121.46f, 1121.93f, 
1122.39f, 1122.83f, 1123.26f, 1123.68f, 1124.08f, 1124.47f, 1124.85f, 1125.21f, 
1125.56f, 1125.89f, 1126.21f, 1126.52f, 1126.81f, 1127.09f, 1127.35f, 1127.60f, 
1127.84f, 1128.06f, 1128.27f, 1128.46f, 1128.64f, 1128.81f, 1128.96f, 1129.09f, 
1129.22f, 1129.32f, 1129.42f, 1129.50f, 1129.56f, 1129.61f, 1129.65f, 1129.67f, 
1129.68f, 
  83.35f,   83.56f,   84.17f,   85.17f,   86.54f,   88.26f,   90.32f,   92.70f, 
  95.36f,   98.27f,  101.42f,  104.77f,  108.30f,  111.99f,  115.82f,  119.78f, 
 123.83f,  127.97f,  132.19f,  136.47f,  140.80f,  145.16f,  149.56f,  153.98f, 
 158.42f,  162.87f,  167.33f,  171.79f,  176.25f,  180.72f,  185.18f,  189.64f, 
 194.10f,  198.55f,  202.99f,  207.43f,  211.87f,  216.30f,  220.72f,  225.13f, 
 229.54f,  233.95f,  238.34f,  242.73f,  247.11f,  251.48f,  255.85f,  260.20f, 
 264.54f,  268.88f,  273.20f,  277.51f,  281.81f,  286.10f,  290.38f,  294.65f, 
 298.90f,  303.15f,  307.38f,  311.60f,  315.80f,  319.99f,  324.17f,  328.33f, 
 332.48f,  336.62f,  340.74f,  344.85f,  348.95f,  353.03f,  357.09f,  361.15f, 
 365.18f,  369.20f,  373.21f,  377.20f,  381.18f,  385.14f,  389.09f,  393.02f, 
 396.93f,  400.83f,  404.72f,  408.58f,  412.44f,  416.27f,  420.09f,  423.90f, 
 427.69f,  431.46f,  435.22f,  438.96f,  442.68f,  446.39f,  450.09f,  453.76f, 
 457.42f,  461.07f,  464.70f,  468.31f,  471.90f,  475.48f,  479.04f,  482.59f, 
 486.12f,  489.63f,  493.13f,  496.61f,  500.08f,  503.52f,  506.96f,  510.37f, 
 513.77f,  517.15f,  520.51f,  523.86f,  527.20f,  530.51f,  533.81f,  537.09f, 
 540.36f,  543.60f,  546.84f,  550.05f,  553.25f,  556.43f,  559.60f,  562.74f, 
 565.87f,  568.99f,  572.09f,  575.17f,  578.23f,  581.28f,  584.31f,  587.32f, 
 590.31f,  593.29f,  596.25f,  599.20f,  602.12f,  605.03f,  607.92f,  610.80f, 
 613.66f,  616.50f,  619.32f,  622.12f,  624.91f,  627.68f,  630.43f,  633.17f, 
 635.89f,  638.59f,  641.27f,  643.93f,  646.58f,  649.20f,  651.81f,  654.40f, 
 656.98f,  659.53f,  662.07f,  664.58f,  667.08f,  669.56f,  672.03f,  674.48f, 
 676.90f,  679.29f,  681.67f,  684.02f,  686.37f,  688.71f,  691.04f,  693.37f, 
 695.69f,  698.00f,  700.31f,  702.61f,  704.91f,  707.21f,  709.50f,  711.78f, 
 714.06f,  716.33f,  718.59f,  720.85f,  723.09f,  725.33f,  727.56f,  729.78f, 
 732.00f,  734.22f,  736.44f,  738.66f,  740.88f,  743.10f,  745.32f,  747.54f, 
 749.76f,  751.98f,  754.20f,  756.42f,  758.64f,  760.86f,  763.08f,  765.30f, 
 767.52f,  769.73f,  771.95f,  774.17f,  776.39f,  778.61f,  780.83f,  783.05f, 
 785.27f,  787.49f,  789.71f,  791.93f,  794.15f,  796.37f,  798.59f,  800.81f, 
 803.03f,  805.25f,  807.47f,  809.68f,  811.90f,  814.12f,  816.34f, 1041.50f, 
1042.46f, 1043.41f, 1044.37f, 1045.33f, 1046.28f, 1047.24f, 1048.20f, 1049.15f, 
1050.11f, 1051.06f, 1052.02f, 1052.97f, 1053.92f, 1054.88f, 1055.83f, 1056.78f, 
1057.73f, 1058.68f, 1059.63f, 1060.58f, 1061.53f, 1062.48f, 1063.42f, 1064.37f, 
1065.31f, 1066.26f, 1067.20f, 1068.14f, 1069.08f, 1070.02f, 1070.95f, 1071.89f, 
1072.82f, 1073.75f, 1074.68f, 1075.61f, 1076.54f, 1077.46f, 1078.38f, 1079.30f, 
1080.22f, 1081.13f, 1082.04f, 1082.95f, 1083.86f, 1084.76f, 1085.66f, 1086.55f, 
1087.44f, 1088.33f, 1089.22f, 1090.09f, 1090.97f, 1089.44f, 1091.10f, 1092.71f, 
1094.26f, 1095.27f, 1096.11f, 1096.94f, 1097.77f, 1098.60f, 1099.42f, 1100.23f, 
1101.03f, 1101.82f, 1102.61f, 1103.39f, 1104.16f, 1104.92f, 1105.67f, 1106.42f, 
1107.15f, 1107.88f, 1108.59f, 1109.30f, 1109.99f, 1110.68f, 1111.35f, 1112.02f, 
1112.67f, 1113.31f, 1113.94f, 1114.56f, 1115.17f, 1115.76f, 1116.34f, 1116.91f, 
1117.47f, 1118.02f, 1118.55f, 1119.07f, 1119.58f, 1120.08f, 1120.56f, 1121.03f, 
1121.48f, 1121.93f, 1122.36f, 1122.77f, 1123.17f, 1123.56f, 1123.94f, 1124.30f, 
1124.65f, 1124.98f, 1125.30f, 1125.61f, 1125.90f, 1126.18f, 1126.44f, 1126.69f, 
1126.93f, 1127.15f, 1127.36f, 1127.55f, 1127.73f, 1127.90f, 1128.05f, 1128.18f, 
1128.31f, 1128.41f, 1128.51f, 1128.59f, 1128.65f, 1128.70f, 1128.74f, 1128.76f, 
1128.77f, 
  84.26f,   84.46f,   85.06f,   86.05f,   87.39f,   89.09f,   91.11f,   93.45f, 
  96.07f,   98.94f,  102.04f,  105.35f,  108.84f,  112.48f,  116.27f,  120.18f, 
 124.20f,  128.30f,  132.48f,  136.72f,  141.01f,  145.34f,  149.71f,  154.10f, 
 158.51f,  162.94f,  167.37f,  171.82f,  176.26f,  180.71f,  185.16f,  189.60f, 
 194.04f,  198.48f,  202.91f,  207.34f,  211.76f,  216.18f,  220.59f,  225.00f, 
 229.40f,  233.80f,  238.18f,  242.56f,  246.94f,  251.30f,  255.65f,  260.00f, 
 264.33f,  268.66f,  272.97f,  277.28f,  281.57f,  285.85f,  290.12f,  294.38f, 
 298.63f,  302.86f,  307.09f,  311.30f,  315.49f,  319.68f,  323.85f,  328.01f, 
 332.15f,  336.28f,  340.39f,  344.50f,  348.58f,  352.66f,  356.72f,  360.76f, 
 364.79f,  368.81f,  372.81f,  376.79f,  380.76f,  384.72f,  388.66f,  392.58f, 
 396.49f,  400.39f,  404.27f,  408.13f,  411.98f,  415.81f,  419.62f,  423.42f, 
 427.21f,  430.97f,  434.73f,  438.46f,  442.18f,  445.89f,  449.57f,  453.25f, 
 456.90f,  460.54f,  464.16f,  467.77f,  471.36f,  474.94f,  478.50f,  482.04f, 
 485.56f,  489.07f,  492.57f,  496.04f,  499.50f,  502.95f,  506.37f,  509.78f, 
 513.18f,  516.56f,  519.92f,  523.26f,  526.59f,  529.90f,  533.20f,  536.47f, 
 539.74f,  542.98f,  546.21f,  549.42f,  552.61f,  555.79f,  558.95f,  562.10f, 
 565.23f,  568.34f,  571.43f,  574.51f,  577.57f,  580.61f,  583.64f,  586.65f, 
 589.64f,  592.61f,  595.57f,  598.51f,  601.44f,  604.34f,  607.23f,  610.10f, 
 612.96f,  615.80f,  618.62f,  621.42f,  624.20f,  626.97f,  629.72f,  632.45f, 
 635.17f,  637.86f,  640.54f,  643.20f,  645.84f,  648.47f,  651.08f,  653.66f, 
 656.23f,  658.79f,  661.32f,  663.83f,  666.33f,  668.81f,  671.27f,  673.72f, 
 676.14f,  678.53f,  680.90f,  683.25f,  685.60f,  687.94f,  690.27f,  692.59f, 
 694.91f,  697.23f,  699.53f,  701.84f,  704.13f,  706.43f,  708.72f,  711.00f, 
 713.28f,  715.55f,  717.81f,  720.06f,  722.31f,  724.55f,  726.78f,  729.00f, 
 731.22f,  733.44f,  735.66f,  737.87f,  740.09f,  742.31f,  744.53f,  746.75f, 
 748.97f,  751.19f,  753.41f,  755.63f,  757.85f,  760.07f,  762.29f,  764.51f, 
 766.73f,  768.95f,  771.17f,  773.39f,  775.61f,  777.83f,  780.04f,  782.26f, 
 784.48f,  786.70f,  788.92f,  791.14f,  793.36f,  795.58f,  797.80f,  800.02f, 
 802.24f,  804.46f,  806.68f,  808.90f,  811.12f,  813.34f,  815.56f, 1040.61f, 
1041.57f, 1042.53f, 1043.48f, 1044.44f, 1045.40f, 1046.35f, 1047.31f, 1048.27f, 
1049.22f, 1050.18f, 1051.13f, 1052.08f, 1053.04f, 1053.99f, 1054.94f, 1055.89f, 
1056.85f, 1057.80f, 1058.75f, 1059.70f, 1060.64f, 1061.59f, 1062.54f, 1063.48f, 
1064.43f, 1065.37f, 1066.31f, 1067.25f, 1068.19f, 1069.13f, 1070.07f, 1071.00f, 
1071.94f, 1072.87f, 1073.80f, 1074.72f, 1075.65f, 1076.57f, 1077.50f, 1078.41f, 
1079.33f, 1080.24f, 1081.16f, 1082.06f, 1082.97f, 1083.87f, 1084.77f, 1085.66f, 
1086.56f, 1087.44f, 1088.33f, 1089.20f, 1090.08f, 1088.60f, 1090.26f, 1091.86f, 
1093.41f, 1094.37f, 1095.22f, 1096.05f, 1096.88f, 1097.71f, 1098.52f, 1099.33f, 
1100.13f, 1100.93f, 1101.72f, 1102.49f, 1103.26f, 1104.03f, 1104.78f, 1105.52f, 
1106.26f, 1106.98f, 1107.70f, 1108.40f, 1109.10f, 1109.78f, 1110.46f, 1111.12f, 
1111.77f, 1112.41f, 1113.04f, 1113.66f, 1114.27f, 1114.86f, 1115.44f, 1116.01f, 
1116.57f, 1117.12f, 1117.65f, 1118.17f, 1118.68f, 1119.17f, 1119.66f, 1120.13f, 
1120.58f, 1121.02f, 1121.45f, 1121.87f, 1122.27f, 1122.66f, 1123.03f, 1123.40f, 
1123.74f, 1124.08f, 1124.40f, 1124.70f, 1124.99f, 1125.27f, 1125.54f, 1125.79f, 
1126.02f, 1126.24f, 1126.45f, 1126.65f, 1126.82f, 1126.99f, 1127.14f, 1127.28f, 
1127.40f, 1127.51f, 1127.60f, 1127.68f, 1127.74f, 1127.79f, 1127.83f, 1127.85f, 
1127.86f}; 				/* 750km */
#endif
