/*   The "j" parameters (1 st line) are intended to be user settable:
        jmod   Maximum number of (rough) model points.
        jslo   Maximum number of discrete ray parameters.
        jdep   Maximum number of discrete model slowness samples.
               Note:  jdep always need to be larger than jslo by
               approximately 50% to account for multi-valuedness
               due to high slowness zones.
        jsrc   Maximum number of discrete model slowness samples above
               the maximum source depth of interest.
        jbrh   Maximum number of tau branches (model discontinuities
               plus one).
        jlvz   Maximum number of low velocity zones.
        jseg   Maximum number of different types of travel-times
               considered.
        jbrn   Maximum number of different travel-time branches to be
               searched.
        jout   Maximum length of all travel-time branches strung
               together.
*/
#define JMOD	160
#define JSLO	350
#define JDEP	450
#define JSRC	150
#define JBRH	20
#define JLVZ	5
#define JSEG	30
#define JBRN	100
#define JOUT	2500
//   The parameters actually used are all derivatives of the "j"
//   parameters and cannot be changed by the user.
#define NMD0	JMOD
#define NSL1	JSLO+1
#define NDP1	JDEP+1
#define NSR0	JSRC
#define NBR1	JBRH+2
#define NBR2	JBRH*2
#define NCP0	2*(JBRH+JLVZ)
#define NLVZ0	JLVZ
