/****************************************************************************
PTABLE.C

This program was based on the program TTIM taken from the NEIC ftp site in 
FORTRAN and converted to C at WC&ATWC.  

Its purpose is to create travel time data files in the same form as the old
Jeffereys-Bullen tables used for locations at the WC/ATWC.  The new table
is arranged as:
Depth 0:tt[0], tt[0.5], tt[1.0], tt[1.5], ... tt[180.0]
Depth 10:tt[0], tt[0.5], tt[1.0], tt[1.5], ... tt[180.0]
Depth 20:tt[0], tt[0.5], tt[1.0], tt[1.5], ... tt[180.0]
	.
	.
	.
Depth 750:tt[0], tt[0.5], tt[1.0], tt[1.5], ... tt[180.0].

This program can be set up to run for each depth or to loop on the depths.
The distances are automatically incremented by 0.5 degrees starting at 0 and
ending at 180.  From 0-115 degrees, the first P time is saved.  Past 115
degrees, the first PKP branch is saved.

        Contributors:       NEIC/ Converted to C by Whitmore in '99
        OS:                 Windows NT v4.0
        Compiler:           Microsoft Visual C++ v6.0
	Link Info:	    See ptable.mak
	                    include ...taulib.obj in the link,
        Compile Info:       See ptable.mak
---------------------------------------------------------------------------*/
#include <windows.h>
#include <winuser.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "ttlim.h"
#include "iasplib.h"
typedef BOOL bool;

int main (void)
{
bool	bPrint[3];
double	dDDdp[MAX];
double	dDep;			// Origin depth in km
double	dDist;			// Epicentral Distance in degrees
double	dDTdd[MAX];
double	dDTdh[MAX];
double	dPTT;			// P (PKP) time saved to file
double	dTT[MAX];
double	dUsrC[2];
FILE 	*hFile, *hFileTbl, *hPFile;
int	i, iCnt;		// based on 0
int	n;			// based on 1
char	szPhase[MAX][PHASE_LENGTH], szPhaseLst[10][PHASE_LENGTH];
char	szModname[] = {"iasp91"};

	// Initialize some things
strcpy (szPhaseLst[0], "P");
bPrint[0] = FALSE;
bPrint[1] = FALSE;
bPrint[2] = TRUE;

	// Open listing file
hFile = fopen ("ttim1.lis", "w");

	// Read in tables
tabin (&hFileTbl, szModname, hFile);

	// Set phases desired
brnset (1, szPhaseLst, bPrint, hFile);

hPFile = fopen ("pfile.dat", "w");
dDep = 0.;
	// Loop over depth at 25km increments
while (dDep <= 750.1)
    {
    depset (dDep, dUsrC, hFile, hFileTbl);
    dDist = 0.;
    iCnt = 0;
    	// Loop over distance at 0.5 degree increments
    while (dDist <= 180.1)
        {
        trtm (dDist, &n, dTT, dDTdd, dDTdh, dDDdp, szPhase);
        if (dDist <= 115.1)		// Use first P or Pdiff
            {
	    dPTT = dTT[0];
 	    }
          else			// Use first branch of PKP
            {
	    for (i=0; i<n; i++)
	        if (strstr (szPhase[i], "PKP") != NULL)
	            {
	            dPTT = dTT[i];
		    break;
		    }
            }
        fprintf (hPFile, "%7.2f, ", dPTT);
        iCnt++;
        if (iCnt == 8)
            {
	    fprintf (hPFile, "\n");
	    iCnt = 0;
	    }
        dDist += 0.5;
        }
    fprintf (hPFile, "\n");
    dDep += 10.;
    }
fclose (hPFile);
fclose (hFile);
fclose (hFileTbl);
return (0);
}
