/****************************************************************************
SETBRN.C

These functions were taken from the NEIC ftp site in FORTRAN and converted
to C at WC&ATWC.  

They are part of the package of programs which compute seismic travel times
and travel time tables given a modern model of the earth's spherically 
symetric shells. Many phases can be computed given the model.

SETBRN generates the P/S velocity model used in computing phase times.

        Contributors:       NEIC (Buland)/ Converted to C by Whitmore
        Conversion Date:    March, 1999
        OS:                 Windows NT v4.0
        Compiler:           Microsoft Visual C++ v6.0
        Link Info:          link with iasplib.obj
        Compile Info:       See setbrn.mak
---------------------------------------------------------------------------*/
#include <windows.h>
#include <winuser.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "limits.h"
#include "iasplib.h"
typedef BOOL bool;

#define PHASE_LENGTH	8	// Max String length for phase names

	// Functions
void collct (int, int, double [], double);
void kseq (void);
void layout (void);
void mkcbr (int, int, int, int, int, int, double []);
void mkdbr (int, int, int, int, int, int, double []);
void mkrbr (int, int, int, int, int, double []);
void mkubr (int, int);
void mseq (void);
void pdect (int, int, int, int, double);
void pdecx (int, int, double [2][NSL1], double fac);
double varn (double [], int, int, int, int, double, double, int, int *);

	// Global Variables
double	dCoef[5][JOUT];
double	dFcs[JSEG][3];
double	dPb[NSL1];
double	dPm[NSR0][2];
double	dPt[JOUT];
double	dPu[NSL1][2];
double	dPux[JBRN][2];
double	dPx[JBRN][2];
double	dTaul[NLVZ0][2];
double	dTaup[NSL1][3][2];
double	dTaut[JOUT];
double	dXa[JOUT];
double	dXl[NLVZ0][2];
double	dXmin;
double	dXp[NSL1][3][2];
double	dXt[JBRN][2];
double	dZm[NSR0][2];
int	iIndx[JSEG][2];
int	iJndx[JBRN][2];
int	iKb[2];
int	iKm[2];
int	iKndx[JSEG][2];
int	iKu[2];
int	iKuse[NSL1][2];
int	iLbb[2];
int	iLbrk[NBR2][2];
int	iLcb[2];
int	iLt[2];
int	iLvz[NLVZ0][2];
int	iMidx[JBRN][2];
int	iMndx[JBRN][2];
int	iMt[2];
int	iNafl[JSEG][3];
int	iNbrn;
int	iNdex[NSR0][2];
int	iNl;
int	iNSeg;
char	szCode[NBR1][2][PHASE_LENGTH];
char	szPhcd[JBRN][PHASE_LENGTH];

int main (void)
{
static	double	xn, pn, tn, zmax, zoc, zic, z0, cn, dTemp;
static	double	dtol = 1.e-6;
static	double	tmp[NSL1][2], xm[2][NSL1];
static	int	i, j, k, l, nph, nb, m;	  		     	// based on 0
static	int	nrec, ind, jnd, icor, m1, k1, n, n1;	// based on 1
static	int	len0, len1, len2, nasgr, ndasr;
static	int	ndx2[NSR0][2];
static	FILE	*hFileRHed, *hFileRTbl, *hFileSHed, *hFileSTbl, 
	        *hFile1, *hFile2, *hFile3;
static	char	szModelName[20], szTemp[20];

dXmin = 200.;
if ((hFileRHed = fopen ("remodl.hed", "rb")) == NULL)
    {
    printf ("Couldn't open remodl.hed\n");
    exit (0);
    }
fread (&ndasr, sizeof (int), 1, hFileRHed);
fread (szModelName, 20, 1, hFileRHed);
fread (&zmax, sizeof (double), 1, hFileRHed);
fread (&zoc, sizeof (double), 1, hFileRHed);
fread (&zic, sizeof (double), 1, hFileRHed);
fread (&iKb[0], sizeof (int), 1, hFileRHed);
fread (&iKb[1], sizeof (int), 1, hFileRHed);
for (i=0; i<iKb[1]; i++) fread (&dPb[i], sizeof (double), 1, hFileRHed);
fread (&iMt[0], sizeof (int), 1, hFileRHed);
fread (&iMt[1], sizeof (int), 1, hFileRHed);
fread (&iLt[0], sizeof (int), 1, hFileRHed);
fread (&iLt[1], sizeof (int), 1, hFileRHed);
fread (&iLbb[0], sizeof (int), 1, hFileRHed);
fread (&iLbb[1], sizeof (int), 1, hFileRHed);
fread (&iLcb[0], sizeof (int), 1, hFileRHed);
fread (&iLcb[1], sizeof (int), 1, hFileRHed);
fread (&xn, sizeof (double), 1, hFileRHed);
fread (&pn, sizeof (double), 1, hFileRHed);
fread (&tn, sizeof (double), 1, hFileRHed);
for (nph=0; nph<2; nph++)
    {
    for (i=0; i<iLbb[nph]; i++) 
        fread (&iLbrk[i][nph], sizeof (int), 1, hFileRHed);
    for (i=0; i<iLcb[nph]; i++)
        fread (szCode[i][nph], PHASE_LENGTH, 1, hFileRHed);
    for (i=0; i<iMt[nph]; i++)
        {
        fread (&dZm[i][nph], sizeof (double), 1, hFileRHed);
        fread (&dPm[i][nph], sizeof (double), 1, hFileRHed);
        fread (&iNdex[i][nph], sizeof (int), 1, hFileRHed);
	}
    for (i=0; i<iLt[nph]; i++)
        {
        fread (&iLvz[i][nph], sizeof (int), 1, hFileRHed);
        fread (&dTaul[i][nph], sizeof (double), 1, hFileRHed);
        fread (&dXl[i][nph], sizeof (double), 1, hFileRHed);
	}
    }
fclose (hFileRHed);

printf ("ndasr = %ld, modnam = %s\n", ndasr, szModelName);
hFileRTbl = fopen ("remodl.tbl", "rb");
nrec=0;

for (nph=0; nph<2; nph++)
    {
    n1 = iKb[nph];
    ind = 0;
    for (k=0; k<n1; k++) xm[nph][k] = 0.;
    AddNrec:
    nrec++;
    fread (&z0, sizeof (double), 1, hFileRTbl);
    fread (&n, sizeof (int), 1, hFileRTbl);
    for (k=0; k<n; k++) fread (&tmp[k][0], sizeof (double), 1, hFileRTbl);
    for (k=0; k<n; k++) fread (&tmp[k][1], sizeof (double), 1, hFileRTbl);
//    fscanf (hFileRTbl, "%lf %ld ", &z0, &n);
//    for (k=0; k<n; k++) fscanf (hFileRTbl, "%lf ", &tmp[k][0]);
//    for (k=0; k<n; k++) fscanf (hFileRTbl, "%lf ", &tmp[k][1]);
    if (ind > 0) goto AddInd;
    if (fabs (z0-zoc) <= dtol) goto AddInd;
    j = 0;
    for (k=1; k<n; k++)
        {
        xm[nph][k] = max (xm[nph][k], fabs (tmp[j][1]-tmp[k][1]));
        j = k;
        }
    if (n+1 == n1) xm[nph][n1-1] = tmp[n-1][1];
    goto AddNrec;
    AddInd:
    ind++;
    for (k=0; k<n; k++)
        {
        dTaup[k][ind-1][nph] = tmp[k][0];
        dXp[k][ind-1][nph] = tmp[k][1];
	}
    if (ind < 3) goto AddNrec;
    }
dXmin = xn * dXmin;

hFile1 = fopen ("setbrn1.lis", "w");
fprintf (hFile1, "kb mt lt iLbb iLcb %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld\n",
         iKb[0], iKb[1], iMt[0], iMt[1], iLt[0], iLt[1], iLbb[0], iLbb[1], 
         iLcb[0], iLcb[1]);
fprintf (hFile1, "xn pn tn xmin %lf %lf %lf %lf\n", xn, pn, tn, dXmin);

cn = 1. / xn;
for (i=0; i<iLbb[0]; i++)
    fprintf (hFile1, "%4ld %4ld  %s %4ld  %s\n", i+1, iLbrk[i][0], szCode[i][0],
             iLbrk[i][1], szCode[i][1]);
for (i=iLbb[0]; i<iLbb[1]; i++)
    fprintf (hFile1, "%ld             %4ld  %s\n", i+1, iLbrk[i][1], szCode[i][1]);
for (i=0; i<iMt[0]; i++)
    fprintf (hFile1, "%ld %lf %lf %ld  %lf %lf %ld\n", i+1, dZm[i][0], 
             dPm[i][0], iNdex[i][0], dZm[i][1], dPm[i][1], iNdex[i][1]);
for (i=iMt[0]; i<iMt[1]; i++)
    fprintf (hFile1, "%ld              %lf %lf %ld\n", i+1, dZm[i][1], dPm[i][1],
             iNdex[i][1]);
for (nph=0; nph<2; nph++)
    for (i=0; i<iLt[nph]; i++)
        fprintf (hFile1, "%ld %ld %ld %lf %lf\n", nph+1, i+1, iLvz[i][nph], 
                 dTaul[i][nph], DEG*dXl[i][nph]);
for (i=0; i<iKb[0]; i++)
    fprintf (hFile1, "    %ld %lf %lf %lf\n", i+1, dPb[i], cn*xm[0][i], 
             cn*xm[1][i]);
for (i=iKb[0]; i<iKb[1]; i++)
    fprintf (hFile1, "    %ld %lf           %lf\n", i+1, dPb[i], cn*xm[1][i]);
fclose (hFile1);

hFile2 = fopen ("setbrn2.lis", "w");

for (nph=0; nph<2; nph++)
    {
    n1 = iKb[nph];
    for (i=1; i<n1; i++)
        {
        xm[nph][i] = xm[nph][i-1] + xm[nph][i];
        dPu[i][nph] = dPb[i];
        iKuse[i][nph] = -1;
        }
    for (ind=3; ind>=2; ind--)
        {
	jnd = ind - 1;
	for (i=0; i<n1; i++)
	    {
            dTaup[i][ind-1][nph] = dTaup[i][ind-1][nph] - dTaup[i][jnd-1][nph];
            dXp[i][ind-1][nph] = dXp[i][ind-1][nph] - dXp[i][jnd-1][nph];
            }
        }
    }
for (nph=0; nph<2; nph++) pdecx (iKb[nph], nph, xm, 2.);

fprintf (hFile2, "ku %ld %ld\n\n", iKu[0], iKu[1]);
for (i=0; i<iKu[0]; i++)
    fprintf (hFile2, "     %ld %lf %lf %lf %lf %lf %lf\n", i+1, dPu[i][0], 
             cn*xm[0][i], cn*(xm[0][i+1]-xm[0][i]), dPu[i][1], 
             cn*xm[1][i], cn*(xm[1][i+1]-xm[1][i]));
for (i=iKu[0]; i<iKu[1]; i++)
    fprintf (hFile2, "     %ld                  %lf %lf %lf\n", i+1, dPu[i][1], 
             cn*xm[1][i], cn*(xm[1][i+1]-xm[1][i]));
for (nph=0; nph<2; nph++)
    for (i=0; i<iKb[nph]; i++)
        fprintf (hFile2, "%ld %lf %lf %lf %lf %lf %lf %lf\n", i+1, dPb[i],
	         dTaup[i][0][nph], dTaup[i][1][nph], dTaup[i][2][nph], 
		 DEG*dXp[i][0][nph], DEG*dXp[i][1][nph], DEG*dXp[i][2][nph]);

layout ();

// for (i=0; i<iKb[1]; i++)
//     fprintf (hFile2, "     %ld %lf %ld %ld\n", i, dPb[i], iKuse[i][0], 
//              iKuse[i][1]);

//printf ("past layout\n");

for (nph=0; nph<2; nph++)
    {
    n1 = iKb[nph];
    k = -1;
    for (i=0; i<n1; i++)
        {
        if (iKuse[i][nph] < 0) continue;
        k++;
        dPu[k][nph] = dPb[i];
        }
    iKu[nph] = k+1;
    }
kseq ();
mseq ();

for (i=0; i<iKu[0]; i++)
    fprintf (hFile2, "     %ld %lf %lf\n", i+1, dPu[i][0], dPu[i][1]);
for (i=iKu[0]; i<iKu[1]; i++)
    fprintf (hFile2, "     %ld           %lf\n", i+1, dPu[i][1]);
for (i=0; i<iNSeg; i++)
    fprintf (hFile2, " %ld %ld %ld %ld %ld %ld %ld %ld %lf %lf %lf\n", 
             i+1, iNafl[i][0], iNafl[i][1], iNafl[i][2], 
             iIndx[i][0], iIndx[i][1], iKndx[i][0], iKndx[i][1],
	     dFcs[i][0], dFcs[i][1], dFcs[i][2]);
for (i=0; i<iNbrn; i++)
    fprintf (hFile2, " %ld %ld %ld %ld %ld %lf %lf %lf %lf %s\n", 
             i+1, iJndx[i][0], iJndx[i][1], iMndx[i][0], iMndx[i][1],
	     dPx[i][0], dPx[i][1], DEG*dXt[i][0], DEG*dXt[i][1], szPhcd[i]);
for (i=0; i<max (iKm[0], iKm[1]); i++)
    fprintf (hFile2, " %ld %ld %ld %lf %lf\n", 
             i+1, iMidx[i][0], iMidx[i][1], dPux[i][0], dPux[i][1]);
for (i=0; i<iNl; i++)
    fprintf (hFile2, " %ld %lf %lf %lf %lf %lE %lE %lE %lE %lE\n", 
             i+1, dPt[i], dTaut[i], DEG*dXa[i], cn*(dXa[i]-dXa[i+1]),
	     dCoef[0][i], dCoef[1][i], dCoef[2][i], dCoef[3][i], dCoef[4][i]);
fclose (hFile2);

hFile3 = fopen ("setbrn3.lis", "w");
for (nph=0; nph<2; nph++)
    {
    iMt[nph] = iMt[nph] - 3;
    iKu[nph] = iKu[nph] - 1;
    iKm[nph] = iKm[nph] - 1;
    }
	// icor=33  -  originally 32 records used as header in setbrn
	// and 2 records used as header in remodl.
icor = 3;
for (nph=0; nph<2; nph++)
    {
    m1 = iMt[nph];
    icor = icor - 3;
    for (i=1; i<m1; i++)
        ndx2[i][nph] = iNdex[i][nph] + icor;
    }
len1 = iKu[1] + iKm[1];
len0 = 8 * len1;
len2 = 5 * iNl;
fprintf (hFile3, "nseg nbrn mt ku km len len1 %ld %ld %ld %ld %ld %ld %ld %ld"
         " %ld %ld\n", iNSeg, iNbrn, iMt[0], iMt[1], iKu[0], iKu[1], 
         iKm[0], iKm[1], len0, len1);
fprintf (hFile3, "\n");
nasgr = len0;
printf ("reclength for direct access %ld\n", nasgr);

nb = strstr (szModelName, " ") - szModelName;
if (nb <= 0) nb = strlen (szModelName);

printf ("header file  : %s.hed\n", szModelName);
printf ("table file   : %s.tbl\n", szModelName);
strcpy (szTemp, szModelName);
strcat (szTemp, ".hed");
hFileSHed = fopen (szTemp, "wb");

fwrite (&nasgr, sizeof (int), 1, hFileSHed);
fwrite (&iNl, sizeof (int), 1, hFileSHed);
fwrite (&len2, sizeof (int), 1, hFileSHed);
fwrite (&xn, sizeof (double), 1, hFileSHed);
fwrite (&pn, sizeof (double), 1, hFileSHed);
fwrite (&tn, sizeof (double), 1, hFileSHed);
fwrite (&iMt[0], sizeof (int), 1, hFileSHed);
fwrite (&iMt[1], sizeof (int), 1, hFileSHed);
fwrite (&iNSeg, sizeof (int), 1, hFileSHed);
fwrite (&iNbrn, sizeof (int), 1, hFileSHed);
fwrite (&iKu[0], sizeof (int), 1, hFileSHed);
fwrite (&iKu[1], sizeof (int), 1, hFileSHed);
fwrite (&iKm[0], sizeof (int), 1, hFileSHed);
fwrite (&iKm[1], sizeof (int), 1, hFileSHed);
for (j=0; j<3; j++)
    for (i=0; i<JSEG; i++)
        fwrite (&dFcs[i][j], sizeof (double), 1, hFileSHed);
for (j=0; j<3; j++)
    for (i=0; i<JSEG; i++)
        fwrite (&iNafl[i][j], sizeof (int), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<JSEG; i++)
        fwrite (&iIndx[i][j], sizeof (int), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<JSEG; i++)
        fwrite (&iKndx[i][j], sizeof (int), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<NSR0; i++)
        fwrite (&dPm[i][j], sizeof (double), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<NSR0; i++)
        fwrite (&dZm[i][j], sizeof (double), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<NSR0; i++)
        fwrite (&ndx2[i][j], sizeof (int), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<NSL1; i++)
        fwrite (&dPu[i][j], sizeof (double), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<JBRN; i++)
        fwrite (&dPux[i][j], sizeof (double), 1, hFileSHed);
for (i=0; i<JBRN; i++)
    fwrite (szPhcd[i], PHASE_LENGTH, 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<JBRN; i++)
        fwrite (&dPx[i][j], sizeof (double), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<JBRN; i++)
        fwrite (&dXt[i][j], sizeof (double), 1, hFileSHed);
for (j=0; j<2; j++)
    for (i=0; i<JBRN; i++)
        fwrite (&iJndx[i][j], sizeof (int), 1, hFileSHed);
for (i=0; i<JOUT; i++)
    fwrite (&dPt[i], sizeof (double), 1, hFileSHed);
for (i=0; i<JOUT; i++)
    fwrite (&dTaut[i], sizeof (double), 1, hFileSHed);
for (j=0; j<JOUT; j++)
    for (i=0; i<5; i++)
        fwrite (&dCoef[i][j], sizeof (double), 1, hFileSHed);
fclose (hFileSHed);

strcpy (szTemp, szModelName);
strcat (szTemp, ".tbl");
hFileSTbl = fopen (szTemp, "wb");
nrec = 0;
dTemp = 0.;
rewind (hFileRTbl);
for (nph=0; nph<2; nph++)
    {
    m1 = iMt[nph];
    n1 = iKu[nph];
    k1 = iKm[nph];
    fprintf (hFile3, "nph m1 n1 k1 %ld %ld %ld %ld\n", nph, m1, n1, k1);
    for (m=1; m<m1; m++)
        {
        if (iNdex[m][nph] == iNdex[m-1][nph]) continue;
        fread (&z0, sizeof (double), 1, hFileRTbl);
        fread (&n, sizeof (int), 1, hFileRTbl);
        for (k=0; k<n; k++) fread (&tmp[k][0], sizeof (double), 1, hFileRTbl);
        for (k=0; k<n; k++) fread (&tmp[k][1], sizeof (double), 1, hFileRTbl);
	if (n == 248 && m < 10) 	// This makes it work for C
	    {
	    m--;
	    continue;
	    }
//        if (iNdex[m][nph] == iNdex[m-1][nph]) continue;
//        fscanf (hFileRTbl, "%lf %ld ", &z0, &n);
//        for (k=0; k<n; k++) fscanf (hFileRTbl, "%lf ", &tmp[k][0]);
//        for (k=0; k<n; k++) fscanf (hFileRTbl, "%lf ", &tmp[k][1]);
        fprintf (hFile3, "m nph ndex n %8ld %8ld %8ld %8ld\n", 
                 m+1, nph+1, iNdex[m][nph], n);
        k = -1;
        l = 0;
        for (i=0; i<n; i++)
            {
            if (iKuse[i][nph] < 0) continue;
            if (fabs (dPux[l][nph]-dPb[i]) <= dtol)
                {
                tmp[l][1] = tmp[i][1];
                l++;
                }
            k++;
            tmp[k][0] = tmp[i][0];
            }
        fprintf (hFile3, "k l nrec %ld %ld %ld %ld %lE\n", k+1, l, nrec+1, 
                 ndx2[m][nph], tmp[0][0]);
        if (k < n1)
	    {
            k++;
	    for (i=k; i<n1; i++) tmp[i][0] = 0.;
            }
        if (l <= k1)
	    for (i=l; i<k1; i++) tmp[i][1] = 0.;
        nrec++;
        for (i=0; i<n1; i++) 
            fwrite (&tmp[i][0], sizeof (double), 1, hFileSTbl);
        for (i=0; i<k1; i++) 
            fwrite (&tmp[i][1], sizeof (double), 1, hFileSTbl);
		// Pad with zeroes for C
	if (n1+k1 < iKu[1]+iKm[1])
	    for (i=0; i<((iKu[1]+iKm[1])-(n1+k1)); i++)
	        fwrite (&dTemp, sizeof (double), 1, hFileSTbl);
        }
    }

fclose (hFile3);
fclose (hFileRTbl);
fclose (hFileSTbl);
return (0);
}

void pdecx (int n1, int nph, double xm[2][NSL1], double fac)
{
double	pa, pax, plim;
double	ptol = 0.03;
int	i, j, k, m;		// based on 0
int	i1;			// based on 1

collct (1, n1, &xm[nph][0], fac*dXmin);
k = -1;
plim = .7 * dPu[n1-1][nph];
for (i=0; i<n1; i++)
    {
    if (xm[nph][i] < 0.) continue;
    if (dPu[i][nph] < plim) goto JumpUp;
    if (dPu[i][nph]-dPu[k][nph] <= ptol) goto JumpUp;
    pa = dPu[k][nph] + .75*(dPu[i][nph]-dPu[k][nph]);
    pax = 1.e10;
    m = -1;
    for (j=i1-1; j<=i; j++)
        {
        if (fabs (dPu[j][nph]-pa) >= pax) continue;
        m = j;
        pax = fabs (dPu[j][nph]-pa);
        }
    if (m+1 == i1 || m == i) goto JumpUp;
    k++;
    dPu[k][nph] = dPu[m][nph];
    xm[nph][k] = 0.;
    iKuse[m][nph] = 1;
    JumpUp:
    k++;
    i1 = i + 1;
    dPu[k][nph] = dPu[i][nph];
    xm[nph][k] = xm[nph][i];
    iKuse[i][nph] = 1;
    }
iKu[nph] = k + 1;
return;
}

void collct (int i1, int i2, double x[], double xmn)
// $$$$$ calls varn $$$$$
{
static	int	is, ie, ks, k0, k1, k2, kb, nch;	// based on 1
static	int	i, m, m1, m2;				// based on 0
static	double	var, dx1, dx2, var1, var2;

is = i1 + 1;
ie = i2 - 1;
if (ie < is) return;
k1 = i1;
var = 0.;
m = -1;
for (i=is-1; i<ie; i++)
    {
    dx1 = fabs (x[k1-1]-x[i]) - xmn;
    dx2 = fabs (x[k1-1]-x[i+1]) - xmn;
    if (fabs (dx2) < fabs (dx1))
        {
        x[i] = -x[i];
        continue;
        }
    if (k1 <= i1) kb = i + 1;
    k1 = i + 1;
    var += (dx1*dx1);
    m++;
    }
dx1 = fabs (x[k1-1]-x[i2-1]) - xmn;
var += (dx1*dx1);
m++;
TryAgain:
if (m <= 0) return;
k1 = i1;
k2 = kb;
ks = kb + 1;
nch = 0;
for (i=ks-1; i<i2; i++)
    {
    if (x[i] < 0.) continue;
    k0 = k1;
    k1 = k2;
    k2 = i+1;
    var1 = varn (x, k0, k1, k2, k1-1, xmn, var, m, &m1);
    var2 = varn (x, k0, k1, k2, k1+1, xmn, var, m, &m2);
    if (min (var1/(double) (m1+1), var2/(double) (m2+1)) >= 
        var/(double) (m+1)) goto LoopEnd;
    nch++;
    x[k1-1] *= (-1.);
    if (var1/(double) (m1+1) - var2/(double) (m2+1) == 0.)
        {
        if (m1-m2 <= 0) goto FirstIf;
          else          goto SecondIf;
	}
      else if (var1/(double) (m1+1) - var2/(double) (m2+1) < 0.)
        {
	FirstIf:
        k1--;
        x[k1-1] = fabs (x[k1-1]);
        var = var1;
        m = m1;
	}
      else if (var1/(double) (m1+1) - var2/(double) (m2+1) > 0.)
        {
	SecondIf:
        k1++;
        x[k1-1] = fabs (x[k1-1]);
        var = var2;
        m = m2;
	}
    LoopEnd:
    if (k0 == i1) kb = k1;
    }
if (nch > 0) goto TryAgain;
return;
}

double varn (double x[], int k0, int k1, int k2, int kt, double xmn,
             double var, int m, int *mn)
/*
 $$$$$ calls only library routines $$$$$
*/
{
static	double	dx1, dx2, tmp;

dx1 = fabs (x[k0-1]-x[k1-1]) - xmn;
dx2 = fabs (x[k1-1]-x[k2-1]) - xmn;
tmp = var - dx1*dx1 - dx2*dx2;
if (kt <= k0 || kt >= k2) 
    {
    dx1 = fabs (x[k0-1]-fabs (x[k2-1])) - xmn;
    *mn = m - 1;
    return (tmp + dx1*dx1);
    }
dx1 = fabs (x[k0-1] - fabs (x[kt-1])) - xmn;
dx2 = fabs (fabs (x[kt-1]) - x[k2-1]) - xmn;
*mn = m;
return (tmp + dx1*dx1 + dx2*dx2);
}

void layout (void)
/*
   Layout contains the program for the desired travel-time segments 
   implemented as calls to the mk_br entry points.  Each call does one 
   segment (which may have many branches).
*/
{
double	dir[3] = {1., 1., 1.}, cref[3] = {1., 2., 2.}, sref[3] = {2., 2., 2.};
int	i, j;			// based on 0

	// Initialize variables.
iNSeg = 0;
iNbrn = 0;
iNl = 0;
for (j=0; j<3; j++) 
    for (i=0; i<JSEG; i++) dFcs[i][j] = 0.;
for (i=0; i<JOUT; i++) dTaut[i] = 0.;
for (j=0; j<2; j++) 
    for (i=0; i<JBRN; i++) dXt[i][j] = 0.;

	// Do all of the segments.

	// P (up-going branch).
printf ("Layout:  do Pup\n");
mkubr (iKu[0], +1);
	// P, Pdiff, and PKP.
printf ("Layout:  do P and PKP\n");
mkdbr (1, iLbb[0], -1, 3, 0, 0, dir);
	// PKiKP.
printf ("Layout:  do PKiKP\n");
mkrbr (2, -1, 2, 0, 0, dir);
	// pP.
printf ("Layout:  do pP\n");
mkdbr (1, iLbb[0], +1, 3, 0, 0, dir);
	// sP.
printf ("Layout:  do sP\n");
mkdbr (1, iLbb[0], +2, 3, 0, 0, dir);
	// pPKiKP.
printf ("Layout:  do pPKiKP\n");
mkrbr (2, +1, 2, 0, 0, dir);
	// sPKiKP.
printf ("Layout:  do sPKiKP\n");
mkrbr (2, +2, 2, 0, 0, dir);
	// PcP.
printf ("Layout:  do PcP\n");
mkrbr (3, -1, 1, 0, 0, dir);
	// ScP.
printf ("Layout:  do ScP\n");
mkrbr (3, -2, 1, 1, 0, dir);
	// SKP.
printf ("Layout:  do SKP\n");
mkdbr (1, 3, -2, 3, 1, 0, dir);
	// SKiKP.
printf ("Layout:  do SKiKP\n");
mkrbr (2, -2, 2, 1, 0, dir);
	// PKKP.
printf ("Layout:  do PKKP\n");
mkdbr (1, 3, -1, 3, 0, 0, cref);
	// SKKP.
printf ("Layout:  do SKKP\n");
mkdbr (1, 3, -2, 3, 1, 0, cref);
	// PP and P'P'.
printf ("Layout:  do PP, P'P'\n");
mkdbr (1, iLbb[0], -1, 3, 0, 0, sref);
	// S (up-going branch).
printf ("Layout:  do Sup\n");
mkubr (iKu[1], +2);
	// S, Sdiff, and SKS.
printf ("Layout:  do S and SKS\n");
mkdbr (1, iLbb[1], -2, 3, 1, 1, dir);
	// pS
printf ("Layout:  do pS\n");
mkdbr (1, iLbb[0], +1, 3, 1, 1, dir);
	// sS
printf ("Layout:  do sS\n");
mkdbr (1, iLbb[1], +2, 3, 1, 1, dir);
	// ScS
printf ("Layout:  do ScS\n");
mkrbr (4, -2, 1, 1, 1, dir);
	// PcS
printf ("Layout:  do PcS\n");
mkrbr (3, -1, 1, 0, 1, dir);
	// PKS
printf ("Layout:  do PKS\n");
mkdbr (1, 3, -1, 3, 0, 1, dir);
	// PKKS
printf ("Layout:  do PKKS\n");
mkdbr (1, 3, -1, 3, 0, 1, cref);
	// SKKS
printf ("Layout:  do SKKS\n");
mkdbr (1, 3, -2, 3, 1, 1, cref);
	// SS and S'S'.
printf ("Layout:  do SS and S'S'\n");
mkdbr (1, iLbb[1], -2, 3, 1, 1, sref);
	// SP
printf ("Layout:  do SP\n");
mkcbr (4, iLbb[0], -2, 1, 1, 0, sref);
	// PS
printf ("Layout:  do PS\n");
mkcbr (4, iLbb[0], -1, 1, 0, 1, sref);
return;
}

/*
   Mkdbr sets up a simple refracted wave segment.  L1 and l2 point to the 
   iLbrk array of slowness break point pointers.  Note that the P and S 
   break point arrays don't necessarily line up layer by layer.  This is 
   not generally a problem as most phases need only worry about the 
   pointer to the surface slowness for one wave type and a pointer 
   somewhere in the core (which is constrained to be the same for both 
   P and S).  Isgn is positive if the wave starts out going up and 
   negative if the wave starts out going down.  Iabs(isng) is 1 if the 
   wave starts out as a P wave and 2 if the wave starts out as an S wave.  
   Lyr gives the number of major layers (mantle, outer core, and inner 
   core) that the wave penetrates.  Nph and kph give the wave type (1 for 
   P and 2 for S) on the down-going and up-going legs of the ray path 
   respectively.  Fac is a three element array giving the number of 
   repeats of the ray path in each major layer.  This scheme incorporates 
   turning rays (e.g., P and S), turning rays reflected, but not 
   converted at the surface (e.g., PP and SS), up-going rays reflected 
   and/or converted at the surface into turning rays (e.g., pP and sP), 
   turning rays converted during transmission through an interface (e.g., 
   SKP and PKS), and rays which turn multiple times while reflecting from 
   the bottom side of a layer (e.g., PKKP or SKKP).  Mkdbr does not 
   include up-going rays (to the receiver), rays reflected from the top 
   side of a discontinuity, or rays which are reflected and converted at 
   the free surface.  See mkubr, mkrbr, and mkcbr respectively for 
   routines which handle these types of rays.
*/
void mkdbr (int l1, int l2, int isgn, int lyr, int nph, int kph, double fac[])
{
static	char	szKs[9] = "KKKKKKKK";
static	char	szTemp[9];
static	double	xfc;
static	int	j, ii, i, k, l, lz1, lz2, m, ind;	// based on 0
static	int	nt;				// based on 1

	// Remember the programming as part of the final phase construction is 
	// done in depcor.
iNSeg++;
iNafl[iNSeg-1][0] = isgn;
iNafl[iNSeg-1][1] = nph+1;
iNafl[iNSeg-1][2] = kph+1;
iIndx[iNSeg-1][0] = iNl + 1;
iKndx[iNSeg-1][0] = 1;
	// Using l1 and l2 to get the breakpoints has some shortcommings, 
	// particularly for converted phases.  It would be more general to 
	// have separate indicies for the breakpoints and the layers covered.
if (l1 > 1) iKndx[iNSeg-1][0] = iLbrk[l1-2][nph];
iKndx[iNSeg-1][1] = min (min (iLbrk[l2-1][nph], iLbrk[l2-1][kph]),
                    iLbrk[l2-1][abs (isgn)-1]);
printf ("Mkdbr:  l1 l2 isgn lyr nph kph = %ld %ld %ld %ld %ld %ld\n", l1, l2, 
         isgn, lyr, nph, kph);
printf ("Mkdbr:  nseg kndx indx = %ld %ld %ld %ld\n", iNSeg, iKndx[iNSeg-1][0],
         iKndx[iNSeg-1][1], iIndx[iNSeg-1][0]);
xfc = 0.;
for (m=0; m<lyr; m++)
    {
    dFcs[iNSeg-1][m] = fac[m];
    xfc = max (xfc, dFcs[iNSeg-1][m]);
    }

	// Set up the required slownesses, taus and distances.

j = iKndx[iNSeg-1][0] - 1;
lz1 = 0;
lz2 = 0;
	// Loop over the layers of interest.
for (i=l1-1; i<l2; i++)
    {
	// Be sure that the phase cuts off at the right place.
    l = min (iLbrk[i][nph], iKndx[iNSeg-1][1]) - 1;
	// Skip all total internal reflections.
    if (szCode[i][nph][0] == 'r' || j >= l) 
        {
	j = l; 
	continue;
	}
	// Set the starting branch pointer.
    iNbrn++;
    nt = iNl + 1;
    iJndx[iNbrn-1][0] = nt;
	// Copy in the desired slownesses.
    for (k=j; k<=l; k++)
        {
        iNl++;
        dPt[iNl-1] = dPb[k];
	// Add up the tau contributions.
	for (m=0; m<lyr; m++)
            dTaut[iNl-1] = dTaut[iNl-1] + fac[m]*(dTaup[k][m][nph]+
                           dTaup[k][m][kph]);
        }
	// Take care of branch end pointers and slownesses.
    iMndx[iNbrn-1][0] = j + 1;
    iMndx[iNbrn-1][1] = l + 1;
    dPx[iNbrn-1][0] = dPb[j];
    dPx[iNbrn-1][1] = dPb[l];
	// Add up distance contributions for the branch end points only.
    for (m=0; m<lyr; m++)
        {
        dXt[iNbrn-1][0] = dXt[iNbrn-1][0] + fac[m]*(dXp[j][m][nph]+
                          dXp[j][m][kph]);
        dXt[iNbrn-1][1] = dXt[iNbrn-1][1] + fac[m]*(dXp[l][m][nph]+
                          dXp[l][m][kph]);
        }
	// Take care of the contribution due to low velocity zones for the 
	// down-going leg(s).
    if (j+1 == iLvz[lz1][nph])
        {
        for (m=0; m<lyr; m++)
	    {
            dTaut[nt-1] = dTaut[nt-1] - fac[m]*dTaup[j][m][nph];
            dXt[iNbrn-1][0] = dXt[iNbrn-1][0] - fac[m]*dXp[j][m][nph];
            }
        dTaut[nt-1] = dTaut[nt-1] + fac[0]*dTaul[lz1][nph];
        dXt[iNbrn-1][0] = dXt[iNbrn-1][0] + fac[0]*dXl[lz1][nph];
        lz1++;
        }
	// Take care of the contributions due to low velocity zones for the 
	// up-going leg(s).
    if(j+1 == iLvz[lz2][kph]) 
        {
        for (m=0; m<lyr; m++)
	    {
            dTaut[nt-1] = dTaut[nt-1] - fac[m]*dTaup[j][m][nph];
            dXt[iNbrn-1][0] = dXt[iNbrn-1][0] - fac[m]*dXp[j][m][nph];
            }
        dTaut[nt-1] = dTaut[nt-1] + fac[0]*dTaul[lz2][kph];
        dXt[iNbrn-1][0] = dXt[iNbrn-1][0] + fac[0]*dXl[lz2][kph];
        lz2++;
        }
	// Decimate the slownesses if the branch is oversampled in distance.
    pdect (iJndx[iNbrn-1][0], iNl, j, abs (isgn)-1, xfc);
	// Set up the interpolation.
    tauspl (iJndx[iNbrn-1][0], iNl, dPt, dCoef);
	// Remember the final branch end slowness value.
    iJndx[iNbrn-1][1] = iNl;

	// Take care of the branch name.  First, set up a default.
    strncpy (szPhcd[iNbrn-1], &szCode[i][nph][1], 1);
    szPhcd[iNbrn-1][1] = '\0';
    strcat (szPhcd[iNbrn-1], &szCode[i][kph][2]);
    if ((int) (fac[0]+.5) > 1) 
        {
	// Re-do the name if the ray is reflected from the surface.
        if (szCode[i][nph][2] == ' ') 
	    {
            strncpy (szPhcd[iNbrn-1], &szCode[i][nph][1], 1);
            szPhcd[iNbrn-1][1] = '\0';
            strcat (szPhcd[iNbrn-1], &szCode[i][kph][1]);
	    }
        if (szCode[i][nph][2] != ' ' && szCode[i][nph][2] != 'K')
	    {
            strncpy (szPhcd[iNbrn-1], &szCode[i][nph][1], 2);
            szPhcd[iNbrn-1][2] = '\0';
            strcat (szPhcd[iNbrn-1], &szCode[i][kph][1]);
	    }
        if(szCode[i][nph][2] == 'K') 
	    {
            strncpy (szPhcd[iNbrn-1], &szCode[i][nph][1], 1);
            szPhcd[iNbrn-1][1] = '\0';
            strcat (szPhcd[iNbrn-1], "'");
            strncat (szPhcd[iNbrn-1], &szCode[i][kph][1], 1);
            szPhcd[iNbrn-1][3] = '\0';
            strcat (szPhcd[iNbrn-1], "'");
            strcat (szPhcd[iNbrn-1], &szCode[i][kph][4]);
	    }
	goto SkipAhead;
        }
    if ((int) (fac[1]+.5) <= 1) goto SkipAhead;
	// Re-do the name if the ray is reflected from the underside of the 
	// core-mantle boundary.
    ind = (int) (fac[1]-.5);
    strncpy (szPhcd[iNbrn-1], &szCode[i][nph][1], 1);
    szPhcd[iNbrn-1][1] = '\0';
    strncat (szPhcd[iNbrn-1], szKs, ind);
    szPhcd[iNbrn-1][ind+1] = '\0';
    strcat (szPhcd[iNbrn-1], &szCode[i][kph][2]);
	// Take care of the missing caustic for SKS, etc.
    SkipAhead:
    ind = -1;
    if (strstr (szPhcd[iNbrn-1], "KSab") != NULL)
        ind = strstr (szPhcd[iNbrn-1], "KSab") - szPhcd[iNbrn-1];
      else if (strstr (szPhcd[iNbrn-1], "S'ab") != NULL)
        ind = strstr (szPhcd[iNbrn-1], "S'ab") - szPhcd[iNbrn-1];
    if (szPhcd[iNbrn-1][0] == 'S' && ind >= 0) 
        {
        szPhcd[iNbrn-1][ind+2] = 'a';
        szPhcd[iNbrn-1][ind+3] = 'c';
	}
	// Take care of little p and s phases.
    if (isgn == 1) 
        {
	strcpy (szTemp, "p");
	strcat (szTemp, szPhcd[iNbrn-1]);
	strcpy (szPhcd[iNbrn-1], szTemp);
	}
    if (isgn == 2) 
        {
	strcpy (szTemp, "s");
	strcat (szTemp, szPhcd[iNbrn-1]);
	strcpy (szPhcd[iNbrn-1], szTemp);
	}
    j = l;
    }
iIndx[iNSeg-1][1] = iNl;
return;
}

/*
   Mkubr handles up-going P and S.  L1 and isgn are as for mkdbr (except 
   that l1 actually plays the role of l2 with the beginning break point 
   assumed to be zero).  The other arguments are not needed.
*/
void mkubr (int l1, int isgn)
{
int	k;			// based on 0
int	l;			// based on 1 (isgn also)

iNSeg++;
iNafl[iNSeg-1][0] = isgn;
iNafl[iNSeg-1][1] = 0;
iNafl[iNSeg-1][2] = 0;
iIndx[iNSeg-1][0] = iNl+1;
iKndx[iNSeg-1][0] = 1;
l = iKb[abs (isgn)-1];
iKndx[iNSeg-1][1] = l;
printf ("Mkubr:  l1 isgn = %ld %ld\n", l1, isgn);
printf ("Mkubr:  iNSeg kndx indx = %ld %ld %ld %ld\n", iNSeg, iKndx[iNSeg-1][0],
        iKndx[iNSeg-1][1], iIndx[iNSeg-1][0]);
iNbrn++;
iJndx[iNbrn-1][0] = iNl + 1;
for (k=0; k<l1; k++)
    {
    iNl++;
    dPt[iNl-1] = dPu[k][abs (isgn)-1];
    dXa[iNl-1] = 0.;
    }
iMndx[iNbrn-1][0] = 1;
iMndx[iNbrn-1][1] = l;
dPx[iNbrn-1][0] = dPb[0];
dPx[iNbrn-1][1] = dPb[l-1];
printf ("Mkubr:  call tauspl - iJndx nl = %ld %ld\n", iJndx[iNbrn-1][0], iNl);
tauspl (iJndx[iNbrn-1][0], iNl, dPt, dCoef);
printf ("Mkubr:  return from tauspl\n");
iJndx[iNbrn-1][1] = iNl;
strncpy (szPhcd[iNbrn-1], &szCode[0][abs (isgn)-1][1], 1);
szPhcd[iNbrn-1][1] = '\0';
iIndx[iNSeg-1][1] = iNl;
return;
}

/*
   Mkrbr handles reflected phases possibly with a conversion such as 
   PcP, PcS, and PkiKP.  Arguments are as for mkdbr (except that l1 
   actually plays the role of l2 with the beginning break point assumed 
   to be zero).
*/
void mkrbr (int l1, int isgn, int lyr, int nph, int kph, double fac[])
{
static	char	szTemp[9];
static	double	xfc;
static	int	k, m;			// based on 0
static	int	l;			// based on 1

iNSeg++;
iNafl[iNSeg-1][0] = isgn;
iNafl[iNSeg-1][1] = nph + 1;
iNafl[iNSeg-1][2] = kph + 1;
iIndx[iNSeg-1][0] = iNl + 1;
iKndx[iNSeg-1][0] = 1;
l = min (iLbrk[l1-1][nph],iLbrk[l1-1][kph]);
iKndx[iNSeg-1][1] = l;
printf ("Mkrbr:  l1 isgn lyr nph kph = %ld %ld %ld %ld %ld\n", 
         l1, isgn, lyr, nph, kph);
printf ("Mkrbr:  iNSeg kndx indx = %ld %ld %ld %ld\n", iNSeg, 
        iKndx[iNSeg-1][0], iKndx[iNSeg-1][1], iIndx[iNSeg-1][0]);
xfc = 0.;
for (m=0; m<lyr; m++)
    {
    dFcs[iNSeg-1][m] = fac[m];
    xfc = max (xfc, dFcs[iNSeg-1][m]);
    }
if(lyr >= 2) xfc = 2.;

iNbrn++;
iJndx[iNbrn-1][0] = iNl + 1;
for (k=0; k<l; k++)
    {
    iNl++;
    dPt[iNl-1] = dPb[k];
    for (m=0; m<lyr; m++)
        dTaut[iNl-1] = dTaut[iNl-1] + fac[m]*(dTaup[k][m][nph]+dTaup[k][m][kph]);
    }
iMndx[iNbrn-1][0] = 1;
iMndx[iNbrn-1][1] = l;
dPx[iNbrn-1][0] = dPb[0];
dPx[iNbrn-1][1] = dPb[l-1];
for (m=0; m<lyr; m++)
    dXt[iNbrn-1][1] = dXt[iNbrn-1][1] + 
                      fac[m]*(dXp[l-1][m][nph]+dXp[l-1][m][kph]);
pdect (iJndx[iNbrn-1][0], iNl, 0, abs (isgn)-1, xfc);
tauspl (iJndx[iNbrn-1][0], iNl, dPt, dCoef);
iJndx[iNbrn-1][1] = iNl;
if (lyr == 1)
    {
    strncpy (szPhcd[iNbrn-1], &szCode[l1-1][nph][1], 1);
    szPhcd[iNbrn-1][1] = '\0';
    strcat (szPhcd[iNbrn-1], "c");
    strncat (szPhcd[iNbrn-1], &szCode[l1-1][kph][1], 1);
    szPhcd[iNbrn-1][3] = '\0';
    }
if (lyr == 2)
    {
    strncpy (szPhcd[iNbrn-1], &szCode[l1-1][nph][1], 1);
    szPhcd[iNbrn-1][1] = '\0';
    strcat (szPhcd[iNbrn-1], &szCode[l1-1][kph][2]);
    }
if (isgn == 1) 
    {
    strcpy (szTemp, "p");
    strcat (szTemp, szPhcd[iNbrn-1]);
    strcpy (szPhcd[iNbrn-1], szTemp);
    }
if (isgn == 2)
    {
    strcpy (szTemp, "s");
    strcat (szTemp, szPhcd[iNbrn-1]);
    strcpy (szPhcd[iNbrn-1], szTemp);
    }
iIndx[iNSeg-1][1] = iNl;
return;
}

/*
   Mkcbr handles phases reflected and converted at the surface such as 
   PS and SP.  Arguments are as for mkdbr.
*/
void mkcbr (int l1, int l2, int isgn, int lyr, int nph, int kph, double fac[])
{
static	char	szTemp[9];
static	double	xfc;
static	int	j, ik, in, k, l, lz1, lz2, m;		// based on 0
static	int	isw, nt;				// based on 1

if (nph < 0 || kph < 0 || nph == kph)
    {
    printf ("Mkcbr:  bad call - nph kph = %ld %ld\n", nph, kph);
    exit (0);
    }
iNSeg++;
iNafl[iNSeg-1][0] = isgn;
iNafl[iNSeg-1][1] = nph + 1;
iNafl[iNSeg-1][2] = kph + 1;
iIndx[iNSeg-1][0] = iNl + 1;
iKndx[iNSeg-1][0] = 1;
if (l1 > 1) iKndx[iNSeg-1][0] = min (iLbrk[l1-1][nph], iLbrk[l1-1][kph]);
iKndx[iNSeg-1][1] = min (min (iLbrk[l2-1][nph], iLbrk[l2-1][kph]),
                              iLbrk[l2-1][abs (isgn)-1]);
printf ("Mkcbr:  l1 l2 isgn lyr nph kph = %ld %ld %ld %ld %ld %ld\n",
        l1, l2, isgn, lyr, nph, kph);
printf ("Mkcbr:  nseg kndx indx = %ld %ld %ld %ld\n",iNSeg, iKndx[iNSeg-1][0],
        iKndx[iNSeg-1][1], iIndx[iNSeg-1][0]);
xfc = 0.;
for (m=0; m<lyr; m++)
    {
    dFcs[iNSeg-1][m] = fac[m];
    xfc = max (xfc, dFcs[iNSeg-1][m]);
    }

j = iKndx[iNSeg-1][0] - 1;
lz1 = 0;
lz2 = 0;
ik = l1 - 1;

printf ("Mkcbr:  start loop\n");
for (in=l1-1; in<l2; in++)
    {
    TopOfLoop:
    l = min (iLbrk[in][nph], iKndx[iNSeg-1][1]) - 1;
    if (szCode[in][nph][0] == 'r' || j >= l) 
        {
        j = max (j, l);
        continue;
	}
    l = min (iLbrk[ik][kph],iKndx[iNSeg-1][1]) - 1;
    if ((szCode[ik][kph][0] == 'r' || j >= l) && ik+1 < l2)
        {
        j = max (j, l);
        ik++;
        goto TopOfLoop;
        }

    if(iLbrk[in][nph] <= iLbrk[ik][kph]) 
        {
        l = min (iLbrk[in][nph], iKndx[iNSeg-1][1]) - 1;
        printf ("nph:  nph in j l code = %ld %ld %ld %ld  %s\n",
                 nph+1, in+1, j+1, l+1, szCode[in][nph]);
        isw = 1;
	}
      else
        {
        l = min (iLbrk[ik][kph], iKndx[iNSeg-1][1]) - 1;
        printf ("kph:  kph ik j l code = %ld %ld %ld %ld  %s\n",
                 kph+1, ik+1, j+1, l+1, szCode[ik][kph]);
        isw = 2;
        }

    iNbrn++;
    nt = iNl + 1;
    iJndx[iNbrn-1][0] = nt;
    for (k=j; k<=l; k++)
        {
        iNl++;
        dPt[iNl-1] = dPb[k];
	for (m=0; m<lyr; m++)
            dTaut[iNl-1] = dTaut[iNl-1] + fac[m]*(dTaup[k][m][nph]+
                           dTaup[k][m][kph]);
        }
    iMndx[iNbrn-1][0] = j + 1;
    iMndx[iNbrn-1][1] = l + 1;
    dPx[iNbrn-1][0] = dPb[j];
    dPx[iNbrn-1][1] = dPb[l];
    for (m=0; m<lyr; m++)
        {
        dXt[iNbrn-1][0] = dXt[iNbrn-1][0] + fac[m]*(dXp[j][m][nph]+
                          dXp[j][m][kph]);
        dXt[iNbrn-1][1] = dXt[iNbrn-1][1] + fac[m]*(dXp[l][m][nph]+
                          dXp[l][m][kph]);
        }
    if (j+1 == iLvz[lz1][nph])
        {
	for (m=0; m<lyr; m++)
	    {
            dTaut[nt-1] = dTaut[nt-1] - fac[m]*dTaup[j][m][nph];
            dXt[iNbrn-1][0] = dXt[iNbrn-1][0] - fac[m]*dXp[j][m][nph];
            }
        dTaut[nt-1] = dTaut[nt-1] + fac[0]*dTaul[lz1][nph];
        dXt[iNbrn-1][0]= dXt[iNbrn-1][0] + fac[0]*dXl[lz1][nph];
        lz1++;
        }
    if (j+1 == iLvz[lz2][kph])
        {
	for (m=0; m<lyr; m++)
	    {
            dTaut[nt-1] = dTaut[nt-1] - fac[m]*dTaup[j][m][kph];
            dXt[iNbrn-1][0] = dXt[iNbrn-1][0] - fac[m]*dXp[j][m][kph];
            }
        dTaut[nt-1] = dTaut[nt-1] + fac[0]*dTaul[lz2][kph];
        dXt[iNbrn-1][0] = dXt[iNbrn-1][0] + fac[0]*dXl[lz2][kph];
        lz2++;
        }
    pdect (iJndx[iNbrn-1][0], iNl, j, abs (isgn)-1, xfc);
    tauspl (iJndx[iNbrn-1][0], iNl, dPt, dCoef);
    iJndx[iNbrn-1][1] = iNl;

    if (szCode[in][nph][2] == ' ') 
        {
        strncpy (szPhcd[iNbrn-1], &szCode[in][nph][1], 1);
        szPhcd[iNbrn-1][1] = '\0';
        strcat (szPhcd[iNbrn-1], &szCode[ik][kph][1]);
        }
    if (szCode[in][nph][2] != ' ' && szCode[in][nph][2] != 'K')
        {
        strncpy (szPhcd[iNbrn-1], &szCode[in][nph][1], 2);
        szPhcd[iNbrn-1][2] = '\0';
        strcat (szPhcd[iNbrn-1], &szCode[ik][kph][1]);
	}
    if(szCode[in][nph][2] == 'K') 
        {
        strncpy (szPhcd[iNbrn-1], &szCode[in][nph][1], 1);
        szPhcd[iNbrn-1][1] = '\0';
        strcat (szPhcd[iNbrn-1], "'");
        strncat (szPhcd[iNbrn-1], &szCode[ik][kph][1], 1);
        szPhcd[iNbrn-1][3] = '\0';
        strcat (szPhcd[iNbrn-1], "'");
        strcat (szPhcd[iNbrn-1], &szCode[ik][kph][4]);
        }
	// Take care of little p and s phases.
    if (isgn == 1) 
        {
	strcpy (szTemp, "p");
	strcat (szTemp, szPhcd[iNbrn-1]);
	strcpy (szPhcd[iNbrn-1], szTemp);
	}
    if (isgn == 2)
        {
	strcpy (szTemp, "s");
	strcat (szTemp, szPhcd[iNbrn-1]);
	strcpy (szPhcd[iNbrn-1], szTemp);
	}
    printf ("szPhcd:  in ik szPhcd = %ld %ld  %s\n", in+1, ik+1, 
             szPhcd[iNbrn-1]);
    if (isw <= 1) 
        {
        j = max (j, l);
	continue;
	}
    ik++;
    j = max (j, l);
    goto TopOfLoop;
    }
iIndx[iNSeg-1][1] = iNl;
return;
}

void pdect (int i1, int i2, int j1, int nph, double fac)
{
static	double	h1, h2, hh, xmn;
static	int	ib[2][2];		// based on 1
static	int	i, it, j, k;		// based on 0 (j1, nph also)
static	int	ii, ie, isg;		// based on 1 (i1, i2 also)

xmn = fac * dXmin;
isg = 1;
for (i=0; i<2; i++)
    {
    ib[i][0] = i1;
    ib[i][1] = i2;
    }
ii = i1 + 1;
ie = i2 - 1;
dXa[i1-1] = dXt[iNbrn-1][0];
for (i=ii-1; i<ie; i++)
    {
    h1 = dPt[i-1] - dPt[i];
    h2 = dPt[i+1] - dPt[i];
    hh = h1 * h2 * (h1-h2);
    h1 = h1 * h1;
    h2 = (h2*h2) * (-1.);
    dXa[i] = -(h2*dTaut[i-1]-(h2+h1)*dTaut[i]+h1*dTaut[i+1]) / hh;
    }
dXa[i2-1] = dXt[iNbrn-1][1];
for (i=ii-1; i<ie; i++)
    {
    if ((dXa[i+1]-dXa[i])*(dXa[i]-dXa[i-1]) > 0.) continue;
    isg = 2;
    ib[0][1] = i - 1;
    ib[1][0] = i + 3;
    }
for (it=0; it<isg; it++)
    collct (ib[it][0], ib[it][1], dXa, xmn);

k = i1 - 2;
j = j1;

for (i=i1-1; i<i2; i++)
    {
    if (dXa[i] < 0.)
        {
	j++;
	continue;
	}
    k++;
    dPt[k] = dPt[i];
    dTaut[k] = dTaut[i];
    dXa[k] = dXa[i];
    iKuse[j][nph] = 1;
    j++;
    }
if(k+1 == iNl) return;
ii = k + 2;
for (i=ii-1; i<iNl; i++) dTaut[i] = 0.;
iNl = k + 1;
return;
}

/*
   Kseq makes a correspondence between model slownesses in array dPb and 
   the subset of the same slownesses used for sampling tau which are 
   stored in dPu (separate sets for P and S).  The net result is to 
   translate the kndx pointers to critical slowness values (bounding 
   branches actually implemented) from pointing into dPb to pointing 
   into dPu.
*/   
void kseq (void)
{
static	int	kl[2] = {0, 0}, kk[JSEG][2][2];		// based on 1
static	int	i, j, l, m, nph;	// based on 0
static	int	k, ki, n1;		// based on 1

	// Compile a sorted list of unique iKndx values in the first column of 
	// kk.

for (i=0; i<iNSeg; i++)
    {
    nph = abs (iNafl[i][0]) - 1;
    k = kl[nph];
    for (j=0; j<2; j++)
        {
        if (k > 0)
	    {
	    for (m=0; m<k; m++)
	        {
                if (kk[m][nph][0]-iKndx[i][j] == 0) goto InnerLoopEnd;
                if (kk[m][nph][0]-iKndx[i][j] > 0) goto NextLoop;
		}
            }
        k++;
        kk[k-1][nph][0] = iKndx[i][j];
        goto InnerLoopEnd;
        NextLoop:
	for (l=k-1; l>=m; l--)
            kk[l+1][nph][0] = kk[l][nph][0];
        k++;
        kk[m][nph][0] = iKndx[i][j];
        InnerLoopEnd:;
        }
    kl[nph] = k;
    }

	// Make the correspondence between dPb and dPu for each iKndx and save 
	// it in the second column of kk.

for (nph=0; nph<2; nph++)
    {
    n1 = iKu[nph];
    k = 1;
    ki = kk[k-1][nph][0];
    for (i=0; i<n1; i++)
        {
        if (dPu[i][nph]-dPb[ki-1] > 0.) 
	    {
	    printf ("Kseq:  dPb(%ld) = %lf not found in dPu (*,%ld).\n",
	             ki-1, dPb[ki-1], nph);
	    exit (0);
	    }
        if (dPu[i][nph]-dPb[ki-1] < 0.) continue;
        kk[k-1][nph][1] = i + 1;
        if (k >= kl[nph]) break;
        k++;
        ki = kk[k-1][nph][0];
        }
    }

	// Replace each iKndx dPb pointer with the corresponding dPu pointer.

for (i=0; i<iNSeg; i++)
    {
    nph = abs (iNafl[i][0]) - 1;
    k = kl[nph];
    for (j=0; j<2; j++)
        {
	for (m=0; m<k; m++)
	    {
            if (kk[m][nph][0]-iKndx[i][j] > 0)
	        {
	        printf ("Kseq:  kndx value %ld not translated.\n", iKndx[i][j]);
    	        exit (0);
		}
            if (kk[m][nph][0]-iKndx[i][j] == 0) break;
	    }
        iKndx[i][j] = kk[m][nph][1];
	}
    }
return;
}

/*         partial reordering of tables		*/
void mseq (void)
{
int	is, i, l, m, j, nph;	// based on 0
int	k;			// based on 1

iKm[0] = 0;
iKm[1] = 0;
is = 0;
for (i=0; i<iNbrn; i++)
    {
    while (iJndx[i][1] > iIndx[is][1]) is++;
    nph = abs (iNafl[is][0]) - 1;
    k = iKm[nph];
    for (j=0; j<2; j++)
        {
        if (k > 0)
	    {
	    for (m=0; m<k; m++)
	        {
                if (iMidx[m][nph]-iMndx[i][j] == 0) goto InnerLoopEnd;
                if (iMidx[m][nph]-iMndx[i][j] > 0) goto NextDo;
		}
            }
        k++;
        iMidx[k-1][nph] = iMndx[i][j];
        dPux[k-1][nph] = dPx[i][j];
        goto InnerLoopEnd;
	NextDo:
	for (l=k-1; l>=m; l--)
	    {
            iMidx[l+1][nph] = iMidx[l][nph];
            dPux[l+1][nph] = dPux[l][nph];
            }
        k++;
        iMidx[m][nph] = iMndx[i][j];
        dPux[m][nph] = dPx[i][j];
        InnerLoopEnd:;
        }
    iKm[nph] = k;
    }
return;
}
