/****************************************************************************
ttim.C

This program was taken from the NEIC ftp site in FORTRAN and converted
to C at WC&ATWC.  The variables were left the same for the most part.

It is part of the package of programs which computes seismic travel times
and travel time tables given a modern model of the earth's spherically 
symetric shells. Many phases can be computed given the model.

        Contributors:       NEIC/ Converted to C by Whitmore in '99
        OS:                 Windows NT v4.0
        Compiler:           Microsoft Visual C++ v6.0
	Link Info:	    See ttim.mak
	                    include ...iasplib.obj in the link,
        Compile Info:       See ttim.mak
---------------------------------------------------------------------------*/
#include <windows.h>
#include <winuser.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "ttlim.h"
#include "iasplib.h"
typedef BOOL bool;

int main (void)
{
bool	bPrint[3];
double	dDDdp[MAX];
double	dDep;			// Origin depth in km
double	dDist;			// Epicentral Distance in degrees
double	dDTdd[MAX];
double	dDTdh[MAX];
double	dSec[MAX]; 
double	dTCor[MAX];
double	dTT[MAX];
double	dUsrC[2];
double	dXCor[MAX];
FILE 	*hFile, *hFileTbl;
int	iMin[MAX];
int	i;			// based on 0
int	n;			// based on 1
char	szPhase[MAX][PHASE_LENGTH], szPhaseLst[10][PHASE_LENGTH];
char	szModname[] = {"iasp91"};

	// Initialize some things
strcpy (szPhaseLst[0], "query");
bPrint[0] = FALSE;
bPrint[1] = FALSE;
bPrint[2] = TRUE;

	// Open listing file
hFile = fopen ("ttim1.lis", "w");

	// Read in tables
tabin (&hFileTbl, szModname, hFile);

	// What kind of output?
printf ("Do you want tau interpolation printed? (1=yes, 0=no)\n");
scanf ("%ld", &bPrint[0]);
printf ("Do you want range summary printed? (1=yes, 0=no)\n");
scanf ("%ld", &bPrint[1]);

	// Set phases desired
brnset (1, szPhaseLst, bPrint, hFile);

	// Get the depth/distance of interest
DepthIn:
dDep = -10.;
if (dDep == -1.) goto End;
while (dDep < 0. || dDep > 750.)
    {
    printf ("Source depth (km)\n");
    scanf ("%lf", &dDep);
    if (dDep == -1.) goto End;
    if (dDep >= 0. && dDep <= 750.) break;
    printf ("Invalid Depth - Re-enter\n");
    }
depset (dDep, dUsrC, hFile, hFileTbl);

dDist = -10.;
while (dDist < 0. || dDep > 180.)
    {
    printf ("Distance (degrees)\n");
    scanf ("%lf", &dDist);
    if (dDist == -1.) goto DepthIn;
    if (dDist >= 0. && dDist <= 180.) break;
    printf ("Invalid Distance - Re-enter\n");
    }

trtm (dDist, &n, dTT, dDTdd, dDTdh, dDDdp, szPhase);
if (n <= 0) 
    {
    printf ("No arrivals for %lf\n", dDist);
    return (0);
    }
for (i=0; i<n; i++)
    {
//  if (iupcor (szPhase[i], dDTdd(i), dXCor(i), dTCor(i)) <= 0)
//      printf ("iupcor failed on phase %s\n", szPhase[i]);
    dXCor[i] = 0.;
    dTCor[i] = 0.;
//  if (!strcmp (szPhase[i], "Pg") || !strcmp (szPhase[i], "Pb") || 
//      !strcmp (szPhase[i], "Pn") || !strcmp (szPhase[i], "P"))
//      ierr = iupcor ("P", dDTdd[i], dXCor[i], dTCor[i]);
//  if (!strcmp (szPhase[i], "Sg") || !strcmp (szPhase[i], "Sb") || 
//      !strcmp (szPhase[i], "Sn") || !strcmp (szPhase[i], "S")) 
//      ierr = iupcor ("S", dDTdd[i], dXCor[i], dTCor[i]);
    iMin[i] = (int) (dTT[i] / 60.);
    dSec[i] = .01 * (int) (100.*(dTT[i]-iMin[i]*60.) + .5);
    if (dSec[i] < 60.) continue;
    iMin[i] = iMin[i] + 1;
    dSec[i] = dSec[i] - 60.;
    }
for (i=0; i<n; i++)
    {
    if (i > 0)
        printf (" %lf %ld  %s %lf %ld %lf %lE %lE %le\n", dDist, i, szPhase[i],
                dTT[i], iMin[i], dSec[i], dDTdd[i], dDTdh[i], dDDdp[i]);
      else
        printf ("       %ld  %s %lf %ld %lf %lE %lE %lE\n", i, szPhase[i],
                dTT[i], iMin[i], dSec[i], dDTdd[i], dDTdh[i], dDDdp[i]);
    if (dXCor[i] != 0. || dTCor[i] != 0.) 
        printf ("                      %lf %lf\n", dTCor[i], dXCor[i]);
    }
End:
fclose (hFile);
fclose (hFileTbl);
return (0);
}
