
	PROGRAM EXTRACT_TELE

	IMPLICIT NONE

	INCLUDE '($RMSDEF)'
	INCLUDE 'LIB$GLUE:KOMC.INC'
	INCLUDE 'LIB$RT:WEB.INC'	!WEB parameter structure
	INCLUDE 'LIB$RT:BUFFERS.INC'	!RT data buffer structure
	INCLUDE 'EXTRACT_TELE.INC'
c	STRUCTURE/TIME_BASE/
c	  REAL*8	DTBASE		!Julian second of LRTC0
c	  INTEGER	LRTC0		!RTC of decode
c	  REAL		RATE		!sample (digitization) rate
c	  REAL		PERSAMP		!1/RATE, sample interval
c	  CHARACTER*6	CTYPE		!Decoded time lable ("IRIGE", "WWVB")
c	END STRUCTURE
c	RECORD/TIME_BASE/	TIME
c	COMMON/TIME_BASE/	TIME
	INCLUDE 'TIME_STRUCT.INC'
	INTEGER*4 LENTRUE
	INTEGER*4 LIB$SET_LOGICAL
	INTEGER*4 LIB$DELETE_LOGICAL
	INTEGER*4 STR$CASE_BLIND_COMPARE
	INTEGER*4 LIB$WAIT

	INTEGER*4 INSDE

	INTEGER*4 NC_DIR_IN
	INTEGER*4 NC_DIR_OUT
	INTEGER*4    NC_JOB		! Non-blank characters in jobname string
	CHARACTER*40 JOBNAME		! Input jobname string
	CHARACTER*40 TESTSTR		! Test string for jobname verification

	INTEGER*4 LIST_LUN/6/
	INTEGER*4 EVT_LUN /10/
	INTEGER*4 EVT2_LUN /12/
	INTEGER*4 ALARM_LUN /14/
	INTEGER*4 TELE_LUN /16/

	INTEGER*4 IUNIT
	INTEGER*4 MAXTEL
	PARAMETER (MAXTEL = 1024)
	INTEGER*2 KTEL(MAXTEL)

C .. .evt file data
	INTEGER*4 TOTAL_WORDS
	INTEGER*4 IN_BLOCKS
	INTEGER*4 BLOCKS_ALLOCATED, EOF_BLOCK
	INTEGER*2 FFB
	COMMON/ RMS_DATA/ BLOCKS_ALLOCATED, EOF_BLOCK, FFB	! Lib$glue:Block_io 

C .. ts time
	REAL*8	DT_OF_RTC	! function
	REAL*8	T0_START_REQ
	REAL*8	T0_END_REQ
	REAL*8	T0_START
	REAL*8	T0_END
	CHARACTER*22 C22START, C22START_DATA, C22END
	REAL*8 DT_FILE

	INTEGER*4	NC_ID
	INTEGER*4	NC_OUT
	INTEGER*4 	NC_FILE
	CHARACTER*90	CSEARCH
	CHARACTER*80	CMESS
	CHARACTER*80	FILE_STR

	INTEGER*4 IER, IERR, IRES, LRES, I
	INTEGER*4 LID
	INTEGER*4 LFLAG
	INTEGER*4 LBLOCKS
	INTEGER*4 LBASE_IN
	INTEGER*4 LBASE_OUT
	INTEGER*4 LDIFF
C*
C	integer*2 vmschn /0/		! udp socket channel out
C*
	INTEGER*4 NWORDS_WEB		! words in web region
	INTEGER*4 NWORDS_DIO		! words in rt data buffer

	INTEGER*4 KBUF			! current buffer count
	INTEGER*4 LBON			! first buffer in file
	INTEGER*4 LRTC_FIRST1
	INTEGER*4 LRTC_FIRST2
	INTEGER*4 LRTC_FIRST
	INTEGER*4 LRTC_START
	INTEGER*4 DATA_WORDS
	INTEGER*4 DATA_BUFFERS
	INTEGER*4 LAST_REQ_BUFF		! number of buffers out
 	INTEGER*4 NBUF_REQ
	INTEGER*4 SAMPLES
	INTEGER*4 LRTC_END1
	INTEGER*4 LRTC_END2
	INTEGER*4 LBOFF			! ending buffer in file
	INTEGER*4 LRTC_END
	INTEGER*4 LRTC_LAST
	INTEGER*4 LRTC_STOP
	INTEGER*4 LB
	INTEGER*4 LBUF
	INTEGER*4 LB_END

C .. Alarm mail declarations
C	REAL*8		MAIL_SENT_SEC
	INTEGER*4	CURRENT_MINUTE
	INTEGER*4	LAST_MAIL_MINUTE /0/
        CHARACTER*(*)	CMAIL_COMMAND
	PARAMETER	(CMAIL_COMMAND = 'MAIL /SUB="EXTRACT_TELE TROUBLE"'//
	1		' TELE$HOT:TELEDSK.ALARM "@TELE$MAIL_DIS"')
	CHARACTER*(*)	MAIL_FILE
	PARAMETER	(MAIL_FILE = 'TELE$HOT:TELEDSK.ALARM')

C .. Output disk device declarations
	CHARACTER*32	DEVICE
	INTEGER*4	NC_DEV
	INTEGER*4	FREE_BLOCKS
	INTEGER*4	MAX_BLOCKS
	INTEGER*4	REMAINING_BLOCKS
C	INTEGER*4	FILE_BLOCKS
	
	LOGICAL*4	END_MSG_FLG
	LOGICAL*4	END_MSGFILE_FLG
	LOGICAL*4	OPEN_OUTPUT_FLG
	LOGICAL*4	TELKIN_OPEN_FLG
	LOGICAL*4	RESET_SEARCH_FLG

	CHARACTER*80	FILENAME
	CHARACTER*128	FILE_OUT_STR
	CHARACTER*9	TABLE /'LNM$GROUP'/

	INCLUDE 'LIB$GLUE:MAILSUBS.INC/LIST'
	INTEGER*4 NMSG
	INTEGER*4 NRECS_READ
	INTEGER*4 NTXT_READ
	INTEGER*4 NC_RET

	INTEGER*4 MAXEQ
	PARAMETER (MAXEQ = 64)
	CHARACTER*80 CEQ(MAXEQ)
	COMMON /MSGS/ CEQ
	CHARACTER*9 CID
	CHARACTER*4 CRID
	INTEGER*4 NEQ
	INTEGER*4 IEQ

	INTEGER*4 LMIN, LMIN1
	REAL*4 S1
	INTEGER*4 IYR1,IMO1,IDY1,IHR1,IMN1
	COMMON /CT/ IYR1,IMO1,IDY1,IHR1,IMN1
	REAL*4 LATD, LOND
	REAL*4 Z, XMAG
	REAL*4 DISTMIN, DISTMAX
	REAL*4 AZDUM1, AZDUM2
	REAL*4 TTMIN, TTMAX
	REAL*4 DIST, TT, DTDD

	INTEGER*4 MAXFIX
	PARAMETER (MAXFIX = 4)
	REAL*4 LATDS(MAXFIX), LONDS(MAXFIX)
	INCLUDE 'NETWORK_BOUNDS.INC/LIST'

C	REAL*4 LATMIN, LATMAX, LONMIN, LONMAX
C	LATMAX = LATDS(1)
C	LATMIN = LATDS(1)
C	LONMAX = LONDS(1)
C	LONMIN = LONDS(1)
C	DO I = 1, MAXFIX
C	  LATD = LATDS(I)
C	  LOND = LONDS(I)
C	  IF (LATD .LE. LATMIN) LATMIN = LATD
C	  IF (LATD .GE. LATMAX) LATMAX = LATD
C	  IF (LOND .LE. LONMIN) LONMIN = LOND
C	  IF (LOND .GE. LONMAX) LONMAX = LOND
C	END DO
C	LAT_CEN = (LATMIN + LATLON) / 2
C	LON_CEN = (LONMIN + LONMAX) / 2

	IUNIT = LIST_LUN
	END_MSG_FLG = .FALSE.
	END_MSGFILE_FLG = .FALSE.

c .. Assume words in WEB region 
	NWORDS_WEB = MAXREG	! ((W.NWPAR + 255) / 256) * 256

	CALL KOMMCRC(IRES)
	IF (IRES .LE. 0) THEN
	  STOP 'MUST ENTER JOBNAME'
	END IF
	CALL UPPER_CASE(KOMS.CLINE)

C .. Build job control logical name and set to 'go'
	CALL KOMSTRC(39, TESTSTR, IRES)
	NC_JOB = IRES
	JOBNAME = 'PAR$' // TESTSTR(1:NC_JOB)
	NC_JOB = NC_JOB + 4

	LRES = LIB$SET_LOGICAL(JOBNAME(1:NC_JOB), 'GO', TABLE,,)
	IER = 10
	IF (.NOT. LRES) GOTO 910

C .. Build job control logical name and set to 'go'
	WRITE(IUNIT, 6000) JOBNAME(1:NC_JOB)
6000	FORMAT(' JOB PROCESSING CONTROL LOGICAL NAME: ', A<NC_JOB>)

	CALL READ_TELE_INPUT (IUNIT, IRES)
	IER = 20
	IF (IRES .LT. 1) GOTO 910

	IF (TELE.T0 .GE. 0.D0) THEN
	  CALL VMSTIME(TELE.T0, CMAIL.CSINCETIME)
	END IF
	
	CMAIL.CMAILFILE = TELE.MAILFILE
	CMAIL.CMAILFOLDER = TELE.FOLDER
	CMAIL.WAIT = TELE.WAIT

	CALL HERRIN(IRES)
	IER = 25
	IF (IRES .LT. 1) GOTO 910

C .. begining of mail file processing
	CALL MAIL_FILE_INIT(IUNIT, CMAIL, IRES)
	IF (IRES .LT. 1) THEN
	  IER = 30
	  GOTO 910
	END IF
	END_MSGFILE_FLG = .TRUE.

	KTEL(1) = MAXTEL
	CALL KINIT(KTEL, 'TELE', IRES)	! SETUP TELE.KIN VECTOR
	IER = 90
	IF(IRES .LT. 1) GOTO 910
	TELKIN_OPEN_FLG = .FALSE.

C .. top of mail processing loop
10	CONTINUE

C .. Check for logical stop of processing
	TESTSTR = ' '
	CALL TRANSLATE_STRING (JOBNAME(1:NC_JOB), TABLE, TESTSTR,
	1	  IRES)

	IRES = STR$CASE_BLIND_COMPARE('GO', TESTSTR)
	IF (IRES .NE. 0) GOTO 850	! terminate all processing

	CALL MAIL_CHECK_FOLDERS(IUNIT, CMAIL, IRES)
	IF (IRES .EQ. 0) THEN
C	  WRITE(IUNIT, *) 'WAITING FOR MAIL LOOP...'
	  IRES =  LIB$WAIT(CMAIL.WAIT)
	  GOTO 10	! no newmail
	ELSE IF (IRES .LT. 0) THEN
	  IER = 40
	  GOTO 910
	END IF

C .. begining of mail msg processing
	CALL MAIL_MSG_INIT(IUNIT, CMAIL, IRES)
	IF (IRES .LT. 1) THEN
	  IER = 50
	  GOTO 910
	END IF
	END_MSG_FLG = .TRUE.

c .. get new messages from folder
	NMSG = 0		! number of messages
	NRECS_READ = 0		! txt record of current msg
	NEQ = 0			! number of eqs msgs

	CALL MAIL_MSG_SEL(IUNIT, CMAIL, IRES)
	IF (IRES .LT. 0) THEN
	  IER = 60
	  GOTO 910
	END IF
	WRITE(IUNIT,*) 'SELECTED MESSAGES:', CMAIL.NMSGS

	IF (CMAIL.NMSGS .EQ. 0) THEN
	  WRITE(IUNIT, *) 'MAIL WAIT LOOP...'
	  IRES = LIB$WAIT(CMAIL.WAIT)
	  GOTO 10	! restart mail search
	END IF

30	CONTINUE	! retrieve msg text

	WRITE(LIST_LUN ,*)  'CALLING MAILGETTXT'
	CALL MAIL_GET_TXT(IUNIT, CMAIL, IRES)	! get line of text current msg
	IF (IRES .LT. 0) THEN
	  IER = 70
	  GOTO 910
	END IF
	IF(CMAIL.STATUS .EQ. MAIL$_NOMOREMSG) THEN	! 
	  CMAIL.NRECS = 0
	  CMAIL.NMSGS = 0
	  GOTO 80
	END IF
	IF (CMAIL.STATUS .EQ. MAIL$_MSGTEXT) THEN
C	  IF (CMAIL.RECTYP .EQ. MAIL$_MESSAGE_TEXT) THEN
C	   NTXT_READ = NTXT_READ + 1
C	  END IF
	  NRECS_READ = NRECS_READ + 1
	  IF (CMAIL.RECTYP .EQ. MAIL$_MESSAGE_HEADER) GOTO 30
	  NTXT_READ = NTXT_READ + 1
	  NC_RET = LENTRUE(CMAIL.CMSGTXT)
	  IF (CMAIL.CMSGTXT(1:1)  .EQ. 'E') THEN
	    NEQ = NEQ + 1
	    CEQ(NEQ) = CMAIL.CMSGTXT
	    WRITE(IUNIT,*) CMAIL.CMSGTXT(:NC_RET)
	  END IF
	END IF
	
	IF (CMAIL.NRECS .EQ. NTXT_READ .OR.
	1	CMAIL.STATUS .EQ. MAIL$_NOMOREREC) THEN
	  NTXT_READ = 0
	  NRECS_READ = 0
	  NMSG = NMSG + 1
	  CMAIL.NRECS = 0
	  IF (NMSG .EQ. CMAIL.NMSGS) THEN
	    CMAIL.NMSGS = 0
	    GOTO 80
	  END IF
	END IF


	GOTO 30	! (NTXT_READ .LT. CMAIL.NRECS) 

C .. at end of message processing for current mail selected
80	CONTINUE

	WRITE(LIST_LUN ,*)  'CALLING MAILMSGEND'
	CALL MAIL_MSG_END(IUNIT, CMAIL, IRES)
	IF (IRES .LT. 1) THEN
	  IER = 80
	  GOTO 910
	END IF
	END_MSG_FLG = .FALSE.
	WRITE(LIST_LUN ,*)  'NEQ:', NEQ
	IF (NEQ .EQ. 0)  GOTO 10	! no txt has 'E' msg, restart

	IEQ = 0				! initialize 1st eq index

C .. top of current eq loop
90	CONTINUE
	IF (TELKIN_OPEN_FLG) THEN
	  CALL DETACH(KTEL, 0, IRES)
	  IER = 85
	  IF (IRES .LT. 0) GOTO 910
	  TELKIN_OPEN_FLG = .FALSE.
	END IF
C .. Check for logical stop of processing
	CALL TRANSLATE_STRING (JOBNAME(1:NC_JOB), TABLE, TESTSTR,
	1	  IRES)
	IRES = STR$CASE_BLIND_COMPARE('GO', TESTSTR)
	IF (IRES .NE. 0) GOTO 850	! terminate all processing

	IF (IEQ .LT. NEQ) THEN		! get event time from text
	  IEQ = IEQ + 1			! bump eq count
	  WRITE(IUNIT,*) CEQ(IEQ)
	  READ(UNIT=CEQ(IEQ), FMT= 610) CID, IYR1, IMO1, IDY1, IHR1, IMN1, S1,
	1	LATD, LOND, Z, XMAG
610	  FORMAT (2X,A8,3X,I4,4I2,F3.1,F7.4,F8.4,F4.1,F2.1)
	ELSE				! done with eqs, restart
	  WRITE (IUNIT, *) 'NO MORE MSGS RESET .EVT SEARCH.'	! stop
	  GOTO 10			! restart mail search
	END IF

	NC_ID = LENTRUE(CID)
	IF (NC_ID .LE. 0) THEN
	  WRITE(IUNIT, *) 'MSG ID HAD ZERO LENGTH; BAD RECORD??'
	  GOTO 90
	END IF

	DISTMIN = 999.9
	DISTMAX = 0.
	TTMIN = 9999.9
	TTMAX = 0.
	WRITE(LIST_LUN ,*)  'CALLING DELAZ'
	DO I = 1, MAXFIX
	  CALL DELAZ( LATD, LOND, LATDS(I), LONDS(I), DIST,
	1	 AZDUM1, AZDUM2)
	  IF (DIST .LE. 98.9) THEN
	    ier = 86
	    CALL TTDDEL(DIST, Z, TT, DTDD, IRES)
	    if (ires .lt. 1) write(iunit,*) 'ttddel ires, ier:', ires, ier
	  ELSE IF (DIST .LT. 110.0) THEN
	    ier = 87
	    CALL TTDDEL(98.9, Z, TT, DTDD, IRES)
	    if (ires .lt. 1) write(iunit,*) 'ttddel ires, ier:', ires, ier
	    TT = TT + DTDD * (DIST - 98.9)
	  ELSE 
	    CALL PKPINT(DIST, Z, TT, DTDD, IRES)
	  END IF	
	  IF (TTMIN .GE. TT) TTMIN = TT
	  IF (TTMAX .LE. TT) TTMAX = TT
	  IF (DISTMIN .GE. DIST) DISTMIN = DIST
	  IF (DISTMAX .LE. DIST) DISTMAX = DIST
	END DO

	IF (DISTMIN .LT. MINDIST_CUTOFF) THEN
	  CALL DELAZ( LATD, LOND, LAT_CEN, LON_CEN, DISTMIN,
	1	 AZDUM1, AZDUM2)
	  IF (DISTMIN .LT. MINDIST_CUTOFF) THEN
	    WRITE(IUNIT, *) 'EVENT DELTA .LT. MINCUTOFF:', MINDIST_CUTOFF,
	1	' SKIPPING EVENT.'
	    GOTO 90
	  END IF
	END IF

c .. test for closein eqs
	IRES = INSDE(LOND, LATD, LONDS, LATDS, 4)
	IF (IRES .NE. 0) THEN
	  WRITE(IUNIT, *) 'EVENT CLOSE TO NETWORK ... ASSUMING ZERO TT.'
	  TTMIN = 0.
	  CALL DELAZ( LATD, LOND, LAT_CEN, LON_CEN, DISTMIN,
	1	 AZDUM1, AZDUM2)
	END IF

	CALL ATTACH(KTEL, TELE_LUN, 'TELE$WARM:TELE', IRES)
	IER = 90
	IF(IRES .LT. 1) GOTO 910
	TELKIN_OPEN_FLG = .TRUE.

	CRID = 'TEL'
	LID = 0
	LMIN = 0
	CALL TELE_KIN(IUNIT, KTEL, 'GET', CRID, CID, LID, LMIN,
	1	 CEQ(IEQ), IRES)
	IER = 95
	IF (IRES .GT. 0) THEN
	  CALL C_CLOCK(LMIN)
	  IF ((XMAG .GE. 6.) .OR.
	1	 ((DISTMIN .LE. 40.) .AND. (Z .GE. 50.))) THEN
	    CALL DROP(KTEL, IRES)
	    IER = 100
	    IF (IRES .LT. 1) GOTO 910
	    CRID = 'SAV'
	    CALL TELE_KIN(IUNIT, KTEL, 'PUT', CRID, CID, LID, LMIN, 
	1	CEQ(IEQ), IRES)
	    IF (IRES .LT. 0) THEN
	      WRITE(IUNIT, *) 'UNABLE TO SAVE TELE.KIN RECORD.'
	    END IF
	    GOTO 90	! do next eq, if any
	  ELSE
	    CALL DROP(KTEL, IRES)
	    IER = 105
	    IF (IRES .LT. 1) GOTO 910
	    CRID = 'REJ'
	    CALL TELE_KIN(IUNIT, KTEL, 'PUT', CRID, CID, LID, LMIN, 
	1	CEQ(IEQ), IRES)
	    IF (IRES .LT. 0) THEN
	      WRITE(IUNIT, *) 'UNABLE TO REJECT TELE.KIN RECORD.'
	    END IF
	    GOTO 90	! do next eq, if any
	  END IF
	ELSE IF (IRES .LT. 0) THEN
	  WRITE(IUNIT, *) 'UNABLE TO READ TELE.KIN RECORD.'
	  GOTO 910
	END IF

	IF (TELKIN_OPEN_FLG) THEN
	  CALL DETACH(KTEL, 0, IRES)
	  IER = 110
	  IF (IRES .LT. 0) GOTO 910
	  TELKIN_OPEN_FLG = .FALSE.
	END IF

C .. calculate recovery times of current event
	CALL GRGMIN(IYR1, LMIN1)
	T0_START_REQ = DFLOAT(LMIN1) * 60.D0 + S1 + DBLE(TTMIN)
	1	 - DBLE(TELE.TLEAD)
	T0_END_REQ = T0_START_REQ + TELE.DT0

	CALL DATE22 (T0_START_REQ, %REF(C22START))
	WRITE (IUNIT, *) 'REQ_START_TIME:', C22START
	CALL DATE22 (T0_END_REQ, %REF(C22END))
	WRITE (IUNIT, *) 'REQ_END_TIME  :', C22END

	NC_DIR_IN = LENTRUE(TELE.INDIR)
	CSEARCH =  TELE.INDIR(:NC_DIR_IN) // 'T*.EVT;'
	OPEN_OUTPUT_FLG = .TRUE.

	LBASE_OUT = 0
	KBUF = 0
	LID = 0
	WRITE(IUNIT, *)

100	CONTINUE		! top of .evt file loop

C .. Check for logical stop of processing
	CALL TRANSLATE_STRING (JOBNAME(1:NC_JOB), TABLE, TESTSTR,
	1	  IRES)
	IRES = STR$CASE_BLIND_COMPARE('GO', TESTSTR)
	IF (IRES .NE. 0) GOTO 850	! terminate all processing

C .. Check for existance of event scheduling file
C	WRITE(IUNIT,* ) 'SEARCHING FOR:"', CSEARCH(:NC_DIR_IN+8), '"'
	IF (RESET_SEARCH_FLG) THEN
	  CALL FIND_FILE(' ', FILE_STR, IRES)	! reset search
	  RESET_SEARCH_FLG = .FALSE.
	END IF
	CALL FIND_FILE (CSEARCH, FILE_STR, IRES)
	IF (IRES .LT. 1) THEN	! no more files
C .. check jobname stuff to cycle
	  CALL LIB$WAIT(TELE.WAIT)		! wait this long
	  IF (.NOT. OPEN_OUTPUT_FLG) THEN	! already processing eq
	    CALL FIND_FILE (CSEARCH, FILE_STR, IRES)	! look for .evt
	    IF (IRES .LT. 1) THEN			! still no .evt
	      WRITE (IUNIT, *) 'NO MORE .EVT FILES THIS EQ.'	! stop
	      RESET_SEARCH_FLG = .TRUE.
	      GOTO 800			! 11/10/94 AWW finish current output FILE
	    END IF
	  ELSE					! new eq
	    WRITE (IUNIT, *) 'NO MORE .EVT FILES DO NEXT MAIL MSG'	! end of data
	    GOTO 90			! 11/10/94 AWW DO NEXT MAIL MSG
	  END IF
	END IF 
	NC_FILE = IRES
	
C	WRITE(IUNIT, *) 'FOUND:"', FILE_STR(:NC_FILE), '"'
	FILE_STR = FILE_STR(:NC_FILE) // CHAR(0)

C .. Open .EVT input file
	LBLOCKS = 0
	LFLAG = 0	! read only
	CLOSE (UNIT=EVT_LUN)	! close unit
	CALL RMS_OPENC(LFLAG, EVT_LUN, FILE_STR(:NC_FILE), LBLOCKS, IRES) 
	IER = 115
	IF(IRES .LT. 1) THEN
	  WRITE(UNIT= CMESS, FMT='(A,A)') 'CANNOT OPEN EVT FILE:',
	1	 FILE_STR(:NC_FILE)
	  GOTO 100		! skip .evt
	END IF
	IF (LBLOCKS .EQ. 0) THEN
	 IER = 120
	 WRITE(UNIT= CMESS, FMT='(A,A)') 'EVT FILE HAS 0 DATA BLOCKS:',
	1	 FILE_STR(:NC_FILE)
	   GOTO 100	! skip .evt
	END IF

C .. Determine .evt file size in words
	IF (FFB .EQ. 0) THEN		! RMS common data, first free byte
	  IN_BLOCKS = EOF_BLOCK - 1	! Last block of data
	  TOTAL_WORDS = IN_BLOCKS * 256	! Words in grm file
	ELSE
	  IN_BLOCKS = EOF_BLOCK
	  TOTAL_WORDS = IN_BLOCKS * 256 + (FFB + 1)/256
	END IF

C .. read web
120	CONTINUE
	LBASE_IN = 0				! base word of next block read
	CALL RMS_GET(EVT_LUN, NWORDS_WEB, W, LBASE_IN, IRES)	! get input data
	IER = 130
	IF (IRES .NE. NWORDS_WEB) THEN
	  CMESS = 'RMS_GET1 WRDS .NE. WORDS IN WEB. WAIT, RETRY.'
	  WRITE(IUNIT, *) 'BAD WEB IN .EVT:', FILE_STR(:NC_FILE),
	1	' SKIPPING TO NEXT FILE.'
	  CLOSE (UNIT=EVT_LUN)	! close unit
	  GOTO 100	  	! get next .evt
C 	  IERR = IERR + 1
C	  IF (IERR .GT. 2) GOTO 910
C	  CALL LIB$WAIT(10.)
C	  GOTO 120 
	END IF	
	IERR = 0

	IF(W.WEB_ID .NE. VERSION) THEN	! check version number of web
	  WRITE(IUNIT,6050) VERSION, W.WEB_ID
6050	  FORMAT(1X, '*ERROR: WEB VERSION MISMATCH.'
	1		 ' COMPILED VERSION= ', F7.2,
	1		 ', EVT W.WEB_ID= ', F7.2)
	  NWORDS_WEB = ((W.NWPAR + 255) / 256) * 256
	  IER = 140
C	  GOTO 910
	ENDIF

	IRES = ((W.NWPAR + 255) / 256) * 256
	IF (NWORDS_WEB .NE. IRES) THEN
	  IER = 150
	  WRITE(IUNIT, *) 'MAXREG .NE. WORDS IN WEB.', MAXREG, IRES
	  NWORDS_WEB = IRES	! actual web words
	  CALL RMS_GET(EVT_LUN, NWORDS_WEB, W, LBASE_IN, IRES)	! get input data
	  IER = 160
	  IF (IRES .NE. NWORDS_WEB) THEN
	    CMESS = 'RMS_GET2 WRDS .NE. WORDS IN WEB.'
	    GOTO 910
	  END IF	
C	  IF (IRES .GT. MAXREG) GOTO 910
	ENDIF

	LBASE_IN = LBASE_IN + NWORDS_WEB

	CALL SET_TIME (IRES)			!set/reset time base
	IER = 170
	IF (IRES .LT. 0) THEN
	  CMESS = 'UNABLE TO SET_TIME BASE.'
	  GOTO 910
	END IF

C ..
C .. read 1st data buffer
	NWORDS_DIO = ((W.NWDIO + 255) / 256) * 256
	CALL RMS_GET(EVT_LUN, NWORDS_DIO, IO.D, LBASE_IN, IRES)
	IF (IRES .NE. NWORDS_DIO) THEN
	  CMESS = 'RMS_GET WRDS .NE. WORDS/DIO FOR 1st DATA BUFFER.'
	  IER = 180
	  GOTO 910
	END IF	
	
C	IF(W.DTIRIG .GT. 0) THEN
C	  DT0 =	 W.DTIRIG + W.STIRIG * (IO.D(1).H.LRTC - W.LTIRIG) ! Irige time first scan
C	ELSE IF (W.DTSER .GT. 0) THEN
C	  DT0 = W.DTSER  + (IO.D(1).H.LRTC - W.LTSER)/ FLOAT(W.KRATE) ! CPUtime first scan
C	ENDIF

	LBON = IO.D(1).H.LBUF			! buffer number
	LRTC_FIRST1 = ((LBON - 1) * W.KSPB)	! + 1 predicted rtc
	LRTC_FIRST2 = IO.D(1).H.LRTC		! observed rtc
	LRTC_FIRST = LRTC_FIRST2		! use this value

	DATA_WORDS = (TOTAL_WORDS - NWORDS_WEB) ! data in file
	DATA_BUFFERS = DATA_WORDS / NWORDS_DIO 	! buffers in file
	LDIFF = MOD(DATA_WORDS, NWORDS_DIO)	! should be 0
	SAMPLES = DATA_BUFFERS * W.KSPB		! total chnl data samples
	LRTC_END1 = SAMPLES + LRTC_FIRST - 1	! predicted ending rtc
	LRTC_END2 = W.LSLI_END			! declared end
	LBOFF = LBON + DATA_BUFFERS - 1		! last buffer, end of file data
	LRTC_END = LRTC_END1			! use this value

	IF (LDIFF .NE. 0) THEN
	  WRITE(IUNIT, *)
	1	'*Error words/DIO buffer mismatch. BUFFERS:', DATA_BUFFERS,
	1	 ' RESID_WORDS:', LDIFF,
	1	' W.KSPB:', W.KSPB
	END IF	
	IF (LRTC_END1 .NE. LRTC_END2) THEN
	  WRITE(IUNIT, *) '*End RTC mismatch;',
	1	 ' CALC:', LRTC_END1, ' FROM FILE:', LRTC_END2
	ENDIF

	T0_START = DT_OF_RTC(LRTC_FIRST) 
	CALL DATE22 (T0_START, %REF(C22START))
	C22START_DATA = C22START
C	WRITE (IUNIT, *) 'INFILE START_TIME:', C22START

	T0_END = DT_OF_RTC(LRTC_END)
	CALL DATE22 (T0_END, %REF(C22END))
C	WRITE (IUNIT, *) 'INFILE END_TIME:', C22END

	IF (OPEN_OUTPUT_FLG) THEN	! check for earliest eq time
	  IF (T0_START_REQ .LT. T0_START) THEN
	    WRITE(IUNIT, *) 'MISSING FIRST PART OF REQ, SKIPPING EQ RECOVERY'
	    RESET_SEARCH_FLG = .TRUE.
	    GOTO 90	! do next eq in mail list
	  END IF
	END IF

	IF (T0_END .LT. T0_START_REQ) THEN	! file precedes event
		CLOSE(UNIT=EVT_LUN)
C	WRITE(IUNIT, *) '	REJECT INPUT EVT FILE:', FILE_STR(:NC_FILE)
C	WRITE(IUNIT, *) '		TIME :', C22START, ' ', C22END
C	WRITE(IUNIT, *) '		LBON :', LBON, ' RTC:', LRTC_FIRST2
C	WRITE(IUNIT, *) '		LBOFF:', LBOFF, ' RTC:', LRTC_END
		GOTO 100	! get next .evt file
	ELSE IF (T0_START .GT. T0_END_REQ) THEN ! file starts after event
	  WRITE(IUNIT, *) 'NEXT .EVT START TIME BEYOND REQUESTED END TIME.' 
C	WRITE(IUNIT, *) '	REJECT INPUT EVT FILE:', FILE_STR(:NC_FILE)
C	WRITE(IUNIT, *) '		TIME :', C22START, ' ', C22END
C	WRITE(IUNIT, *) '		LBON :', LBON, ' RTC:', LRTC_FIRST2
C	WRITE(IUNIT, *) '		LBOFF:', LBOFF, ' RTC:', LRTC_END
		GOTO 800	! done with current eq
	ELSE IF (T0_START_REQ .GT. T0_START) THEN
C	WRITE(IUNIT, *) '	ACCEPT 1ST INPUT EVT FILE:', FILE_STR(:NC_FILE)
C	WRITE(IUNIT, *) '		TIME :', C22START, ' ', C22END
C	WRITE(IUNIT, *) '		LBON :', LBON, ' RTC:', LRTC_FIRST2
C	WRITE(IUNIT, *) '		LBOFF:', LBOFF, ' RTC:', LRTC_END
	  LDIFF = ((T0_START_REQ - T0_START) * TIME.RATE)/ W.KSPB
	  LBON = LBON + LDIFF
	  LRTC_FIRST = LRTC_FIRST + (LDIFF * W.KSPB)
	  LRTC_START = LRTC_FIRST
	  T0_START = DT_OF_RTC(LRTC_FIRST) 
	  CALL DATE22 (T0_START, %REF(C22START_DATA))

	  NBUF_REQ = INT( (TELE.DT0 * DFLOAT(W.KRATE) + DFLOAT(W.KSPB - 1) )
	1		/ DFLOAT(W.KSPB))
	  WRITE(IUNIT, *) 'NUMBER OF REQ BUFFERS:', NBUF_REQ
	  LAST_REQ_BUFF = LBON + NBUF_REQ 
	  LRTC_STOP = LAST_REQ_BUFF * W.KSPB - 1
	END IF

	IF (LBOFF .GT. LAST_REQ_BUFF) THEN
	  LRTC_END = LRTC_END - (LBOFF - LAST_REQ_BUFF) * W.KSPB 
	  LBOFF = LAST_REQ_BUFF	! set last buff
	END IF 

	IF (OPEN_OUTPUT_FLG) THEN	! Open new .EVT output file
	  LBLOCKS = (NBUF_REQ * W.NWDIO + W.NWPAR + 255 )/ 256
	  NC_DIR_OUT = LENTRUE(TELE.OUTDIR)
	  FREE_BLOCKS = 0 ! Check output device space, device & blocks returned
	  CALL GET_FREE_BLOCKS(TELE.OUTDIR(:NC_DIR_OUT), DEVICE, FREE_BLOCKS,
	1	 MAX_BLOCKS, IRES)
	  IF (IRES .LT. 1) THEN
	    IER = 190
	    CMESS = 'UNABLE TO GET DEVICE FREE BLOCKS'
	    CALL TIME_STAMP('** EXTRACT_TELE FREE_BLOCKS error at:', IUNIT)
	    CALL WRITE_ERR(IUNIT, 'EXTRACT_TELE', CMESS, IER, IRES)
	    GOTO 910
	  END IF

	  NC_DEV = LENTRUE(DEVICE)
	  REMAINING_BLOCKS = FREE_BLOCKS - LBLOCKS ! If current event is output

C .. Check time of last mail update, notify if necessary
	  CALL C_CLOCK(CURRENT_MINUTE)		 ! Get current system minute
	  IF ((CURRENT_MINUTE - LAST_MAIL_MINUTE) .GT. TELE.ALARM .OR.
	1	LAST_MAIL_MINUTE .EQ. 0 ) THEN
	    IF (REMAINING_BLOCKS .LT. TELE.MIN_FREE) THEN
	      LAST_MAIL_MINUTE = CURRENT_MINUTE		! Time of last mail call
	      WRITE (UNIT=CMESS, FMT=6040) DEVICE(1:NC_DEV), FREE_BLOCKS 
6040	      FORMAT(1X, '*EXTRACT_TELE* ', A<NC_DEV>, ' HAS ONLY',
	1	 I7, ' FREE BLOCKS. WAITING FOR SPACE...')
	      CALL SEND_MAIL(IUNIT, ALARM_LUN, CMAIL_COMMAND, MAIL_FILE,
	1	 CMESS)
	    END IF
	  END IF

C .. If not enough space, loop til more becomes available
	  IF  (REMAINING_BLOCKS .LT. TELE.MIN_FREE) THEN
	    CALL TIME_STAMP('** !NOTE! TELESEISM DISK AT MIN FREE BLOCKS **',
	1	 IUNIT)
	    GOTO 910	! temporary exit, should restart with next request
	  END IF
c......................................................................
c .. Create new cuspid.evt file for extracted .evt data

	  CALL NXTSEQ('EVENT', LID, IRES)	! get next id
	  IER = 200
	  IF (IRES .LT. 1) GOTO 910

	  FILENAME = 'T' // CHAR(0)
	  CALL CONINTC(FILENAME, LID, IRES)
	  NC_ID = IRES - 1
	  FILENAME = FILENAME(:IRES) // '.EVT' // CHAR(0)
	  NC_OUT = IRES + 4
	  FILE_OUT_STR =  TELE.OUTDIR(:NC_DIR_OUT) // FILENAME(:NC_OUT+1)	  
	  NC_OUT = NC_DIR_OUT + NC_OUT
	  CLOSE (UNIT=EVT2_LUN, IOSTAT= IRES)	! close unit
	  LFLAG = 4	! write with truncate on close
	  CALL RMS_OPENC(LFLAG, EVT2_LUN, FILE_OUT_STR, LBLOCKS, IRES) 
	  IER = 210
	  IF(IRES .LT. 1) THEN
	    WRITE(UNIT= CMESS, FMT='(A,A)') 'CANNOT OPEN EVT FILE:',
	1	 FILE_OUT_STR(:NC_OUT)
	  END IF
	  WRITE(IUNIT, *) '	OUTPUT .EVT FILE:', FILE_OUT_STR(:NC_OUT)

	  IF (IRES .LT. 1) THEN
	    IER = -IRES
	    IF (IER .EQ. RMS$_DNF) THEN
	      CMESS = 'EXTRACT_TELE RMS_OPEN DNF-IS OUTPUT DIRECTORY DEFINED?'
	      GOTO 910
	    ELSE IF (IER .EQ. RMS$_FUL) THEN
	      REMAINING_BLOCKS = 0
	      CALL TIME_STAMP('** RMS_OPEN ERROR: OUTPUT DISK FULL.', IUNIT)
	      WRITE (UNIT=CMESS, FMT=6060) DEVICE(1:NC_DEV)
6060	      FORMAT(1X, '*EXTRACT_TELE ERROR* DISK ', A<NC_DEV>,
	1	 ' IS FULL.')
	      CALL SEND_MAIL(IUNIT, ALARM_LUN, CMAIL_COMMAND, MAIL_FILE,
	1	 CMESS)
	    END IF
	    CMESS = 'EXTRACT_TELE RMS_OPEN OUTFILE ERROR'
	    GOTO 910
	  END IF

c .. set some values in WEB so this will look like a proper event to REFORM
c    REFORM does some consistancy checks with these so they must be set.
c    Create pseudo event #1 in t. structure
	  W.L_CID  = LID			!CUSP ID of event
	  W.KSLING = LID			!CUSP ID 
	  T.LCID(1) = LID			!CUSP ID 
	  W.KSCARAB = 1				!INDEX IN T. ARRAYS
	  T.LTRON(1) = LRTC_START 		!RTC AT EVENT START
	  T.LTROFF(1) = LRTC_STOP	 	!last RTC of last buffer
	  W.LSLI_END = LRTC_STOP
	  W.LSCA_END = LRTC_STOP

c .. write WEB out to new .evt file after updating parameters
	  CALL RMS_PUT(EVT2_LUN, NWORDS_WEB, W, 0, IRES)	! write web
	  IER = 220
	  IF (IRES .NE. NWORDS_WEB) GOTO 910

	  LBASE_OUT = NWORDS_WEB		! current offset at end of web
	  OPEN_OUTPUT_FLG = .FALSE.
	END IF

	WRITE(IUNIT, *) '	INPUT EVT FILE:', FILE_STR(:NC_FILE)
	WRITE(IUNIT, *) '	   FILE TIME :', C22START, ' ', C22END
	WRITE(IUNIT, *) '	   DATA TIME :', C22START_DATA, ' ', C22END
	WRITE(IUNIT, *) '		LBON :', LBON, ' RTC:', LRTC_FIRST
	WRITE(IUNIT, *) '		LBOFF:', LBOFF, ' RTC:', LRTC_END

c .. write 1st data buffer out to .evt file 
	IF (LBON .EQ. IO.D(1).H.LBUF) THEN
	  CALL RMS_PUT(EVT2_LUN, NWORDS_DIO, IO.D, LBASE_OUT, IRES)
	  IER = 230
	  IF (IRES .NE. NWORDS_DIO) GOTO 910
	  LBASE_OUT = LBASE_OUT + NWORDS_DIO	! bump offset to end of 1st out buffer
	  KBUF = KBUF + 1			!count of buffers output
	  LB = LBON + 1			!set buffer index to 2nd buffer
	ELSE
	  LB = LBON
	  LBASE_IN = LBASE_IN + (LDIFF-1)*NWORDS_DIO
	END IF

c ...... Top of buffer write loop

	DO WHILE (LB .LE. LBOFF) 
	  LBASE_IN = LBASE_IN + NWORDS_DIO	! bump input base offset
	  CALL RMS_GET(EVT_LUN, NWORDS_DIO, IO.D, LBASE_IN, IRES)
	  IF (IRES .EQ. 0) THEN
	    WRITE(IUNIT, *) 'RMSGET EOF'
	    GOTO 500			! finished with this file
	  ELSE IF (IRES .NE. NWORDS_DIO) THEN
	    CMESS = 'RMS_GET WORDS .NE. WORDS/DIO FOR DATA BUFFER.'
	    IER = 240
	    GOTO 910
	  END IF	
	  LBUF = IO.D(1).H.LBUF
	  IF (LBUF .EQ. LB) THEN
	    CALL RMS_PUT(EVT2_LUN, NWORDS_DIO, IO.D, LBASE_OUT, IRES)	! write it out
	    IER = 250
	    IF (IRES .NE. NWORDS_DIO) GOTO 910
	    LBASE_OUT = LBASE_OUT + NWORDS_DIO	! bump output base offset
	    KBUF = KBUF + 1			!increment count of buffers out
	    LB = LB + 1				!increment buffer loop index
	  ELSE
	    WRITE(IUNIT, *) '*RESET ERROR? RMS_GET LBUF .NE. LB:', LBUF, LB
	    LB = LBOFF+1
	  END IF
	END DO
c ...... Bottom of buffer loop for current .evt input file

500	CONTINUE

	LRTC_LAST = IO.D(1).H.LRTC + W.KSPB - 1	! observed last sample rtc
	IF (LRTC_LAST .NE. LRTC_END) THEN
	  WRITE(IUNIT, *) '*LBOFF RTC mismatch;',
	1	 ' FOUND:', LRTC_LAST, ' FROM FILE:', LRTC_END
	END IF

	LB_END = IO.D(1).H.LBUF			! last buffer read
	IF (LB_END .NE. LBOFF) THEN
	  WRITE(IUNIT, *) '*LBOFF BUFFER at end of loop;',
	1	 ' FOUND:', LB_END, ' EXPECT:', LBOFF
	END IF

	WRITE (IUNIT, 6300) LID, LB_END, KBUF
6300	FORMAT (1X,' (', I<NC_ID>, ')', ' LBEND=', I12, ' Buffers:', I5)

	CLOSE(UNIT=EVT_LUN, IOSTAT=IRES)	! close input .evt file
	IF (IRES .NE. 0) THEN
	  WRITE(UNIT=IUNIT, FMT='(A,I)')
	1	 '*Error closing EVT; BAD IOSTAT:', IRES, ' LID:', LID
	END  IF

	GOTO 100		! do next .evt file 

C .. Normal end of EVT processing
800	CONTINUE
	  
C .. update web
	IF (.NOT. OPEN_OUTPUT_FLG) THEN
c .. update final values in WEB so this will look like a proper event to REFORM
	  W.L_CID  = LID			!CUSP ID of event
	  W.KSLING = LID			!CUSP ID 
	  T.LCID(1) = LID			!CUSP ID 
	  W.KSCARAB = 1				!INDEX IN T. ARRAYS
	  T.LTRON(1) = LRTC_START 		!RTC AT EVENT START
	  T.LTROFF(1) = LRTC_LAST	 	!last RTC of last buffer
	  W.LSLI_END = LRTC_LAST
	  W.LSCA_END = LRTC_LAST

	  CALL RMS_PUT(EVT2_LUN, NWORDS_WEB, W, 0, IRES)	! write web
	  IER = 260
	  IF (IRES .NE. NWORDS_WEB) GOTO 910

	  DT_FILE = DT_OF_RTC(LRTC_LAST)		!stop sec of file
	  CALL DATE22 (DT_FILE, %REF(C22END))
	  WRITE (IUNIT, 6666) '	OUTPUT .EVT >>>>> END_TIME:', C22END
6666	  FORMAT(1X, A, A, //)
	  CLOSE(UNIT=EVT2_LUN, STATUS='KEEP', IOSTAT=IRES)
	  IF (IRES .NE. 0) THEN
	    WRITE(IUNIT, *) '*Error on output .EVT close; IOSTAT:',
	1	 IRES, ' ID:', LID
	  END  IF
	END IF

	CALL POSTC('REFALL', LID, 10, IRES)
	IF (IRES .LT. 0) THEN
	  WRITE(IUNIT, *) 'UNABLE TO POST ID:', LID
	END IF

	CALL ATTACH(KTEL, TELE_LUN, 'TELE$WARM:TELE', IRES)
	IER = 270
	IF(IRES .LT. 1) GOTO 910
	TELKIN_OPEN_FLG = .TRUE.

	CALL C_CLOCK(LMIN)
	CRID = 'TEL'
	CALL TELE_KIN(IUNIT, KTEL, 'PUT', CRID, CID, LID, LMIN,
	1	 CEQ(IEQ), IRES)
	IF (IRES .LT. 0) THEN
	  IER = 280
	  WRITE(IUNIT, *) 'UNABLE TO UPDATE TELE.KIN IER = 280.'
	END IF

	RESET_SEARCH_FLG = .TRUE.
	GOTO 90	! do next eq on list

850	CONTINUE

	IF (END_MSG_FLG) THEN
	  CALL MAIL_MSG_END(IUNIT, CMAIL, IRES)
	  IF (IRES .LT. 1) THEN
	    CALL GETMSG(IUNIT, CMAIL.STATUS)
	  END IF
	END IF

	IF (END_MSGFILE_FLG) THEN
	  CALL MAIL_FILE_END(IUNIT, CMAIL, IRES)
	  IF (IRES .LT. 0) THEN
	    CALL GETMSG(IUNIT, CMAIL.STATUS)
	  END IF
	END IF

	IF (.NOT. OPEN_OUTPUT_FLG) THEN
	  CLOSE(UNIT=EVT2_LUN, STATUS='KEEP', IOSTAT=IRES)
	  IF (IRES .NE. 0) THEN
	    WRITE(IUNIT, *) '*Error on output .EVT close; IOSTAT:',
	1	 IRES, ' ID:', LID
	  END  IF
	END IF

C	IF (VMSCHN .GT. 0) CALL CLOSE_MSG_SOCKET(VMSCHN, IRES)
	LRES = LIB$DELETE_LOGICAL(JOBNAME(1:NC_JOB), TABLE)
	IF (.NOT. LRES) CALL GETMSG(IUNIT, LRES)

	WRITE (IUNIT, *) '		END OF PROCESSING'

	CALL EXIT

c ... ERROR path, notify and quit
910	CONTINUE

	CALL WRITE_ERR(IUNIT, 'EXTRACT_TELE', CMESS, IER, IRES)

	CLOSE(UNIT=EVT_LUN, STATUS='KEEP', IOSTAT=IRES)
	IF (IRES .NE. 0) THEN
	  WRITE(IUNIT, *) '*Error on .EVT close; IOSTAT:', IRES, ' ID:', LID
	END  IF

	CLOSE(UNIT=EVT2_LUN, STATUS='DELETE', IOSTAT=IRES)
	IF (IRES .NE. 0) THEN
	  WRITE(IUNIT, *) '*Error on output .EVT close; IOSTAT:',
	1	 IRES, ' ID:', LID
	END  IF

C	IF (VMSCHN .GT. 0) CALL CLOSE_MSG_SOCKET(VMSCHN, IRES)

	IF (CMAIL.STATUS .NE. 0) CALL GETMSG(IUNIT, CMAIL.STATUS)

	IF (END_MSG_FLG) THEN
	  CALL MAIL_MSG_END(IUNIT, CMAIL, IRES)
	  IF (IRES .LT. 1) THEN
	    CALL GETMSG(IUNIT, CMAIL.STATUS)
	  END IF
	END IF

	IF (END_MSGFILE_FLG) THEN
	  CALL MAIL_FILE_END(IUNIT, CMAIL, IRES)
	  IF (IRES .LT. 0) THEN
	    CALL GETMSG(IUNIT, CMAIL.STATUS)
	  END IF
	END IF

	LRES = LIB$DELETE_LOGICAL(JOBNAME(1:NC_JOB), TABLE)
	IF (.NOT. LRES) CALL GETMSG(IUNIT, LRES)

	END

C ----------------------------------------------------------------------
	SUBROUTINE READ_TELE_INPUT (IUNIT, IRES)

c .... read the initalization file (logical TELE$DCK or TELE.DCK if no 
c	logical is defined))
c	Call only AFTER LINKNLOCK, we need the WEB values here
c	The values are stored and passed in the 'TELE.INC' common
	IMPLICIT NONE
	INCLUDE 'LIB$RT:WEB.INC'
	INCLUDE 'EXTRACT_TELE.INC'		!structures
	INTEGER*4	LENTRUE
	LOGICAL	 IT_IS
	INTEGER*4 IUNIT, JUNIT
	INTEGER*4 IER, IRES
	INTEGER*4 NC_NAME, NC_DIR_IN, NC_DIR_OUT
	INTEGER*4 NC_MFILE, NC_FOLDER
	INTEGER*4 ISEMI, IVER, IVER_OLD/0/
	CHARACTER*80 CMESS
	CHARACTER*80 CNAME
	CHARACTER*80 CSTR		!KOM work space

	INTEGER*4 YEAR, MONTH, DAY, HOURS, MINS		! Input times
	INTEGER*4 START_TIME_GREG(5)
	COMMON/TIME/ YEAR, MONTH, DAY, HOURS, MINS	! Equivalence storage
	EQUIVALENCE (YEAR, START_TIME_GREG(1))

	REAL*4 SECS
	INTEGER*4 START_TIME_MIN				! START time


c .. define defaults
c	variable	default value	internal units		.ini units
C			(inter/exter)
C	--------	-------------	--------------		----------

	TELE.INDIR	= 'HOT:'	
	TELE.OUTDIR	= 'TELE$HOT:'
	TELE.MAILFILE	= 'SYS$LOGIN:MAIL.MAI' 
	TELE.FOLDER	= 'NEWMAIL'
	TELE.WAIT	= 600.		! seconds
	TELE.ALARM	= 60		! minutes
	TELE.MIN_FREE	= 100000	! blocks
	TELE.T0 = 0.D0
	TELE.TLEAD = 60.D0
	TELE.DT0 = 1200.D0

c .. open the file, try logical TELE$DCK 1st then file TELE$HOT:TELE.DCK
	IER = 10
	JUNIT = 20
	OPEN(UNIT=JUNIT,
	1  FILE='TELE$DCK',	!logical name of initializer file
	1  TYPE='OLD',
	1  READONLY, 
	1  ERR=40)			!no definition, try TELE$HOT:TELE.DCK

	GOTO 45

40	CONTINUE

	WRITE (IUNIT, *) 
	1	' TELE$DCK not defined trying file TELE$HOT:TELE.DCK'

	IER = 20
	OPEN(UNIT=JUNIT,
	1  FILE='TELE$HOT:TELE.DCK',	   !try literal name for local initializer file
	1  TYPE='OLD',
	1  READONLY, 
	1  ERR=910)

45	CONTINUE
	CNAME = ' '
	INQUIRE(UNIT=JUNIT, NAME=CNAME)
	NC_NAME = LENTRUE(CNAME)
	ISEMI = INDEX(CNAME, ';') 
	READ(UNIT=CNAME,FMT='(<ISEMI>X,I<NC_NAME-ISEMI>)') IVER
	
c .. read in the initializer file
50	CONTINUE

	CALL KOMRDC(JUNIT, IRES)			!get a line
	
	IF(IRES .EQ. -10) GOTO 60		!end of file
	IF(IRES .EQ. 0) GOTO 50			!blank or comment line, skip it
	IER = 30
	IF(IRES .LT. 0) GOTO 910

	CALL KOMSTRC(20, CSTR, IRES)	!interpret 1st token
	IER = 40
	IF(IRES .LT. 1) GOTO 910

c .. command interpretation
	IF (IT_IS ('IN!')) THEN		! device:[direct]
	  CALL KOMSTRC(80, TELE.INDIR, IRES)
	  IER = 50
	  IF (IRES .LE. 0) GOTO 910
	  NC_DIR_IN = IRES
	ELSE IF (IT_IS ('OUT!')) THEN		! device:[direct]
	  CALL KOMSTRC(80, TELE.OUTDIR, IRES)
	  IER = 60
	  IF (IRES .LE. 0) GOTO 910
	  NC_DIR_OUT = IRES
	ELSE IF (IT_IS ('MAIL!')) THEN		! device:[direct]
	  CALL KOMSTRC(80, TELE.MAILFILE, IRES)
	  IER = 70
	  IF (IRES .LE. 0) GOTO 910
	  NC_MFILE = IRES
	ELSE IF (IT_IS ('FOLD!')) THEN		! device:[direct]
	  CALL KOMSTRC(80, TELE.FOLDER, IRES)
	  IER = 80
	  IF (IRES .LE. 0) GOTO 910
	  NC_FOLDER = IRES
	ELSE IF (IT_IS ('FREE!')) THEN		! min_free disk block on device
	  CALL KOMINTC(TELE.MIN_FREE, IRES)
	  IER = 90
	  IF (IRES .LT. 0) GOTO 910
	ELSE IF (IT_IS ('ALARM!')) THEN		! minutes mail alarm notifications
	  CALL KOMINTC(TELE.ALARM, IRES)
	  IER = 100
	  IF (IRES .LT. 0) GOTO 910
	ELSE IF (IT_IS ('WAIT!')) THEN		! seconds to wait for new evt file
	  CALL KOMVALC(TELE.WAIT, IRES)
	  IER = 110
	  IF (IRES .LT. 0) GOTO 910
	ELSE IF (IT_IS ('DUR!')) THEN		! seconds evt duration
	  CALL KOMDVALC(TELE.DT0, IRES)
	  IER = 120
	  IF (IRES .LT. 0) GOTO 910
	ELSE IF (IT_IS ('LEAD!')) THEN		! seconds evt duration
	  CALL KOMVALC(TELE.TLEAD, IRES)
	  IER = 130
	  IF (IRES .LT. 0) GOTO 910
	ELSE IF (IT_IS ('TIME!')) THEN		! evt start time
	  IER = 140
	  CALL KOMINTC(YEAR, IRES)		! Parse START year
	  IF (IRES .LT. 1) THEN
	    CMESS =  'BAD YEAR.'
	    GOTO 910
	  END IF

	  CALL KOMINTC(MONTH, IRES)			! Parse START month
	  IF (IRES .LT. 1 .OR. MONTH .LT. 1 .OR. MONTH .GT. 12) THEN
	    CMESS =  'BAD MONTH.'
	    GOTO 910
	  END IF

	  CALL KOMINTC(DAY, IRES)				! Parse START days
	  IF (IRES .LT. 1 .OR. DAY .LT. 1 .OR. DAY .GT. 31) THEN
	    CMESS =  'BAD DAY.'
	    GOTO 910
	  END IF

	  CALL KOMINTC(HOURS, IRES)			! Parse START hours
	  IF (IRES .LT. 1 .OR. HOURS .LT. 0 .OR. HOURS .GT. 23) THEN
	    CMESS =  'BAD HOURS.'
	    GOTO 910
	  END IF

	  CALL KOMINTC(MINS, IRES)				! Parse START minutes
	  IF (IRES .LT. 1 .OR. MINS .LT. 0 .OR. MINS .GT. 59) THEN
	    CMESS =  'BAD MINUTES.'
	    GOTO 910
	  END IF

	  CALL KOMVALC(SECS, IRES)				! Parse START seconds
	  IF (IRES .LT. 1 .OR. SECS .LT. 0 .OR. SECS .GE. 60.) THEN
	    CMESS =  'BAD SECONDS.'
	    GOTO 910
	  END IF


	  CALL GRGMIN(START_TIME_GREG, START_TIME_MIN)	! Convert time to mins	
	  TELE.T0 = START_TIME_MIN * 60.D0 + SECS	! Event START time in secs

	ELSE					! bad input
	    WRITE (UNIT=CMESS, FMT='(2A)')
	1	'*READ_TELE_INPUT nonsense input line /',
	1	CSTR(:IRES), '/'
	END IF

	GOTO 50			!MORE, MORE AND STILL NOT SATIFIED...

c .. end of the init file

60	CLOSE (JUNIT)

c .. regurg results
	IF (IVER .NE. IVER_OLD) THEN
	  WRITE (IUNIT, *) ' TELE.INDIR		= ', TELE.INDIR(:NC_DIR_IN),
	1	'    (DEV:[DIR])' 
	  WRITE (IUNIT, *) ' TELE.OUTDIR	= ', TELE.OUTDIR(:NC_DIR_OUT),
	1	'    (DEV:[DIR])' 
	  WRITE (IUNIT, *) ' TELE.MAILFILE	= ', TELE.MAILFILE(:NC_MFILE),
	1	'    (DEV:[DIR])' 
	  WRITE (IUNIT, *) ' TELE.FOLDER	= ', TELE.FOLDER(:NC_FOLDER),
	1	'    (MAILFOLDER)' 

	  WRITE (IUNIT, *) ' TELE.T0		= ', TELE.T0,
	1	 ' (MESSAGE STARTTIME)'
	  WRITE (IUNIT, *) ' TELE.DT0		= ', TELE.DT0,
	1	 ' (DURATION SECS)'
	  WRITE (IUNIT, *) ' TELE.TLEAD		= ', TELE.TLEAD,
	1	 ' (LEAD TIME SECS)'
	  WRITE (IUNIT, *) ' TELE.MIN_FREE	= ', TELE.MIN_FREE,
	1	 ' (BLOCKS)'
	  WRITE (IUNIT, *) ' TELE.ALARM		= ', TELE.ALARM,
	1	 ' (DELAY MINUTES)'
	  WRITE (IUNIT, *) ' TELE.WAIT		= ', TELE.WAIT,
	1	 ' (NEW .EVT WAIT SECS)'
	END IF

	IVER_OLD = IVER
	IRES = 1
	RETURN
	
C .. ERROR PATH

910	CONTINUE
	IRES = - IER
	CALL WRITE_ERR(IUNIT, 'READ_TELE_INPUT', CMESS, IER, IRES)
	END

