C
C	WEB.INC
C
C	28-JUN-1988 -RSD
C		VERSION 2.0
C		CONVERT TO I*4 CUSP --- "GENERIC" CUSP ---
C		DECLARE EVERY VARIABLE EXPLICITLY IN A STRUCTURE.
C
C	02-AUG-1988 -RSD
C		ADD SLM(MAXPIN) FOR SCAN LIST MEMORY.
C		ADD KFRAME -- NUMBER OF WORDS IN A MAJOR FRAME.
C		CHANGE MAXTRG FROM 100 TO 20.
C
C	05-aug-1988 -pjj
C		changed maxwrd calculation to reflect addition of kslm above.
C
C	14-AUG-1988 -RSD
C		ADD MAXREG --> TOTAL WORDS IN WEB REGION.
C		USE MAXREG IN CALCULATIONS FOR MAXMEM AND MAXWRD TO
C		  AUTOMATICALLY RECALCULATE MAXMEM WHEN NEW ARRAYS ARE ADDED.
C
C	25-AUG-1988 -RSD
C		ADD  LCID(MAXTRG) ARRAY OF CUSP IDs. FILLED BY BICUSPID.FOR
C		ADD  KSCARAB AND KSLING VARIABLES TO HOLD RESPECTIVE KTRIGOUTs.
C		ADD  KSCA_STOP --> SCARAB CONTROL FLAG.
C		ADD  KSLI_STOP --> SLING  CONTROL FLAG.
C		DROP KSLIME.
C
C	26-AUG-1988 -RSD
C		ADD LIDOUT --> POINTER TO LAST CUSPID PRODUCED BY BICUSPID,
C				MUST BE MODULOd BY MAXTRG FOR ENTRY INTO
C				LTRON, LTROFF, LCID.
C
C	30-AUG-1988 -RSD
C		ADD STRUCTURE DUMMY --> GUARANTEE I ALWAYS KNOW THE LAST
C					ADDRESS IN THE WEB REGION WHICH
C					NOW IS PAD.IPAD(128).
C
C	15-SEP-1988 -RSD
C		ADD IRIG_STOP --> STOP FLAG FOR CONTINUOUSLY RUNNING IRIGE.
C
C	25-SEP-1988 -RSD
C		INTERCHANGE MEANING OF SER AND SYS IN TIMEKEEPING:
C		  DTSYS NOW MEANS SYSTEM START TIME FOR CORE AND
C		  DTSER NOW MEANS SYSTEM TIME THAT CORE LAST RESET LBUF.
C
C	26-SEP-1988 -RSD
C		VERSION 2.01
C
C	11-JUL-1989 -RSD
C		VERSION 2.02
C		CHANGE TSTA TO TSTW --- SHORT TERM WINDOW
C		CAHNGE TLTA TO TLTW --- LONG  TERM WINDOW
C
	PARAMETER VERSION = 2.01
	PARAMETER MAXPAR  = 512	!MAXIMIMUM I*2 WORDS ALLOWED IN PARAMETER AREA
	PARAMETER MAXPIN  = 512
	PARAMETER MAXSUB  = 100
	PARAMETER MAXWEB  = 1000
	PARAMETER MAXTRG  = 20

	PARAMETER MAXREG  = (			!TOTAL I*2 WORDS IN WEB REGION
	1		     MAXPAR		! PARAMETER SECTION OF WEB
	2			+ 20 * MAXPIN	! PIN ARRAYS
	3			+ 17 * MAXSUB	! SUBNET ARRAYS
	4			+  2 * MAXWEB	! PIN-SUBNET ARRAYS (NODES)
	5			+  7 * MAXTRG	! EVENT ARRAYS
	6			+ 256)		! 128 I*4 WORDS OF PADDING


C-RSD	PARAMETER MAXMEM  = (  512 * 256) - MAXREG !MEMORY REGION FOR DATA.
C-RSD	PARAMETER MAXMEM  = ( 1024 * 256) - MAXREG	! .5 MB
C-RSD	PARAMETER MAXMEM  = ( 2048 * 256) - MAXREG	!1   MB
C-RSD	PARAMETER MAXMEM  = ( 4096 * 256) - MAXREG	!2   MB
C-RSD	PARAMETER MAXMEM  = ( 8192 * 256) - MAXREG	!4   MB
	PARAMETER MAXMEM  = (12288 * 256) - MAXREG	!6   MB		!DDG
C-RSD	PARAMETER MAXMEM  = (16384 * 256) - MAXREG	!8   MB

	PARAMETER MAXWRD  = (MAXREG + MAXMEM)		!THIS IS 2 BYTE WORDS
	PARAMETER MAXPAG  = (MAXWRD + 255) / 256

C-RSD	PARAMETER MAXDIO = 32256  !MAXIMUM ALLOWED QIO TO DISK
	PARAMETER MAXDIO = 16128  !MAXIMUM ALLOWED QIO TO DISK, I*2 WORDS
C-RSD	PARAMETER MAXDIO =  4096  !MAXIMUM ALLOWED QIO TO DISK
C-RSD	PARAMETER MAXDIO =  2048  !MAXIMUM ALLOWED QIO TO DISK
C-RSD	PARAMETER MAXDIO =  1024  !MAXIMUM ALLOWED QIO TO DISK

	PARAMETER MAXHDR =  1024  !HEADER FOR EACH I/O BUFFER
	PARAMETER MAXDTA = (MAXDIO - MAXHDR)
	PARAMETER MAXBUF = (MAXMEM / MAXDIO)


	INCLUDE 'RT:DIO_STRUCT.INC/LIST'

C ***** SCALAR PARAMETERS
	STRUCTURE /WEB/
	  REAL*4	WEB_ID		! VERSION OF WEB FOR THIS DATA SET
	  INTEGER*4	NWPAR		! WORDS IN PARAMETER AREA
	  INTEGER*4	MPIN		! MAXIMUM NUMBER OF PINS ALLOWED
	  INTEGER*4	NPIN		! NUMBER OF ACTIVE PINS
	  INTEGER*4	MSUB		! MAXIMUN NUMBER OF SUBNETS
	  INTEGER*4	NSUB		! CURRENT SUBNETS
	  INTEGER*4	MWEB		! MAXIMUM WEB NODE MEMBERSHIP
	  INTEGER*4	NWEB		! CURRENT WEB NODE MEMBERSHIP
						! 32 BYTES		! 16 W

	  INTEGER*4	KSTOP		! CORE/SYSTEM STOP FLAG. STOP=1, IDLE=10
	  INTEGER*4	KRATE		! NOMINAL DIGITIZATION RATE
	  INTEGER*4	KFACT		! ACCELERATION FACTOR
					!   (E.G. 16 FOR FM TAPE)
	  INTEGER*4	LPACER		! TUSTIN HARDWARE CLOCK FREQUENCY
	  INTEGER*4	KCHLO		! STARTING CHANNEL
	  INTEGER*4	KCHHI		! ENDING CHANNEL
	  INTEGER*4	KSPB		! SCANS PER BUFFER
	  INTEGER*4	KFRAME		! NUMBER OF WORDS IN A MAJOR FRAME.
	  INTEGER*4	NBUF		! NUMBER OF DATA BUFFERS IN MEMORY
	  INTEGER*4	IREFTEK		! NUMBER OF WORDS IN REFTEK HEADER
					!   & TRAILER
	  INTEGER*2	NWDATA		! WORDS OF DATA
	  INTEGER*2	NWDMA		! WORDS PER DMA IO
	  INTEGER*2	NWDIO		! WORDS PER DISK QIO
	  INTEGER*2	NWNUL		! PADDING TO MAKE DISK IO AN
					!   INTEGRAL # OF DISK BLOCKS
	  INTEGER*4	LBUF		! CORE: MOST RECENTLY COMPLETED BUFFER
					!   (2 QIOs ARE AHEAD OF IT)
					!   (1 BUF = 1 QIO FROM DR11W)
	  INTEGER*4	L_ERR		! NUMBER OF FIFO OVERFLOWS IN CORE
	  INTEGER*4	LB_NEXT		! BUFFER THAT SCARAB IS WORKING WITH
	  INTEGER*4	LB_LAST		! LAST BUFFER SLING HAS WRITTEN.
	  INTEGER*4	KSCA_STOP	! SCARAB CONTROL FLAG. STOP=1, IDLE=10
	  INTEGER*4	KSLI_STOP	! SLING  CONTROL FLAG. STOP=1, IDLE=10
	  INTEGER*4	LDMAX		! # OF DATA BUFFERS, CUTOFF FOR REFORM
	  INTEGER*4	KTRGIN		! PNTR TO LAST EVENT(LTRON, LTROFF, LCID)
	  INTEGER*4	LIDOUT		! POINTER TO LAST CUSPID MADE BY BICUSPID
	  INTEGER*4	L_CID		! CUSP ID CURRENT SLING/SCARAB EVENT.
	  INTEGER*4	KSCARAB		! LAST EVENT OUT TO DISK.(LTRON,LTROFF,LCID)
	  INTEGER*4	KSLING		! LAST EVENT OUT TO TAPE.(LTRON,LTROFF,LCID)
	  INTEGER*4	LSCA_END	! RTC SET BY SCARAB AT THE TRUE END OF
	  INTEGER*4	LSLI_END	! RTC SET BY SLING  AT THE TRUE END OF
					!   AN EVENT
						! 104 BYTES		! 52 W

	  INTEGER*4	KSPI_ON		! SPIDER EVENT IN PROGRESS
	  INTEGER*4	KSPI_STOP	! SPIDER STOP FLAG, 1 => STOP, -1 -> HOT START
	  INTEGER*4	NDEC		! TRIGGER DECIMATION
	  REAL*4	TSTW		! SHORT TERM WINDOW (SECONDS)
	  REAL*4	TLTW		! LONG  TERM WINDOW (SECONDS)
	  REAL*4	QUIET		! QUIET STATION CONSTANT
	  REAL*4	SENSE		! NETWORK SENSITIVITY
	  REAL*4	TENON		! ONSET TENACITY (SPIKE SUPRESSION)
	  REAL*4	TENOFF		! TERMINATION TENACITY
	  REAL*4	TPREVT		! PRE-EVENT MEMORY
	  REAL*4	TPOST		! POST EVENT MEMORY
						! 44 BYTES		! 22 W

	  INTEGER*4	IRIG_STOP	! IRIGE CONTROL FLAG. STOP=1, IDLE=10
	  INTEGER*4	KIRIGE		! IRIG CHANNEL
	  INTEGER*4	KYEAR		! YEAR OF INTEREST -- FOR IRIG DECODER
	  INTEGER*4	LTIRIG		! RTC AT LAST DECODE
	  REAL*4	STIRIG		! DIGITIZATION INTERVAL
	  REAL*8	DTIRIG		! TIME AT LAST DECODE
						! 28 BYTES		! 14 W

	  INTEGER*4	KSHIFT		! TUSTIN A/D BUFFER SKEW
	  INTEGER*4	LERRTC		! RTC OF ERROR BUFFER
	  INTEGER*4	N_ERR		! NUMBER OF I/O ERRORS
	  INTEGER*4	KBAD(4)		! IOSB FOR LAST DR11W I/O ERROR
						! 28 BYTES		! 14 W

	  INTEGER*4	LTSYS		! LRTC AT CORE START(SYSTEM TIME)
	  INTEGER*4	LTMIN		! JULIAN MINUTE AT SERIES START
	  REAL*8	DTSYS		! GREGORIAN SEC AT CORE START
	  INTEGER*4	LTSER		! RTC FOR DTSER
	  REAL*8	DTSER		! GREGORIAN SYSTIME THAT CORE RESET LBUF
	  REAL*8	DTSTOP		! CPU TIME AT CORE STOP, JULIAN SECONDS 
	  INTEGER*4	LTSTOP		! RTC FOR DTSTOP
	  BYTE		C_NET(4)	! NETWORK ACQUIRING THE ORIGINAL DATA
	  BYTE		C_DEV(4)	! DEVICE USED TO ACQUIRE THE ORIG. DATA
						! 48 BYTES		! 24 W

	  BYTE		C_T_NET(4)	! NETWORK DIGITIZING THE ANALOG TAPE
	  BYTE		C_T_DEV(4)	! DEVICE USED BY C_T_NET
	  BYTE		C_T_DUB(12)	! DUB TAPE LABEL	!-PJJ 091186
	  BYTE		C_T_TAPE(10)	! TAPE ID ie A,B,etc or 5 day id
	  REAL*8	D_T_T0		! REQUESTED START TIME
	  REAL*4	R_T_DUR		! REQUESTED DURATION
	  REAL*4	R_T_RATE	! REQUESTED DIG RATE
	  BYTE		C_T_TRACK(32)	! TRACKS DIGITIZED !10 -> 32 -PJJ 091186
	  BYTE		C_T_STALST(30)	! NAME OF STATION MASTER LIST
						! 108 BYTES		! 54 W

	  INTEGER*2	KFILL(MAXPAR - 196)	! 392 BYTES	!TOTAL=  196 W
	ENDSTRUCTURE

	STRUCTURE /PIN/
	  BYTE		CSITE(6, MAXPIN)	! SITE NAME
	  BYTE		CINST(4, MAXPIN)	! INSTRUMENT TYPE 28JUN88 -RSD
	  INTEGER*2	KPIN(MAXPIN)		! ADC CONNECTION
	  INTEGER*2	KSLM(MAXPIN)		! SCAN LIST MEMORY ARRAY
	  INTEGER*2	KVOTE(MAXPIN)		! PIN VOTING TABLE, 1 -> VOTE,
						!		    0 -> DON'T
	  INTEGER*2	KTRG(MAXPIN)		! CURRENT TRIGGER CONDITION
	  INTEGER*2	KDLY(MAXPIN)		! STATE TRANSITION DELAY
	  REAL*4	BIAS(MAXPIN)		! BIAS
	  REAL*4	SNR_ON(MAXPIN)		! SIGNAL/NOISE RATIO FOR A
						!   TRIGGER TO START
	  REAL*4	SNR_OFF(MAXPIN)		! SNR FOR A PIN LEVEL
						!   TRIGGER TO END
	  REAL*4	RB(MAXPIN)		! STW - SHORT TERM WINDOW
	  REAL*4	RBB(MAXPIN)		! LTW - LONG TERM AVERAGE
	ENDSTRUCTURE

	STRUCTURE /SUB/				! SUBNET ARRAYS
	  BYTE		CSUB(32, MAXSUB)	! SUBNET TITLES
	  INTEGER*2	KTHR(MAXSUB)		! SUBNET TRIGGER LEVELS
	ENDSTRUCTURE

	STRUCTURE /NODE/		!TRIGGER NODE MEMBERSHIP (ONE ENTRY FOR 
					!  EACH SUBNET-STATION PAIR)
	  INTEGER*2	KSUB(MAXWEB)		! SUBNET INDEX
	  INTEGER*2	KCHN(MAXWEB)		! ADC CHANNEL
	ENDSTRUCTURE

	STRUCTURE /TRIG/			! EVENT TRIGGER FIFO
	  INTEGER*2	KTRTYP(MAXTRG)		! TRIGGER TYPE
	  INTEGER*4	LTRON(MAXTRG)		! TRIGGER ON  RTC
	  INTEGER*4	LTROFF(MAXTRG)		! TRIGGER OFF RTC
	  INTEGER*4	LCID(MAXTRG)		! CUSPID FOR TRIGGERS
	ENDSTRUCTURE

	STRUCTURE /DUMMY/
	  INTEGER*4	IPAD(128)		!DUMMY SPACE
	ENDSTRUCTURE

	RECORD /WEB/    W
	RECORD /PIN/    P
	RECORD /SUB/    S
	RECORD /NODE/   N
	RECORD /TRIG/   T
	RECORD /DUMMY/  PAD
	COMMON /GREST/  W, P, S, N, T, PAD




C	MODIFIED
C	09-APR-86 -RSD
C		ADD NET AND DEVICE IDENTIFICATION PARAMETERS
C		ADD PARAMETERS FOR TAPE DIGITIZING
C
C	12-JUN-86 -RSD
C		ADD N_ERR, DTSTOP
C
C	11-SEP-86 -PJJ
C		CHANGE TAPE PARAMETERS
C
C	17-SEP-86 -RSD
C		ADDED KYEAR FOR IRIG TIME DECODER AND ON-THE-FLY
C		  YEAR CHANGES.
C
C	22-SEP-86 -RSD
C		INTERCHANGED MEANING OF C_NET AND C_T_NET.
C		ADDED C_T_DEV.
C
C	06-NOV-86 -RSD
C		ADDED:
C		  LB_NEXT FOR DISK SYNCHRONIZATION BETWEEN
C			SCARAB AND SLING.
C		  LEND	RTC TO INDICATE THE TRUE END OF
C			A TRIGGER. IF (LEND .LT. LTROFF) THEN
C			THE EVENT WAS OVERWRITTEN AND DATA
C			WAS LOST PART-WAY THROUGH; THE EVENT
C			WAS TRUNCATED AT THE LAST GOOD BUFFER.
C
C	20-JUL-87 -RSD
C		ADDED:
C		  LB_LAST -> LAST BUFFER SLING HAS WRITTEN TO .EVT.
C			ADDED TO WEB FOR TAPE DIGITIZING.
C		  L_CID CUSP ID THAT SLING IS CURRENTLY WRITTING.
C			FILE IS Tcusp_id.EVT.
C
C	10-AUG-87 -RSD
C		ADDED:
C		  MAXHDR -> MAXIMUM NUMBER OF WORDS IN HEADER FOR
C			EACH I/O BUFFER.
C		  MAXDTA -> MAXIMUM NUMBER OF WORDS OF DATA IN ONE
C			I/O BUFFER. MAXHDR + MAXDTA .LE. MAXDIO.
C		  MAXDIO -> MAXIMUM NUMBER OF WORDS THAT CAN BE
C			WRITTEN TO DISK AT ONE TIME.
C
C	12-AUG-87 -RSD
C		CALCULATION FOR MAXMEM:
C		  1024 PAGES * 256 WORDS = 262,144 W
C				           -13,416 W IN PARAMETER SECTION
C					  _________
C					   251,288 W FOR 1024 PAGE WORK SET.
C
C		  (2048 * 256) - 13416 =   513,432 W FOR 2048 PAGE WORK SET.
C
C	14-AUG-87 -RSD
C		CHANGE PARAMETER MAXDTA TO VARIABLE MDATA.
C		REARRANGE THE IO PORTION OF GREST.
C		ADD
C			NWDMA = WORDS PER DMA TRANSFER FROM DRV11-WA/DR11-W.
C			NWDIO = WORDS PER DISK QIO.
C			NWNUL = PADDING TO ROUND OUT THE DISK IO.
C
C	19-AUG-87 -RSD
C		ADDED PARAMETERS:
C			MAXDTA	= MAXIMUM DATA WORDS PER I/O BUFFER.
C			MAXBUF	= MAXIMUM I/O BUFFERS IN MEMORY.
C		DELETED VARIABLE MDATA.
C		CHANGED MAXHDR FROM 16 TO 256 WORDS.
C
C	25-AUG-87 -RSD
C		PUT ACTUAL IO BUFFERS IN SEPERATE INCLUDE FILE (BUFFERS.INC)
C
C	23-OCT-87 -RSD
C		CALCULATION FOR MAXMEM
C		  (4096 * 256) - 13416 =   1035160 W FOR 4096 PAGE WORK SET.
C
C	26-OCT-87 -RSD
C		CALCULATION FOR MAXMEM
C		  (16384 * 256) - 13416 =   4180888 W FOR 16384 PAGE WORK SET.
C		  ( 8192 * 256) - 13416 =   2083736 W FOR  8192 PAGE WORK SET.
C
C	29-OCT-87 -RSD
C		ADD KSPIN_STOP SO THAT SPINIT CAN RUN (DOING NOTHING)
C		  UNTIL KSPIN_STOP IS SET.
C
C	25-NOV-87 -RSD
C		ADD DTSYS --> SYSTEM TIME WHEN CORE FIRST STARTS.
C		REDEFINE DTSTOP TO BE SYSTEM TIME WHEN CORE STOPS.
C		REMOVE KSPIN_STOP.
C
C	07-DEC-87 -RSD
C		ADD KSPI_ON : 1 -> SPIDER EVENT IN PROGRESS
C		ADD KVOTE   : 1 -> SPIDER DOES CALCUALTIONS
C				FOR THIS PIN
C		ADD SNR_ON  : SIGNAL/NOISE RATIO FOR TRIGGER ON
C		ADD SNR_OFF : SNR FOR TRIGGER GOING OFF
C		ADD TPOST   : POST TRIGGER SECONDS TO SAVE
C				MINIMUM EVENT = TPREVT + TPOST
C
C	12-FEB-88 -RSD
C		ADD KSLIME  :
C		ADD LTSYS   :
C
C	14-FEB-88 / 13-FEB-88(VARIAN) -RSD
C		ADD L_ERR
C		ADD LTSYS
C		ADD LTSTOP
C
C	18-FEB-88 -RSD
C		ADD LPACER  : = 0 -> PACER NOT USED
C			    : > 0 -> HARDWARE CLOCK FREQUENCY
C				4000000 TO 1000000 FOR TUSTIN.
C
C	09-MAR-1988 -RSD
C		ADD PARAMETER VERSION	! WEB VERSION NUMBER
C		ADD WEB_ID		! FIELD FOR VERSION IN DATA.
C
C		ADD IREFTEK		! IF > 0, = NUMBER OF WORDS
C					!	    IN HEADER & TRAILER
C					!	    FROM REFTEK 44B
C
C	11-MAR-1988 -RSD
C		CHANGED CALCULATIONS FOR NUMBER OF PAGES FOR MAXMEM
C			TO REFLECT THE FACT THAT I HAD ENLARGED THE
C			PARAMETER SECTION FROM 10,856 WORDS TO 13,416 WORDS.
C
C	12-MAR-1988 -RSD
C		CHANGE MAXDIO FROM 16384 TO 16128 SINCE DEC
C			HAS A LIMITATION AT 16383.
C		ADD NWDATA = NWDMA - IREFTEK.
C		INTERCHANGE THE VARIABLE NAMES MAXBUF AND MAXMEM BELOW
C		  ALSO IN THE COMMENTS ABOVE.
C		  MAXMEM = TOTAL MEMORY SPACE FOR DATA.
C		  MAXBUF = NUMBER OF IO BUFFERS IN THE DATA MEMORY SPACE.
C
C	15-MAR-1988 -RSD
C		FOR REFTEK TESTING:
C			MAXMEM = 117656
C				 117656 + 13416 = 256 WORDS * 512 PAGES.
C			MAXDIO =  4096
C			MAXDIO =  1024
C
C	20-APR-1988 -RSD
C		CHANGE MAXHDR FROM 256 WORDS TO 1024 WORDS.
C		VERSION = 1.01
C
