#include "filelist.h"
#include "string.h"

// define the File from command line file list
FileList::FileList(int ind, int cmd_argc, char ** cmd_argv) {

	mode = CMDLINEFILELIST;
	argv = cmd_argv;
	argc = cmd_argc;
	cmdline_index = ind;
	start_flag = 1;
}

// define the file list from a file
FileList::FileList(char * filelist_filename) {
	fptr = fopen(filelist_filename, "r");
}


//get the next filename either from the cmd line or 
// from the file depending upon the mode.
char * FileList::getNextFile(void) {

char * cptr;

	switch (mode) {
	case FILEFILELIST:
		cptr = fgets(filename_buf, 1024, fptr);
		if (cptr != NULL)
			
		if ( (cptr = strchr(filename_buf, '\n')) != NULL)
			*cptr = '\0';	// trim of the newline

		if (cptr == NULL)
			return NULL;
		return filename_buf;
		break;

	case CMDLINEFILELIST:
		if (start_flag == 1) {
			start_flag = 0;
			return argv[cmdline_index];
		} else {
			if (cmdline_index++ >argc) {
				return(NULL);
			} else {
				return argv[cmdline_index];
			}
		}
		break;
	}

	return NULL; 	// bad mode
}
